/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.core.optimize;

import com.google.common.base.Optional;
import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.shardingsphere.core.parse.antlr.sql.statement.dml.InsertStatement;
import org.apache.shardingsphere.core.parse.old.parser.context.insertvalue.InsertValue;
import org.apache.shardingsphere.core.parse.old.parser.expression.SQLExpression;
import org.apache.shardingsphere.core.parse.old.parser.expression.SQLNumberExpression;
import org.apache.shardingsphere.core.parse.old.parser.expression.SQLPlaceholderExpression;
import org.apache.shardingsphere.core.parse.old.parser.expression.SQLTextExpression;
import org.apache.shardingsphere.core.rule.ShardingRule;

public final class GeneratedKey {
    private final String columnName;
    private final List<Comparable<?>> generatedKeys = new LinkedList();

    public static Optional<GeneratedKey> getGenerateKey(ShardingRule shardingRule, List<Object> parameters, InsertStatement insertStatement) {
        Optional generateKeyColumnName = shardingRule.findGenerateKeyColumnName(insertStatement.getTables().getSingleTableName());
        if (!generateKeyColumnName.isPresent()) {
            return Optional.absent();
        }
        return GeneratedKey.isContainsGenerateKeyColumn(insertStatement, (String)generateKeyColumnName.get()) ? GeneratedKey.findGeneratedKey(parameters, insertStatement, (String)generateKeyColumnName.get()) : Optional.of((Object)GeneratedKey.createGeneratedKey(shardingRule, insertStatement, (String)generateKeyColumnName.get()));
    }

    private static boolean isContainsGenerateKeyColumn(InsertStatement insertStatement, String generateKeyColumnName) {
        int valuesCount = insertStatement.getValues().isEmpty() ? 0 : ((InsertValue)insertStatement.getValues().get(0)).getColumnValues().size();
        return valuesCount == insertStatement.getColumnNames().size() && insertStatement.getColumnNames().contains(generateKeyColumnName);
    }

    private static Optional<GeneratedKey> findGeneratedKey(List<Object> parameters, InsertStatement insertStatement, String generateKeyColumnName) {
        GeneratedKey result = null;
        for (SQLExpression each : GeneratedKey.findGenerateKeyExpressions(insertStatement, generateKeyColumnName)) {
            if (null == result) {
                result = new GeneratedKey(generateKeyColumnName);
            }
            if (each instanceof SQLPlaceholderExpression) {
                result.getGeneratedKeys().add((Comparable)parameters.get(((SQLPlaceholderExpression)each).getIndex()));
                continue;
            }
            if (each instanceof SQLNumberExpression) {
                result.getGeneratedKeys().add((Comparable)((Object)((SQLNumberExpression)each).getNumber()));
                continue;
            }
            if (!(each instanceof SQLTextExpression)) continue;
            result.getGeneratedKeys().add((Comparable<?>)((Object)((SQLTextExpression)each).getText()));
        }
        return Optional.fromNullable(result);
    }

    private static Collection<SQLExpression> findGenerateKeyExpressions(InsertStatement insertStatement, String generateKeyColumnName) {
        LinkedList<SQLExpression> result = new LinkedList<SQLExpression>();
        Collection<String> columnNames = GeneratedKey.getColumnNames(insertStatement, generateKeyColumnName);
        for (InsertValue each : insertStatement.getValues()) {
            Optional<SQLExpression> generateKeyExpression = GeneratedKey.findGenerateKeyExpression(generateKeyColumnName, columnNames.iterator(), each);
            if (!generateKeyExpression.isPresent()) continue;
            result.add((SQLExpression)generateKeyExpression.get());
        }
        return result;
    }

    private static Collection<String> getColumnNames(InsertStatement insertStatement, String generateKeyColumnName) {
        int valuesCount = insertStatement.getValues().isEmpty() ? 0 : ((InsertValue)insertStatement.getValues().get(0)).getColumnValues().size();
        ArrayList<String> result = new ArrayList<String>(insertStatement.getColumnNames());
        if (valuesCount != insertStatement.getColumnNames().size()) {
            result.remove(generateKeyColumnName);
        }
        return result;
    }

    private static Optional<SQLExpression> findGenerateKeyExpression(String generateKeyColumnName, Iterator<String> columnNames, InsertValue insertValue) {
        for (SQLExpression each : insertValue.getColumnValues()) {
            String columnName = columnNames.next();
            if (!generateKeyColumnName.equalsIgnoreCase(columnName)) continue;
            return Optional.of((Object)each);
        }
        return Optional.absent();
    }

    private static GeneratedKey createGeneratedKey(ShardingRule shardingRule, InsertStatement insertStatement, String generateKeyColumnName) {
        String tableName = insertStatement.getTables().getSingleTableName();
        GeneratedKey result = new GeneratedKey(generateKeyColumnName);
        for (int i = 0; i < insertStatement.getValues().size(); ++i) {
            result.getGeneratedKeys().add(shardingRule.generateKey(tableName));
        }
        return result;
    }

    @ConstructorProperties(value={"columnName"})
    public GeneratedKey(String columnName) {
        this.columnName = columnName;
    }

    public String getColumnName() {
        return this.columnName;
    }

    public List<Comparable<?>> getGeneratedKeys() {
        return this.generatedKeys;
    }
}

