/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.core.optimize;

import java.util.List;
import org.apache.shardingsphere.core.optimize.GeneratedKey;
import org.apache.shardingsphere.core.optimize.engine.OptimizeEngine;
import org.apache.shardingsphere.core.optimize.engine.encrypt.EncryptDefaultOptimizeEngine;
import org.apache.shardingsphere.core.optimize.engine.encrypt.EncryptInsertOptimizeEngine;
import org.apache.shardingsphere.core.optimize.engine.sharding.insert.InsertOptimizeEngine;
import org.apache.shardingsphere.core.optimize.engine.sharding.query.QueryOptimizeEngine;
import org.apache.shardingsphere.core.parse.antlr.sql.statement.SQLStatement;
import org.apache.shardingsphere.core.parse.antlr.sql.statement.dml.DMLStatement;
import org.apache.shardingsphere.core.parse.antlr.sql.statement.dml.InsertStatement;
import org.apache.shardingsphere.core.parse.antlr.sql.statement.dml.SelectStatement;
import org.apache.shardingsphere.core.rule.EncryptRule;
import org.apache.shardingsphere.core.rule.ShardingRule;

public final class OptimizeEngineFactory {
    public static OptimizeEngine newInstance(ShardingRule shardingRule, SQLStatement sqlStatement, List<Object> parameters, GeneratedKey generatedKey) {
        if (sqlStatement instanceof InsertStatement) {
            return new InsertOptimizeEngine(shardingRule, (InsertStatement)sqlStatement, parameters, generatedKey);
        }
        if (sqlStatement instanceof SelectStatement || sqlStatement instanceof DMLStatement) {
            return new QueryOptimizeEngine(sqlStatement.getRouteConditions().getOrCondition(), parameters);
        }
        return new QueryOptimizeEngine(sqlStatement.getRouteConditions().getOrCondition(), parameters);
    }

    public static OptimizeEngine newInstance(EncryptRule encryptRule, SQLStatement sqlStatement, List<Object> parameters) {
        if (sqlStatement instanceof InsertStatement) {
            return new EncryptInsertOptimizeEngine(encryptRule, (InsertStatement)sqlStatement, parameters);
        }
        return new EncryptDefaultOptimizeEngine();
    }

    private OptimizeEngineFactory() {
    }
}

