/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.core.optimize.engine.encrypt;

import com.google.common.base.Optional;
import java.beans.ConstructorProperties;
import java.util.LinkedList;
import java.util.List;
import org.apache.shardingsphere.core.optimize.engine.OptimizeEngine;
import org.apache.shardingsphere.core.optimize.result.OptimizeResult;
import org.apache.shardingsphere.core.optimize.result.insert.InsertOptimizeResult;
import org.apache.shardingsphere.core.optimize.result.insert.InsertOptimizeResultUnit;
import org.apache.shardingsphere.core.parse.antlr.sql.statement.dml.InsertStatement;
import org.apache.shardingsphere.core.parse.antlr.sql.token.InsertValuesToken;
import org.apache.shardingsphere.core.parse.old.lexer.token.DefaultKeyword;
import org.apache.shardingsphere.core.parse.old.parser.context.insertvalue.InsertValue;
import org.apache.shardingsphere.core.parse.old.parser.expression.SQLExpression;
import org.apache.shardingsphere.core.parse.old.parser.expression.SQLNumberExpression;
import org.apache.shardingsphere.core.parse.old.parser.expression.SQLPlaceholderExpression;
import org.apache.shardingsphere.core.parse.old.parser.expression.SQLTextExpression;
import org.apache.shardingsphere.core.rule.EncryptRule;

public final class EncryptInsertOptimizeEngine
implements OptimizeEngine {
    private final EncryptRule encryptRule;
    private final InsertStatement insertStatement;
    private final List<Object> parameters;

    @Override
    public OptimizeResult optimize() {
        List insertValues = this.insertStatement.getValues();
        InsertOptimizeResult insertOptimizeResult = this.createInsertOptimizeResult();
        int parametersCount = 0;
        int insertOptimizeResultIndex = 0;
        for (InsertValue each : insertValues) {
            SQLExpression[] currentColumnValues = this.createCurrentColumnValues(each);
            Object[] currentParameters = this.createCurrentParameters(parametersCount, each);
            parametersCount += each.getParametersCount();
            insertOptimizeResult.addUnit(currentColumnValues, currentParameters);
            if (this.isNeededToAppendQueryAssistedColumn()) {
                this.fillWithQueryAssistedColumn(insertOptimizeResult, insertOptimizeResultIndex);
            }
            ++insertOptimizeResultIndex;
        }
        return new OptimizeResult(insertOptimizeResult);
    }

    private InsertOptimizeResult createInsertOptimizeResult() {
        DefaultKeyword type = this.insertStatement.findSQLToken(InsertValuesToken.class).isPresent() ? DefaultKeyword.VALUES : DefaultKeyword.SET;
        return new InsertOptimizeResult(type, this.insertStatement.getColumnNames());
    }

    private SQLExpression[] createCurrentColumnValues(InsertValue insertValue) {
        SQLExpression[] result = new SQLExpression[insertValue.getColumnValues().size() + this.getIncrement()];
        insertValue.getColumnValues().toArray(result);
        return result;
    }

    private Object[] createCurrentParameters(int beginIndex, InsertValue insertValue) {
        if (0 == insertValue.getParametersCount()) {
            return new Object[0];
        }
        Object[] result = new Object[insertValue.getParametersCount() + this.getIncrement()];
        this.parameters.subList(beginIndex, beginIndex + insertValue.getParametersCount()).toArray(result);
        return result;
    }

    private int getIncrement() {
        int result = 0;
        if (this.isNeededToAppendQueryAssistedColumn()) {
            result += this.encryptRule.getEncryptorEngine().getAssistedQueryColumnCount(this.insertStatement.getTables().getSingleTableName()).intValue();
        }
        return result;
    }

    private boolean isNeededToAppendQueryAssistedColumn() {
        return this.encryptRule.getEncryptorEngine().isHasShardingQueryAssistedEncryptor(this.insertStatement.getTables().getSingleTableName());
    }

    private void fillWithQueryAssistedColumn(InsertOptimizeResult insertOptimizeResult, int insertOptimizeResultIndex) {
        LinkedList<Object> assistedColumnNames = new LinkedList<Object>();
        for (String each : insertOptimizeResult.getColumnNames()) {
            InsertOptimizeResultUnit unit = insertOptimizeResult.getUnits().get(insertOptimizeResultIndex);
            Optional assistedColumnName = this.encryptRule.getEncryptorEngine().getAssistedQueryColumn(this.insertStatement.getTables().getSingleTableName(), each);
            if (!assistedColumnName.isPresent()) continue;
            assistedColumnNames.add(assistedColumnName.get());
            this.fillInsertOptimizeResultUnit(unit, (Comparable)unit.getColumnValue(each));
        }
        if (!assistedColumnNames.isEmpty()) {
            insertOptimizeResult.getColumnNames().addAll(assistedColumnNames);
        }
    }

    private void fillInsertOptimizeResultUnit(InsertOptimizeResultUnit unit, Comparable<?> columnValue) {
        if (!this.parameters.isEmpty()) {
            unit.addColumnValue((SQLExpression)new SQLPlaceholderExpression(this.parameters.size() - 1));
            unit.addColumnParameter(columnValue);
        } else if (columnValue.getClass() == String.class) {
            unit.addColumnValue((SQLExpression)new SQLTextExpression(columnValue.toString()));
        } else {
            unit.addColumnValue((SQLExpression)new SQLNumberExpression((Number)((Object)columnValue)));
        }
    }

    @ConstructorProperties(value={"encryptRule", "insertStatement", "parameters"})
    public EncryptInsertOptimizeEngine(EncryptRule encryptRule, InsertStatement insertStatement, List<Object> parameters) {
        this.encryptRule = encryptRule;
        this.insertStatement = insertStatement;
        this.parameters = parameters;
    }
}

