/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.core.optimize.engine.sharding.insert;

import com.google.common.base.Optional;
import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.shardingsphere.core.optimize.GeneratedKey;
import org.apache.shardingsphere.core.optimize.condition.ShardingCondition;
import org.apache.shardingsphere.core.optimize.condition.ShardingConditions;
import org.apache.shardingsphere.core.optimize.engine.OptimizeEngine;
import org.apache.shardingsphere.core.optimize.result.OptimizeResult;
import org.apache.shardingsphere.core.optimize.result.insert.InsertOptimizeResult;
import org.apache.shardingsphere.core.optimize.result.insert.InsertOptimizeResultUnit;
import org.apache.shardingsphere.core.parse.antlr.sql.statement.dml.InsertStatement;
import org.apache.shardingsphere.core.parse.antlr.sql.token.InsertValuesToken;
import org.apache.shardingsphere.core.parse.old.lexer.token.DefaultKeyword;
import org.apache.shardingsphere.core.parse.old.parser.context.condition.AndCondition;
import org.apache.shardingsphere.core.parse.old.parser.context.condition.Condition;
import org.apache.shardingsphere.core.parse.old.parser.context.insertvalue.InsertValue;
import org.apache.shardingsphere.core.parse.old.parser.expression.SQLExpression;
import org.apache.shardingsphere.core.parse.old.parser.expression.SQLNumberExpression;
import org.apache.shardingsphere.core.parse.old.parser.expression.SQLPlaceholderExpression;
import org.apache.shardingsphere.core.parse.old.parser.expression.SQLTextExpression;
import org.apache.shardingsphere.core.rule.ShardingRule;
import org.apache.shardingsphere.core.strategy.route.value.ListRouteValue;
import org.apache.shardingsphere.core.strategy.route.value.RouteValue;

public final class InsertOptimizeEngine
implements OptimizeEngine {
    private final ShardingRule shardingRule;
    private final InsertStatement insertStatement;
    private final List<Object> parameters;
    private final GeneratedKey generatedKey;

    @Override
    public OptimizeResult optimize() {
        List andConditions = this.insertStatement.getRouteConditions().getOrCondition().getAndConditions();
        Iterator<Comparable<?>> generatedKeys = this.createGeneratedKeys();
        ArrayList<ShardingCondition> shardingConditions = new ArrayList<ShardingCondition>(andConditions.size());
        InsertOptimizeResult insertOptimizeResult = this.createInsertOptimizeResult();
        int parametersCount = 0;
        for (int i = 0; i < andConditions.size(); ++i) {
            InsertValue insertValue = (InsertValue)this.insertStatement.getValues().get(i);
            SQLExpression[] currentColumnValues = this.createCurrentColumnValues(insertValue);
            Object[] currentParameters = this.createCurrentParameters(parametersCount, insertValue);
            parametersCount += insertValue.getParametersCount();
            ShardingCondition shardingCondition = this.createShardingCondition((AndCondition)andConditions.get(i));
            insertOptimizeResult.addUnit(currentColumnValues, currentParameters);
            if (this.isNeededToAppendGeneratedKey()) {
                Comparable<?> currentGeneratedKey = generatedKeys.next();
                this.fillWithGeneratedKeyName(insertOptimizeResult);
                this.fillInsertOptimizeResultUnit(insertOptimizeResult.getUnits().get(i), currentGeneratedKey);
                this.fillShardingCondition(shardingCondition, currentGeneratedKey);
            }
            if (this.isNeededToAppendQueryAssistedColumn()) {
                this.fillWithQueryAssistedColumn(insertOptimizeResult, i);
            }
            shardingConditions.add(shardingCondition);
        }
        return new OptimizeResult(new ShardingConditions(shardingConditions), insertOptimizeResult);
    }

    private InsertOptimizeResult createInsertOptimizeResult() {
        DefaultKeyword type = this.insertStatement.findSQLToken(InsertValuesToken.class).isPresent() ? DefaultKeyword.VALUES : DefaultKeyword.SET;
        return new InsertOptimizeResult(type, this.insertStatement.getColumnNames());
    }

    private Iterator<Comparable<?>> createGeneratedKeys() {
        return this.isNeededToAppendGeneratedKey() ? this.generatedKey.getGeneratedKeys().iterator() : null;
    }

    private SQLExpression[] createCurrentColumnValues(InsertValue insertValue) {
        SQLExpression[] result = new SQLExpression[insertValue.getColumnValues().size() + this.getIncrement()];
        insertValue.getColumnValues().toArray(result);
        return result;
    }

    private Object[] createCurrentParameters(int beginIndex, InsertValue insertValue) {
        if (0 == insertValue.getParametersCount()) {
            return new Object[0];
        }
        Object[] result = new Object[insertValue.getParametersCount() + this.getIncrement()];
        this.parameters.subList(beginIndex, beginIndex + insertValue.getParametersCount()).toArray(result);
        return result;
    }

    private int getIncrement() {
        int result = 0;
        if (this.isNeededToAppendGeneratedKey()) {
            ++result;
        }
        if (this.isNeededToAppendQueryAssistedColumn()) {
            result += this.shardingRule.getShardingEncryptorEngine().getAssistedQueryColumnCount(this.insertStatement.getTables().getSingleTableName()).intValue();
        }
        return result;
    }

    private boolean isNeededToAppendGeneratedKey() {
        String tableName = this.insertStatement.getTables().getSingleTableName();
        Optional generateKeyColumn = this.shardingRule.findGenerateKeyColumnName(tableName);
        int valueSize = this.insertStatement.getValues().isEmpty() ? 0 : ((InsertValue)this.insertStatement.getValues().get(0)).getColumnValues().size();
        return this.insertStatement.getColumnNames().size() != valueSize || generateKeyColumn.isPresent() && !this.insertStatement.getColumnNames().contains(generateKeyColumn.get());
    }

    private ShardingCondition createShardingCondition(AndCondition andCondition) {
        ShardingCondition result = new ShardingCondition();
        result.getShardingValues().addAll(this.getShardingValues(andCondition));
        return result;
    }

    private Collection<ListRouteValue> getShardingValues(AndCondition andCondition) {
        LinkedList<ListRouteValue> result = new LinkedList<ListRouteValue>();
        for (Condition each : andCondition.getConditions()) {
            result.add(new ListRouteValue(each.getColumn().getName(), each.getColumn().getTableName(), (Collection)each.getConditionValues(this.parameters)));
        }
        return result;
    }

    private void fillWithGeneratedKeyName(InsertOptimizeResult insertOptimizeResult) {
        String generateKeyColumnName = (String)this.shardingRule.findGenerateKeyColumnName(this.insertStatement.getTables().getSingleTableName()).get();
        insertOptimizeResult.getColumnNames().remove(generateKeyColumnName);
        insertOptimizeResult.getColumnNames().add(generateKeyColumnName);
    }

    private void fillShardingCondition(ShardingCondition shardingCondition, Comparable<?> currentGeneratedKey) {
        String tableName = this.insertStatement.getTables().getSingleTableName();
        String generateKeyColumnName = (String)this.shardingRule.findGenerateKeyColumnName(tableName).get();
        if (this.shardingRule.isShardingColumn(generateKeyColumnName, tableName)) {
            shardingCondition.getShardingValues().add((RouteValue)new ListRouteValue(generateKeyColumnName, tableName, Collections.singletonList(currentGeneratedKey)));
        }
    }

    private boolean isNeededToAppendQueryAssistedColumn() {
        return this.shardingRule.getShardingEncryptorEngine().isHasShardingQueryAssistedEncryptor(this.insertStatement.getTables().getSingleTableName());
    }

    private void fillWithQueryAssistedColumn(InsertOptimizeResult insertOptimizeResult, int insertOptimizeResultIndex) {
        LinkedList<Object> assistedColumnNames = new LinkedList<Object>();
        for (String each : insertOptimizeResult.getColumnNames()) {
            InsertOptimizeResultUnit unit = insertOptimizeResult.getUnits().get(insertOptimizeResultIndex);
            Optional assistedColumnName = this.shardingRule.getShardingEncryptorEngine().getAssistedQueryColumn(this.insertStatement.getTables().getSingleTableName(), each);
            if (!assistedColumnName.isPresent()) continue;
            assistedColumnNames.add(assistedColumnName.get());
            this.fillInsertOptimizeResultUnit(unit, (Comparable)unit.getColumnValue(each));
        }
        if (!assistedColumnNames.isEmpty()) {
            insertOptimizeResult.getColumnNames().addAll(assistedColumnNames);
        }
    }

    private void fillInsertOptimizeResultUnit(InsertOptimizeResultUnit unit, Comparable<?> columnValue) {
        if (!this.parameters.isEmpty()) {
            unit.addColumnValue((SQLExpression)new SQLPlaceholderExpression(this.parameters.size() - 1));
            unit.addColumnParameter(columnValue);
        } else if (columnValue.getClass() == String.class) {
            unit.addColumnValue((SQLExpression)new SQLTextExpression(columnValue.toString()));
        } else {
            unit.addColumnValue((SQLExpression)new SQLNumberExpression((Number)((Object)columnValue)));
        }
    }

    @ConstructorProperties(value={"shardingRule", "insertStatement", "parameters", "generatedKey"})
    public InsertOptimizeEngine(ShardingRule shardingRule, InsertStatement insertStatement, List<Object> parameters, GeneratedKey generatedKey) {
        this.shardingRule = shardingRule;
        this.insertStatement = insertStatement;
        this.parameters = parameters;
        this.generatedKey = generatedKey;
    }
}

