/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.core.optimize.engine.sharding.query;

import com.google.common.collect.BoundType;
import com.google.common.collect.Range;
import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.shardingsphere.core.constant.ShardingOperator;
import org.apache.shardingsphere.core.exception.ShardingException;
import org.apache.shardingsphere.core.optimize.condition.ShardingCondition;
import org.apache.shardingsphere.core.optimize.condition.ShardingConditions;
import org.apache.shardingsphere.core.optimize.engine.OptimizeEngine;
import org.apache.shardingsphere.core.optimize.engine.sharding.query.AlwaysFalseShardingCondition;
import org.apache.shardingsphere.core.optimize.engine.sharding.query.AlwaysFalseShardingValue;
import org.apache.shardingsphere.core.optimize.result.OptimizeResult;
import org.apache.shardingsphere.core.parse.old.parser.context.condition.AndCondition;
import org.apache.shardingsphere.core.parse.old.parser.context.condition.Column;
import org.apache.shardingsphere.core.parse.old.parser.context.condition.Condition;
import org.apache.shardingsphere.core.parse.old.parser.context.condition.OrCondition;
import org.apache.shardingsphere.core.strategy.route.value.BetweenRouteValue;
import org.apache.shardingsphere.core.strategy.route.value.ListRouteValue;
import org.apache.shardingsphere.core.strategy.route.value.RouteValue;

public final class QueryOptimizeEngine
implements OptimizeEngine {
    private final OrCondition orCondition;
    private final List<Object> parameters;

    @Override
    public OptimizeResult optimize() {
        ArrayList<ShardingCondition> result = new ArrayList<ShardingCondition>(this.orCondition.getAndConditions().size());
        for (AndCondition each : this.orCondition.getAndConditions()) {
            result.add(this.optimize(each.getConditionsMap()));
        }
        return new OptimizeResult(new ShardingConditions(result));
    }

    private ShardingCondition optimize(Map<Column, List<Condition>> conditionsMap) {
        ShardingCondition result = new ShardingCondition();
        for (Map.Entry<Column, List<Condition>> entry : conditionsMap.entrySet()) {
            try {
                RouteValue shardingValue = this.optimize(entry.getKey(), entry.getValue());
                if (shardingValue instanceof AlwaysFalseShardingValue) {
                    return new AlwaysFalseShardingCondition();
                }
                result.getShardingValues().add(shardingValue);
            }
            catch (ClassCastException ex) {
                throw new ShardingException("Found different types for sharding value `%s`.", new Object[]{entry.getKey()});
            }
        }
        return result;
    }

    private RouteValue optimize(Column column, List<Condition> conditions) {
        List<Comparable<?>> listValue = null;
        Range<Comparable<?>> rangeValue = null;
        for (Condition each : conditions) {
            List conditionValues = each.getConditionValues(this.parameters);
            if ((ShardingOperator.EQUAL == each.getOperator() || ShardingOperator.IN == each.getOperator()) && (listValue = this.optimize(conditionValues, listValue)).isEmpty()) {
                return new AlwaysFalseShardingValue();
            }
            if (ShardingOperator.BETWEEN != each.getOperator()) continue;
            try {
                rangeValue = this.optimize(Range.range((Comparable)((Comparable)conditionValues.get(0)), (BoundType)BoundType.CLOSED, (Comparable)((Comparable)conditionValues.get(1)), (BoundType)BoundType.CLOSED), rangeValue);
            }
            catch (IllegalArgumentException ex) {
                return new AlwaysFalseShardingValue();
            }
        }
        if (null == listValue) {
            return new BetweenRouteValue(column.getName(), column.getTableName(), rangeValue);
        }
        if (null == rangeValue) {
            return new ListRouteValue(column.getName(), column.getTableName(), listValue);
        }
        return (listValue = this.optimize(listValue, rangeValue)).isEmpty() ? new AlwaysFalseShardingValue() : new ListRouteValue(column.getName(), column.getTableName(), listValue);
    }

    private List<Comparable<?>> optimize(List<Comparable<?>> value1, List<Comparable<?>> value2) {
        if (null == value2) {
            return value1;
        }
        value1.retainAll(value2);
        return value1;
    }

    private Range<Comparable<?>> optimize(Range<Comparable<?>> value1, Range<Comparable<?>> value2) {
        return null == value2 ? value1 : value1.intersection(value2);
    }

    private List<Comparable<?>> optimize(List<Comparable<?>> listValue, Range<Comparable<?>> rangeValue) {
        LinkedList result = new LinkedList();
        for (Comparable<?> each : listValue) {
            if (!rangeValue.contains(each)) continue;
            result.add(each);
        }
        return result;
    }

    @ConstructorProperties(value={"orCondition", "parameters"})
    public QueryOptimizeEngine(OrCondition orCondition, List<Object> parameters) {
        this.orCondition = orCondition;
        this.parameters = parameters;
    }
}

