/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.core.optimize.result.insert;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import org.apache.shardingsphere.core.optimize.result.insert.ColumnValueOptimizeResult;
import org.apache.shardingsphere.core.optimize.result.insert.InsertOptimizeResultUnit;
import org.apache.shardingsphere.core.optimize.result.insert.SetAssignmentOptimizeResult;
import org.apache.shardingsphere.core.parse.old.lexer.token.DefaultKeyword;
import org.apache.shardingsphere.core.parse.old.parser.expression.SQLExpression;

public final class InsertOptimizeResult {
    private final DefaultKeyword type;
    private final Collection<String> columnNames = new LinkedHashSet<String>();
    private final List<InsertOptimizeResultUnit> units = new LinkedList<InsertOptimizeResultUnit>();

    public InsertOptimizeResult(DefaultKeyword type, Collection<String> columnNames) {
        this.type = type;
        this.columnNames.addAll(columnNames);
    }

    public void addUnit(SQLExpression[] columnValues, Object[] columnParameters) {
        if (this.type == DefaultKeyword.VALUES) {
            this.units.add(new ColumnValueOptimizeResult(this.columnNames, columnValues, columnParameters));
        } else {
            this.units.add(new SetAssignmentOptimizeResult(this.columnNames, columnValues, columnParameters));
        }
    }

    public DefaultKeyword getType() {
        return this.type;
    }

    public Collection<String> getColumnNames() {
        return this.columnNames;
    }

    public List<InsertOptimizeResultUnit> getUnits() {
        return this.units;
    }
}

