/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.core.optimize.result.insert;

import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.apache.shardingsphere.core.exception.ShardingException;
import org.apache.shardingsphere.core.parse.old.parser.expression.SQLExpression;
import org.apache.shardingsphere.core.parse.old.parser.expression.SQLNumberExpression;
import org.apache.shardingsphere.core.parse.old.parser.expression.SQLPlaceholderExpression;
import org.apache.shardingsphere.core.parse.old.parser.expression.SQLTextExpression;
import org.apache.shardingsphere.core.rule.DataNode;

public abstract class InsertOptimizeResultUnit {
    private final Collection<String> columnNames;
    private final SQLExpression[] values;
    private final Object[] parameters;
    private final List<DataNode> dataNodes = new LinkedList<DataNode>();

    public final void addColumnValue(SQLExpression sqlExpression) {
        this.values[this.getCurrentIndex((Object[])this.values)] = sqlExpression;
    }

    public final void addColumnParameter(Object parameter) {
        this.parameters[this.getCurrentIndex((Object[])this.parameters)] = parameter;
    }

    private int getCurrentIndex(Object[] array) {
        int count = 0;
        for (Object each : array) {
            if (null == each) continue;
            ++count;
        }
        return count;
    }

    public final void setColumnValue(String columnName, Object columnValue) {
        SQLExpression sqlExpression = this.values[this.getColumnIndex(columnName)];
        if (sqlExpression instanceof SQLPlaceholderExpression) {
            this.parameters[this.getParameterIndex((SQLExpression)sqlExpression)] = columnValue;
        } else {
            SQLTextExpression columnExpression = String.class == columnValue.getClass() ? new SQLTextExpression(String.valueOf(columnValue)) : new SQLNumberExpression((Number)columnValue);
            this.values[this.getColumnIndex((String)columnName)] = columnExpression;
        }
    }

    private int getColumnIndex(String columnName) {
        return new ArrayList<String>(this.columnNames).indexOf(columnName);
    }

    private int getParameterIndex(SQLExpression sqlExpression) {
        int result = 0;
        for (SQLExpression each : this.values) {
            if (sqlExpression == each) {
                return result;
            }
            if (!(each instanceof SQLPlaceholderExpression)) continue;
            ++result;
        }
        throw new ShardingException("Can not get parameter index.", new Object[0]);
    }

    public final Object getColumnValue(String columnName) {
        SQLExpression sqlExpression = this.values[this.getColumnIndex(columnName)];
        if (sqlExpression instanceof SQLPlaceholderExpression) {
            return this.parameters[this.getParameterIndex(sqlExpression)];
        }
        if (sqlExpression instanceof SQLTextExpression) {
            return ((SQLTextExpression)sqlExpression).getText();
        }
        return ((SQLNumberExpression)sqlExpression).getNumber();
    }

    protected final String getColumnSQLExpressionValue(int columnValueIndex) {
        SQLExpression sqlExpression = this.values[columnValueIndex];
        if (sqlExpression instanceof SQLPlaceholderExpression) {
            return "?";
        }
        if (sqlExpression instanceof SQLTextExpression) {
            return String.format("'%s'", ((SQLTextExpression)sqlExpression).getText());
        }
        return String.valueOf(((SQLNumberExpression)sqlExpression).getNumber());
    }

    @ConstructorProperties(value={"columnNames", "values", "parameters"})
    public InsertOptimizeResultUnit(Collection<String> columnNames, SQLExpression[] values, Object[] parameters) {
        this.columnNames = columnNames;
        this.values = values;
        this.parameters = parameters;
    }

    public Collection<String> getColumnNames() {
        return this.columnNames;
    }

    public SQLExpression[] getValues() {
        return this.values;
    }

    public Object[] getParameters() {
        return this.parameters;
    }

    public List<DataNode> getDataNodes() {
        return this.dataNodes;
    }
}

