/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.transaction.core;

import javax.sql.DataSource;
import org.apache.shardingsphere.transaction.core.ResourceIDGenerator;

public final class ResourceDataSource {
    private final String originalName;
    private String uniqueResourceName;
    private final DataSource dataSource;

    public ResourceDataSource(String originalName, DataSource dataSource) {
        this.originalName = originalName;
        this.dataSource = dataSource;
        this.uniqueResourceName = ResourceIDGenerator.getInstance().nextId() + originalName;
    }

    public String getOriginalName() {
        return this.originalName;
    }

    public String getUniqueResourceName() {
        return this.uniqueResourceName;
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }
}

