/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.single.decider;

import java.util.Collection;
import java.util.LinkedList;
import java.util.Optional;
import org.apache.shardingsphere.infra.binder.QueryContext;
import org.apache.shardingsphere.infra.binder.decider.SQLFederationDecider;
import org.apache.shardingsphere.infra.binder.decider.context.SQLFederationDeciderContext;
import org.apache.shardingsphere.infra.binder.statement.SQLStatementContext;
import org.apache.shardingsphere.infra.binder.statement.dml.SelectStatementContext;
import org.apache.shardingsphere.infra.binder.type.IndexAvailable;
import org.apache.shardingsphere.infra.config.props.ConfigurationProperties;
import org.apache.shardingsphere.infra.database.type.DatabaseType;
import org.apache.shardingsphere.infra.database.type.DatabaseTypeEngine;
import org.apache.shardingsphere.infra.datanode.DataNode;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.metadata.database.rule.ShardingSphereRuleMetaData;
import org.apache.shardingsphere.infra.metadata.database.schema.QualifiedTable;
import org.apache.shardingsphere.infra.metadata.database.schema.util.IndexMetaDataUtil;
import org.apache.shardingsphere.single.rule.SingleRule;
import org.apache.shardingsphere.sql.parser.sql.common.segment.generic.table.SimpleTableSegment;

public final class SingleSQLFederationDecider
implements SQLFederationDecider<SingleRule> {
    public void decide(SQLFederationDeciderContext deciderContext, QueryContext queryContext, ShardingSphereRuleMetaData globalRuleMetaData, ShardingSphereDatabase database, SingleRule rule, ConfigurationProperties props) {
        SelectStatementContext select = (SelectStatementContext)queryContext.getSqlStatementContext();
        Collection<QualifiedTable> singleTableNames = SingleSQLFederationDecider.getSingleTableNames(select, database, rule);
        if (singleTableNames.isEmpty()) {
            return;
        }
        if (this.containsView(database, singleTableNames)) {
            deciderContext.setUseSQLFederation(true);
            return;
        }
        deciderContext.setUseSQLFederation(!SingleSQLFederationDecider.isAllTablesInSameDataSource(deciderContext, rule, singleTableNames));
        SingleSQLFederationDecider.addTableDataNodes(deciderContext, rule, singleTableNames);
    }

    private static void addTableDataNodes(SQLFederationDeciderContext deciderContext, SingleRule rule, Collection<QualifiedTable> singleTableNames) {
        for (QualifiedTable each : singleTableNames) {
            rule.findSingleTableDataNode(each.getSchemaName(), each.getTableName()).ifPresent(optional -> deciderContext.getDataNodes().add(optional));
        }
    }

    private static boolean isAllTablesInSameDataSource(SQLFederationDeciderContext deciderContext, SingleRule rule, Collection<QualifiedTable> singleTableNames) {
        if (!rule.isSingleTablesInSameDataSource(singleTableNames)) {
            return false;
        }
        QualifiedTable sampleTable = singleTableNames.iterator().next();
        Optional<DataNode> dataNode = rule.findSingleTableDataNode(sampleTable.getSchemaName(), sampleTable.getTableName());
        if (!dataNode.isPresent()) {
            return true;
        }
        for (DataNode each : deciderContext.getDataNodes()) {
            if (each.getDataSourceName().equalsIgnoreCase(dataNode.get().getDataSourceName())) continue;
            return false;
        }
        return true;
    }

    private static Collection<QualifiedTable> getSingleTableNames(SQLStatementContext<?> sqlStatementContext, ShardingSphereDatabase database, SingleRule rule) {
        DatabaseType databaseType = sqlStatementContext.getDatabaseType();
        Collection result = SingleSQLFederationDecider.getQualifiedTables(database, databaseType, sqlStatementContext.getTablesContext().getTables());
        if (result.isEmpty() && sqlStatementContext instanceof IndexAvailable) {
            result = IndexMetaDataUtil.getTableNames((ShardingSphereDatabase)database, (DatabaseType)databaseType, (Collection)((IndexAvailable)sqlStatementContext).getIndexes());
        }
        return rule.getSingleTableNames(result);
    }

    private static Collection<QualifiedTable> getQualifiedTables(ShardingSphereDatabase database, DatabaseType databaseType, Collection<SimpleTableSegment> tableSegments) {
        LinkedList<QualifiedTable> result = new LinkedList<QualifiedTable>();
        String schemaName = DatabaseTypeEngine.getDefaultSchemaName((DatabaseType)databaseType, (String)database.getName());
        for (SimpleTableSegment each : tableSegments) {
            String actualSchemaName = each.getOwner().map(optional -> optional.getIdentifier().getValue()).orElse(schemaName);
            result.add(new QualifiedTable(actualSchemaName, each.getTableName().getIdentifier().getValue()));
        }
        return result;
    }

    private boolean containsView(ShardingSphereDatabase database, Collection<QualifiedTable> singleTableNames) {
        for (QualifiedTable each : singleTableNames) {
            if (!database.getSchema(each.getSchemaName()).containsView(each.getTableName())) continue;
            return true;
        }
        return false;
    }

    public int getOrder() {
        return 0;
    }

    public Class<SingleRule> getTypeClass() {
        return SingleRule.class;
    }
}

