/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.single.route.engine;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.shardingsphere.dialect.exception.syntax.table.TableExistsException;
import org.apache.shardingsphere.infra.datanode.DataNode;
import org.apache.shardingsphere.infra.metadata.database.schema.QualifiedTable;
import org.apache.shardingsphere.infra.route.context.RouteContext;
import org.apache.shardingsphere.infra.route.context.RouteMapper;
import org.apache.shardingsphere.infra.route.context.RouteUnit;
import org.apache.shardingsphere.single.exception.SingleTableNotFoundException;
import org.apache.shardingsphere.single.route.engine.SingleRouteEngine;
import org.apache.shardingsphere.single.rule.SingleRule;
import org.apache.shardingsphere.sql.parser.sql.common.statement.SQLStatement;
import org.apache.shardingsphere.sql.parser.sql.common.statement.ddl.AlterTableStatement;
import org.apache.shardingsphere.sql.parser.sql.common.statement.ddl.CreateTableStatement;
import org.apache.shardingsphere.sql.parser.sql.common.statement.ddl.DropTableStatement;
import org.apache.shardingsphere.sql.parser.sql.common.statement.dml.SelectStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.handler.ddl.CreateTableStatementHandler;

public final class SingleStandardRouteEngine
implements SingleRouteEngine {
    private final Collection<QualifiedTable> singleTableNames;
    private final SQLStatement sqlStatement;

    @Override
    public void route(RouteContext routeContext, SingleRule singleRule) {
        if (routeContext.getRouteUnits().isEmpty() || this.sqlStatement instanceof SelectStatement) {
            this.route0(routeContext, singleRule);
        } else {
            RouteContext newRouteContext = new RouteContext();
            this.route0(newRouteContext, singleRule);
            this.combineRouteContext(routeContext, newRouteContext);
        }
    }

    private void combineRouteContext(RouteContext routeContext, RouteContext newRouteContext) {
        Map<String, RouteUnit> dataSourceRouteUnits = this.getDataSourceRouteUnits(newRouteContext);
        routeContext.getRouteUnits().removeIf(each -> !dataSourceRouteUnits.containsKey(each.getDataSourceMapper().getLogicName()));
        for (Map.Entry<String, RouteUnit> entry : dataSourceRouteUnits.entrySet()) {
            routeContext.putRouteUnit(entry.getValue().getDataSourceMapper(), entry.getValue().getTableMappers());
        }
    }

    private Map<String, RouteUnit> getDataSourceRouteUnits(RouteContext newRouteContext) {
        return newRouteContext.getRouteUnits().stream().collect(Collectors.toMap(each -> each.getDataSourceMapper().getLogicName(), Function.identity()));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void route0(RouteContext routeContext, SingleRule rule) {
        if (this.sqlStatement instanceof CreateTableStatement) {
            QualifiedTable table = this.singleTableNames.iterator().next();
            Optional<DataNode> dataNodeOptional = rule.findSingleTableDataNode(table.getSchemaName(), table.getTableName());
            if (!dataNodeOptional.isPresent()) {
                String dataSourceName = rule.assignNewDataSourceName();
                routeContext.getRouteUnits().add(new RouteUnit(new RouteMapper(dataSourceName, dataSourceName), Collections.singleton(new RouteMapper(table.getTableName(), table.getTableName()))));
                return;
            } else {
                if (!CreateTableStatementHandler.ifNotExists((CreateTableStatement)((CreateTableStatement)this.sqlStatement))) throw new TableExistsException(table.getTableName());
                String dataSourceName = dataNodeOptional.map(DataNode::getDataSourceName).orElse(null);
                routeContext.getRouteUnits().add(new RouteUnit(new RouteMapper(dataSourceName, dataSourceName), Collections.singleton(new RouteMapper(table.getTableName(), table.getTableName()))));
            }
            return;
        } else {
            if (!(this.sqlStatement instanceof AlterTableStatement) && !(this.sqlStatement instanceof DropTableStatement) && !rule.isAllTablesInSameDataSource(routeContext, this.singleTableNames)) return;
            this.fillRouteContext(rule, routeContext, rule.getSingleTableNames(this.singleTableNames));
        }
    }

    private void fillRouteContext(SingleRule singleRule, RouteContext routeContext, Collection<QualifiedTable> logicTables) {
        for (QualifiedTable each : logicTables) {
            String tableName = each.getTableName();
            Optional<DataNode> dataNode = singleRule.findSingleTableDataNode(each.getSchemaName(), tableName);
            if (!dataNode.isPresent()) {
                throw new SingleTableNotFoundException(tableName);
            }
            String dataSource = dataNode.get().getDataSourceName();
            routeContext.putRouteUnit(new RouteMapper(dataSource, dataSource), Collections.singletonList(new RouteMapper(tableName, tableName)));
        }
    }

    @Generated
    public SingleStandardRouteEngine(Collection<QualifiedTable> singleTableNames, SQLStatement sqlStatement) {
        this.singleTableNames = singleTableNames;
        this.sqlStatement = sqlStatement;
    }
}

