/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.single.route.validator.ddl;

import org.apache.shardingsphere.infra.binder.statement.SQLStatementContext;
import org.apache.shardingsphere.infra.exception.SchemaNotFoundException;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.metadata.database.schema.model.ShardingSphereSchema;
import org.apache.shardingsphere.infra.util.exception.ShardingSpherePreconditions;
import org.apache.shardingsphere.single.exception.DropNotEmptySchemaException;
import org.apache.shardingsphere.single.route.validator.SingleMetaDataValidator;
import org.apache.shardingsphere.single.rule.SingleRule;
import org.apache.shardingsphere.sql.parser.sql.common.statement.ddl.DropSchemaStatement;
import org.apache.shardingsphere.sql.parser.sql.common.value.identifier.IdentifierValue;
import org.apache.shardingsphere.sql.parser.sql.dialect.handler.ddl.DropSchemaStatementHandler;

public final class SingleDropSchemaMetaDataValidator
implements SingleMetaDataValidator<DropSchemaStatement> {
    @Override
    public void validate(SingleRule rule, SQLStatementContext<DropSchemaStatement> sqlStatementContext, ShardingSphereDatabase database) {
        boolean containsCascade = DropSchemaStatementHandler.containsCascade((DropSchemaStatement)((DropSchemaStatement)sqlStatementContext.getSqlStatement()));
        for (IdentifierValue each : ((DropSchemaStatement)sqlStatementContext.getSqlStatement()).getSchemaNames()) {
            String schemaName = each.getValue();
            ShardingSphereSchema schema = database.getSchema(schemaName);
            ShardingSpherePreconditions.checkNotNull((Object)schema, () -> new SchemaNotFoundException(schemaName));
            ShardingSpherePreconditions.checkState((containsCascade || schema.getAllTableNames().isEmpty() ? 1 : 0) != 0, () -> new DropNotEmptySchemaException(schemaName));
        }
    }
}

