/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.single.rule;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Optional;
import java.util.TreeSet;
import java.util.concurrent.ThreadLocalRandom;
import java.util.stream.Collectors;
import javax.sql.DataSource;
import lombok.Generated;
import org.apache.shardingsphere.infra.config.rule.RuleConfiguration;
import org.apache.shardingsphere.infra.database.type.DatabaseTypeEngine;
import org.apache.shardingsphere.infra.datanode.DataNode;
import org.apache.shardingsphere.infra.datasource.state.DataSourceStateManager;
import org.apache.shardingsphere.infra.metadata.database.schema.QualifiedTable;
import org.apache.shardingsphere.infra.route.context.RouteContext;
import org.apache.shardingsphere.infra.route.context.RouteUnit;
import org.apache.shardingsphere.infra.rule.ShardingSphereRule;
import org.apache.shardingsphere.infra.rule.identifier.scope.DatabaseRule;
import org.apache.shardingsphere.infra.rule.identifier.type.DataNodeContainedRule;
import org.apache.shardingsphere.infra.rule.identifier.type.DataSourceContainedRule;
import org.apache.shardingsphere.infra.rule.identifier.type.MutableDataNodeRule;
import org.apache.shardingsphere.infra.rule.identifier.type.TableContainedRule;
import org.apache.shardingsphere.infra.rule.identifier.type.exportable.ExportableRule;
import org.apache.shardingsphere.single.api.config.SingleRuleConfiguration;
import org.apache.shardingsphere.single.datanode.SingleTableDataNodeLoader;

public final class SingleRule
implements DatabaseRule,
DataNodeContainedRule,
TableContainedRule,
MutableDataNodeRule,
ExportableRule {
    private final SingleRuleConfiguration configuration;
    private final String defaultDataSource;
    private final Collection<String> dataSourceNames;
    private final Map<String, Collection<DataNode>> singleTableDataNodes;
    private final Map<String, String> tableNames;

    public SingleRule(SingleRuleConfiguration ruleConfig, String databaseName, Map<String, DataSource> dataSourceMap, Collection<ShardingSphereRule> builtRules) {
        this.configuration = ruleConfig;
        this.defaultDataSource = ruleConfig.getDefaultDataSource().orElse(null);
        Map enabledDataSources = DataSourceStateManager.getInstance().getEnabledDataSourceMap(databaseName, dataSourceMap);
        Map<String, DataSource> aggregateDataSourceMap = this.getAggregateDataSourceMap((Map<String, DataSource>)enabledDataSources, builtRules);
        this.dataSourceNames = aggregateDataSourceMap.keySet();
        this.singleTableDataNodes = SingleTableDataNodeLoader.load(databaseName, DatabaseTypeEngine.getStorageType(enabledDataSources.values()), aggregateDataSourceMap, this.getLoadedTables(builtRules));
        this.tableNames = this.singleTableDataNodes.entrySet().stream().collect(Collectors.toConcurrentMap(Map.Entry::getKey, entry -> ((DataNode)((Collection)entry.getValue()).iterator().next()).getTableName()));
    }

    private Map<String, DataSource> getAggregateDataSourceMap(Map<String, DataSource> dataSourceMap, Collection<ShardingSphereRule> builtRules) {
        Map<String, DataSource> result = new LinkedHashMap<String, DataSource>(dataSourceMap);
        for (ShardingSphereRule each : builtRules) {
            if (!(each instanceof DataSourceContainedRule)) continue;
            result = this.getAggregateDataSourceMap(result, (DataSourceContainedRule)each);
        }
        return result;
    }

    private Map<String, DataSource> getAggregateDataSourceMap(Map<String, DataSource> dataSourceMap, DataSourceContainedRule builtRule) {
        LinkedHashMap<String, DataSource> result = new LinkedHashMap<String, DataSource>();
        for (Map.Entry entry : builtRule.getDataSourceMapper().entrySet()) {
            for (String each : (Collection)entry.getValue()) {
                if (!dataSourceMap.containsKey(each)) continue;
                result.putIfAbsent((String)entry.getKey(), dataSourceMap.remove(each));
            }
        }
        result.putAll(dataSourceMap);
        return result;
    }

    private Collection<String> getLoadedTables(Collection<ShardingSphereRule> builtRules) {
        return builtRules.stream().filter(each -> each instanceof DataNodeContainedRule).flatMap(each -> ((DataNodeContainedRule)each).getAllTables().stream()).collect(Collectors.toCollection(() -> new TreeSet(String.CASE_INSENSITIVE_ORDER)));
    }

    public String assignNewDataSourceName() {
        return null == this.defaultDataSource ? new ArrayList<String>(this.dataSourceNames).get(ThreadLocalRandom.current().nextInt(this.dataSourceNames.size())) : this.defaultDataSource;
    }

    public boolean isSingleTablesInSameDataSource(Collection<QualifiedTable> singleTableNames) {
        String firstFoundDataSourceName = null;
        for (QualifiedTable each : singleTableNames) {
            Optional<DataNode> dataNode = this.findSingleTableDataNode(each.getSchemaName(), each.getTableName());
            if (!dataNode.isPresent()) continue;
            if (null == firstFoundDataSourceName) {
                firstFoundDataSourceName = dataNode.get().getDataSourceName();
                continue;
            }
            if (firstFoundDataSourceName.equals(dataNode.get().getDataSourceName())) continue;
            return false;
        }
        return true;
    }

    public boolean isAllTablesInSameDataSource(RouteContext routeContext, Collection<QualifiedTable> singleTableNames) {
        if (!this.isSingleTablesInSameDataSource(singleTableNames)) {
            return false;
        }
        QualifiedTable sampleTable = singleTableNames.iterator().next();
        Optional<DataNode> dataNode = this.findSingleTableDataNode(sampleTable.getSchemaName(), sampleTable.getTableName());
        if (dataNode.isPresent()) {
            for (RouteUnit each : routeContext.getRouteUnits()) {
                if (each.getDataSourceMapper().getLogicName().equals(dataNode.get().getDataSourceName())) continue;
                return false;
            }
        }
        return true;
    }

    public Collection<QualifiedTable> getSingleTableNames(Collection<QualifiedTable> qualifiedTables) {
        LinkedList<QualifiedTable> result = new LinkedList<QualifiedTable>();
        for (QualifiedTable each : qualifiedTables) {
            Collection dataNodes = this.singleTableDataNodes.getOrDefault(each.getTableName().toLowerCase(), new LinkedList());
            if (dataNodes.isEmpty() || !this.containsDataNode(each, dataNodes)) continue;
            result.add(each);
        }
        return result;
    }

    private boolean containsDataNode(QualifiedTable qualifiedTable, Collection<DataNode> dataNodes) {
        for (DataNode each : dataNodes) {
            if (!qualifiedTable.getSchemaName().equalsIgnoreCase(each.getSchemaName())) continue;
            return true;
        }
        return false;
    }

    public void put(String dataSourceName, String schemaName, String tableName) {
        if (this.dataSourceNames.contains(dataSourceName)) {
            Collection dataNodes = this.singleTableDataNodes.computeIfAbsent(tableName.toLowerCase(), key -> new LinkedHashSet());
            DataNode dataNode = new DataNode(dataSourceName, tableName);
            dataNode.setSchemaName(schemaName);
            dataNodes.add(dataNode);
            this.tableNames.put(tableName.toLowerCase(), tableName);
        }
    }

    public void remove(String schemaName, String tableName) {
        this.remove(Collections.singleton(schemaName.toLowerCase()), tableName);
    }

    public void remove(Collection<String> schemaNames, String tableName) {
        if (!this.singleTableDataNodes.containsKey(tableName.toLowerCase())) {
            return;
        }
        Collection<DataNode> dataNodes = this.singleTableDataNodes.get(tableName.toLowerCase());
        dataNodes.removeIf(each -> schemaNames.contains(each.getSchemaName().toLowerCase()));
        if (dataNodes.isEmpty()) {
            this.singleTableDataNodes.remove(tableName.toLowerCase());
            this.tableNames.remove(tableName.toLowerCase());
        }
    }

    public Optional<DataNode> findSingleTableDataNode(String schemaName, String tableName) {
        Collection dataNodes = this.singleTableDataNodes.getOrDefault(tableName.toLowerCase(), new LinkedHashSet());
        for (DataNode each : dataNodes) {
            if (!schemaName.equalsIgnoreCase(each.getSchemaName())) continue;
            return Optional.of(each);
        }
        return Optional.empty();
    }

    public ShardingSphereRule reloadRule(RuleConfiguration config, String databaseName, Map<String, DataSource> dataSourceMap, Collection<ShardingSphereRule> builtRules) {
        return new SingleRule((SingleRuleConfiguration)config, databaseName, dataSourceMap, builtRules);
    }

    public Map<String, Collection<DataNode>> getAllDataNodes() {
        return this.singleTableDataNodes;
    }

    public Collection<DataNode> getDataNodesByTableName(String tableName) {
        return this.singleTableDataNodes.getOrDefault(tableName.toLowerCase(), Collections.emptyList());
    }

    public Optional<String> findFirstActualTable(String logicTable) {
        return Optional.empty();
    }

    public boolean isNeedAccumulate(Collection<String> tables) {
        return false;
    }

    public Optional<String> findLogicTableByActualTable(String actualTable) {
        return Optional.empty();
    }

    public Optional<String> findActualTableByCatalog(String catalog, String logicTable) {
        return Optional.empty();
    }

    public Collection<String> getAllTables() {
        TreeSet<String> result = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
        result.addAll(this.tableNames.values());
        return result;
    }

    public Collection<String> getTables() {
        return new HashSet<String>(this.tableNames.values());
    }

    public Map<String, Object> getExportData() {
        return Collections.singletonMap("single_tables", this.tableNames.keySet());
    }

    public String getType() {
        return SingleRule.class.getSimpleName();
    }

    @Generated
    public SingleRuleConfiguration getConfiguration() {
        return this.configuration;
    }

    @Generated
    public Collection<String> getDataSourceNames() {
        return this.dataSourceNames;
    }

    @Generated
    public Map<String, Collection<DataNode>> getSingleTableDataNodes() {
        return this.singleTableDataNodes;
    }
}

