/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.apache.spark.MapSizesByExecutorId;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkException;
import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.broadcast.BroadcastManager;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.config.package$;
import org.apache.spark.io.CompressionCodec;
import org.apache.spark.io.CompressionCodec$;
import org.apache.spark.scheduler.MapStatus;
import org.apache.spark.scheduler.MergeStatus;
import org.apache.spark.scheduler.ShuffleOutputStatus;
import org.apache.spark.shuffle.MetadataFetchFailedException;
import org.apache.spark.storage.BlockId;
import org.apache.spark.storage.BlockManagerId;
import org.apache.spark.storage.ShuffleBlockId;
import org.apache.spark.storage.ShuffleMergedBlockId;
import org.apache.spark.util.Utils$;
import org.apache.spark.util.io.ChunkedByteBuffer;
import org.apache.spark.util.io.ChunkedByteBufferOutputStream;
import org.roaringbitmap.RoaringBitmap;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.ArrayOps$;
import scala.collection.Iterator;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Growable;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

public final class MapOutputTracker$
implements Logging {
    public static final MapOutputTracker$ MODULE$ = new MapOutputTracker$();
    private static final String ENDPOINT_NAME;
    private static final int DIRECT;
    private static final int BROADCAST;
    private static final int SHUFFLE_PUSH_MAP_ID;
    private static transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        Logging.$init$(MODULE$);
        ENDPOINT_NAME = "MapOutputTracker";
        DIRECT = 0;
        BROADCAST = 1;
        SHUFFLE_PUSH_MAP_ID = -1;
    }

    @Override
    public String logName() {
        return Logging.logName$(this);
    }

    @Override
    public Logger log() {
        return Logging.log$(this);
    }

    @Override
    public void logInfo(Function0<String> msg) {
        Logging.logInfo$(this, msg);
    }

    @Override
    public void logDebug(Function0<String> msg) {
        Logging.logDebug$(this, msg);
    }

    @Override
    public void logTrace(Function0<String> msg) {
        Logging.logTrace$(this, msg);
    }

    @Override
    public void logWarning(Function0<String> msg) {
        Logging.logWarning$(this, msg);
    }

    @Override
    public void logError(Function0<String> msg) {
        Logging.logError$(this, msg);
    }

    @Override
    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$(this, msg, throwable);
    }

    @Override
    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$(this, msg, throwable);
    }

    @Override
    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$(this, msg, throwable);
    }

    @Override
    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$(this, msg, throwable);
    }

    @Override
    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$(this, msg, throwable);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$(this, isInterpreter);
    }

    @Override
    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$(this, isInterpreter, silent);
    }

    @Override
    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$(this);
    }

    @Override
    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$(this, isInterpreter, silent);
    }

    @Override
    public Logger org$apache$spark$internal$Logging$$log_() {
        return org$apache$spark$internal$Logging$$log_;
    }

    @Override
    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public String ENDPOINT_NAME() {
        return ENDPOINT_NAME;
    }

    private int DIRECT() {
        return DIRECT;
    }

    private int BROADCAST() {
        return BROADCAST;
    }

    public int SHUFFLE_PUSH_MAP_ID() {
        return SHUFFLE_PUSH_MAP_ID;
    }

    public <T extends ShuffleOutputStatus> Tuple2<byte[], Broadcast<byte[][]>> serializeOutputStatuses(T[] statuses, BroadcastManager broadcastManager, boolean isLocal, int minBroadcastSize, SparkConf conf) {
        Tuple2 tuple2;
        ChunkedByteBufferOutputStream out = new ChunkedByteBufferOutputStream(0x100000, (Function1<Object, ByteBuffer>)(Function1 & Serializable)x$1 -> MapOutputTracker$.$anonfun$serializeOutputStatuses$1(BoxesRunTime.unboxToInt((Object)x$1)));
        out.write(this.DIRECT());
        CompressionCodec codec = CompressionCodec$.MODULE$.createCodec(conf, conf.get(package$.MODULE$.MAP_STATUS_COMPRESSION_CODEC()));
        ObjectOutputStream objOut = new ObjectOutputStream(codec.compressedOutputStream(out));
        Utils$.MODULE$.tryWithSafeFinally((JFunction0.mcV.sp & Serializable)() -> {
            ShuffleOutputStatus[] shuffleOutputStatusArray = statuses;
            synchronized (statuses) {
                objOut.writeObject(statuses);
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
        }, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> objOut.close());
        ChunkedByteBuffer chunkedByteBuf = out.toChunkedByteBuffer();
        long arrSize = out.size();
        if (arrSize >= (long)minBroadcastSize) {
            byte[][] arr = (byte[][])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])chunkedByteBuf.getChunks()), (Function1 & Serializable)x$18 -> x$18.array(), ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Byte.TYPE)));
            Broadcast<byte[][]> bcast = broadcastManager.newBroadcast(arr, isLocal, ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(ScalaRunTime$.MODULE$.arrayClass(Byte.TYPE))));
            ByteArrayOutputStream out2 = new ByteArrayOutputStream();
            out2.write(this.BROADCAST());
            ObjectOutputStream oos = new ObjectOutputStream(codec.compressedOutputStream((OutputStream)out2));
            Utils$.MODULE$.tryWithSafeFinally((JFunction0.mcV.sp & Serializable)() -> oos.writeObject(bcast), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> oos.close());
            byte[] outArr = out2.toByteArray();
            this.logInfo((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(48).append("Broadcast outputstatuses size = ").append(outArr.length).append(", actual size = ").append(arrSize).toString());
            tuple2 = new Tuple2((Object)outArr, bcast);
        } else {
            tuple2 = new Tuple2((Object)chunkedByteBuf.toArray(), null);
        }
        return tuple2;
    }

    public <T extends ShuffleOutputStatus> T[] deserializeOutputStatuses(byte[] bytes, SparkConf conf) {
        ShuffleOutputStatus[] shuffleOutputStatusArray;
        Predef$.MODULE$.assert(bytes.length > 0);
        ByteArrayInputStream in = new ByteArrayInputStream(bytes, 1, bytes.length - 1);
        byte by = bytes[0];
        if (this.DIRECT() == by) {
            shuffleOutputStatusArray = (ShuffleOutputStatus[])MapOutputTracker$.deserializeObject$1(in, conf);
        } else if (this.BROADCAST() == by) {
            ShuffleOutputStatus[] shuffleOutputStatusArray2;
            try {
                Broadcast bcast = (Broadcast)MapOutputTracker$.deserializeObject$1(in, conf);
                this.logInfo((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(48).append("Broadcast outputstatuses size = ").append(bytes.length).append(", actual size = ").append(ArrayOps$.MODULE$.foldLeft$extension(Predef$.MODULE$.refArrayOps((Object[])bcast.value()), (Object)BoxesRunTime.boxToLong((long)0L), (Function2 & Serializable)(x$19, x$20) -> BoxesRunTime.boxToLong((long)MapOutputTracker$.$anonfun$deserializeOutputStatuses$4(BoxesRunTime.unboxToLong((Object)x$19), x$20)))).toString());
                ChunkedByteBuffer qual$1 = new ChunkedByteBuffer((ByteBuffer[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])bcast.value()), (Function1 & Serializable)x$1 -> ByteBuffer.wrap(x$1), ClassTag$.MODULE$.apply(ByteBuffer.class)));
                boolean x$12 = qual$1.toInputStream$default$1();
                InputStream bcastIn = qual$1.toInputStream(x$12);
                bcastIn.skip(1L);
                shuffleOutputStatusArray2 = (ShuffleOutputStatus[])MapOutputTracker$.deserializeObject$1(bcastIn, conf);
            }
            catch (IOException e) {
                this.logWarning((Function0<String>)(Function0 & Serializable)() -> "Exception encountered during deserializing broadcasted output statuses: ", e);
                throw new SparkException("Unable to deserialize broadcasted output statuses", e);
            }
            shuffleOutputStatusArray = shuffleOutputStatusArray2;
        } else {
            throw new IllegalArgumentException(new StringBuilder(22).append("Unexpected byte tag = ").append(bytes[0]).toString());
        }
        return shuffleOutputStatusArray;
    }

    public MapSizesByExecutorId convertMapStatuses(int shuffleId, int startPartition, int endPartition, MapStatus[] mapStatuses, int startMapIndex, int endMapIndex, Option<MergeStatus[]> mergeStatuses) {
        Predef$.MODULE$.assert(mapStatuses != null);
        HashMap splitsByAddress = new HashMap();
        boolean enableBatchFetch = true;
        if (mergeStatuses.exists((Function1 & Serializable)x$21 -> BoxesRunTime.boxToBoolean((boolean)ArrayOps$.MODULE$.exists$extension(Predef$.MODULE$.refArrayOps((Object[])x$21), (Function1 & Serializable)x$22 -> BoxesRunTime.boxToBoolean((boolean)MapOutputTracker$.$anonfun$convertMapStatuses$2(x$22))))) && startMapIndex == 0 && endMapIndex == mapStatuses.length) {
            enableBatchFetch = false;
            this.logDebug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(66).append("Disable shuffle batch fetch as Push based shuffle is enabled for ").append(shuffleId).append(".").toString());
            int numMaps = mapStatuses.length;
            ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.slice$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.zipWithIndex$extension(Predef$.MODULE$.refArrayOps((Object[])mergeStatuses.get()))), startPartition, endPartition)), (Function1 & Serializable)x0$1 -> {
                MapOutputTracker$.$anonfun$convertMapStatuses$4(splitsByAddress, shuffleId, mapStatuses, numMaps, x0$1);
                return BoxedUnit.UNIT;
            });
        } else {
            Iterator iter = ArrayOps$.MODULE$.iterator$extension(Predef$.MODULE$.refArrayOps((Object[])mapStatuses)).zipWithIndex();
            iter.slice(startMapIndex, endMapIndex).withFilter((Function1 & Serializable)check$ifrefutable$2 -> BoxesRunTime.boxToBoolean((boolean)MapOutputTracker$.$anonfun$convertMapStatuses$9(check$ifrefutable$2))).foreach((Function1 & Serializable)x$24 -> {
                MapOutputTracker$.$anonfun$convertMapStatuses$10(shuffleId, startPartition, endPartition, splitsByAddress, x$24);
                return BoxedUnit.UNIT;
            });
        }
        return new MapSizesByExecutorId((Iterator<Tuple2<BlockManagerId, Seq<Tuple3<BlockId, Object, Object>>>>)splitsByAddress.mapValues((Function1 & Serializable)x$25 -> x$25.toSeq()).iterator(), enableBatchFetch);
    }

    public Option<MergeStatus[]> convertMapStatuses$default$7() {
        return None$.MODULE$;
    }

    public Iterator<Tuple2<BlockManagerId, Seq<Tuple3<BlockId, Object, Object>>>> getMapStatusesForMergeStatus(int shuffleId, int partitionId, MapStatus[] mapStatuses, RoaringBitmap tracker) {
        Predef$.MODULE$.assert(mapStatuses != null && tracker != null);
        HashMap splitsByAddress = new HashMap();
        ArrayOps$.MODULE$.withFilter$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.zipWithIndex$extension(Predef$.MODULE$.refArrayOps((Object[])mapStatuses))), (Function1 & Serializable)check$ifrefutable$3 -> BoxesRunTime.boxToBoolean((boolean)MapOutputTracker$.$anonfun$getMapStatusesForMergeStatus$1(check$ifrefutable$3))).foreach((Function1 & Serializable)x$26 -> {
            BoxedUnit boxedUnit;
            Tuple2 tuple2 = x$26;
            if (tuple2 != null) {
                MapStatus status = (MapStatus)tuple2._1();
                int mapIndex = tuple2._2$mcI$sp();
                if (tracker.contains(mapIndex)) {
                    MODULE$.validateStatus(status, shuffleId, partitionId);
                    boxedUnit = ((Growable)splitsByAddress.getOrElseUpdate((Object)status.location(), (Function0 & Serializable)() -> (ListBuffer)ListBuffer$.MODULE$.apply((Seq)Nil$.MODULE$))).$plus$eq((Object)new Tuple3((Object)new ShuffleBlockId(shuffleId, status.mapId(), partitionId), (Object)BoxesRunTime.boxToLong((long)status.getSizeForBlock(partitionId)), (Object)BoxesRunTime.boxToInteger((int)mapIndex)));
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
            } else {
                throw new MatchError((Object)tuple2);
            }
            BoxedUnit boxedUnit2 = boxedUnit;
            return boxedUnit2;
        });
        return splitsByAddress.mapValues((Function1 & Serializable)x$27 -> x$27.toSeq()).iterator();
    }

    public void validateStatus(ShuffleOutputStatus status, int shuffleId, int partition) {
        if (status == null) {
            String errorMessage = new StringBuilder(50).append("Missing an output location for shuffle ").append(shuffleId).append(" partition ").append(partition).toString();
            this.logError((Function0<String>)(Function0 & Serializable)() -> errorMessage);
            throw new MetadataFetchFailedException(shuffleId, partition, errorMessage);
        }
    }

    public static final /* synthetic */ ByteBuffer $anonfun$serializeOutputStatuses$1(int x$1) {
        return ByteBuffer.allocate(x$1);
    }

    private static final Object deserializeObject$1(InputStream in, SparkConf conf$4) {
        CompressionCodec codec = CompressionCodec$.MODULE$.createCodec(conf$4, conf$4.get(package$.MODULE$.MAP_STATUS_COMPRESSION_CODEC()));
        ObjectInputStream objIn = new ObjectInputStream(codec.compressedInputStream(in));
        return Utils$.MODULE$.tryWithSafeFinally((Function0 & Serializable)() -> objIn.readObject(), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> objIn.close());
    }

    public static final /* synthetic */ long $anonfun$deserializeOutputStatuses$4(long x$19, byte[] x$20) {
        return x$19 + (long)x$20.length;
    }

    public static final /* synthetic */ boolean $anonfun$convertMapStatuses$2(MergeStatus x$22) {
        return x$22 != null;
    }

    public static final /* synthetic */ boolean $anonfun$convertMapStatuses$6(Tuple2 check$ifrefutable$1) {
        Tuple2 tuple2 = check$ifrefutable$1;
        boolean bl = tuple2 != null;
        return bl;
    }

    public static final /* synthetic */ void $anonfun$convertMapStatuses$4(HashMap splitsByAddress$1, int shuffleId$9, MapStatus[] mapStatuses$1, int numMaps$1, Tuple2 x0$1) {
        Seq seq;
        int partId;
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            MergeStatus mergeStatus = (MergeStatus)tuple2._1();
            partId = tuple2._2$mcI$sp();
            if (mergeStatus != null && mergeStatus.totalSize() > 0L) {
                ((Growable)splitsByAddress$1.getOrElseUpdate((Object)mergeStatus.location(), (Function0 & Serializable)() -> (ListBuffer)ListBuffer$.MODULE$.apply((Seq)Nil$.MODULE$))).$plus$eq((Object)new Tuple3((Object)new ShuffleMergedBlockId(shuffleId$9, mergeStatus.shuffleMergeId(), partId), (Object)BoxesRunTime.boxToLong((long)mergeStatus.totalSize()), (Object)BoxesRunTime.boxToInteger((int)MODULE$.SHUFFLE_PUSH_MAP_ID())));
                Tuple2[] mapStatusesWithIndex = ArrayOps$.MODULE$.zipWithIndex$extension(Predef$.MODULE$.refArrayOps((Object[])mapStatuses$1));
                seq = (Seq)mergeStatus.getMissingMaps(numMaps$1).map((Function1)Predef$.MODULE$.wrapRefArray((Object[])mapStatusesWithIndex));
            } else {
                seq = ArrayOps$.MODULE$.toSeq$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.zipWithIndex$extension(Predef$.MODULE$.refArrayOps((Object[])mapStatuses$1))));
            }
        } else {
            throw new MatchError((Object)tuple2);
        }
        Seq remainingMapStatuses = seq;
        remainingMapStatuses.withFilter((Function1 & Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)MapOutputTracker$.$anonfun$convertMapStatuses$6(check$ifrefutable$1))).foreach((Function1 & Serializable)x$23 -> {
            Tuple2 tuple2 = x$23;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            MapStatus mapStatus = (MapStatus)tuple2._1();
            int mapIndex = tuple2._2$mcI$sp();
            MODULE$.validateStatus(mapStatus, shuffleId$9, partId);
            long size = mapStatus.getSizeForBlock(partId);
            BoxedUnit boxedUnit = size != 0L ? ((Growable)splitsByAddress$1.getOrElseUpdate((Object)mapStatus.location(), (Function0 & Serializable)() -> (ListBuffer)ListBuffer$.MODULE$.apply((Seq)Nil$.MODULE$))).$plus$eq((Object)new Tuple3((Object)new ShuffleBlockId(shuffleId$9, mapStatus.mapId(), partId), (Object)BoxesRunTime.boxToLong((long)size), (Object)BoxesRunTime.boxToInteger((int)mapIndex))) : BoxedUnit.UNIT;
            return boxedUnit;
        });
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ boolean $anonfun$convertMapStatuses$9(Tuple2 check$ifrefutable$2) {
        Tuple2 tuple2 = check$ifrefutable$2;
        boolean bl = tuple2 != null;
        return bl;
    }

    public static final /* synthetic */ Object $anonfun$convertMapStatuses$11(MapStatus status$3, HashMap splitsByAddress$1, int shuffleId$9, int mapIndex$3, int part) {
        long size = status$3.getSizeForBlock(part);
        return size != 0L ? ((Growable)splitsByAddress$1.getOrElseUpdate((Object)status$3.location(), (Function0 & Serializable)() -> (ListBuffer)ListBuffer$.MODULE$.apply((Seq)Nil$.MODULE$))).$plus$eq((Object)new Tuple3((Object)new ShuffleBlockId(shuffleId$9, status$3.mapId(), part), (Object)BoxesRunTime.boxToLong((long)size), (Object)BoxesRunTime.boxToInteger((int)mapIndex$3))) : BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$convertMapStatuses$10(int shuffleId$9, int startPartition$3, int endPartition$3, HashMap splitsByAddress$1, Tuple2 x$24) {
        Tuple2 tuple2 = x$24;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        MapStatus status = (MapStatus)tuple2._1();
        int mapIndex = tuple2._2$mcI$sp();
        MODULE$.validateStatus(status, shuffleId$9, startPartition$3);
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(startPartition$3), endPartition$3).foreach((Function1 & Serializable)part -> MapOutputTracker$.$anonfun$convertMapStatuses$11(status, splitsByAddress$1, shuffleId$9, mapIndex, BoxesRunTime.unboxToInt((Object)part)));
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ boolean $anonfun$getMapStatusesForMergeStatus$1(Tuple2 check$ifrefutable$3) {
        Tuple2 tuple2 = check$ifrefutable$3;
        boolean bl = tuple2 != null;
        return bl;
    }

    private MapOutputTracker$() {
    }
}

