/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark;

import java.io.Serializable;
import java.net.URL;
import java.util.ServiceLoader;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.hadoop.io.ArrayWritable;
import org.apache.hadoop.io.Writable;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext;
import org.apache.spark.SparkException;
import org.apache.spark.SparkMasterRegex$;
import org.apache.spark.TaskContext$;
import org.apache.spark.deploy.LocalSparkCluster;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.config.Tests$;
import org.apache.spark.internal.config.package$;
import org.apache.spark.resource.ResourceProfile;
import org.apache.spark.resource.ResourceUtils$;
import org.apache.spark.scheduler.ExternalClusterManager;
import org.apache.spark.scheduler.SchedulerBackend;
import org.apache.spark.scheduler.TaskScheduler;
import org.apache.spark.scheduler.TaskSchedulerImpl;
import org.apache.spark.scheduler.TaskSchedulerImpl$;
import org.apache.spark.scheduler.cluster.StandaloneSchedulerBackend;
import org.apache.spark.scheduler.local.LocalSchedulerBackend;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.Iterable;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.JavaConverters$;
import scala.collection.LinearSeqOps;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.util.control.NonFatal$;

public final class SparkContext$
implements Logging {
    public static final SparkContext$ MODULE$ = new SparkContext$();
    private static final Set<String> org$apache$spark$SparkContext$$VALID_LOG_LEVELS;
    private static final Object SPARK_CONTEXT_CONSTRUCTOR_LOCK;
    private static final AtomicReference<SparkContext> org$apache$spark$SparkContext$$activeContext;
    private static Option<SparkContext> contextBeingConstructed;
    private static final String SPARK_JOB_DESCRIPTION;
    private static final String SPARK_JOB_GROUP_ID;
    private static final String SPARK_JOB_INTERRUPT_ON_CANCEL;
    private static final String SPARK_SCHEDULER_POOL;
    private static final String RDD_SCOPE_KEY;
    private static final String RDD_SCOPE_NO_OVERRIDE_KEY;
    private static final String DRIVER_IDENTIFIER;
    private static transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        Logging.$init$(MODULE$);
        org$apache$spark$SparkContext$$VALID_LOG_LEVELS = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"ALL", "DEBUG", "ERROR", "FATAL", "INFO", "OFF", "TRACE", "WARN"}));
        SPARK_CONTEXT_CONSTRUCTOR_LOCK = new Object();
        org$apache$spark$SparkContext$$activeContext = new AtomicReference<Object>(null);
        contextBeingConstructed = None$.MODULE$;
        SPARK_JOB_DESCRIPTION = "spark.job.description";
        SPARK_JOB_GROUP_ID = "spark.jobGroup.id";
        SPARK_JOB_INTERRUPT_ON_CANCEL = "spark.job.interruptOnCancel";
        SPARK_SCHEDULER_POOL = "spark.scheduler.pool";
        RDD_SCOPE_KEY = "spark.rdd.scope";
        RDD_SCOPE_NO_OVERRIDE_KEY = "spark.rdd.scope.noOverride";
        DRIVER_IDENTIFIER = "driver";
    }

    @Override
    public String logName() {
        return Logging.logName$(this);
    }

    @Override
    public Logger log() {
        return Logging.log$(this);
    }

    @Override
    public void logInfo(Function0<String> msg) {
        Logging.logInfo$(this, msg);
    }

    @Override
    public void logDebug(Function0<String> msg) {
        Logging.logDebug$(this, msg);
    }

    @Override
    public void logTrace(Function0<String> msg) {
        Logging.logTrace$(this, msg);
    }

    @Override
    public void logWarning(Function0<String> msg) {
        Logging.logWarning$(this, msg);
    }

    @Override
    public void logError(Function0<String> msg) {
        Logging.logError$(this, msg);
    }

    @Override
    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$(this, msg, throwable);
    }

    @Override
    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$(this, msg, throwable);
    }

    @Override
    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$(this, msg, throwable);
    }

    @Override
    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$(this, msg, throwable);
    }

    @Override
    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$(this, msg, throwable);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$(this, isInterpreter);
    }

    @Override
    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$(this, isInterpreter, silent);
    }

    @Override
    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$(this);
    }

    @Override
    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$(this, isInterpreter, silent);
    }

    @Override
    public Logger org$apache$spark$internal$Logging$$log_() {
        return org$apache$spark$internal$Logging$$log_;
    }

    @Override
    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public String $lessinit$greater$default$3() {
        return null;
    }

    public Seq<String> $lessinit$greater$default$4() {
        return scala.package$.MODULE$.Nil();
    }

    public Map<String, String> $lessinit$greater$default$5() {
        return (Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
    }

    public Set<String> org$apache$spark$SparkContext$$VALID_LOG_LEVELS() {
        return org$apache$spark$SparkContext$$VALID_LOG_LEVELS;
    }

    private Object SPARK_CONTEXT_CONSTRUCTOR_LOCK() {
        return SPARK_CONTEXT_CONSTRUCTOR_LOCK;
    }

    public AtomicReference<SparkContext> org$apache$spark$SparkContext$$activeContext() {
        return org$apache$spark$SparkContext$$activeContext;
    }

    private Option<SparkContext> contextBeingConstructed() {
        return contextBeingConstructed;
    }

    private void contextBeingConstructed_$eq(Option<SparkContext> x$1) {
        contextBeingConstructed = x$1;
    }

    private void assertNoOtherContextIsRunning(SparkContext sc) {
        Object object = this.SPARK_CONTEXT_CONSTRUCTOR_LOCK();
        synchronized (object) {
            Option$.MODULE$.apply((Object)this.org$apache$spark$SparkContext$$activeContext().get()).filter((Function1 & Serializable)x$60 -> BoxesRunTime.boxToBoolean((boolean)SparkContext$.$anonfun$assertNoOtherContextIsRunning$1(sc, x$60))).foreach((Function1 & Serializable)ctx -> {
                String errMsg = new StringBuilder(69).append("Only one SparkContext should be running in this JVM (see SPARK-2243).").append(new StringBuilder(51).append("The currently running SparkContext was created at:\n").append(ctx.org$apache$spark$SparkContext$$creationSite().longForm()).toString()).toString();
                throw new SparkException(errMsg);
            });
            this.contextBeingConstructed().filter((Function1 & Serializable)x$61 -> BoxesRunTime.boxToBoolean((boolean)SparkContext$.$anonfun$assertNoOtherContextIsRunning$3(sc, x$61))).foreach((Function1 & Serializable)otherContext -> {
                SparkContext$.$anonfun$assertNoOtherContextIsRunning$4(otherContext);
                return BoxedUnit.UNIT;
            });
        }
    }

    public void org$apache$spark$SparkContext$$assertOnDriver() {
        if (TaskContext$.MODULE$.get() != null) {
            throw new IllegalStateException("SparkContext should only be created and accessed on the driver.");
        }
    }

    public SparkContext getOrCreate(SparkConf config) {
        SparkContext sparkContext;
        Object object = this.SPARK_CONTEXT_CONSTRUCTOR_LOCK();
        synchronized (object) {
            if (this.org$apache$spark$SparkContext$$activeContext().get() == null) {
                this.setActiveContext(new SparkContext(config));
            } else if (ArrayOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.refArrayOps((Object[])config.getAll()))) {
                this.logWarning((Function0<String>)(Function0 & Serializable)() -> "Using an existing SparkContext; some configuration may not take effect.");
            }
            sparkContext = this.org$apache$spark$SparkContext$$activeContext().get();
        }
        return sparkContext;
    }

    public SparkContext getOrCreate() {
        SparkContext sparkContext;
        Object object = this.SPARK_CONTEXT_CONSTRUCTOR_LOCK();
        synchronized (object) {
            if (this.org$apache$spark$SparkContext$$activeContext().get() == null) {
                this.setActiveContext(new SparkContext());
            }
            sparkContext = this.org$apache$spark$SparkContext$$activeContext().get();
        }
        return sparkContext;
    }

    public Option<SparkContext> getActive() {
        Option option;
        Object object = this.SPARK_CONTEXT_CONSTRUCTOR_LOCK();
        synchronized (object) {
            option = Option$.MODULE$.apply((Object)this.org$apache$spark$SparkContext$$activeContext().get());
        }
        return option;
    }

    public void markPartiallyConstructed(SparkContext sc) {
        Object object = this.SPARK_CONTEXT_CONSTRUCTOR_LOCK();
        synchronized (object) {
            this.assertNoOtherContextIsRunning(sc);
            this.contextBeingConstructed_$eq((Option<SparkContext>)new Some((Object)sc));
        }
    }

    public void setActiveContext(SparkContext sc) {
        Object object = this.SPARK_CONTEXT_CONSTRUCTOR_LOCK();
        synchronized (object) {
            this.assertNoOtherContextIsRunning(sc);
            this.contextBeingConstructed_$eq((Option<SparkContext>)None$.MODULE$);
            this.org$apache$spark$SparkContext$$activeContext().set(sc);
        }
    }

    public void clearActiveContext() {
        Object object = this.SPARK_CONTEXT_CONSTRUCTOR_LOCK();
        synchronized (object) {
            this.org$apache$spark$SparkContext$$activeContext().set(null);
        }
    }

    public String SPARK_JOB_DESCRIPTION() {
        return SPARK_JOB_DESCRIPTION;
    }

    public String SPARK_JOB_GROUP_ID() {
        return SPARK_JOB_GROUP_ID;
    }

    public String SPARK_JOB_INTERRUPT_ON_CANCEL() {
        return SPARK_JOB_INTERRUPT_ON_CANCEL;
    }

    public String SPARK_SCHEDULER_POOL() {
        return SPARK_SCHEDULER_POOL;
    }

    public String RDD_SCOPE_KEY() {
        return RDD_SCOPE_KEY;
    }

    public String RDD_SCOPE_NO_OVERRIDE_KEY() {
        return RDD_SCOPE_NO_OVERRIDE_KEY;
    }

    public String DRIVER_IDENTIFIER() {
        return DRIVER_IDENTIFIER;
    }

    private <T extends Writable> ArrayWritable arrayToArrayWritable(Iterable<T> arr, ClassTag<T> evidence$17) {
        return new ArrayWritable(scala.reflect.package$.MODULE$.classTag(evidence$17).runtimeClass(), (Writable[])((IterableOnceOps)arr.map((Function1 & Serializable)x -> SparkContext$.anyToWritable$1(x))).toArray(ClassTag$.MODULE$.apply(Writable.class)));
    }

    public Option<String> jarOfClass(Class<?> cls) {
        String uriStr;
        URL uri = cls.getResource(new StringBuilder(7).append("/").append(cls.getName().replace('.', '/')).append(".class").toString());
        return uri != null ? ((uriStr = uri.toString()).startsWith("jar:file:") ? new Some((Object)uriStr.substring("jar:file:".length(), uriStr.indexOf(33))) : None$.MODULE$) : None$.MODULE$;
    }

    public Option<String> jarOfObject(Object obj) {
        return this.jarOfClass(obj.getClass());
    }

    public SparkConf updatedConf(SparkConf conf, String master, String appName, String sparkHome, Seq<String> jars, Map<String, String> environment) {
        SparkConf res = conf.clone();
        res.setMaster(master);
        res.setAppName(appName);
        Object object = sparkHome != null ? res.setSparkHome(sparkHome) : BoxedUnit.UNIT;
        Object object2 = jars != null && !jars.isEmpty() ? res.setJars(jars) : BoxedUnit.UNIT;
        res.setExecutorEnv((Seq<Tuple2<String, String>>)environment.toSeq());
        return res;
    }

    public String updatedConf$default$4() {
        return null;
    }

    public Seq<String> updatedConf$default$5() {
        return scala.package$.MODULE$.Nil();
    }

    public Map<String, String> updatedConf$default$6() {
        return (Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
    }

    public int numDriverCores(String master) {
        return this.numDriverCores(master, null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int numDriverCores(String master, SparkConf conf) {
        boolean bl;
        Option option;
        Option option2;
        String string = master;
        if ("local".equals(string)) {
            return 1;
        }
        if (string != null && !(option2 = SparkMasterRegex$.MODULE$.LOCAL_N_REGEX().unapplySeq((CharSequence)string)).isEmpty() && option2.get() != null && ((List)option2.get()).lengthCompare(1) == 0) {
            String threads = (String)((LinearSeqOps)option2.get()).apply(0);
            return SparkContext$.convertToInt$1(threads);
        }
        if (string != null && !(option = SparkMasterRegex$.MODULE$.LOCAL_N_FAILURES_REGEX().unapplySeq((CharSequence)string)).isEmpty() && option.get() != null && ((List)option.get()).lengthCompare(2) == 0) {
            String threads = (String)((LinearSeqOps)option.get()).apply(0);
            return SparkContext$.convertToInt$1(threads);
        }
        if ("yarn".equals(string)) {
            bl = true;
        } else {
            if (string == null) return 0;
            Option option3 = SparkMasterRegex$.MODULE$.KUBERNETES_REGEX().unapplySeq((CharSequence)string);
            if (option3.isEmpty()) return 0;
            if (option3.get() == null) return 0;
            if (((List)option3.get()).lengthCompare(1) != 0) return 0;
            bl = true;
        }
        if (!bl) return 0;
        if (conf == null) return 0;
        String string2 = conf.get(package$.MODULE$.SUBMIT_DEPLOY_MODE());
        String string3 = "cluster";
        if (string2 == null) {
            if (string3 != null) {
                return 0;
            }
        } else if (!string2.equals(string3)) return 0;
        int n = conf.getInt(package$.MODULE$.DRIVER_CORES().key(), 0);
        return n;
    }

    public Tuple2<SchedulerBackend, TaskScheduler> org$apache$spark$SparkContext$$createTaskScheduler(SparkContext sc, String master, String deployMode) {
        Option option;
        Option option2;
        Option option3;
        Option option4;
        Tuple2 tuple2;
        int MAX_LOCAL_TASK_FAILURES = 1;
        String string = master;
        if ("local".equals(string)) {
            SparkContext$.checkResourcesPerTask$1(1, sc);
            TaskSchedulerImpl scheduler = new TaskSchedulerImpl(sc, MAX_LOCAL_TASK_FAILURES, true, TaskSchedulerImpl$.MODULE$.$lessinit$greater$default$4());
            LocalSchedulerBackend backend2 = new LocalSchedulerBackend(sc.getConf(), scheduler, 1);
            scheduler.initialize(backend2);
            tuple2 = new Tuple2((Object)backend2, (Object)scheduler);
        } else if (string != null && !(option4 = SparkMasterRegex$.MODULE$.LOCAL_N_REGEX().unapplySeq((CharSequence)string)).isEmpty() && option4.get() != null && ((List)option4.get()).lengthCompare(1) == 0) {
            int threadCount;
            String threads;
            String string2 = threads = (String)((LinearSeqOps)option4.get()).apply(0);
            String string3 = "*";
            int n = !(string2 != null ? !string2.equals(string3) : string3 != null) ? SparkContext$.localCpuCount$1() : (threadCount = StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(threads)));
            if (threadCount <= 0) {
                throw new SparkException(new StringBuilder(34).append("Asked to run locally with ").append(threadCount).append(" threads").toString());
            }
            SparkContext$.checkResourcesPerTask$1(threadCount, sc);
            TaskSchedulerImpl scheduler = new TaskSchedulerImpl(sc, MAX_LOCAL_TASK_FAILURES, true, TaskSchedulerImpl$.MODULE$.$lessinit$greater$default$4());
            LocalSchedulerBackend backend3 = new LocalSchedulerBackend(sc.getConf(), scheduler, threadCount);
            scheduler.initialize(backend3);
            tuple2 = new Tuple2((Object)backend3, (Object)scheduler);
        } else if (string != null && !(option3 = SparkMasterRegex$.MODULE$.LOCAL_N_FAILURES_REGEX().unapplySeq((CharSequence)string)).isEmpty() && option3.get() != null && ((List)option3.get()).lengthCompare(2) == 0) {
            String threads = (String)((LinearSeqOps)option3.get()).apply(0);
            String maxFailures = (String)((LinearSeqOps)option3.get()).apply(1);
            String string4 = threads;
            String string5 = "*";
            int threadCount = !(string4 != null ? !string4.equals(string5) : string5 != null) ? SparkContext$.localCpuCount$2() : StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(threads));
            SparkContext$.checkResourcesPerTask$1(threadCount, sc);
            TaskSchedulerImpl scheduler = new TaskSchedulerImpl(sc, StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(maxFailures)), true, TaskSchedulerImpl$.MODULE$.$lessinit$greater$default$4());
            LocalSchedulerBackend backend4 = new LocalSchedulerBackend(sc.getConf(), scheduler, threadCount);
            scheduler.initialize(backend4);
            tuple2 = new Tuple2((Object)backend4, (Object)scheduler);
        } else if (string != null && !(option2 = SparkMasterRegex$.MODULE$.SPARK_REGEX().unapplySeq((CharSequence)string)).isEmpty() && option2.get() != null && ((List)option2.get()).lengthCompare(1) == 0) {
            String sparkUrl = (String)((LinearSeqOps)option2.get()).apply(0);
            TaskSchedulerImpl scheduler = new TaskSchedulerImpl(sc);
            String[] masterUrls = (String[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])sparkUrl.split(",")), (Function1 & Serializable)x$63 -> new StringBuilder(8).append("spark://").append((String)x$63).toString(), ClassTag$.MODULE$.apply(String.class));
            StandaloneSchedulerBackend backend5 = new StandaloneSchedulerBackend(scheduler, sc, masterUrls);
            scheduler.initialize(backend5);
            tuple2 = new Tuple2((Object)backend5, (Object)scheduler);
        } else if (string != null && !(option = SparkMasterRegex$.MODULE$.LOCAL_CLUSTER_REGEX().unapplySeq((CharSequence)string)).isEmpty() && option.get() != null && ((List)option.get()).lengthCompare(3) == 0) {
            String numWorkers = (String)((LinearSeqOps)option.get()).apply(0);
            String coresPerWorker = (String)((LinearSeqOps)option.get()).apply(1);
            String memoryPerWorker = (String)((LinearSeqOps)option.get()).apply(2);
            SparkContext$.checkResourcesPerTask$1(StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(coresPerWorker)), sc);
            int memoryPerWorkerInt = StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(memoryPerWorker));
            if (sc.executorMemory() > memoryPerWorkerInt) {
                throw new SparkException(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("Asked to launch cluster with %d MiB RAM / worker but requested %d MiB/worker"), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)memoryPerWorkerInt), BoxesRunTime.boxToInteger((int)sc.executorMemory())})));
            }
            sc.conf().setIfMissing(package$.MODULE$.SHUFFLE_HOST_LOCAL_DISK_READING_ENABLED(), BoxesRunTime.boxToBoolean((boolean)false));
            TaskSchedulerImpl scheduler = new TaskSchedulerImpl(sc);
            LocalSparkCluster localCluster = new LocalSparkCluster(StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(numWorkers)), StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(coresPerWorker)), memoryPerWorkerInt, sc.conf());
            String[] masterUrls = localCluster.start();
            StandaloneSchedulerBackend backend6 = new StandaloneSchedulerBackend(scheduler, sc, masterUrls);
            scheduler.initialize(backend6);
            backend6.shutdownCallback_$eq((Function1<StandaloneSchedulerBackend, BoxedUnit>)(Function1 & Serializable)backend -> {
                localCluster.stop();
                return BoxedUnit.UNIT;
            });
            tuple2 = new Tuple2((Object)backend6, (Object)scheduler);
        } else {
            Tuple2 tuple22;
            ExternalClusterManager clusterMgr;
            Option<ExternalClusterManager> option5 = this.getClusterManager(string);
            if (!(option5 instanceof Some)) {
                if (None$.MODULE$.equals(option5)) {
                    throw new SparkException(new StringBuilder(30).append("Could not parse Master URL: '").append(master).append("'").toString());
                }
                throw new MatchError(option5);
            }
            Some some = (Some)option5;
            ExternalClusterManager externalClusterManager = clusterMgr = (ExternalClusterManager)some.value();
            ExternalClusterManager cm = externalClusterManager;
            try {
                TaskScheduler scheduler = cm.createTaskScheduler(sc, string);
                SchedulerBackend backend7 = cm.createSchedulerBackend(sc, string, scheduler);
                cm.initialize(scheduler, backend7);
                tuple22 = new Tuple2((Object)backend7, (Object)scheduler);
            }
            catch (Throwable throwable) {
                Option option6;
                Throwable throwable2 = throwable;
                if (throwable2 instanceof SparkException) {
                    SparkException sparkException = (SparkException)throwable2;
                    throw sparkException;
                }
                if (throwable2 != null && !(option6 = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                    Throwable e = (Throwable)option6.get();
                    throw new SparkException("External scheduler cannot be instantiated", e);
                }
                throw throwable;
            }
            tuple2 = tuple22;
        }
        return tuple2;
    }

    private Option<ExternalClusterManager> getClusterManager(String url) {
        ClassLoader loader = Utils$.MODULE$.getContextOrSparkClassLoader();
        Iterable serviceLoaders = (Iterable)((IterableOps)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(ServiceLoader.load(ExternalClusterManager.class, loader)).asScala()).filter((Function1 & Serializable)x$64 -> BoxesRunTime.boxToBoolean((boolean)x$64.canCreate(url)));
        if (serviceLoaders.size() > 1) {
            throw new SparkException(new StringBuilder(60).append("Multiple external cluster managers registered for the url ").append(url).append(": ").append(serviceLoaders).toString());
        }
        return serviceLoaders.headOption();
    }

    public void org$apache$spark$SparkContext$$fillMissingMagicCommitterConfsIfNeeded(SparkConf conf) {
        block1: {
            Tuple2[] magicCommitterConfs = (Tuple2[])ArrayOps$.MODULE$.filter$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.filter$extension(Predef$.MODULE$.refArrayOps((Object[])conf.getAllWithPrefix("spark.hadoop.fs.s3a.bucket.")), (Function1 & Serializable)x$65 -> BoxesRunTime.boxToBoolean((boolean)SparkContext$.$anonfun$fillMissingMagicCommitterConfsIfNeeded$1(x$65)))), (Function1 & Serializable)x$66 -> BoxesRunTime.boxToBoolean((boolean)SparkContext$.$anonfun$fillMissingMagicCommitterConfsIfNeeded$2(x$66)));
            if (!ArrayOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.refArrayOps((Object[])magicCommitterConfs))) break block1;
            conf.setIfMissing("spark.hadoop.fs.s3a.committer.magic.enabled", "true");
            if (conf.get("spark.hadoop.fs.s3a.committer.magic.enabled").equals("true")) {
                conf.setIfMissing("spark.hadoop.fs.s3a.committer.name", "magic");
                conf.setIfMissing("spark.hadoop.mapreduce.outputcommitter.factory.scheme.s3a", "org.apache.hadoop.fs.s3a.commit.S3ACommitterFactory");
                conf.setIfMissing("spark.sql.parquet.output.committer.class", "org.apache.spark.internal.io.cloud.BindingParquetOutputCommitter");
                conf.setIfMissing("spark.sql.sources.commitProtocolClass", "org.apache.spark.internal.io.cloud.PathOutputCommitProtocol");
            }
        }
    }

    public static final /* synthetic */ boolean $anonfun$assertNoOtherContextIsRunning$1(SparkContext sc$1, SparkContext x$60) {
        return x$60 != sc$1;
    }

    public static final /* synthetic */ boolean $anonfun$assertNoOtherContextIsRunning$3(SparkContext sc$1, SparkContext x$61) {
        return x$61 != sc$1;
    }

    public static final /* synthetic */ void $anonfun$assertNoOtherContextIsRunning$4(SparkContext otherContext) {
        String otherContextCreationSite = (String)Option$.MODULE$.apply((Object)otherContext.org$apache$spark$SparkContext$$creationSite()).map((Function1 & Serializable)x$62 -> x$62.longForm()).getOrElse((Function0 & Serializable)() -> "unknown location");
        String warnMsg = new StringBuilder(189).append("Another SparkContext is being constructed (or threw an exception in its constructor). This may indicate an error, since only one SparkContext should be running in this JVM (see SPARK-2243).").append(new StringBuilder(40).append(" The other SparkContext was created at:\n").append(otherContextCreationSite).toString()).toString();
        MODULE$.logWarning((Function0<String>)(Function0 & Serializable)() -> warnMsg);
    }

    private static final Writable anyToWritable$1(Writable u) {
        return u;
    }

    private static final int convertToInt$1(String threads) {
        String string = threads;
        String string2 = "*";
        return !(string != null ? !string.equals(string2) : string2 != null) ? Runtime.getRuntime().availableProcessors() : StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(threads));
    }

    private static final void checkResourcesPerTask$1(int executorCores, SparkContext sc$2) {
        int taskCores = BoxesRunTime.unboxToInt((Object)sc$2.conf().get(package$.MODULE$.CPUS_PER_TASK()));
        Object object = !BoxesRunTime.unboxToBoolean((Object)sc$2.conf().get(Tests$.MODULE$.SKIP_VALIDATE_CORES_TESTING())) ? BoxesRunTime.boxToBoolean((boolean)ResourceUtils$.MODULE$.validateTaskCpusLargeEnough(sc$2.conf(), executorCores, taskCores)) : BoxedUnit.UNIT;
        ResourceProfile defaultProf = sc$2.resourceProfileManager().defaultResourceProfile();
        ResourceUtils$.MODULE$.warnOnWastedResources(defaultProf, sc$2.conf(), (Option<Object>)new Some((Object)BoxesRunTime.boxToInteger((int)executorCores)));
    }

    private static final int localCpuCount$1() {
        return Runtime.getRuntime().availableProcessors();
    }

    private static final int localCpuCount$2() {
        return Runtime.getRuntime().availableProcessors();
    }

    public static final /* synthetic */ boolean $anonfun$fillMissingMagicCommitterConfsIfNeeded$1(Tuple2 x$65) {
        return ((String)x$65._1()).endsWith(".committer.magic.enabled");
    }

    public static final /* synthetic */ boolean $anonfun$fillMissingMagicCommitterConfsIfNeeded$2(Tuple2 x$66) {
        return ((String)x$66._2()).equalsIgnoreCase("true");
    }

    private SparkContext$() {
    }
}

