/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.fasterxml.jackson.module.scala.DefaultScalaModule$;
import java.io.Serializable;
import java.net.URL;
import org.apache.spark.ErrorInfo;
import org.apache.spark.util.Utils$;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Option$;
import scala.collection.immutable.SortedMap;

public final class SparkThrowableHelper$ {
    public static final SparkThrowableHelper$ MODULE$ = new SparkThrowableHelper$();
    private static final URL errorClassesUrl = Utils$.MODULE$.getSparkClassLoader().getResource("error/error-classes.json");
    private static final SortedMap<String, ErrorInfo> errorClassToInfoMap;

    static {
        JsonMapper mapper = (JsonMapper)JsonMapper.builder().addModule((Module)DefaultScalaModule$.MODULE$).build();
        errorClassToInfoMap = (SortedMap)mapper.readValue(MODULE$.errorClassesUrl(), (TypeReference)new TypeReference<SortedMap<String, ErrorInfo>>(){});
    }

    public URL errorClassesUrl() {
        return errorClassesUrl;
    }

    public SortedMap<String, ErrorInfo> errorClassToInfoMap() {
        return errorClassToInfoMap;
    }

    public String getMessage(String errorClass, String[] messageParameters) {
        ErrorInfo errorInfo = (ErrorInfo)this.errorClassToInfoMap().getOrElse((Object)errorClass, (Function0 & Serializable)() -> {
            throw new IllegalArgumentException(new StringBuilder(26).append("Cannot find error class '").append(errorClass).append("'").toString());
        });
        return String.format(errorInfo.messageFormat(), messageParameters);
    }

    public String getSqlState(String errorClass) {
        return (String)Option$.MODULE$.apply((Object)errorClass).flatMap((Function1 & Serializable)key -> MODULE$.errorClassToInfoMap().get(key)).flatMap((Function1 & Serializable)x$1 -> x$1.sqlState()).orNull((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    private SparkThrowableHelper$() {
    }
}

