/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.broadcast;

import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.ref.SoftReference;
import java.nio.ByteBuffer;
import java.util.Map;
import java.util.zip.Adler32;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkEnv$;
import org.apache.spark.SparkException;
import org.apache.spark.TaskContext;
import org.apache.spark.TaskContext$;
import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.broadcast.TorrentBroadcast$;
import org.apache.spark.io.CompressionCodec;
import org.apache.spark.io.CompressionCodec$;
import org.apache.spark.serializer.Serializer;
import org.apache.spark.storage.BlockData;
import org.apache.spark.storage.BlockId;
import org.apache.spark.storage.BlockManager;
import org.apache.spark.storage.BlockResult;
import org.apache.spark.storage.BroadcastBlockId;
import org.apache.spark.storage.BroadcastBlockId$;
import org.apache.spark.storage.ByteBufferBlockData;
import org.apache.spark.storage.StorageLevel;
import org.apache.spark.storage.StorageLevel$;
import org.apache.spark.util.Utils$;
import org.apache.spark.util.io.ChunkedByteBuffer;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.BuildFrom$;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.math.Integral;
import scala.math.Numeric;
import scala.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.util.Random$;

@ScalaSignature(bytes="\u0006\u0005\t}c!\u0002\u0017.\u0001=*\u0004\u0002\u0003-\u0001\u0005\u0003\u0005\u000b\u0011B\u001e\t\u0013e\u0003!\u0011!Q\u0001\nik\u0006\u0002\u00030\u0001\u0005\u0007\u0005\u000b1B0\t\u000b\u0015\u0004A\u0011\u00014\t\u00131\u0004\u0001\u0019!a\u0001\n\u0013i\u0007\"\u0003<\u0001\u0001\u0004\u0005\r\u0011\"\u0003x\u0011%i\b\u00011A\u0001B\u0003&a\u000eC\u0006\u0002\u0006\u0001\u0001\r\u00111A\u0005\n\u0005\u001d\u0001bCA\r\u0001\u0001\u0007\t\u0019!C\u0005\u00037A1\"a\b\u0001\u0001\u0004\u0005\t\u0015)\u0003\u0002\n!Y\u00111\u0005\u0001A\u0002\u0003\u0007I\u0011BA\u0013\u0011-\ti\u0003\u0001a\u0001\u0002\u0004%I!a\f\t\u0017\u0005M\u0002\u00011A\u0001B\u0003&\u0011q\u0005\u0005\n\u0003o\u0001\u0001\u0019!C\u0005\u0003sA\u0011\"!\u0011\u0001\u0001\u0004%I!a\u0011\t\u0011\u0005\u001d\u0003\u0001)Q\u0005\u0003wAq!!\u0013\u0001\t\u0013\tY\u0005C\u0005\u0002Z\u0001\u0011\r\u0011\"\u0003\u0002\\!A\u0011\u0011\u000e\u0001!\u0002\u0013\ti\u0006C\u0005\u0002l\u0001\u0011\r\u0011\"\u0003\u0002&!A\u0011Q\u000e\u0001!\u0002\u0013\t9\u0003C\u0006\u0002p\u0001\u0001\r\u00111A\u0005\n\u0005E\u0004bCA=\u0001\u0001\u0007\t\u0019!C\u0005\u0003wB1\"a \u0001\u0001\u0004\u0005\t\u0015)\u0003\u0002t!9\u0011\u0011\u0011\u0001\u0005R\u0005\r\u0005bBAC\u0001\u0011%\u0011q\u0011\u0005\b\u00033\u0003A\u0011BAN\u0011\u001d\t\t\u000b\u0001C\u0005\u0003GCq!!,\u0001\t#\ny\u000bC\u0004\u00026\u0002!\t&a.\t\u000f\u0005m\u0006\u0001\"\u0003\u0002>\"9\u0011\u0011\u001a\u0001\u0005\n\u0005\r\u0005bBAf\u0001\u0011%\u0011Q\u001a\u0005\u000e\u00033\u0004\u0001\u0013aA\u0001\u0002\u0013%\u00111\\/\b\u000f\u0005uW\u0006#\u0003\u0002`\u001a1A&\fE\u0005\u0003CDa!\u001a\u0013\u0005\u0002\u0005%\b\"CAvI\t\u0007I\u0011BAw\u0011!\tY\u0010\nQ\u0001\n\u0005=\bbBA\u007fI\u0011\u0005\u0011q \u0005\b\u0005K!C\u0011\u0001B\u0014\u0011\u001d\u00119\u0005\nC\u0001\u0005\u0013B\u0011Ba\u0015%\u0003\u0003%IA!\u0016\u0003!Q{'O]3oi\n\u0013x.\u00193dCN$(B\u0001\u00180\u0003%\u0011'o\\1eG\u0006\u001cHO\u0003\u00021c\u0005)1\u000f]1sW*\u0011!gM\u0001\u0007CB\f7\r[3\u000b\u0003Q\n1a\u001c:h+\t1Th\u0005\u0003\u0001o)\u0003\u0006c\u0001\u001d:w5\tQ&\u0003\u0002;[\tI!I]8bI\u000e\f7\u000f\u001e\t\u0003yub\u0001\u0001B\u0003?\u0001\t\u0007\u0001IA\u0001U\u0007\u0001\t\"!Q$\u0011\u0005\t+U\"A\"\u000b\u0003\u0011\u000bQa]2bY\u0006L!AR\"\u0003\u000f9{G\u000f[5oOB\u0011!\tS\u0005\u0003\u0013\u000e\u00131!\u00118z!\tYe*D\u0001M\u0015\tiu&\u0001\u0005j]R,'O\\1m\u0013\tyEJA\u0004M_\u001e<\u0017N\\4\u0011\u0005E3V\"\u0001*\u000b\u0005M#\u0016AA5p\u0015\u0005)\u0016\u0001\u00026bm\u0006L!a\u0016*\u0003\u0019M+'/[1mSj\f'\r\\3\u0002\u0007=\u0014'.\u0001\u0002jIB\u0011!iW\u0005\u00039\u000e\u0013A\u0001T8oO&\u0011\u0011,O\u0001\u000bKZLG-\u001a8dK\u0012\n\u0004c\u00011dw5\t\u0011M\u0003\u0002c\u0007\u00069!/\u001a4mK\u000e$\u0018B\u00013b\u0005!\u0019E.Y:t)\u0006<\u0017A\u0002\u001fj]&$h\bF\u0002hU.$\"\u0001[5\u0011\u0007a\u00021\bC\u0003_\t\u0001\u000fq\fC\u0003Y\t\u0001\u00071\bC\u0003Z\t\u0001\u0007!,\u0001\u0004`m\u0006dW/Z\u000b\u0002]B\u0019q\u000e^\u001e\u000e\u0003AT!!\u001d:\u0002\u0007I,gM\u0003\u0002t)\u0006!A.\u00198h\u0013\t)\bOA\u0007T_\u001a$(+\u001a4fe\u0016t7-Z\u0001\u000b?Z\fG.^3`I\u0015\fHC\u0001=|!\t\u0011\u00150\u0003\u0002{\u0007\n!QK\\5u\u0011\u001dah!!AA\u00029\f1\u0001\u001f\u00132\u0003\u001dyf/\u00197vK\u0002B#aB@\u0011\u0007\t\u000b\t!C\u0002\u0002\u0004\r\u0013\u0011\u0002\u001e:b]NLWM\u001c;\u0002!\r|W\u000e\u001d:fgNLwN\\\"pI\u0016\u001cWCAA\u0005!\u0015\u0011\u00151BA\b\u0013\r\tia\u0011\u0002\u0007\u001fB$\u0018n\u001c8\u0011\t\u0005E\u0011QC\u0007\u0003\u0003'Q!aU\u0018\n\t\u0005]\u00111\u0003\u0002\u0011\u0007>l\u0007O]3tg&|gnQ8eK\u000e\fAcY8naJ,7o]5p]\u000e{G-Z2`I\u0015\fHc\u0001=\u0002\u001e!AA0CA\u0001\u0002\u0004\tI!A\td_6\u0004(/Z:tS>t7i\u001c3fG\u0002B#AC@\u0002\u0013\tdwnY6TSj,WCAA\u0014!\r\u0011\u0015\u0011F\u0005\u0004\u0003W\u0019%aA%oi\u0006i!\r\\8dWNK'0Z0%KF$2\u0001_A\u0019\u0011!aH\"!AA\u0002\u0005\u001d\u0012A\u00032m_\u000e\\7+\u001b>fA!\u0012Qb`\u0001\u0010G\",7m[:v[\u0016s\u0017M\u00197fIV\u0011\u00111\b\t\u0004\u0005\u0006u\u0012bAA \u0007\n9!i\\8mK\u0006t\u0017aE2iK\u000e\\7/^7F]\u0006\u0014G.\u001a3`I\u0015\fHc\u0001=\u0002F!AApDA\u0001\u0002\u0004\tY$\u0001\tdQ\u0016\u001c7n];n\u000b:\f'\r\\3eA\u000591/\u001a;D_:4Gc\u0001=\u0002N!9\u0011qJ\tA\u0002\u0005E\u0013\u0001B2p]\u001a\u0004B!a\u0015\u0002V5\tq&C\u0002\u0002X=\u0012\u0011b\u00159be.\u001cuN\u001c4\u0002\u0017\t\u0014x.\u00193dCN$\u0018\nZ\u000b\u0003\u0003;\u0002B!a\u0018\u0002f5\u0011\u0011\u0011\r\u0006\u0004\u0003Gz\u0013aB:u_J\fw-Z\u0005\u0005\u0003O\n\tG\u0001\tCe>\fGmY1ti\ncwnY6JI\u0006a!M]8bI\u000e\f7\u000f^%eA\u0005Ia.^7CY>\u001c7n]\u0001\u000b]Vl'\t\\8dWN\u0004\u0013!C2iK\u000e\\7/^7t+\t\t\u0019\bE\u0003C\u0003k\n9#C\u0002\u0002x\r\u0013Q!\u0011:sCf\fQb\u00195fG.\u001cX/\\:`I\u0015\fHc\u0001=\u0002~!AApFA\u0001\u0002\u0004\t\u0019(\u0001\u0006dQ\u0016\u001c7n];ng\u0002\n\u0001bZ3u-\u0006dW/\u001a\u000b\u0002w\u0005a1-\u00197d\u0007\",7m[:v[R!\u0011qEAE\u0011\u001d\tYI\u0007a\u0001\u0003\u001b\u000bQA\u00197pG.\u0004B!a$\u0002\u00166\u0011\u0011\u0011\u0013\u0006\u0004\u0003'#\u0016a\u00018j_&!\u0011qSAI\u0005)\u0011\u0015\u0010^3Ck\u001a4WM]\u0001\foJLG/\u001a\"m_\u000e\\7\u000f\u0006\u0003\u0002(\u0005u\u0005BBAP7\u0001\u00071(A\u0003wC2,X-\u0001\u0006sK\u0006$'\t\\8dWN$\"!!*\u0011\u000b\t\u000b)(a*\u0011\t\u0005}\u0013\u0011V\u0005\u0005\u0003W\u000b\tGA\u0005CY>\u001c7\u000eR1uC\u0006YAm\\+oa\u0016\u00148/[:u)\rA\u0018\u0011\u0017\u0005\b\u0003gk\u0002\u0019AA\u001e\u0003!\u0011Gn\\2lS:<\u0017!\u00033p\t\u0016\u001cHO]8z)\rA\u0018\u0011\u0018\u0005\b\u0003gs\u0002\u0019AA\u001e\u0003-9(/\u001b;f\u001f\nTWm\u0019;\u0015\u0007a\fy\fC\u0004\u0002B~\u0001\r!a1\u0002\u0007=,H\u000fE\u0002R\u0003\u000bL1!a2S\u0005Iy%M[3di>+H\u000f];u'R\u0014X-Y7\u0002%I,\u0017\r\u001a\"s_\u0006$7-Y:u\u00052|7m[\u0001\u0018e\u0016dW-Y:f\u00052|7m['b]\u0006<WM\u001d'pG.$2\u0001_Ah\u0011\u001d\t\t.\ta\u0001\u0003'\fqA\u00197pG.LE\r\u0005\u0003\u0002`\u0005U\u0017\u0002BAl\u0003C\u0012qA\u00117pG.LE-\u0001\u0005tkB,'\u000fJ5e+\u0005Q\u0016\u0001\u0005+peJ,g\u000e\u001e\"s_\u0006$7-Y:u!\tADeE\u0003%\u0003GT\u0005\u000bE\u0002C\u0003KL1!a:D\u0005\u0019\te.\u001f*fMR\u0011\u0011q\\\u0001\u0015i>\u0014(/\u001a8u\u0005J|\u0017\rZ2bgRdunY6\u0016\u0005\u0005=\bCBAy\u0003o\fi&\u0004\u0002\u0002t*\u0019\u0011Q_\u0018\u0002\tU$\u0018\u000e\\\u0005\u0005\u0003s\f\u0019PA\u0004LKfdunY6\u0002+Q|'O]3oi\n\u0013x.\u00193dCN$Hj\\2lA\u0005q!\r\\8dW&4\u0017p\u00142kK\u000e$X\u0003\u0002B\u0001\u0005\u001f!\"Ba\u0001\u0003\u0012\tM!Q\u0003B\u0012)\u0011\u0011)Aa\u0002\u0011\u000b\t\u000b)(!$\t\u0013\t%\u0001&!AA\u0004\t-\u0011AC3wS\u0012,gnY3%eA!\u0001m\u0019B\u0007!\ra$q\u0002\u0003\u0006}!\u0012\r\u0001\u0011\u0005\u00071\"\u0002\rA!\u0004\t\u000f\u0005\r\u0002\u00061\u0001\u0002(!9!q\u0003\u0015A\u0002\te\u0011AC:fe&\fG.\u001b>feB!!1\u0004B\u0010\u001b\t\u0011iBC\u0002\u0003\u0018=JAA!\t\u0003\u001e\tQ1+\u001a:jC2L'0\u001a:\t\u000f\u0005\u0015\u0001\u00061\u0001\u0002\n\u0005\u0001RO\u001c\"m_\u000e\\\u0017NZ=PE*,7\r^\u000b\u0005\u0005S\u0011y\u0003\u0006\u0005\u0003,\t]\"1\tB#)\u0011\u0011iC!\r\u0011\u0007q\u0012y\u0003B\u0003?S\t\u0007\u0001\tC\u0005\u00034%\n\t\u0011q\u0001\u00036\u0005QQM^5eK:\u001cW\rJ\u001a\u0011\t\u0001\u001c'Q\u0006\u0005\b\u0005sI\u0003\u0019\u0001B\u001e\u0003\u0019\u0011Gn\\2lgB)!)!\u001e\u0003>A\u0019\u0011Ka\u0010\n\u0007\t\u0005#KA\u0006J]B,Ho\u0015;sK\u0006l\u0007b\u0002B\fS\u0001\u0007!\u0011\u0004\u0005\b\u0003\u000bI\u0003\u0019AA\u0005\u0003%)h\u000e]3sg&\u001cH\u000fF\u0004y\u0005\u0017\u0012iE!\u0015\t\u000beS\u0003\u0019\u0001.\t\u000f\t=#\u00061\u0001\u0002<\u0005\u0001\"/Z7pm\u00164%o\\7Ee&4XM\u001d\u0005\b\u0003gS\u0003\u0019AA\u001e\u000319(/\u001b;f%\u0016\u0004H.Y2f)\t\u00119\u0006\u0005\u0003\u0003Z\tmS\"\u0001:\n\u0007\tu#O\u0001\u0004PE*,7\r\u001e")
public class TorrentBroadcast<T>
extends Broadcast<T> {
    private final ClassTag<T> evidence$1;
    private transient SoftReference<T> _value;
    private transient Option<CompressionCodec> compressionCodec;
    private transient int blockSize;
    private boolean checksumEnabled;
    private final BroadcastBlockId broadcastId;
    private final int numBlocks;
    private int[] checksums;

    public static <T> T unBlockifyObject(InputStream[] inputStreamArray, Serializer serializer, Option<CompressionCodec> option, ClassTag<T> classTag) {
        return TorrentBroadcast$.MODULE$.unBlockifyObject(inputStreamArray, serializer, option, classTag);
    }

    public static <T> ByteBuffer[] blockifyObject(T t, int n, Serializer serializer, Option<CompressionCodec> option, ClassTag<T> classTag) {
        return TorrentBroadcast$.MODULE$.blockifyObject(t, n, serializer, option, classTag);
    }

    private /* synthetic */ long super$id() {
        return super.id();
    }

    private SoftReference<T> _value() {
        return this._value;
    }

    private void _value_$eq(SoftReference<T> x$1) {
        this._value = x$1;
    }

    private Option<CompressionCodec> compressionCodec() {
        return this.compressionCodec;
    }

    private void compressionCodec_$eq(Option<CompressionCodec> x$1) {
        this.compressionCodec = x$1;
    }

    private int blockSize() {
        return this.blockSize;
    }

    private void blockSize_$eq(int x$1) {
        this.blockSize = x$1;
    }

    private boolean checksumEnabled() {
        return this.checksumEnabled;
    }

    private void checksumEnabled_$eq(boolean x$1) {
        this.checksumEnabled = x$1;
    }

    private void setConf(SparkConf conf) {
        this.compressionCodec_$eq((Option<CompressionCodec>)(BoxesRunTime.unboxToBoolean((Object)conf.get(org.apache.spark.internal.config.package$.MODULE$.BROADCAST_COMPRESS())) ? new Some((Object)CompressionCodec$.MODULE$.createCodec(conf)) : None$.MODULE$));
        this.blockSize_$eq((int)BoxesRunTime.unboxToLong((Object)conf.get(org.apache.spark.internal.config.package$.MODULE$.BROADCAST_BLOCKSIZE())) * 1024);
        this.checksumEnabled_$eq(BoxesRunTime.unboxToBoolean((Object)conf.get(org.apache.spark.internal.config.package$.MODULE$.BROADCAST_CHECKSUM())));
    }

    private BroadcastBlockId broadcastId() {
        return this.broadcastId;
    }

    private int numBlocks() {
        return this.numBlocks;
    }

    private int[] checksums() {
        return this.checksums;
    }

    private void checksums_$eq(int[] x$1) {
        this.checksums = x$1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public synchronized T getValue() {
        T t;
        T memoized;
        T t2 = memoized = this._value() == null ? null : (T)this._value().get();
        if (memoized != null) {
            t = memoized;
        } else {
            void var2_2;
            T newlyRead = this.readBroadcastBlock();
            this._value_$eq(new SoftReference<T>(newlyRead));
            t = var2_2;
        }
        return t;
    }

    private int calcChecksum(ByteBuffer block) {
        Adler32 adler = new Adler32();
        if (block.hasArray()) {
            adler.update(block.array(), block.arrayOffset() + block.position(), block.limit() - block.position());
        } else {
            byte[] bytes = new byte[block.remaining()];
            block.duplicate().get(bytes);
            adler.update(bytes);
        }
        return (int)adler.getValue();
    }

    private int writeBlocks(T value) {
        int n;
        BlockManager blockManager = SparkEnv$.MODULE$.get().blockManager();
        if (!blockManager.putSingle(this.broadcastId(), value, StorageLevel$.MODULE$.MEMORY_AND_DISK(), false, this.evidence$1)) {
            throw new SparkException(new StringBuilder(32).append("Failed to store ").append(this.broadcastId()).append(" in BlockManager").toString());
        }
        try {
            ByteBuffer[] blocks = TorrentBroadcast$.MODULE$.blockifyObject(value, this.blockSize(), SparkEnv$.MODULE$.get().serializer(), this.compressionCodec(), this.evidence$1);
            if (this.checksumEnabled()) {
                this.checksums_$eq(new int[blocks.length]);
            }
            ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.zipWithIndex$extension(Predef$.MODULE$.refArrayOps((Object[])blocks))), (Function1 & Serializable)x0$1 -> {
                TorrentBroadcast.$anonfun$writeBlocks$1(this, blockManager, x0$1);
                return BoxedUnit.UNIT;
            });
            n = blocks.length;
        }
        catch (Throwable t) {
            this.logError((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(57).append("Store broadcast ").append(this.broadcastId()).append(" fail, remove all pieces of the broadcast").toString());
            blockManager.removeBroadcast(super.id(), true);
            throw t;
        }
        return n;
    }

    /*
     * WARNING - void declaration
     */
    private BlockData[] readBlocks() {
        void var1_1;
        BlockData[] blocks = new BlockData[this.numBlocks()];
        BlockManager bm = SparkEnv$.MODULE$.get().blockManager();
        ((IterableOnceOps)Random$.MODULE$.shuffle((IterableOnce)package$.MODULE$.Seq().range((Object)BoxesRunTime.boxToInteger((int)0), (Object)BoxesRunTime.boxToInteger((int)this.numBlocks()), (Integral)Numeric.IntIsIntegral$.MODULE$), BuildFrom$.MODULE$.buildFromIterableOps())).foreach((Function1)(JFunction1.mcVI.sp & Serializable)pid -> {
            BroadcastBlockId pieceId = new BroadcastBlockId(this.super$id(), new StringBuilder(5).append("piece").append(pid).toString());
            this.logDebug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(18).append("Reading piece ").append(pieceId).append(" of ").append(this.broadcastId()).toString());
            Option<BlockData> option = bm.getLocalBytes(pieceId);
            if (option instanceof Some) {
                BlockData block;
                Some some = (Some)option;
                blocks$1[pid] = block = (BlockData)some.value();
                this.releaseBlockManagerLock(pieceId);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (None$.MODULE$.equals(option)) {
                ChunkedByteBuffer b;
                Option<ChunkedByteBuffer> option2 = bm.getRemoteBytes(pieceId);
                if (option2 instanceof Some) {
                    int sum;
                    Some some = (Some)option2;
                    b = (ChunkedByteBuffer)some.value();
                    if (this.checksumEnabled() && (sum = this.calcChecksum(b.chunks()[0])) != this.checksums()[pid]) {
                        throw new SparkException(new StringBuilder(0).append(new StringBuilder(26).append("corrupt remote block ").append(pieceId).append(" of ").append(this.broadcastId()).append(":").toString()).append(new StringBuilder(5).append(" ").append(sum).append(" != ").append(this.checksums()[pid]).toString()).toString());
                    }
                    if (!bm.putBytes(pieceId, b, StorageLevel$.MODULE$.MEMORY_AND_DISK_SER(), true, $this.evidence$1)) {
                        throw new SparkException(new StringBuilder(42).append("Failed to store ").append(pieceId).append(" of ").append(this.broadcastId()).append(" in local BlockManager").toString());
                    }
                } else {
                    if (None$.MODULE$.equals(option2)) {
                        throw new SparkException(new StringBuilder(18).append("Failed to get ").append(pieceId).append(" of ").append(this.broadcastId()).toString());
                    }
                    throw new MatchError(option2);
                }
                blocks$1[pid] = new ByteBufferBlockData(b, true);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                BoxedUnit boxedUnit2 = BoxedUnit.UNIT;
            } else {
                throw new MatchError(option);
            }
        });
        return var1_1;
    }

    @Override
    public void doUnpersist(boolean blocking) {
        TorrentBroadcast$.MODULE$.unpersist(super.id(), false, blocking);
    }

    @Override
    public void doDestroy(boolean blocking) {
        TorrentBroadcast$.MODULE$.unpersist(super.id(), true, blocking);
    }

    private void writeObject(ObjectOutputStream out) {
        Utils$.MODULE$.tryOrIOException((JFunction0.mcV.sp & Serializable)() -> {
            this.assertValid();
            out.defaultWriteObject();
        });
    }

    private T readBroadcastBlock() {
        return Utils$.MODULE$.tryOrIOException((Function0 & Serializable)() -> TorrentBroadcast$.MODULE$.org$apache$spark$broadcast$TorrentBroadcast$$torrentBroadcastLock().withLock(this.broadcastId(), (Function0 & Serializable)() -> {
            Map<Object, Object> broadcastCache = SparkEnv$.MODULE$.get().broadcastManager().cachedValues();
            return Option$.MODULE$.apply(broadcastCache.get(this.broadcastId())).map((Function1 & Serializable)x$5 -> x$5).getOrElse((Function0 & Serializable)() -> {
                Object object;
                this.setConf(SparkEnv$.MODULE$.get().conf());
                BlockManager blockManager = SparkEnv$.MODULE$.get().blockManager();
                Option<BlockResult> option = blockManager.getLocalValues(this.broadcastId());
                if (option instanceof Some) {
                    Some some = (Some)option;
                    BlockResult blockResult = (BlockResult)some.value();
                    if (!blockResult.data().hasNext()) {
                        throw new SparkException(new StringBuilder(45).append("Failed to get locally stored broadcast data: ").append(this.broadcastId()).toString());
                    }
                    Object x = blockResult.data().next();
                    this.releaseBlockManagerLock(this.broadcastId());
                    Object object2 = x != null ? broadcastCache.put(this.broadcastId(), x) : BoxedUnit.UNIT;
                    object = x;
                } else if (None$.MODULE$.equals(option)) {
                    Object t;
                    String estimatedTotalSize = Utils$.MODULE$.bytesToString(this.numBlocks() * this.blockSize());
                    this.logInfo((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(0).append(new StringBuilder(49).append("Started reading broadcast variable ").append(this.super$id()).append(" with ").append(this.numBlocks()).append(" pieces ").toString()).append(new StringBuilder(23).append("(estimated total size ").append(estimatedTotalSize).append(")").toString()).toString());
                    long startTimeNs = System.nanoTime();
                    BlockData[] blocks = this.readBlocks();
                    this.logInfo((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(33).append("Reading broadcast variable ").append(this.super$id()).append(" took ").append(Utils$.MODULE$.getUsedTimeNs(startTimeNs)).toString());
                    try {
                        Object obj = TorrentBroadcast$.MODULE$.unBlockifyObject((InputStream[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])blocks), (Function1 & Serializable)x$6 -> x$6.toInputStream(), ClassTag$.MODULE$.apply(InputStream.class)), SparkEnv$.MODULE$.get().serializer(), this.compressionCodec(), $this.evidence$1);
                        StorageLevel storageLevel = StorageLevel$.MODULE$.MEMORY_AND_DISK();
                        if (!blockManager.putSingle(this.broadcastId(), obj, storageLevel, false, $this.evidence$1)) {
                            throw new SparkException(new StringBuilder(32).append("Failed to store ").append(this.broadcastId()).append(" in BlockManager").toString());
                        }
                        Object object3 = obj != null ? broadcastCache.put(this.broadcastId(), obj) : BoxedUnit.UNIT;
                        t = obj;
                    }
                    finally {
                        ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps((Object[])blocks), (Function1 & Serializable)x$7 -> {
                            x$7.dispose();
                            return BoxedUnit.UNIT;
                        });
                    }
                    object = t;
                } else {
                    throw new MatchError(option);
                }
                return object;
            });
        }));
    }

    private void releaseBlockManagerLock(BlockId blockId) {
        BlockManager blockManager = SparkEnv$.MODULE$.get().blockManager();
        Option option = Option$.MODULE$.apply((Object)TaskContext$.MODULE$.get());
        if (option instanceof Some) {
            Some some = (Some)option;
            TaskContext taskContext = (TaskContext)some.value();
            taskContext.addTaskCompletionListener((Function1 & Serializable)x$8 -> {
                blockManager.releaseLock(blockId, blockManager.releaseLock$default$2());
                return BoxedUnit.UNIT;
            });
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (None$.MODULE$.equals(option)) {
            blockManager.releaseLock(blockId, blockManager.releaseLock$default$2());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError((Object)option);
        }
    }

    public static final /* synthetic */ void $anonfun$writeBlocks$1(TorrentBroadcast $this, BlockManager blockManager$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            ChunkedByteBuffer bytes;
            BroadcastBlockId pieceId;
            ByteBuffer block = (ByteBuffer)tuple2._1();
            int i = tuple2._2$mcI$sp();
            if ($this.checksumEnabled()) {
                $this.checksums()[i] = $this.calcChecksum(block);
            }
            if (!blockManager$1.putBytes(pieceId = new BroadcastBlockId($this.super$id(), new StringBuilder(5).append("piece").append(i).toString()), bytes = new ChunkedByteBuffer(block.duplicate()), StorageLevel$.MODULE$.MEMORY_AND_DISK_SER(), true, $this.evidence$1)) {
                throw new SparkException(new StringBuilder(0).append(new StringBuilder(21).append("Failed to store ").append(pieceId).append(" of ").append($this.broadcastId()).append(" ").toString()).append("in local BlockManager").toString());
            }
        } else {
            throw new MatchError((Object)tuple2);
        }
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public TorrentBroadcast(T obj, long id, ClassTag<T> evidence$1) {
        this.evidence$1 = evidence$1;
        super(id, evidence$1);
        this.checksumEnabled = false;
        this.setConf(SparkEnv$.MODULE$.get().conf());
        this.broadcastId = new BroadcastBlockId(super.id(), BroadcastBlockId$.MODULE$.apply$default$2());
        this.numBlocks = this.writeBlocks(obj);
    }
}

