/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.deploy;

import java.io.Serializable;
import org.apache.spark.SparkConf;
import org.apache.spark.deploy.master.Master$;
import org.apache.spark.deploy.worker.Worker$;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.config.package$;
import org.apache.spark.rpc.RpcEnv;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

@ScalaSignature(bytes="\u0006\u000554Q!\u0005\n\u0001)iA\u0001b\n\u0001\u0003\u0002\u0003\u0006I!\u000b\u0005\tY\u0001\u0011\t\u0011)A\u0005S!AQ\u0006\u0001B\u0001B\u0003%\u0011\u0006\u0003\u0005/\u0001\t\u0005\t\u0015!\u00030\u0011\u0015\u0019\u0004\u0001\"\u00015\u0011\u001dY\u0004A1A\u0005\nqBa\u0001\u0013\u0001!\u0002\u0013i\u0004bB%\u0001\u0005\u0004%IA\u0013\u0005\u00073\u0002\u0001\u000b\u0011B&\t\u000fi\u0003!\u0019!C\u0005\u0015\"11\f\u0001Q\u0001\n-Cq\u0001\u0018\u0001A\u0002\u0013\u0005Q\fC\u0004_\u0001\u0001\u0007I\u0011A0\t\r\u0015\u0004\u0001\u0015)\u0003*\u0011\u00151\u0007\u0001\"\u0001h\u0011\u0015Y\u0007\u0001\"\u0001m\u0005EaunY1m'B\f'o[\"mkN$XM\u001d\u0006\u0003'Q\ta\u0001Z3qY>L(BA\u000b\u0017\u0003\u0015\u0019\b/\u0019:l\u0015\t9\u0002$\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u00023\u0005\u0019qN]4\u0014\u0007\u0001Y\u0012\u0005\u0005\u0002\u001d?5\tQDC\u0001\u001f\u0003\u0015\u00198-\u00197b\u0013\t\u0001SD\u0001\u0004B]f\u0014VM\u001a\t\u0003E\u0015j\u0011a\t\u0006\u0003IQ\t\u0001\"\u001b8uKJt\u0017\r\\\u0005\u0003M\r\u0012q\u0001T8hO&tw-\u0001\u0006ok6<vN]6feN\u001c\u0001\u0001\u0005\u0002\u001dU%\u00111&\b\u0002\u0004\u0013:$\u0018AD2pe\u0016\u001c\b+\u001a:X_J\\WM]\u0001\u0010[\u0016lwN]=QKJ<vN]6fe\u0006!1m\u001c8g!\t\u0001\u0014'D\u0001\u0015\u0013\t\u0011DCA\u0005Ta\u0006\u00148nQ8oM\u00061A(\u001b8jiz\"R!N\u001c9si\u0002\"A\u000e\u0001\u000e\u0003IAQaJ\u0003A\u0002%BQ\u0001L\u0003A\u0002%BQ!L\u0003A\u0002%BQAL\u0003A\u0002=\nQ\u0002\\8dC2Dun\u001d;oC6,W#A\u001f\u0011\u0005y*eBA D!\t\u0001U$D\u0001B\u0015\t\u0011\u0005&\u0001\u0004=e>|GOP\u0005\u0003\tv\ta\u0001\u0015:fI\u00164\u0017B\u0001$H\u0005\u0019\u0019FO]5oO*\u0011A)H\u0001\u000fY>\u001c\u0017\r\u001c%pgRt\u0017-\\3!\u00035i\u0017m\u001d;feJ\u00038-\u00128wgV\t1\nE\u0002M#Nk\u0011!\u0014\u0006\u0003\u001d>\u000bq!\\;uC\ndWM\u0003\u0002Q;\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\u0005Ik%aC!se\u0006L()\u001e4gKJ\u0004\"\u0001V,\u000e\u0003US!A\u0016\u000b\u0002\u0007I\u00048-\u0003\u0002Y+\n1!\u000b]2F]Z\fa\"\\1ti\u0016\u0014(\u000b]2F]Z\u001c\b%A\u0007x_J\\WM\u001d*qG\u0016sgo]\u0001\u000fo>\u00148.\u001a:Sa\u000e,eN^:!\u0003=i\u0017m\u001d;fe^+'-V%Q_J$X#A\u0015\u0002'5\f7\u000f^3s/\u0016\u0014W+\u0013)peR|F%Z9\u0015\u0005\u0001\u001c\u0007C\u0001\u000fb\u0013\t\u0011WD\u0001\u0003V]&$\bb\u00023\u000e\u0003\u0003\u0005\r!K\u0001\u0004q\u0012\n\u0014\u0001E7bgR,'oV3c+&\u0003vN\u001d;!\u0003\u0015\u0019H/\u0019:u)\u0005A\u0007c\u0001\u000fj{%\u0011!.\b\u0002\u0006\u0003J\u0014\u0018-_\u0001\u0005gR|\u0007\u000fF\u0001a\u0001")
public class LocalSparkCluster
implements Logging {
    private final int numWorkers;
    private final int coresPerWorker;
    private final int memoryPerWorker;
    private final SparkConf conf;
    private final String localHostname;
    private final ArrayBuffer<RpcEnv> masterRpcEnvs;
    private final ArrayBuffer<RpcEnv> workerRpcEnvs;
    private int masterWebUIPort;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    @Override
    public String logName() {
        return Logging.logName$(this);
    }

    @Override
    public Logger log() {
        return Logging.log$(this);
    }

    @Override
    public void logInfo(Function0<String> msg) {
        Logging.logInfo$(this, msg);
    }

    @Override
    public void logDebug(Function0<String> msg) {
        Logging.logDebug$(this, msg);
    }

    @Override
    public void logTrace(Function0<String> msg) {
        Logging.logTrace$(this, msg);
    }

    @Override
    public void logWarning(Function0<String> msg) {
        Logging.logWarning$(this, msg);
    }

    @Override
    public void logError(Function0<String> msg) {
        Logging.logError$(this, msg);
    }

    @Override
    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$(this, msg, throwable);
    }

    @Override
    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$(this, msg, throwable);
    }

    @Override
    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$(this, msg, throwable);
    }

    @Override
    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$(this, msg, throwable);
    }

    @Override
    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$(this, msg, throwable);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$(this, isInterpreter);
    }

    @Override
    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$(this, isInterpreter, silent);
    }

    @Override
    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$(this);
    }

    @Override
    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$(this, isInterpreter, silent);
    }

    @Override
    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    @Override
    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private String localHostname() {
        return this.localHostname;
    }

    private ArrayBuffer<RpcEnv> masterRpcEnvs() {
        return this.masterRpcEnvs;
    }

    private ArrayBuffer<RpcEnv> workerRpcEnvs() {
        return this.workerRpcEnvs;
    }

    public int masterWebUIPort() {
        return this.masterWebUIPort;
    }

    public void masterWebUIPort_$eq(int x$1) {
        this.masterWebUIPort = x$1;
    }

    public String[] start() {
        this.logInfo((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(45).append("Starting a local Spark cluster with ").append($this.numWorkers).append(" workers.").toString());
        SparkConf _conf = this.conf.clone().setIfMissing(package$.MODULE$.MASTER_REST_SERVER_ENABLED(), BoxesRunTime.boxToBoolean((boolean)false)).set(package$.MODULE$.SHUFFLE_SERVICE_ENABLED(), BoxesRunTime.boxToBoolean((boolean)false));
        Tuple3<RpcEnv, Object, Option<Object>> tuple3 = Master$.MODULE$.startRpcEnvAndEndpoint(this.localHostname(), 0, 0, _conf);
        if (tuple3 == null) {
            throw new MatchError(tuple3);
        }
        RpcEnv rpcEnv = (RpcEnv)tuple3._1();
        int webUiPort = BoxesRunTime.unboxToInt((Object)tuple3._2());
        Tuple2 tuple2 = new Tuple2((Object)rpcEnv, (Object)BoxesRunTime.boxToInteger((int)webUiPort));
        Tuple2 tuple22 = tuple2;
        RpcEnv rpcEnv2 = (RpcEnv)tuple22._1();
        int webUiPort2 = tuple22._2$mcI$sp();
        this.masterWebUIPort_$eq(webUiPort2);
        this.masterRpcEnvs().$plus$eq((Object)rpcEnv2);
        String masterUrl = new StringBuilder(9).append("spark://").append(Utils$.MODULE$.localHostNameForURI()).append(":").append(rpcEnv2.address().port()).toString();
        String[] masters = (String[])((Object[])new String[]{masterUrl});
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), this.numWorkers).foreach((Function1 & Serializable)workerNum -> LocalSparkCluster.$anonfun$start$2(this, masters, _conf, BoxesRunTime.unboxToInt((Object)workerNum)));
        return masters;
    }

    public void stop() {
        this.logInfo((Function0<String>)(Function0 & Serializable)() -> "Shutting down local Spark cluster.");
        this.workerRpcEnvs().foreach((Function1 & Serializable)x$2 -> {
            x$2.shutdown();
            return BoxedUnit.UNIT;
        });
        this.workerRpcEnvs().foreach((Function1 & Serializable)x$3 -> {
            x$3.awaitTermination();
            return BoxedUnit.UNIT;
        });
        this.masterRpcEnvs().foreach((Function1 & Serializable)x$4 -> {
            x$4.shutdown();
            return BoxedUnit.UNIT;
        });
        this.masterRpcEnvs().foreach((Function1 & Serializable)x$5 -> {
            x$5.awaitTermination();
            return BoxedUnit.UNIT;
        });
        this.masterRpcEnvs().clear();
        this.workerRpcEnvs().clear();
    }

    public static final /* synthetic */ ArrayBuffer $anonfun$start$2(LocalSparkCluster $this, String[] masters$1, SparkConf _conf$1, int workerNum) {
        String string;
        if (Utils$.MODULE$.isTesting()) {
            String x$1 = "worker";
            String x$2 = Utils$.MODULE$.createTempDir$default$1();
            string = Utils$.MODULE$.createTempDir(x$2, "worker").getAbsolutePath();
        } else {
            string = null;
        }
        String workDir = string;
        RpcEnv workerEnv = Worker$.MODULE$.startRpcEnvAndEndpoint($this.localHostname(), 0, 0, $this.coresPerWorker, $this.memoryPerWorker, masters$1, workDir, (Option<Object>)new Some((Object)BoxesRunTime.boxToInteger((int)workerNum)), _conf$1, (Option<String>)((Option)$this.conf.get(org.apache.spark.internal.config.Worker$.MODULE$.SPARK_WORKER_RESOURCE_FILE())));
        return (ArrayBuffer)$this.workerRpcEnvs().$plus$eq((Object)workerEnv);
    }

    public LocalSparkCluster(int numWorkers, int coresPerWorker, int memoryPerWorker, SparkConf conf) {
        this.numWorkers = numWorkers;
        this.coresPerWorker = coresPerWorker;
        this.memoryPerWorker = memoryPerWorker;
        this.conf = conf;
        Logging.$init$(this);
        this.localHostname = Utils$.MODULE$.localHostName();
        this.masterRpcEnvs = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.workerRpcEnvs = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.masterWebUIPort = -1;
    }
}

