/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.deploy;

import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.spark.SparkConf;
import org.apache.spark.deploy.SparkHadoopUtil;
import org.apache.spark.internal.Logging;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnceOps;
import scala.collection.JavaConverters$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class SparkHadoopUtil$
implements Logging {
    public static final SparkHadoopUtil$ MODULE$ = new SparkHadoopUtil$();
    private static SparkHadoopUtil instance;
    private static Seq<Map.Entry<String, String>> hiveConfKeys;
    private static final String SPARK_YARN_CREDS_TEMP_EXTENSION;
    private static final String SPARK_YARN_CREDS_COUNTER_DELIM;
    private static final int UPDATE_INPUT_METRICS_INTERVAL_RECORDS;
    private static final String SPARK_HADOOP_CONF_FILE;
    private static transient Logger org$apache$spark$internal$Logging$$log_;
    private static volatile byte bitmap$0;

    static {
        Logging.$init$(MODULE$);
        SPARK_YARN_CREDS_TEMP_EXTENSION = ".tmp";
        SPARK_YARN_CREDS_COUNTER_DELIM = "-";
        UPDATE_INPUT_METRICS_INTERVAL_RECORDS = 1000;
        SPARK_HADOOP_CONF_FILE = "__spark_hadoop_conf__.xml";
    }

    @Override
    public String logName() {
        return Logging.logName$(this);
    }

    @Override
    public Logger log() {
        return Logging.log$(this);
    }

    @Override
    public void logInfo(Function0<String> msg) {
        Logging.logInfo$(this, msg);
    }

    @Override
    public void logDebug(Function0<String> msg) {
        Logging.logDebug$(this, msg);
    }

    @Override
    public void logTrace(Function0<String> msg) {
        Logging.logTrace$(this, msg);
    }

    @Override
    public void logWarning(Function0<String> msg) {
        Logging.logWarning$(this, msg);
    }

    @Override
    public void logError(Function0<String> msg) {
        Logging.logError$(this, msg);
    }

    @Override
    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$(this, msg, throwable);
    }

    @Override
    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$(this, msg, throwable);
    }

    @Override
    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$(this, msg, throwable);
    }

    @Override
    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$(this, msg, throwable);
    }

    @Override
    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$(this, msg, throwable);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$(this, isInterpreter);
    }

    @Override
    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$(this, isInterpreter, silent);
    }

    @Override
    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$(this);
    }

    @Override
    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$(this, isInterpreter, silent);
    }

    @Override
    public Logger org$apache$spark$internal$Logging$$log_() {
        return org$apache$spark$internal$Logging$$log_;
    }

    @Override
    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private SparkHadoopUtil instance$lzycompute() {
        SparkHadoopUtil$ sparkHadoopUtil$ = this;
        synchronized (sparkHadoopUtil$) {
            if ((byte)(bitmap$0 & 1) == 0) {
                instance = new SparkHadoopUtil();
                bitmap$0 = (byte)(bitmap$0 | 1);
            }
        }
        return instance;
    }

    private SparkHadoopUtil instance() {
        return (byte)(bitmap$0 & 1) == 0 ? this.instance$lzycompute() : instance;
    }

    public String SPARK_YARN_CREDS_TEMP_EXTENSION() {
        return SPARK_YARN_CREDS_TEMP_EXTENSION;
    }

    public String SPARK_YARN_CREDS_COUNTER_DELIM() {
        return SPARK_YARN_CREDS_COUNTER_DELIM;
    }

    public int UPDATE_INPUT_METRICS_INTERVAL_RECORDS() {
        return UPDATE_INPUT_METRICS_INTERVAL_RECORDS;
    }

    public String SPARK_HADOOP_CONF_FILE() {
        return SPARK_HADOOP_CONF_FILE;
    }

    public SparkHadoopUtil get() {
        return this.instance();
    }

    /*
     * WARNING - void declaration
     */
    public Configuration newConfiguration(SparkConf conf) {
        void var2_2;
        Configuration hadoopConf = new Configuration();
        this.org$apache$spark$deploy$SparkHadoopUtil$$appendS3AndSparkHadoopHiveConfigurations(conf, hadoopConf);
        return var2_2;
    }

    public void org$apache$spark$deploy$SparkHadoopUtil$$appendS3AndSparkHadoopHiveConfigurations(SparkConf conf, Configuration hadoopConf) {
        block2: {
            if (conf == null) break block2;
            String keyId = System.getenv("AWS_ACCESS_KEY_ID");
            String accessKey = System.getenv("AWS_SECRET_ACCESS_KEY");
            if (keyId != null && accessKey != null) {
                hadoopConf.set("fs.s3.awsAccessKeyId", keyId);
                hadoopConf.set("fs.s3n.awsAccessKeyId", keyId);
                hadoopConf.set("fs.s3a.access.key", keyId);
                hadoopConf.set("fs.s3.awsSecretAccessKey", accessKey);
                hadoopConf.set("fs.s3n.awsSecretAccessKey", accessKey);
                hadoopConf.set("fs.s3a.secret.key", accessKey);
                String sessionToken = System.getenv("AWS_SESSION_TOKEN");
                if (sessionToken != null) {
                    hadoopConf.set("fs.s3a.session.token", sessionToken);
                }
            }
            this.appendHiveConfigs(hadoopConf);
            this.org$apache$spark$deploy$SparkHadoopUtil$$appendSparkHadoopConfigs(conf, hadoopConf);
            this.appendSparkHiveConfigs(conf, hadoopConf);
            String bufferSize = conf.get(org.apache.spark.internal.config.package$.MODULE$.BUFFER_SIZE()).toString();
            hadoopConf.set("io.file.buffer.size", bufferSize);
        }
    }

    private Seq<Map.Entry<String, String>> hiveConfKeys$lzycompute() {
        SparkHadoopUtil$ sparkHadoopUtil$ = this;
        synchronized (sparkHadoopUtil$) {
            if ((byte)(bitmap$0 & 2) == 0) {
                Nil$ nil$;
                URL configFile = Utils$.MODULE$.getContextOrSparkClassLoader().getResource("hive-site.xml");
                if (configFile != null) {
                    Configuration conf = new Configuration(false);
                    conf.addResource(configFile);
                    nil$ = ((IterableOnceOps)JavaConverters$.MODULE$.asScalaIteratorConverter(conf.iterator()).asScala()).toSeq();
                } else {
                    nil$ = package$.MODULE$.Nil();
                }
                hiveConfKeys = nil$;
                bitmap$0 = (byte)(bitmap$0 | 2);
            }
        }
        return hiveConfKeys;
    }

    private Seq<Map.Entry<String, String>> hiveConfKeys() {
        return (byte)(bitmap$0 & 2) == 0 ? this.hiveConfKeys$lzycompute() : hiveConfKeys;
    }

    private void appendHiveConfigs(Configuration hadoopConf) {
        this.hiveConfKeys().foreach((Function1 & Serializable)kv -> {
            hadoopConf.set((String)kv.getKey(), (String)kv.getValue());
            return BoxedUnit.UNIT;
        });
    }

    public void org$apache$spark$deploy$SparkHadoopUtil$$appendSparkHadoopConfigs(SparkConf conf, Configuration hadoopConf) {
        block2: {
            ArrayOps$.MODULE$.withFilter$extension(Predef$.MODULE$.refArrayOps((Object[])conf.getAll()), (Function1 & Serializable)check$ifrefutable$3 -> BoxesRunTime.boxToBoolean((boolean)SparkHadoopUtil$.$anonfun$appendSparkHadoopConfigs$4(check$ifrefutable$3))).withFilter((Function1 & Serializable)x$13 -> BoxesRunTime.boxToBoolean((boolean)SparkHadoopUtil$.$anonfun$appendSparkHadoopConfigs$5(x$13))).foreach((Function1 & Serializable)x$14 -> {
                SparkHadoopUtil$.$anonfun$appendSparkHadoopConfigs$6(hadoopConf, x$14);
                return BoxedUnit.UNIT;
            });
            if (conf.getOption("spark.hadoop.mapreduce.fileoutputcommitter.algorithm.version").isEmpty()) {
                hadoopConf.set("mapreduce.fileoutputcommitter.algorithm.version", "1");
            }
            if (conf.getOption("spark.hadoop.fs.s3a.downgrade.syncable.exceptions").isEmpty()) {
                hadoopConf.set("fs.s3a.downgrade.syncable.exceptions", "true");
            }
            if (!hadoopConf.get("fs.s3a.endpoint", "").isEmpty() || hadoopConf.get("fs.s3a.endpoint.region") != null) break block2;
            hadoopConf.set("fs.s3a.endpoint", "s3.amazonaws.com");
        }
    }

    private void appendSparkHiveConfigs(SparkConf conf, Configuration hadoopConf) {
        ArrayOps$.MODULE$.withFilter$extension(Predef$.MODULE$.refArrayOps((Object[])conf.getAll()), (Function1 & Serializable)check$ifrefutable$4 -> BoxesRunTime.boxToBoolean((boolean)SparkHadoopUtil$.$anonfun$appendSparkHiveConfigs$4(check$ifrefutable$4))).withFilter((Function1 & Serializable)x$15 -> BoxesRunTime.boxToBoolean((boolean)SparkHadoopUtil$.$anonfun$appendSparkHiveConfigs$5(x$15))).foreach((Function1 & Serializable)x$16 -> {
            SparkHadoopUtil$.$anonfun$appendSparkHiveConfigs$6(hadoopConf, x$16);
            return BoxedUnit.UNIT;
        });
    }

    public FSDataOutputStream createFile(FileSystem fs, Path path, boolean allowEC) {
        FSDataOutputStream fSDataOutputStream;
        if (allowEC) {
            fSDataOutputStream = fs.create(path);
        } else {
            try {
                Method builderMethod = fs.getClass().getMethod("createFile", Path.class);
                if (!fs.mkdirs(path.getParent())) {
                    throw new IOException(new StringBuilder(28).append("Failed to create parents of ").append(path).toString());
                }
                Path qualifiedPath = fs.makeQualified(path);
                Object builder = builderMethod.invoke((Object)fs, qualifiedPath);
                Class<?> builderCls = builder.getClass();
                Method replicateMethod = builderCls.getMethod("replicate", new Class[0]);
                Method buildMethod = builderCls.getMethod("build", new Class[0]);
                Object b2 = replicateMethod.invoke(builder, new Object[0]);
                fSDataOutputStream = (FSDataOutputStream)buildMethod.invoke(b2, new Object[0]);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                fSDataOutputStream = fs.create(path);
            }
        }
        return fSDataOutputStream;
    }

    public static final /* synthetic */ boolean $anonfun$appendSparkHadoopConfigs$4(Tuple2 check$ifrefutable$3) {
        Tuple2 tuple2 = check$ifrefutable$3;
        boolean bl = tuple2 != null;
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$appendSparkHadoopConfigs$5(Tuple2 x$13) {
        Tuple2 tuple2 = x$13;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String key = (String)tuple2._1();
        boolean bl = key.startsWith("spark.hadoop.");
        return bl;
    }

    public static final /* synthetic */ void $anonfun$appendSparkHadoopConfigs$6(Configuration hadoopConf$2, Tuple2 x$14) {
        Tuple2 tuple2 = x$14;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String key = (String)tuple2._1();
        String value = (String)tuple2._2();
        hadoopConf$2.set(key.substring("spark.hadoop.".length()), value);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ boolean $anonfun$appendSparkHiveConfigs$4(Tuple2 check$ifrefutable$4) {
        Tuple2 tuple2 = check$ifrefutable$4;
        boolean bl = tuple2 != null;
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$appendSparkHiveConfigs$5(Tuple2 x$15) {
        Tuple2 tuple2 = x$15;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String key = (String)tuple2._1();
        boolean bl = key.startsWith("spark.hive.");
        return bl;
    }

    public static final /* synthetic */ void $anonfun$appendSparkHiveConfigs$6(Configuration hadoopConf$3, Tuple2 x$16) {
        Tuple2 tuple2 = x$16;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String key = (String)tuple2._1();
        String value = (String)tuple2._2();
        hadoopConf$3.set(key.substring("spark.".length()), value);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    private SparkHadoopUtil$() {
    }
}

