/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.executor;

import java.io.Serializable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicLongArray;
import org.apache.spark.executor.ExecutorMetrics;
import org.apache.spark.executor.ExecutorMetrics$;
import org.apache.spark.executor.ExecutorMetricsPoller$TCMP$;
import org.apache.spark.executor.ExecutorMetricsSource;
import org.apache.spark.internal.Logging;
import org.apache.spark.memory.MemoryManager;
import org.apache.spark.metrics.ExecutorMetricType$;
import org.apache.spark.util.ThreadUtils$;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.mutable.HashMap;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\tUb!B\u0016-\u00019\"\u0004\u0002C!\u0001\u0005\u0003\u0005\u000b\u0011B\"\t\u0011%\u0003!\u0011!Q\u0001\n)C\u0001\"\u0014\u0001\u0003\u0002\u0003\u0006IA\u0014\u0005\u0006+\u0002!\tAV\u0003\u00057\u0002\u0001ALB\u0003c\u0001\u0001c3\r\u0003\u0005t\r\tU\r\u0011\"\u0001u\u0011%\t\u0019A\u0002B\tB\u0003%Q\u000f\u0003\u0006\u0002\u0006\u0019\u0011)\u001a!C\u0001\u0003\u000fA!\"a\u0004\u0007\u0005#\u0005\u000b\u0011BA\u0005\u0011\u0019)f\u0001\"\u0001\u0002\u0012!I\u00111\u0004\u0004\u0002\u0002\u0013\u0005\u0011Q\u0004\u0005\n\u0003G1\u0011\u0013!C\u0001\u0003KA\u0011\"a\u000f\u0007#\u0003%\t!!\u0010\t\u0013\u0005\u0005c!!A\u0005B\u0005\r\u0003\"CA)\r\u0005\u0005I\u0011AA*\u0011%\t)FBA\u0001\n\u0003\t9\u0006C\u0005\u0002d\u0019\t\t\u0011\"\u0011\u0002f!I\u00111\u000f\u0004\u0002\u0002\u0013\u0005\u0011Q\u000f\u0005\n\u0003\u007f2\u0011\u0011!C!\u0003\u0003C\u0011\"!\"\u0007\u0003\u0003%\t%a\"\t\u0013\u0005%e!!A\u0005B\u0005-\u0005\"CAG\r\u0005\u0005I\u0011IAH\u000f)\t\u0019\nAA\u0001\u0012\u0003a\u0013Q\u0013\u0004\nE\u0002\t\t\u0011#\u0001-\u0003/Ca!V\r\u0005\u0002\u0005=\u0006\"CAE3\u0005\u0005IQIAF\u0011%\t\t,GA\u0001\n\u0003\u000b\u0019\fC\u0005\u0002:f\t\t\u0011\"!\u0002<\"Q\u0011Q\u0019\u0001C\u0002\u0013\u0005A&a2\t\u0011\u0005M\u0007\u0001)A\u0005\u0003\u0013D\u0011\"!6\u0001\u0005\u0004%I!a6\t\u0011\u0005m\u0007\u0001)A\u0005\u00033D\u0011\"!8\u0001\u0005\u0004%I!a8\t\u0011\u0005%\b\u0001)A\u0005\u0003CDq!a;\u0001\t\u0003\ti\u000fC\u0004\u0002v\u0002!\t!!<\t\u000f\u0005]\b\u0001\"\u0001\u0002z\"9!q\u0001\u0001\u0005\u0002\t%\u0001b\u0002B\t\u0001\u0011\u0005!1\u0003\u0005\b\u0005;\u0001A\u0011\u0001B\u0010\u0011\u001d\u0011\u0019\u0004\u0001C\u0001\u0003[\u0014Q#\u0012=fGV$xN]'fiJL7m\u001d)pY2,'O\u0003\u0002.]\u0005AQ\r_3dkR|'O\u0003\u00020a\u0005)1\u000f]1sW*\u0011\u0011GM\u0001\u0007CB\f7\r[3\u000b\u0003M\n1a\u001c:h'\r\u0001Qg\u000f\t\u0003mej\u0011a\u000e\u0006\u0002q\u0005)1oY1mC&\u0011!h\u000e\u0002\u0007\u0003:L(+\u001a4\u0011\u0005qzT\"A\u001f\u000b\u0005yr\u0013\u0001C5oi\u0016\u0014h.\u00197\n\u0005\u0001k$a\u0002'pO\u001eLgnZ\u0001\u000e[\u0016lwN]=NC:\fw-\u001a:\u0004\u0001A\u0011AiR\u0007\u0002\u000b*\u0011aIL\u0001\u0007[\u0016lwN]=\n\u0005!+%!D'f[>\u0014\u00180T1oC\u001e,'/A\bq_2d\u0017N\\4J]R,'O^1m!\t14*\u0003\u0002Mo\t!Aj\u001c8h\u0003U)\u00070Z2vi>\u0014X*\u001a;sS\u000e\u001c8k\\;sG\u0016\u00042AN(R\u0013\t\u0001vG\u0001\u0004PaRLwN\u001c\t\u0003%Nk\u0011\u0001L\u0005\u0003)2\u0012Q#\u0012=fGV$xN]'fiJL7m]*pkJ\u001cW-\u0001\u0004=S:LGO\u0010\u000b\u0005/bK&\f\u0005\u0002S\u0001!)\u0011\t\u0002a\u0001\u0007\")\u0011\n\u0002a\u0001\u0015\")Q\n\u0002a\u0001\u001d\nA1\u000b^1hK.+\u0017\u0010\u0005\u00037;~{\u0016B\u000108\u0005\u0019!V\u000f\u001d7feA\u0011a\u0007Y\u0005\u0003C^\u00121!\u00138u\u0005\u0011!6)\u0014)\u0014\t\u0019)Dm\u001a\t\u0003m\u0015L!AZ\u001c\u0003\u000fA\u0013x\u000eZ;diB\u0011\u0001\u000e\u001d\b\u0003S:t!A[7\u000e\u0003-T!\u0001\u001c\"\u0002\rq\u0012xn\u001c;?\u0013\u0005A\u0014BA88\u0003\u001d\u0001\u0018mY6bO\u0016L!!\u001d:\u0003\u0019M+'/[1mSj\f'\r\\3\u000b\u0005=<\u0014!B2pk:$X#A;\u0011\u0005Y|X\"A<\u000b\u0005aL\u0018AB1u_6L7M\u0003\u0002{w\u0006Q1m\u001c8dkJ\u0014XM\u001c;\u000b\u0005ql\u0018\u0001B;uS2T\u0011A`\u0001\u0005U\u00064\u0018-C\u0002\u0002\u0002]\u0014!\"\u0011;p[&\u001cGj\u001c8h\u0003\u0019\u0019w.\u001e8uA\u0005)\u0001/Z1lgV\u0011\u0011\u0011\u0002\t\u0004m\u0006-\u0011bAA\u0007o\ny\u0011\t^8nS\u000eduN\\4BeJ\f\u00170\u0001\u0004qK\u0006\\7\u000f\t\u000b\u0007\u0003'\t9\"!\u0007\u0011\u0007\u0005Ua!D\u0001\u0001\u0011\u0015\u00198\u00021\u0001v\u0011\u001d\t)a\u0003a\u0001\u0003\u0013\tAaY8qsR1\u00111CA\u0010\u0003CAqa\u001d\u0007\u0011\u0002\u0003\u0007Q\u000fC\u0005\u0002\u00061\u0001\n\u00111\u0001\u0002\n\u0005q1m\u001c9zI\u0011,g-Y;mi\u0012\nTCAA\u0014U\r)\u0018\u0011F\u0016\u0003\u0003W\u0001B!!\f\u000285\u0011\u0011q\u0006\u0006\u0005\u0003c\t\u0019$A\u0005v]\u000eDWmY6fI*\u0019\u0011QG\u001c\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002:\u0005=\"!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\u0012TCAA U\u0011\tI!!\u000b\u0002\u001bA\u0014x\u000eZ;diB\u0013XMZ5y+\t\t)\u0005\u0005\u0003\u0002H\u00055SBAA%\u0015\r\tY%`\u0001\u0005Y\u0006tw-\u0003\u0003\u0002P\u0005%#AB*ue&tw-\u0001\u0007qe>$Wo\u0019;Be&$\u00180F\u0001`\u00039\u0001(o\u001c3vGR,E.Z7f]R$B!!\u0017\u0002`A\u0019a'a\u0017\n\u0007\u0005usGA\u0002B]fD\u0001\"!\u0019\u0012\u0003\u0003\u0005\raX\u0001\u0004q\u0012\n\u0014a\u00049s_\u0012,8\r^%uKJ\fGo\u001c:\u0016\u0005\u0005\u001d\u0004CBA5\u0003_\nI&\u0004\u0002\u0002l)\u0019\u0011QN\u001c\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0002r\u0005-$\u0001C%uKJ\fGo\u001c:\u0002\u0011\r\fg.R9vC2$B!a\u001e\u0002~A\u0019a'!\u001f\n\u0007\u0005mtGA\u0004C_>dW-\u00198\t\u0013\u0005\u00054#!AA\u0002\u0005e\u0013A\u00059s_\u0012,8\r^#mK6,g\u000e\u001e(b[\u0016$B!!\u0012\u0002\u0004\"A\u0011\u0011\r\u000b\u0002\u0002\u0003\u0007q,\u0001\u0005iCND7i\u001c3f)\u0005y\u0016\u0001\u0003;p'R\u0014\u0018N\\4\u0015\u0005\u0005\u0015\u0013AB3rk\u0006d7\u000f\u0006\u0003\u0002x\u0005E\u0005\"CA1/\u0005\u0005\t\u0019AA-\u0003\u0011!6)\u0014)\u0011\u0007\u0005U\u0011dE\u0003\u001a\u00033\u000b)\u000bE\u0005\u0002\u001c\u0006\u0005V/!\u0003\u0002\u00145\u0011\u0011Q\u0014\u0006\u0004\u0003?;\u0014a\u0002:v]RLW.Z\u0005\u0005\u0003G\u000biJA\tBEN$(/Y2u\rVt7\r^5p]J\u0002B!a*\u0002.6\u0011\u0011\u0011\u0016\u0006\u0004\u0003Wk\u0018AA5p\u0013\r\t\u0018\u0011\u0016\u000b\u0003\u0003+\u000bQ!\u00199qYf$b!a\u0005\u00026\u0006]\u0006\"B:\u001d\u0001\u0004)\bbBA\u00039\u0001\u0007\u0011\u0011B\u0001\bk:\f\u0007\u000f\u001d7z)\u0011\ti,!1\u0011\tYz\u0015q\u0018\t\u0006mu+\u0018\u0011\u0002\u0005\n\u0003\u0007l\u0012\u0011!a\u0001\u0003'\t1\u0001\u001f\u00131\u0003%\u0019H/Y4f)\u000ek\u0005+\u0006\u0002\u0002JBA\u00111ZAg\u0003#\f\u0019\"D\u0001z\u0013\r\ty-\u001f\u0002\u0012\u0007>t7-\u001e:sK:$\b*Y:i\u001b\u0006\u0004\bcAA\u000b\u000b\u0005Q1\u000f^1hKR\u001bU\n\u0015\u0011\u0002\u001fQ\f7o['fiJL7\rU3bWN,\"!!7\u0011\u000f\u0005-\u0017Q\u001a&\u0002\n\u0005\u0001B/Y:l\u001b\u0016$(/[2QK\u0006\\7\u000fI\u0001\u0007a>dG.\u001a:\u0016\u0005\u0005\u0005\b\u0003\u0002\u001cP\u0003G\u0004B!a3\u0002f&\u0019\u0011q]=\u00031M\u001b\u0007.\u001a3vY\u0016$W\t_3dkR|'oU3sm&\u001cW-A\u0004q_2dWM\u001d\u0011\u0002\tA|G\u000e\u001c\u000b\u0003\u0003_\u00042ANAy\u0013\r\t\u0019p\u000e\u0002\u0005+:LG/A\u0003ti\u0006\u0014H/A\u0006p]R\u000b7o[*uCJ$H\u0003CAx\u0003w\fyPa\u0001\t\r\u0005uh\u00051\u0001K\u0003\u0019!\u0018m]6JI\"1!\u0011\u0001\u0014A\u0002}\u000bqa\u001d;bO\u0016LE\r\u0003\u0004\u0003\u0006\u0019\u0002\raX\u0001\u000fgR\fw-Z!ui\u0016l\u0007\u000f^%e\u0003Ayg\u000eV1tW\u000e{W\u000e\u001d7fi&|g\u000e\u0006\u0005\u0002p\n-!Q\u0002B\b\u0011\u0019\tip\na\u0001\u0015\"1!\u0011A\u0014A\u0002}CaA!\u0002(\u0001\u0004y\u0016AE4fiR\u000b7o['fiJL7\rU3bWN$BA!\u0006\u0003\u001cA!aGa\u0006K\u0013\r\u0011Ib\u000e\u0002\u0006\u0003J\u0014\u0018-\u001f\u0005\u0007\u0003{D\u0003\u0019\u0001&\u0002%\u001d,G/\u0012=fGV$xN]+qI\u0006$Xm\u001d\u000b\u0003\u0005C\u0001\u0002Ba\t\u0003*\u0005E'QF\u0007\u0003\u0005KQAAa\n\u0002l\u00059Q.\u001e;bE2,\u0017\u0002\u0002B\u0016\u0005K\u0011q\u0001S1tQ6\u000b\u0007\u000fE\u0002S\u0005_I1A!\r-\u0005=)\u00050Z2vi>\u0014X*\u001a;sS\u000e\u001c\u0018\u0001B:u_B\u0004")
public class ExecutorMetricsPoller
implements Logging {
    private volatile ExecutorMetricsPoller$TCMP$ TCMP$module;
    private final MemoryManager memoryManager;
    private final long pollingInterval;
    private final Option<ExecutorMetricsSource> executorMetricsSource;
    private final ConcurrentHashMap<Tuple2<Object, Object>, TCMP> stageTCMP;
    private final ConcurrentHashMap<Object, AtomicLongArray> taskMetricPeaks;
    private final Option<ScheduledExecutorService> poller;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    @Override
    public String logName() {
        return Logging.logName$(this);
    }

    @Override
    public Logger log() {
        return Logging.log$(this);
    }

    @Override
    public void logInfo(Function0<String> msg) {
        Logging.logInfo$(this, msg);
    }

    @Override
    public void logDebug(Function0<String> msg) {
        Logging.logDebug$(this, msg);
    }

    @Override
    public void logTrace(Function0<String> msg) {
        Logging.logTrace$(this, msg);
    }

    @Override
    public void logWarning(Function0<String> msg) {
        Logging.logWarning$(this, msg);
    }

    @Override
    public void logError(Function0<String> msg) {
        Logging.logError$(this, msg);
    }

    @Override
    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$(this, msg, throwable);
    }

    @Override
    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$(this, msg, throwable);
    }

    @Override
    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$(this, msg, throwable);
    }

    @Override
    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$(this, msg, throwable);
    }

    @Override
    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$(this, msg, throwable);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$(this, isInterpreter);
    }

    @Override
    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$(this, isInterpreter, silent);
    }

    @Override
    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$(this);
    }

    @Override
    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$(this, isInterpreter, silent);
    }

    public ExecutorMetricsPoller$TCMP$ TCMP() {
        if (this.TCMP$module == null) {
            this.TCMP$lzycompute$1();
        }
        return this.TCMP$module;
    }

    @Override
    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    @Override
    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public ConcurrentHashMap<Tuple2<Object, Object>, TCMP> stageTCMP() {
        return this.stageTCMP;
    }

    private ConcurrentHashMap<Object, AtomicLongArray> taskMetricPeaks() {
        return this.taskMetricPeaks;
    }

    private Option<ScheduledExecutorService> poller() {
        return this.poller;
    }

    public void poll() {
        long[] latestMetrics = ExecutorMetrics$.MODULE$.getCurrentMetrics(this.memoryManager);
        this.executorMetricsSource.foreach((Function1 & Serializable)x$1 -> {
            x$1.updateMetricsSnapshot(latestMetrics);
            return BoxedUnit.UNIT;
        });
        this.stageTCMP().forEachValue(Long.MAX_VALUE, v -> ExecutorMetricsPoller.updatePeaks$1(v.peaks(), latestMetrics));
        this.taskMetricPeaks().forEachValue(Long.MAX_VALUE, metrics -> ExecutorMetricsPoller.updatePeaks$1(metrics, latestMetrics));
    }

    public void start() {
        this.poller().foreach((Function1 & Serializable)exec -> {
            Runnable pollingTask = () -> Utils$.MODULE$.logUncaughtExceptions((JFunction0.mcV.sp & Serializable)() -> this.poll());
            return exec.scheduleAtFixedRate(pollingTask, 0L, $this.pollingInterval, TimeUnit.MILLISECONDS);
        });
    }

    public void onTaskStart(long taskId, int stageId, int stageAttemptId) {
        this.taskMetricPeaks().put(BoxesRunTime.boxToLong((long)taskId), new AtomicLongArray(ExecutorMetricType$.MODULE$.numMetrics()));
        TCMP countAndPeaks = this.stageTCMP().computeIfAbsent((Tuple2<Object, Object>)new Tuple2.mcII.sp(stageId, stageAttemptId), x$2 -> new TCMP(this, new AtomicLong(0L), new AtomicLongArray(ExecutorMetricType$.MODULE$.numMetrics())));
        long stageCount = countAndPeaks.count().incrementAndGet();
        this.logDebug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(19).append("stageTCMP: (").append(stageId).append(", ").append(stageAttemptId).append(") -> ").append(stageCount).toString());
    }

    public void onTaskCompletion(long taskId, int stageId, int stageAttemptId) {
        this.stageTCMP().computeIfPresent((Tuple2<Object, Object>)new Tuple2.mcII.sp(stageId, stageAttemptId), (stage, countAndPeaks) -> this.decrementCount$1((Tuple2)stage, (TCMP)countAndPeaks));
        this.taskMetricPeaks().remove(BoxesRunTime.boxToLong((long)taskId));
    }

    public long[] getTaskMetricPeaks(long taskId) {
        long[] metricPeaks;
        block0: {
            AtomicLongArray currentPeaks = this.taskMetricPeaks().get(BoxesRunTime.boxToLong((long)taskId));
            metricPeaks = new long[ExecutorMetricType$.MODULE$.numMetrics()];
            if (currentPeaks == null) break block0;
            ExecutorMetricType$.MODULE$.metricToOffset().foreach((Function1 & Serializable)x0$1 -> {
                ExecutorMetricsPoller.$anonfun$getTaskMetricPeaks$1(metricPeaks, currentPeaks, x0$1);
                return BoxedUnit.UNIT;
            });
        }
        return metricPeaks;
    }

    /*
     * WARNING - void declaration
     */
    public HashMap<Tuple2<Object, Object>, ExecutorMetrics> getExecutorUpdates() {
        void var1_1;
        HashMap executorUpdates = new HashMap();
        this.stageTCMP().replaceAll((k, v) -> this.getUpdateAndResetPeaks$1((Tuple2)k, (TCMP)v, executorUpdates));
        executorUpdates.foreach((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Tuple2 k2 = (Tuple2)tuple2._1();
            TCMP tCMP = this.stageTCMP().computeIfPresent((Tuple2<Object, Object>)k2, (k, v) -> this.removeIfInactive$1((Tuple2)k, (TCMP)v));
            return tCMP;
        });
        return var1_1;
    }

    public void stop() {
        this.poller().foreach((Function1 & Serializable)exec -> BoxesRunTime.boxToBoolean((boolean)ExecutorMetricsPoller.$anonfun$stop$1(exec)));
    }

    private final void TCMP$lzycompute$1() {
        ExecutorMetricsPoller executorMetricsPoller = this;
        synchronized (executorMetricsPoller) {
            if (this.TCMP$module == null) {
                this.TCMP$module = new ExecutorMetricsPoller$TCMP$(this);
            }
        }
    }

    private static final void updatePeaks$1(AtomicLongArray metrics, long[] latestMetrics$1) {
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), metrics.length()).foreach((Function1)(JFunction1.mcJI.sp & Serializable)i -> metrics.getAndAccumulate(i, latestMetrics$1[i], (x, y) -> package$.MODULE$.max(x, y)));
    }

    private final TCMP decrementCount$1(Tuple2 stage, TCMP countAndPeaks) {
        long countValue = countAndPeaks.count().decrementAndGet();
        Predef$.MODULE$.assert(countValue >= 0L, (Function0 & Serializable)() -> "task count shouldn't below 0");
        this.logDebug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(0).append(new StringBuilder(19).append("stageTCMP: (").append(stage._1$mcI$sp()).append(", ").append(stage._2$mcI$sp()).append(") -> ").toString()).append(countValue).toString());
        return countAndPeaks;
    }

    public static final /* synthetic */ void $anonfun$getTaskMetricPeaks$1(long[] metricPeaks$1, AtomicLongArray currentPeaks$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        int i = tuple2._2$mcI$sp();
        metricPeaks$1[i] = currentPeaks$1.get(i);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    private final TCMP getUpdateAndResetPeaks$1(Tuple2 k, TCMP v, HashMap executorUpdates$1) {
        executorUpdates$1.put((Object)k, (Object)new ExecutorMetrics(v.peaks()));
        return new TCMP(this, v.count(), new AtomicLongArray(ExecutorMetricType$.MODULE$.numMetrics()));
    }

    private final TCMP removeIfInactive$1(Tuple2 k, TCMP v) {
        TCMP tCMP;
        if (v.count().get() == 0L) {
            this.logDebug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(28).append("removing (").append(k._1$mcI$sp()).append(", ").append(k._2$mcI$sp()).append(") from stageTCMP").toString());
            tCMP = null;
        } else {
            tCMP = v;
        }
        return tCMP;
    }

    public static final /* synthetic */ boolean $anonfun$stop$1(ScheduledExecutorService exec) {
        exec.shutdown();
        return exec.awaitTermination(10L, TimeUnit.SECONDS);
    }

    public ExecutorMetricsPoller(MemoryManager memoryManager, long pollingInterval, Option<ExecutorMetricsSource> executorMetricsSource) {
        this.memoryManager = memoryManager;
        this.pollingInterval = pollingInterval;
        this.executorMetricsSource = executorMetricsSource;
        Logging.$init$(this);
        this.stageTCMP = new ConcurrentHashMap();
        this.taskMetricPeaks = new ConcurrentHashMap();
        this.poller = pollingInterval > 0L ? new Some((Object)ThreadUtils$.MODULE$.newDaemonSingleThreadScheduledExecutor("executor-metrics-poller")) : None$.MODULE$;
    }

    public class TCMP
    implements Product,
    Serializable {
        private final AtomicLong count;
        private final AtomicLongArray peaks;
        public final /* synthetic */ ExecutorMetricsPoller $outer;

        public Iterator<String> productElementNames() {
            return Product.productElementNames$((Product)this);
        }

        public AtomicLong count() {
            return this.count;
        }

        public AtomicLongArray peaks() {
            return this.peaks;
        }

        public TCMP copy(AtomicLong count, AtomicLongArray peaks) {
            return new TCMP(this.org$apache$spark$executor$ExecutorMetricsPoller$TCMP$$$outer(), count, peaks);
        }

        public AtomicLong copy$default$1() {
            return this.count();
        }

        public AtomicLongArray copy$default$2() {
            return this.peaks();
        }

        public String productPrefix() {
            return "TCMP";
        }

        public int productArity() {
            return 2;
        }

        public Object productElement(int x$1) {
            Object object;
            int n = x$1;
            switch (n) {
                case 0: {
                    object = this.count();
                    break;
                }
                case 1: {
                    object = this.peaks();
                    break;
                }
                default: {
                    object = Statics.ioobe((int)x$1);
                    break;
                }
            }
            return object;
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof TCMP;
        }

        public String productElementName(int x$1) {
            String string;
            int n = x$1;
            switch (n) {
                case 0: {
                    string = "count";
                    break;
                }
                case 1: {
                    string = "peaks";
                    break;
                }
                default: {
                    string = (String)Statics.ioobe((int)x$1);
                    break;
                }
            }
            return string;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof TCMP)) return false;
            if (((TCMP)object).org$apache$spark$executor$ExecutorMetricsPoller$TCMP$$$outer() != this.org$apache$spark$executor$ExecutorMetricsPoller$TCMP$$$outer()) return false;
            boolean bl = true;
            if (!bl) return false;
            TCMP tCMP = (TCMP)x$1;
            if (!BoxesRunTime.equalsNumNum((Number)this.count(), (Number)tCMP.count())) return false;
            AtomicLongArray atomicLongArray = this.peaks();
            AtomicLongArray atomicLongArray2 = tCMP.peaks();
            if (atomicLongArray == null) {
                if (atomicLongArray2 != null) {
                    return false;
                }
            } else if (!atomicLongArray.equals(atomicLongArray2)) return false;
            if (!tCMP.canEqual(this)) return false;
            return true;
        }

        public /* synthetic */ ExecutorMetricsPoller org$apache$spark$executor$ExecutorMetricsPoller$TCMP$$$outer() {
            return this.$outer;
        }

        public TCMP(ExecutorMetricsPoller $outer, AtomicLong count, AtomicLongArray peaks) {
            this.count = count;
            this.peaks = peaks;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            Product.$init$((Product)this);
        }
    }
}

