/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.internal.config;

import java.io.Serializable;
import java.util.concurrent.TimeUnit;
import org.apache.spark.internal.config.ConfigBuilder;
import org.apache.spark.internal.config.ConfigEntry;
import org.apache.spark.internal.config.OptionalConfigEntry;
import org.apache.spark.internal.config.package$;
import org.apache.spark.network.util.ByteUnit;
import scala.Function0;
import scala.Function1;
import scala.collection.immutable.Seq;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

public final class History$ {
    public static final History$ MODULE$ = new History$();
    private static final String DEFAULT_LOG_DIR = "file:/tmp/spark-events";
    private static final ConfigEntry<String> HISTORY_LOG_DIR = new ConfigBuilder("spark.history.fs.logDirectory").version("1.1.0").stringConf().createWithDefault(MODULE$.DEFAULT_LOG_DIR());
    private static final ConfigEntry<Object> SAFEMODE_CHECK_INTERVAL_S = new ConfigBuilder("spark.history.fs.safemodeCheck.interval").version("1.6.0").timeConf(TimeUnit.SECONDS).createWithDefaultString("5s");
    private static final ConfigEntry<Object> UPDATE_INTERVAL_S = new ConfigBuilder("spark.history.fs.update.interval").version("1.4.0").timeConf(TimeUnit.SECONDS).createWithDefaultString("10s");
    private static final ConfigEntry<Object> CLEANER_ENABLED = new ConfigBuilder("spark.history.fs.cleaner.enabled").version("1.4.0").booleanConf().createWithDefault(BoxesRunTime.boxToBoolean((boolean)false));
    private static final ConfigEntry<Object> CLEANER_INTERVAL_S = new ConfigBuilder("spark.history.fs.cleaner.interval").version("1.4.0").timeConf(TimeUnit.SECONDS).createWithDefaultString("1d");
    private static final ConfigEntry<Object> MAX_LOG_AGE_S = new ConfigBuilder("spark.history.fs.cleaner.maxAge").version("1.4.0").timeConf(TimeUnit.SECONDS).createWithDefaultString("7d");
    private static final ConfigEntry<Object> MAX_LOG_NUM = new ConfigBuilder("spark.history.fs.cleaner.maxNum").doc("The maximum number of log files in the event log directory.").version("3.0.0").intConf().createWithDefault(BoxesRunTime.boxToInteger((int)Integer.MAX_VALUE));
    private static final OptionalConfigEntry<String> LOCAL_STORE_DIR = new ConfigBuilder("spark.history.store.path").doc("Local directory where to cache application history information. By default this is not set, meaning all history information will be kept in memory.").version("2.3.0").stringConf().createOptional();
    private static final ConfigEntry<Object> MAX_LOCAL_DISK_USAGE = new ConfigBuilder("spark.history.store.maxDiskUsage").version("2.3.0").bytesConf(ByteUnit.BYTE).createWithDefaultString("10g");
    private static final ConfigEntry<Object> HISTORY_SERVER_UI_PORT = new ConfigBuilder("spark.history.ui.port").doc("Web UI port to bind Spark History Server").version("1.0.0").intConf().createWithDefault(BoxesRunTime.boxToInteger((int)18080));
    private static final ConfigEntry<Object> FAST_IN_PROGRESS_PARSING = new ConfigBuilder("spark.history.fs.inProgressOptimization.enabled").doc("Enable optimized handling of in-progress logs. This option may leave finished applications that fail to rename their event logs listed as in-progress.").version("2.4.0").booleanConf().createWithDefault(BoxesRunTime.boxToBoolean((boolean)true));
    private static final ConfigEntry<Object> END_EVENT_REPARSE_CHUNK_SIZE = new ConfigBuilder("spark.history.fs.endEventReparseChunkSize").doc("How many bytes to parse at the end of log files looking for the end event. This is used to speed up generation of application listings by skipping unnecessary parts of event log files. It can be disabled by setting this config to 0.").version("2.4.0").bytesConf(ByteUnit.BYTE).createWithDefaultString("1m");
    private static final ConfigEntry<Object> EVENT_LOG_ROLLING_MAX_FILES_TO_RETAIN = new ConfigBuilder("spark.history.fs.eventLog.rolling.maxFilesToRetain").doc(new StringBuilder(194).append("The maximum number of event log files which will be retained as non-compacted. By default, all event log files will be retained. Please set the configuration ").append(new StringBuilder(40).append("and ").append(package$.MODULE$.EVENT_LOG_ROLLING_MAX_FILE_SIZE().key()).append(" accordingly if you want to control ").toString()).append("the overall size of event log files.").toString()).version("3.0.0").intConf().checkValue((Function1<Object, Object>)(JFunction1.mcZI.sp & Serializable)x$1 -> x$1 > 0, "Max event log files to retain should be higher than 0.").createWithDefault(BoxesRunTime.boxToInteger((int)Integer.MAX_VALUE));
    private static final ConfigEntry<Object> EVENT_LOG_COMPACTION_SCORE_THRESHOLD = new ConfigBuilder("spark.history.fs.eventLog.rolling.compaction.score.threshold").doc("The threshold score to determine whether it's good to do the compaction or not. The compaction score is calculated in analyzing, and being compared to this value. Compaction will proceed only when the score is higher than the threshold value.").version("3.0.0").internal().doubleConf().createWithDefault(BoxesRunTime.boxToDouble((double)0.7));
    private static final ConfigEntry<Object> DRIVER_LOG_CLEANER_ENABLED = new ConfigBuilder("spark.history.fs.driverlog.cleaner.enabled").version("3.0.0").fallbackConf(MODULE$.CLEANER_ENABLED());
    private static final ConfigEntry<Object> DRIVER_LOG_CLEANER_INTERVAL = new ConfigBuilder("spark.history.fs.driverlog.cleaner.interval").version("3.0.0").fallbackConf(MODULE$.CLEANER_INTERVAL_S());
    private static final ConfigEntry<Object> MAX_DRIVER_LOG_AGE_S = new ConfigBuilder("spark.history.fs.driverlog.cleaner.maxAge").version("3.0.0").fallbackConf(MODULE$.MAX_LOG_AGE_S());
    private static final ConfigEntry<Object> HISTORY_SERVER_UI_ACLS_ENABLE = new ConfigBuilder("spark.history.ui.acls.enable").version("1.0.1").booleanConf().createWithDefault(BoxesRunTime.boxToBoolean((boolean)false));
    private static final ConfigEntry<Seq<String>> HISTORY_SERVER_UI_ADMIN_ACLS = new ConfigBuilder("spark.history.ui.admin.acls").version("2.1.1").stringConf().toSequence().createWithDefault((Seq<String>)scala.package$.MODULE$.Nil());
    private static final ConfigEntry<Seq<String>> HISTORY_SERVER_UI_ADMIN_ACLS_GROUPS = new ConfigBuilder("spark.history.ui.admin.acls.groups").version("2.1.1").stringConf().toSequence().createWithDefault((Seq<String>)scala.package$.MODULE$.Nil());
    private static final ConfigEntry<Object> NUM_REPLAY_THREADS = new ConfigBuilder("spark.history.fs.numReplayThreads").version("2.0.0").intConf().createWithDefaultFunction((Function0<Object>)(JFunction0.mcI.sp & Serializable)() -> (int)Math.ceil((float)Runtime.getRuntime().availableProcessors() / 4.0f));
    private static final ConfigEntry<Object> RETAINED_APPLICATIONS = new ConfigBuilder("spark.history.retainedApplications").version("1.0.0").intConf().createWithDefault(BoxesRunTime.boxToInteger((int)50));
    private static final OptionalConfigEntry<String> PROVIDER = new ConfigBuilder("spark.history.provider").version("1.1.0").stringConf().createOptional();
    private static final ConfigEntry<Object> KERBEROS_ENABLED = new ConfigBuilder("spark.history.kerberos.enabled").version("1.0.1").booleanConf().createWithDefault(BoxesRunTime.boxToBoolean((boolean)false));
    private static final OptionalConfigEntry<String> KERBEROS_PRINCIPAL = new ConfigBuilder("spark.history.kerberos.principal").version("1.0.1").stringConf().createOptional();
    private static final OptionalConfigEntry<String> KERBEROS_KEYTAB = new ConfigBuilder("spark.history.kerberos.keytab").version("1.0.1").stringConf().createOptional();
    private static final OptionalConfigEntry<String> CUSTOM_EXECUTOR_LOG_URL = new ConfigBuilder("spark.history.custom.executor.log.url").doc("Specifies custom spark executor log url for supporting external log service instead of using cluster managers' application log urls in the history server. Spark will support some path variables via patterns which can vary on cluster manager. Please check the documentation for your cluster manager to see which patterns are supported, if any. This configuration has no effect on a live application, it only affects the history server.").version("3.0.0").stringConf().createOptional();
    private static final ConfigEntry<Object> APPLY_CUSTOM_EXECUTOR_LOG_URL_TO_INCOMPLETE_APP = new ConfigBuilder("spark.history.custom.executor.log.url.applyIncompleteApplication").doc(new StringBuilder(171).append("Whether to apply custom executor log url, as specified by ").append(new StringBuilder(37).append(MODULE$.CUSTOM_EXECUTOR_LOG_URL().key()).append(", to incomplete application as well. ").toString()).append("Even if this is true, this still only affects the behavior of the history server, ").append("not running spark applications.").toString()).version("3.0.0").booleanConf().createWithDefault(BoxesRunTime.boxToBoolean((boolean)true));
    private static final ConfigEntry<Object> HYBRID_STORE_ENABLED = new ConfigBuilder("spark.history.store.hybridStore.enabled").doc("Whether to use HybridStore as the store when parsing event logs. HybridStore will first write data to an in-memory store and having a background thread that dumps data to a disk store after the writing to in-memory store is completed.").version("3.1.0").booleanConf().createWithDefault(BoxesRunTime.boxToBoolean((boolean)false));
    private static final ConfigEntry<Object> MAX_IN_MEMORY_STORE_USAGE = new ConfigBuilder("spark.history.store.hybridStore.maxMemoryUsage").doc("Maximum memory space that can be used to create HybridStore. The HybridStore co-uses the heap memory, so the heap memory should be increased through the memory option for SHS if the HybridStore is enabled.").version("3.1.0").bytesConf(ByteUnit.BYTE).createWithDefaultString("2g");

    public String DEFAULT_LOG_DIR() {
        return DEFAULT_LOG_DIR;
    }

    public ConfigEntry<String> HISTORY_LOG_DIR() {
        return HISTORY_LOG_DIR;
    }

    public ConfigEntry<Object> SAFEMODE_CHECK_INTERVAL_S() {
        return SAFEMODE_CHECK_INTERVAL_S;
    }

    public ConfigEntry<Object> UPDATE_INTERVAL_S() {
        return UPDATE_INTERVAL_S;
    }

    public ConfigEntry<Object> CLEANER_ENABLED() {
        return CLEANER_ENABLED;
    }

    public ConfigEntry<Object> CLEANER_INTERVAL_S() {
        return CLEANER_INTERVAL_S;
    }

    public ConfigEntry<Object> MAX_LOG_AGE_S() {
        return MAX_LOG_AGE_S;
    }

    public ConfigEntry<Object> MAX_LOG_NUM() {
        return MAX_LOG_NUM;
    }

    public OptionalConfigEntry<String> LOCAL_STORE_DIR() {
        return LOCAL_STORE_DIR;
    }

    public ConfigEntry<Object> MAX_LOCAL_DISK_USAGE() {
        return MAX_LOCAL_DISK_USAGE;
    }

    public ConfigEntry<Object> HISTORY_SERVER_UI_PORT() {
        return HISTORY_SERVER_UI_PORT;
    }

    public ConfigEntry<Object> FAST_IN_PROGRESS_PARSING() {
        return FAST_IN_PROGRESS_PARSING;
    }

    public ConfigEntry<Object> END_EVENT_REPARSE_CHUNK_SIZE() {
        return END_EVENT_REPARSE_CHUNK_SIZE;
    }

    public ConfigEntry<Object> EVENT_LOG_ROLLING_MAX_FILES_TO_RETAIN() {
        return EVENT_LOG_ROLLING_MAX_FILES_TO_RETAIN;
    }

    public ConfigEntry<Object> EVENT_LOG_COMPACTION_SCORE_THRESHOLD() {
        return EVENT_LOG_COMPACTION_SCORE_THRESHOLD;
    }

    public ConfigEntry<Object> DRIVER_LOG_CLEANER_ENABLED() {
        return DRIVER_LOG_CLEANER_ENABLED;
    }

    public ConfigEntry<Object> DRIVER_LOG_CLEANER_INTERVAL() {
        return DRIVER_LOG_CLEANER_INTERVAL;
    }

    public ConfigEntry<Object> MAX_DRIVER_LOG_AGE_S() {
        return MAX_DRIVER_LOG_AGE_S;
    }

    public ConfigEntry<Object> HISTORY_SERVER_UI_ACLS_ENABLE() {
        return HISTORY_SERVER_UI_ACLS_ENABLE;
    }

    public ConfigEntry<Seq<String>> HISTORY_SERVER_UI_ADMIN_ACLS() {
        return HISTORY_SERVER_UI_ADMIN_ACLS;
    }

    public ConfigEntry<Seq<String>> HISTORY_SERVER_UI_ADMIN_ACLS_GROUPS() {
        return HISTORY_SERVER_UI_ADMIN_ACLS_GROUPS;
    }

    public ConfigEntry<Object> NUM_REPLAY_THREADS() {
        return NUM_REPLAY_THREADS;
    }

    public ConfigEntry<Object> RETAINED_APPLICATIONS() {
        return RETAINED_APPLICATIONS;
    }

    public OptionalConfigEntry<String> PROVIDER() {
        return PROVIDER;
    }

    public ConfigEntry<Object> KERBEROS_ENABLED() {
        return KERBEROS_ENABLED;
    }

    public OptionalConfigEntry<String> KERBEROS_PRINCIPAL() {
        return KERBEROS_PRINCIPAL;
    }

    public OptionalConfigEntry<String> KERBEROS_KEYTAB() {
        return KERBEROS_KEYTAB;
    }

    public OptionalConfigEntry<String> CUSTOM_EXECUTOR_LOG_URL() {
        return CUSTOM_EXECUTOR_LOG_URL;
    }

    public ConfigEntry<Object> APPLY_CUSTOM_EXECUTOR_LOG_URL_TO_INCOMPLETE_APP() {
        return APPLY_CUSTOM_EXECUTOR_LOG_URL_TO_INCOMPLETE_APP;
    }

    public ConfigEntry<Object> HYBRID_STORE_ENABLED() {
        return HYBRID_STORE_ENABLED;
    }

    public ConfigEntry<Object> MAX_IN_MEMORY_STORE_USAGE() {
        return MAX_IN_MEMORY_STORE_USAGE;
    }

    private History$() {
    }
}

