/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.internal.io;

import java.io.IOException;
import java.io.Serializable;
import java.util.Date;
import java.util.UUID;
import org.apache.hadoop.conf.Configurable;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.JobID;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.JobStatus;
import org.apache.hadoop.mapreduce.OutputCommitter;
import org.apache.hadoop.mapreduce.OutputFormat;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.TaskAttemptID;
import org.apache.hadoop.mapreduce.TaskID;
import org.apache.hadoop.mapreduce.TaskType;
import org.apache.hadoop.mapreduce.lib.output.FileOutputCommitter;
import org.apache.hadoop.mapreduce.task.TaskAttemptContextImpl;
import org.apache.spark.internal.io.FileCommitProtocol;
import org.apache.spark.internal.io.FileCommitProtocol$;
import org.apache.spark.internal.io.HadoopMapReduceCommitProtocol$;
import org.apache.spark.internal.io.SparkHadoopWriterUtils$;
import org.apache.spark.mapred.SparkHadoopMapRedUtil$;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.StringOps$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.collection.mutable.Set;
import scala.collection.mutable.Set$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0005\u0005\rh\u0001\u0002\u0011\"\u00011B\u0001b\u0011\u0001\u0003\u0002\u0003\u0006I\u0001\u0012\u0005\t\u0019\u0002\u0011\t\u0011)A\u0005\t\"AQ\n\u0001B\u0001B\u0003%a\nC\u0003S\u0001\u0011\u00051\u000bC\u0005Y\u0001\u0001\u0007\t\u0019!C\u00053\"I!\r\u0001a\u0001\u0002\u0004%Ia\u0019\u0005\nS\u0002\u0001\r\u0011!Q!\niCqA\u001c\u0001C\u0002\u0013%q\u000e\u0003\u0004q\u0001\u0001\u0006IA\u0014\u0005\bc\u0002\u0001\r\u0011\"\u0003s\u0011\u001dY\b\u00011A\u0005\nqDaA \u0001!B\u0013\u0019\b\"CA\u0001\u0001\u0001\u0007I\u0011BA\u0002\u0011%\tY\u0001\u0001a\u0001\n\u0013\ti\u0001\u0003\u0005\u0002\u0012\u0001\u0001\u000b\u0015BA\u0003\u0011\u001d\t)\u0002\u0001C\t\u0003/Aq!!\n\u0001\t#\t9\u0003C\u0004\u00024\u0001!\t%!\u000e\t\u000f\u0005%\u0003\u0001\"\u0011\u0002L!9\u0011Q\u000b\u0001\u0005\u0012\u0005]\u0003bBA/\u0001\u0011\u0005\u0013q\f\u0005\b\u0003W\u0002A\u0011IA7\u0011\u001d\tI\t\u0001C!\u0003\u0017Cq!a$\u0001\t\u0003\n\t\nC\u0004\u0002\u0016\u0002!\t%a&\t\u000f\u0005m\u0005\u0001\"\u0011\u0002\u001e\u001eI\u0011\u0011U\u0011\u0002\u0002#\u0005\u00111\u0015\u0004\tA\u0005\n\t\u0011#\u0001\u0002&\"1!\u000b\bC\u0001\u0003sC\u0011\"a/\u001d#\u0003%\t!!0\t\u0013\u0005MG$!A\u0005\n\u0005U'!\b%bI>|\u0007/T1q%\u0016$WoY3D_6l\u0017\u000e\u001e)s_R|7m\u001c7\u000b\u0005\t\u001a\u0013AA5p\u0015\t!S%\u0001\u0005j]R,'O\\1m\u0015\t1s%A\u0003ta\u0006\u00148N\u0003\u0002)S\u00051\u0011\r]1dQ\u0016T\u0011AK\u0001\u0004_J<7\u0001A\n\u0005\u00015\nt\b\u0005\u0002/_5\t\u0011%\u0003\u00021C\t\u0011b)\u001b7f\u0007>lW.\u001b;Qe>$xnY8m!\t\u0011DH\u0004\u00024s9\u0011AgN\u0007\u0002k)\u0011agK\u0001\u0007yI|w\u000e\u001e \n\u0003a\nQa]2bY\u0006L!AO\u001e\u0002\u000fA\f7m[1hK*\t\u0001(\u0003\u0002>}\ta1+\u001a:jC2L'0\u00192mK*\u0011!h\u000f\t\u0003\u0001\u0006k\u0011aI\u0005\u0003\u0005\u000e\u0012q\u0001T8hO&tw-A\u0003k_\nLE\r\u0005\u0002F\u0013:\u0011ai\u0012\t\u0003imJ!\u0001S\u001e\u0002\rA\u0013X\rZ3g\u0013\tQ5J\u0001\u0004TiJLgn\u001a\u0006\u0003\u0011n\nA\u0001]1uQ\u0006IB-\u001f8b[&\u001c\u0007+\u0019:uSRLwN\\(wKJ<(/\u001b;f!\ty\u0005+D\u0001<\u0013\t\t6HA\u0004C_>dW-\u00198\u0002\rqJg.\u001b;?)\u0011!VKV,\u0011\u00059\u0002\u0001\"B\"\u0005\u0001\u0004!\u0005\"\u0002'\u0005\u0001\u0004!\u0005bB'\u0005!\u0003\u0005\rAT\u0001\nG>lW.\u001b;uKJ,\u0012A\u0017\t\u00037\u0002l\u0011\u0001\u0018\u0006\u0003;z\u000b\u0011\"\\1qe\u0016$WoY3\u000b\u0005};\u0013A\u00025bI>|\u0007/\u0003\u0002b9\nyq*\u001e;qkR\u001cu.\\7jiR,'/A\u0007d_6l\u0017\u000e\u001e;fe~#S-\u001d\u000b\u0003I\u001e\u0004\"aT3\n\u0005\u0019\\$\u0001B+oSRDq\u0001\u001b\u0004\u0002\u0002\u0003\u0007!,A\u0002yIE\n!bY8n[&$H/\u001a:!Q\t91\u000e\u0005\u0002PY&\u0011Qn\u000f\u0002\niJ\fgn]5f]R\fA\u0002[1t-\u0006d\u0017\u000e\u001a)bi\",\u0012AT\u0001\u000eQ\u0006\u001ch+\u00197jIB\u000bG\u000f\u001b\u0011\u0002#\u0005$G-\u001a3BEN\u0004\u0016\r\u001e5GS2,7/F\u0001t!\u0011!\u0018\u0010\u0012#\u000e\u0003UT!A^<\u0002\u000f5,H/\u00192mK*\u0011\u0001pO\u0001\u000bG>dG.Z2uS>t\u0017B\u0001>v\u0005\ri\u0015\r]\u0001\u0016C\u0012$W\rZ!cgB\u000bG\u000f\u001b$jY\u0016\u001cx\fJ3r)\t!W\u0010C\u0004i\u0017\u0005\u0005\t\u0019A:\u0002%\u0005$G-\u001a3BEN\u0004\u0016\r\u001e5GS2,7\u000f\t\u0015\u0003\u0019-\fa\u0002]1si&$\u0018n\u001c8QCRD7/\u0006\u0002\u0002\u0006A!A/a\u0002E\u0013\r\tI!\u001e\u0002\u0004'\u0016$\u0018A\u00059beRLG/[8o!\u0006$\bn]0%KF$2\u0001ZA\b\u0011!Ag\"!AA\u0002\u0005\u0015\u0011a\u00049beRLG/[8o!\u0006$\bn\u001d\u0011)\u0005=Y\u0017AC:uC\u001eLgn\u001a#jeV\u0011\u0011\u0011\u0004\t\u0005\u00037\t\t#\u0004\u0002\u0002\u001e)\u0019\u0011q\u00040\u0002\u0005\u0019\u001c\u0018\u0002BA\u0012\u0003;\u0011A\u0001U1uQ\u0006q1/\u001a;va\u000e{W.\\5ui\u0016\u0014Hc\u0001.\u0002*!9\u00111F\tA\u0002\u00055\u0012aB2p]R,\u0007\u0010\u001e\t\u00047\u0006=\u0012bAA\u00199\n\u0011B+Y:l\u0003R$X-\u001c9u\u0007>tG/\u001a=u\u0003=qWm\u001e+bg.$V-\u001c9GS2,Gc\u0002#\u00028\u0005m\u0012Q\t\u0005\b\u0003s\u0011\u0002\u0019AA\u0017\u0003-!\u0018m]6D_:$X\r\u001f;\t\u000f\u0005u\"\u00031\u0001\u0002@\u0005\u0019A-\u001b:\u0011\t=\u000b\t\u0005R\u0005\u0004\u0003\u0007Z$AB(qi&|g\u000e\u0003\u0004\u0002HI\u0001\r\u0001R\u0001\u0004Kb$\u0018A\u00068foR\u000b7o\u001b+f[B4\u0015\u000e\\3BEN\u0004\u0016\r\u001e5\u0015\u000f\u0011\u000bi%a\u0014\u0002T!9\u0011\u0011H\nA\u0002\u00055\u0002BBA)'\u0001\u0007A)A\u0006bEN|G.\u001e;f\t&\u0014\bBBA$'\u0001\u0007A)A\u0006hKR4\u0015\u000e\\3oC6,G#\u0002#\u0002Z\u0005m\u0003bBA\u001d)\u0001\u0007\u0011Q\u0006\u0005\u0007\u0003\u000f\"\u0002\u0019\u0001#\u0002\u0011M,G/\u001e9K_\n$2\u0001ZA1\u0011\u001d\t\u0019'\u0006a\u0001\u0003K\n!B[8c\u0007>tG/\u001a=u!\rY\u0016qM\u0005\u0004\u0003Sb&A\u0003&pE\u000e{g\u000e^3yi\u0006I1m\\7nSRTuN\u0019\u000b\u0006I\u0006=\u0014\u0011\u000f\u0005\b\u0003G2\u0002\u0019AA3\u0011\u001d\t\u0019H\u0006a\u0001\u0003k\n1\u0002^1tW\u000e{W.\\5ugB)!'a\u001e\u0002|%\u0019\u0011\u0011\u0010 \u0003\u0007M+\u0017\u000f\u0005\u0003\u0002~\u0005\reb\u0001\u0018\u0002\u0000%\u0019\u0011\u0011Q\u0011\u0002%\u0019KG.Z\"p[6LG\u000f\u0015:pi>\u001cw\u000e\\\u0005\u0005\u0003\u000b\u000b9IA\tUCN\\7i\\7nSRlUm]:bO\u0016T1!!!\"\u0003!\t'm\u001c:u\u0015>\u0014Gc\u00013\u0002\u000e\"9\u00111M\fA\u0002\u0005\u0015\u0014!C:fiV\u0004H+Y:l)\r!\u00171\u0013\u0005\b\u0003sA\u0002\u0019AA\u0017\u0003)\u0019w.\\7jiR\u000b7o\u001b\u000b\u0005\u0003w\nI\nC\u0004\u0002:e\u0001\r!!\f\u0002\u0013\u0005\u0014wN\u001d;UCN\\Gc\u00013\u0002 \"9\u0011\u0011\b\u000eA\u0002\u00055\u0012!\b%bI>|\u0007/T1q%\u0016$WoY3D_6l\u0017\u000e\u001e)s_R|7m\u001c7\u0011\u00059b2#\u0002\u000f\u0002(\u00065\u0006cA(\u0002*&\u0019\u00111V\u001e\u0003\r\u0005s\u0017PU3g!\u0011\ty+a.\u000e\u0005\u0005E&b\u0001\u0012\u00024*\u0011\u0011QW\u0001\u0005U\u00064\u0018-C\u0002>\u0003c#\"!a)\u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00134+\t\tyLK\u0002O\u0003\u0003\\#!a1\u0011\t\u0005\u0015\u0017qZ\u0007\u0003\u0003\u000fTA!!3\u0002L\u0006IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003\u001b\\\u0014AC1o]>$\u0018\r^5p]&!\u0011\u0011[Ad\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\roJLG/\u001a*fa2\f7-\u001a\u000b\u0003\u0003/\u0004B!!7\u0002`6\u0011\u00111\u001c\u0006\u0005\u0003;\f\u0019,\u0001\u0003mC:<\u0017\u0002BAq\u00037\u0014aa\u00142kK\u000e$\b")
public class HadoopMapReduceCommitProtocol
extends FileCommitProtocol
implements Serializable {
    private final String jobId;
    private final String path;
    private final boolean dynamicPartitionOverwrite;
    private transient OutputCommitter committer;
    private final boolean hasValidPath;
    private transient Map<String, String> addedAbsPathFiles;
    private transient Set<String> partitionPaths;

    public static boolean $lessinit$greater$default$3() {
        return HadoopMapReduceCommitProtocol$.MODULE$.$lessinit$greater$default$3();
    }

    private OutputCommitter committer() {
        return this.committer;
    }

    private void committer_$eq(OutputCommitter x$1) {
        this.committer = x$1;
    }

    private boolean hasValidPath() {
        return this.hasValidPath;
    }

    private Map<String, String> addedAbsPathFiles() {
        return this.addedAbsPathFiles;
    }

    private void addedAbsPathFiles_$eq(Map<String, String> x$1) {
        this.addedAbsPathFiles = x$1;
    }

    private Set<String> partitionPaths() {
        return this.partitionPaths;
    }

    private void partitionPaths_$eq(Set<String> x$1) {
        this.partitionPaths = x$1;
    }

    public Path stagingDir() {
        return FileCommitProtocol$.MODULE$.getStagingDir(this.path, this.jobId);
    }

    public OutputCommitter setupCommitter(TaskAttemptContext context) {
        OutputFormat format = (OutputFormat)context.getOutputFormatClass().getConstructor(new Class[0]).newInstance(new Object[0]);
        OutputFormat outputFormat = format;
        if (outputFormat instanceof Configurable) {
            OutputFormat outputFormat2 = outputFormat;
            ((Configurable)outputFormat2).setConf(context.getConfiguration());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
        return format.getOutputCommitter(context);
    }

    @Override
    public String newTaskTempFile(TaskAttemptContext taskContext, Option<String> dir, String ext) {
        Path path;
        String filename = this.getFilename(taskContext, ext);
        OutputCommitter outputCommitter = this.committer();
        if (outputCommitter instanceof FileOutputCommitter) {
            BoxedUnit boxedUnit;
            FileOutputCommitter fileOutputCommitter = (FileOutputCommitter)outputCommitter;
            if (this.dynamicPartitionOverwrite) {
                Predef$.MODULE$.assert(dir.isDefined(), (Function0 & Serializable)() -> "The dataset to be written must be partitioned when dynamicPartitionOverwrite is true.");
                boxedUnit = this.partitionPaths().$plus$eq(dir.get());
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            path = new Path((String)Option$.MODULE$.apply((Object)fileOutputCommitter.getWorkPath()).map((Function1 & Serializable)x$2 -> x$2.toString()).getOrElse((Function0 & Serializable)() -> $this.path));
        } else {
            path = new Path(this.path);
        }
        Path stagingDir = path;
        return (String)dir.map((Function1 & Serializable)d -> new Path(new Path(stagingDir, d), filename).toString()).getOrElse((Function0 & Serializable)() -> new Path(stagingDir, filename).toString());
    }

    @Override
    public String newTaskTempFileAbsPath(TaskAttemptContext taskContext, String absoluteDir, String ext) {
        String filename = this.getFilename(taskContext, ext);
        String absOutputPath = new Path(absoluteDir, filename).toString();
        String tmpOutputPath = new Path(this.stagingDir(), new StringBuilder(1).append(UUID.randomUUID().toString()).append("-").append(filename).toString()).toString();
        this.addedAbsPathFiles().update((Object)tmpOutputPath, (Object)absOutputPath);
        return tmpOutputPath;
    }

    public String getFilename(TaskAttemptContext taskContext, String ext) {
        int split;
        int arg$macro$1 = split = taskContext.getTaskAttemptID().getTaskID().getId();
        String arg$macro$2 = this.jobId;
        String arg$macro$3 = ext;
        return StringOps$.MODULE$.format$extension("part-%05d-%s%s", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)arg$macro$1), arg$macro$2, arg$macro$3}));
    }

    @Override
    public void setupJob(JobContext jobContext) {
        JobID jobId = SparkHadoopWriterUtils$.MODULE$.createJobID(new Date(), 0);
        TaskID taskId = new TaskID((org.apache.hadoop.mapreduce.JobID)jobId, TaskType.MAP, 0);
        TaskAttemptID taskAttemptId = new TaskAttemptID(taskId, 0);
        jobContext.getConfiguration().set("mapreduce.job.id", jobId.toString());
        jobContext.getConfiguration().set("mapreduce.task.id", taskAttemptId.getTaskID().toString());
        jobContext.getConfiguration().set("mapreduce.task.attempt.id", taskAttemptId.toString());
        jobContext.getConfiguration().setBoolean("mapreduce.task.ismap", true);
        jobContext.getConfiguration().setInt("mapreduce.task.partition", 0);
        TaskAttemptContextImpl taskAttemptContext = new TaskAttemptContextImpl(jobContext.getConfiguration(), taskAttemptId);
        this.committer_$eq(this.setupCommitter((TaskAttemptContext)taskAttemptContext));
        this.committer().setupJob(jobContext);
    }

    @Override
    public void commitJob(JobContext jobContext, Seq<FileCommitProtocol.TaskCommitMessage> taskCommits) {
        block3: {
            this.committer().commitJob(jobContext);
            if (!this.hasValidPath()) break block3;
            Tuple2 tuple2 = ((IterableOps)taskCommits.map((Function1 & Serializable)x$3 -> (Tuple2)x$3.obj())).unzip(Predef$.MODULE$.$conforms());
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Seq allAbsPathFiles = (Seq)tuple2._1();
            Seq allPartitionPaths = (Seq)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)allAbsPathFiles, (Object)allPartitionPaths);
            Tuple2 tuple23 = tuple22;
            Seq allAbsPathFiles2 = (Seq)tuple23._1();
            Seq allPartitionPaths2 = (Seq)tuple23._2();
            FileSystem fs = this.stagingDir().getFileSystem(jobContext.getConfiguration());
            scala.collection.immutable.Map filesToMove = (scala.collection.immutable.Map)allAbsPathFiles2.foldLeft(Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$), (Function2 & Serializable)(x$5, x$6) -> (scala.collection.immutable.Map)x$5.$plus$plus((IterableOnce)x$6));
            this.logDebug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(47).append("Committing files staged for absolute locations ").append(filesToMove).toString());
            scala.collection.immutable.Set absParentPaths = ((IterableOnceOps)filesToMove.values().map((Function1 & Serializable)x$7 -> new Path(x$7).getParent())).toSet();
            if (this.dynamicPartitionOverwrite) {
                this.logDebug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(57).append("Clean up absolute partition directories for overwriting: ").append(absParentPaths).toString());
                absParentPaths.foreach((Function1 & Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)fs.delete(x$8, true)));
            }
            this.logDebug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(36).append("Create absolute parent directories: ").append(absParentPaths).toString());
            absParentPaths.foreach((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)fs.mkdirs(x$1)));
            filesToMove.withFilter((Function1 & Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)HadoopMapReduceCommitProtocol.$anonfun$commitJob$9(check$ifrefutable$1))).foreach((Function1 & Serializable)x$9 -> {
                HadoopMapReduceCommitProtocol.$anonfun$commitJob$10(fs, x$9);
                return BoxedUnit.UNIT;
            });
            if (this.dynamicPartitionOverwrite) {
                scala.collection.immutable.Set partitionPaths = (scala.collection.immutable.Set)allPartitionPaths2.foldLeft(Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$), (Function2 & Serializable)(x$10, x$11) -> (scala.collection.immutable.Set)x$10.$plus$plus((IterableOnce)x$11));
                this.logDebug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(56).append("Clean up default partition directories for overwriting: ").append(partitionPaths).toString());
                partitionPaths.foreach((Function1 & Serializable)part -> {
                    HadoopMapReduceCommitProtocol.$anonfun$commitJob$13(this, fs, part);
                    return BoxedUnit.UNIT;
                });
            }
            fs.delete(this.stagingDir(), true);
        }
    }

    @Override
    public void abortJob(JobContext jobContext) {
        try {
            this.committer().abortJob(jobContext, JobStatus.State.FAILED);
        }
        catch (IOException e) {
            this.logWarning((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(25).append("Exception while aborting ").append(jobContext.getJobID()).toString(), e);
        }
        try {
            if (this.hasValidPath()) {
                FileSystem fs = this.stagingDir().getFileSystem(jobContext.getConfiguration());
                fs.delete(this.stagingDir(), true);
            }
        }
        catch (IOException e) {
            this.logWarning((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(25).append("Exception while aborting ").append(jobContext.getJobID()).toString(), e);
        }
    }

    @Override
    public void setupTask(TaskAttemptContext taskContext) {
        this.committer_$eq(this.setupCommitter(taskContext));
        this.committer().setupTask(taskContext);
        this.addedAbsPathFiles_$eq((Map<String, String>)((Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$)));
        this.partitionPaths_$eq((Set<String>)((Set)Set$.MODULE$.apply((Seq)Nil$.MODULE$)));
    }

    @Override
    public FileCommitProtocol.TaskCommitMessage commitTask(TaskAttemptContext taskContext) {
        TaskAttemptID attemptId = taskContext.getTaskAttemptID();
        this.logTrace((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(12).append("Commit task ").append(attemptId).toString());
        SparkHadoopMapRedUtil$.MODULE$.commitTask(this.committer(), taskContext, attemptId.getJobID().getId(), attemptId.getTaskID().getId());
        return new FileCommitProtocol.TaskCommitMessage(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.addedAbsPathFiles().toMap((.less.colon.less)$less$colon$less$.MODULE$.refl())), (Object)this.partitionPaths().toSet()));
    }

    @Override
    public void abortTask(TaskAttemptContext taskContext) {
        try {
            this.committer().abortTask(taskContext);
        }
        catch (IOException e) {
            this.logWarning((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(25).append("Exception while aborting ").append(taskContext.getTaskAttemptID()).toString(), e);
        }
        try {
            this.addedAbsPathFiles().withFilter((Function1 & Serializable)check$ifrefutable$2 -> BoxesRunTime.boxToBoolean((boolean)HadoopMapReduceCommitProtocol.$anonfun$abortTask$2(check$ifrefutable$2))).foreach((Function1 & Serializable)x$12 -> BoxesRunTime.boxToBoolean((boolean)HadoopMapReduceCommitProtocol.$anonfun$abortTask$3(taskContext, x$12)));
        }
        catch (IOException e) {
            this.logWarning((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(25).append("Exception while aborting ").append(taskContext.getTaskAttemptID()).toString(), e);
        }
    }

    public static final /* synthetic */ boolean $anonfun$commitJob$9(Tuple2 check$ifrefutable$1) {
        Tuple2 tuple2 = check$ifrefutable$1;
        boolean bl = tuple2 != null;
        return bl;
    }

    public static final /* synthetic */ void $anonfun$commitJob$10(FileSystem fs$1, Tuple2 x$9) {
        Tuple2 tuple2 = x$9;
        if (tuple2 != null) {
            String dst;
            String src = (String)tuple2._1();
            if (!fs$1.rename(new Path(src), new Path(dst = (String)tuple2._2()))) {
                throw new IOException(new StringBuilder(0).append(new StringBuilder(55).append("Failed to rename ").append(src).append(" to ").append(dst).append(" when committing files staged for ").toString()).append("absolute locations").toString());
            }
        } else {
            throw new MatchError((Object)tuple2);
        }
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$commitJob$13(HadoopMapReduceCommitProtocol $this, FileSystem fs$1, String part) {
        Path finalPartPath = new Path($this.path, part);
        Object object = !fs$1.delete(finalPartPath, true) && !fs$1.exists(finalPartPath.getParent()) ? BoxesRunTime.boxToBoolean((boolean)fs$1.mkdirs(finalPartPath.getParent())) : BoxedUnit.UNIT;
        Path stagingPartPath = new Path($this.stagingDir(), part);
        if (!fs$1.rename(stagingPartPath, finalPartPath)) {
            throw new IOException(new StringBuilder(0).append(new StringBuilder(27).append("Failed to rename ").append(stagingPartPath).append(" to ").append(finalPartPath).append(" when ").toString()).append("committing files staged for overwriting dynamic partitions").toString());
        }
    }

    public static final /* synthetic */ boolean $anonfun$abortTask$2(Tuple2 check$ifrefutable$2) {
        Tuple2 tuple2 = check$ifrefutable$2;
        boolean bl = tuple2 != null;
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$abortTask$3(TaskAttemptContext taskContext$1, Tuple2 x$12) {
        Tuple2 tuple2 = x$12;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String src = (String)tuple2._1();
        Path tmp = new Path(src);
        boolean bl = tmp.getFileSystem(taskContext$1.getConfiguration()).delete(tmp, false);
        return bl;
    }

    public HadoopMapReduceCommitProtocol(String jobId, String path, boolean dynamicPartitionOverwrite) {
        this.jobId = jobId;
        this.path = path;
        this.dynamicPartitionOverwrite = dynamicPartitionOverwrite;
        this.hasValidPath = Try$.MODULE$.apply((Function0 & Serializable)() -> new Path($this.path)).isSuccess();
        this.addedAbsPathFiles = null;
        this.partitionPaths = null;
    }
}

