/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.io;

import java.io.InputStream;
import java.io.OutputStream;
import net.jpountz.lz4.LZ4BlockInputStream;
import net.jpountz.lz4.LZ4BlockOutputStream;
import net.jpountz.lz4.LZ4Factory;
import net.jpountz.xxhash.XXHashFactory;
import org.apache.spark.SparkConf;
import org.apache.spark.annotation.DeveloperApi;
import org.apache.spark.internal.config.package$;
import org.apache.spark.io.CompressionCodec;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@DeveloperApi
@ScalaSignature(bytes="\u0006\u0005m3A\u0001C\u0005\u0001%!AQ\u0004\u0001B\u0001B\u0003%a\u0004C\u0003#\u0001\u0011\u00051\u0005\u0003\u0005'\u0001!\u0015\r\u0015\"\u0003(\u0011!1\u0004\u0001#b!\n\u00139\u0004BB \u0001A\u0003%\u0001\tC\u0003D\u0001\u0011\u0005C\tC\u0003O\u0001\u0011\u0005sJA\nM5R\u001au.\u001c9sKN\u001c\u0018n\u001c8D_\u0012,7M\u0003\u0002\u000b\u0017\u0005\u0011\u0011n\u001c\u0006\u0003\u00195\tQa\u001d9be.T!AD\b\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005\u0001\u0012aA8sO\u000e\u00011c\u0001\u0001\u00143A\u0011AcF\u0007\u0002+)\ta#A\u0003tG\u0006d\u0017-\u0003\u0002\u0019+\t1\u0011I\\=SK\u001a\u0004\"AG\u000e\u000e\u0003%I!\u0001H\u0005\u0003!\r{W\u000e\u001d:fgNLwN\\\"pI\u0016\u001c\u0017\u0001B2p]\u001a\u0004\"a\b\u0011\u000e\u0003-I!!I\u0006\u0003\u0013M\u0003\u0018M]6D_:4\u0017A\u0002\u001fj]&$h\b\u0006\u0002%KA\u0011!\u0004\u0001\u0005\u0006;\t\u0001\rAH\u0001\u000bYj$d)Y2u_JLX#\u0001\u0015\u0011\u0005%\u0002T\"\u0001\u0016\u000b\u0005-b\u0013a\u00017{i)\u0011QFL\u0001\bUB|WO\u001c;{\u0015\u0005y\u0013a\u00018fi&\u0011\u0011G\u000b\u0002\u000b\u0019j#d)Y2u_JL\bFA\u00024!\t!B'\u0003\u00026+\tIAO]1og&,g\u000e^\u0001\u000eqbD\u0015m\u001d5GC\u000e$xN]=\u0016\u0003a\u0002\"!\u000f\u001f\u000e\u0003iR!a\u000f\u0017\u0002\raD\b.Y:i\u0013\ti$HA\u0007Y1\"\u000b7\u000f\u001b$bGR|'/\u001f\u0015\u0003\tM\n1\u0002Z3gCVdGoU3fIB\u0011A#Q\u0005\u0003\u0005V\u00111!\u00138u\u0003Y\u0019w.\u001c9sKN\u001cX\rZ(viB,Ho\u0015;sK\u0006lGCA#M!\t1%*D\u0001H\u0015\tQ\u0001JC\u0001J\u0003\u0011Q\u0017M^1\n\u0005-;%\u0001D(viB,Ho\u0015;sK\u0006l\u0007\"B'\u0007\u0001\u0004)\u0015!A:\u0002+\r|W\u000e\u001d:fgN,G-\u00138qkR\u001cFO]3b[R\u0011\u0001k\u0015\t\u0003\rFK!AU$\u0003\u0017%s\u0007/\u001e;TiJ,\u0017-\u001c\u0005\u0006\u001b\u001e\u0001\r\u0001\u0015\u0015\u0003\u0001U\u0003\"AV-\u000e\u0003]S!\u0001W\u0006\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0002[/\naA)\u001a<fY>\u0004XM]!qS\u0002")
public class LZ4CompressionCodec
implements CompressionCodec {
    private transient LZ4Factory lz4Factory;
    private transient XXHashFactory xxHashFactory;
    private final SparkConf conf;
    private final int defaultSeed;
    private volatile transient byte bitmap$trans$0;

    @Override
    public OutputStream compressedContinuousOutputStream(OutputStream s) {
        return CompressionCodec.compressedContinuousOutputStream$(this, s);
    }

    @Override
    public InputStream compressedContinuousInputStream(InputStream s) {
        return CompressionCodec.compressedContinuousInputStream$(this, s);
    }

    private LZ4Factory lz4Factory$lzycompute() {
        LZ4CompressionCodec lZ4CompressionCodec = this;
        synchronized (lZ4CompressionCodec) {
            if ((byte)(this.bitmap$trans$0 & 1) == 0) {
                this.lz4Factory = LZ4Factory.fastestInstance();
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 1);
            }
        }
        return this.lz4Factory;
    }

    private LZ4Factory lz4Factory() {
        return (byte)(this.bitmap$trans$0 & 1) == 0 ? this.lz4Factory$lzycompute() : this.lz4Factory;
    }

    private XXHashFactory xxHashFactory$lzycompute() {
        LZ4CompressionCodec lZ4CompressionCodec = this;
        synchronized (lZ4CompressionCodec) {
            if ((byte)(this.bitmap$trans$0 & 2) == 0) {
                this.xxHashFactory = XXHashFactory.fastestInstance();
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 2);
            }
        }
        return this.xxHashFactory;
    }

    private XXHashFactory xxHashFactory() {
        return (byte)(this.bitmap$trans$0 & 2) == 0 ? this.xxHashFactory$lzycompute() : this.xxHashFactory;
    }

    @Override
    public OutputStream compressedOutputStream(OutputStream s) {
        int blockSize = (int)BoxesRunTime.unboxToLong((Object)this.conf.get(package$.MODULE$.IO_COMPRESSION_LZ4_BLOCKSIZE()));
        boolean syncFlush = false;
        return new LZ4BlockOutputStream(s, blockSize, this.lz4Factory().fastCompressor(), this.xxHashFactory().newStreamingHash32(this.defaultSeed).asChecksum(), syncFlush);
    }

    @Override
    public InputStream compressedInputStream(InputStream s) {
        boolean disableConcatenationOfByteStream = false;
        return new LZ4BlockInputStream(s, this.lz4Factory().fastDecompressor(), this.xxHashFactory().newStreamingHash32(this.defaultSeed).asChecksum(), disableConcatenationOfByteStream);
    }

    public LZ4CompressionCodec(SparkConf conf) {
        this.conf = conf;
        CompressionCodec.$init$(this);
        this.defaultSeed = -1756908916;
    }
}

