/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.memory;

import java.io.Serializable;
import javax.annotation.concurrent.GuardedBy;
import org.apache.spark.SparkConf;
import org.apache.spark.internal.Logging;
import org.apache.spark.memory.ExecutionMemoryPool;
import org.apache.spark.memory.MemoryMode;
import org.apache.spark.memory.StorageMemoryPool;
import org.apache.spark.storage.BlockId;
import org.apache.spark.storage.memory.MemoryStore;
import org.apache.spark.unsafe.Platform;
import org.apache.spark.unsafe.array.ByteArrayMethods;
import org.apache.spark.unsafe.memory.MemoryAllocator;
import org.slf4j.Logger;
import scala.Function0;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\u0005%fA\u0002\u0016,\u0003\u0003i3\u0007\u0003\u0005A\u0001\t\u0005\t\u0015!\u0003C\u0011!1\u0005A!A!\u0002\u00139\u0005\u0002\u0003&\u0001\u0005\u0003\u0005\u000b\u0011B&\t\u00119\u0003!\u0011!Q\u0001\n-CQa\u0014\u0001\u0005\u0002ACqa\u0016\u0001C\u0002\u0013E\u0001\f\u0003\u0004]\u0001\u0001\u0006I!\u0017\u0005\bW\u0002\u0011\r\u0011\"\u0005Y\u0011\u0019a\u0007\u0001)A\u00053\"9a\u000e\u0001b\u0001\n#y\u0007BB:\u0001A\u0003%\u0001\u000fC\u0004v\u0001\t\u0007I\u0011C8\t\rY\u0004\u0001\u0015!\u0003q\u0011\u001dA\bA1Q\u0005\u0012eDaA\u001f\u0001!\u0002\u0013Y\u0005bB>\u0001\u0005\u0004&\t\"\u001f\u0005\u0007y\u0002\u0001\u000b\u0011B&\t\u000bu\u0004a\u0011A=\t\u000by\u0004a\u0011A=\t\r}\u0004AQAA\u0001\u0011\u001d\tY\u0002\u0001D\u0001\u0003;Aq!a\u0010\u0001\r\u0003\t\t\u0005\u0003\u0005\u0002J\u00011\taKA&\u0011!\t)\u0006\u0001C\u0001W\u0005]\u0003\u0002CA0\u0001\u0011\u00051&!\u0019\t\u000f\u0005\u0015\u0004\u0001\"\u0001\u0002h!9\u0011Q\u000e\u0001\u0005\u0006\u0005=\u0004bBA9\u0001\u0011\u0015\u00111\u000f\u0005\u0007\u0003s\u0002AQA=\t\r\u0005m\u0004\u0001\"\u0002z\u0011\u0019\ti\b\u0001C\u0003s\"1\u0011q\u0010\u0001\u0005\u0006eDa!!!\u0001\t\u000bI\bBBAB\u0001\u0011\u0015\u0011\u0010\u0003\u0005\u0002\u0006\u0002!\taKAD\u0011%\tY\t\u0001b\u0001\n\u000b\ti\t\u0003\u0005\u0002\u0010\u0002\u0001\u000bQBA\u001d\u0011!\t\t\n\u0001b\u0001\n\u0003I\bbBAJ\u0001\u0001\u0006Ia\u0013\u0005\u000b\u0003+\u0003!\u0019!C\u0003W\u0005]\u0005\u0002CAT\u0001\u0001\u0006i!!'\u0003\u001b5+Wn\u001c:z\u001b\u0006t\u0017mZ3s\u0015\taS&\u0001\u0004nK6|'/\u001f\u0006\u0003]=\nQa\u001d9be.T!\u0001M\u0019\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005\u0011\u0014aA8sON\u0019\u0001\u0001\u000e\u001e\u0011\u0005UBT\"\u0001\u001c\u000b\u0003]\nQa]2bY\u0006L!!\u000f\u001c\u0003\r\u0005s\u0017PU3g!\tYd(D\u0001=\u0015\tiT&\u0001\u0005j]R,'O\\1m\u0013\tyDHA\u0004M_\u001e<\u0017N\\4\u0002\t\r|gNZ\u0002\u0001!\t\u0019E)D\u0001.\u0013\t)UFA\u0005Ta\u0006\u00148nQ8oM\u0006Aa.^7D_J,7\u000f\u0005\u00026\u0011&\u0011\u0011J\u000e\u0002\u0004\u0013:$\u0018aE8o\u0011\u0016\f\u0007o\u0015;pe\u0006<W-T3n_JL\bCA\u001bM\u0013\tieG\u0001\u0003M_:<\u0017!F8o\u0011\u0016\f\u0007/\u0012=fGV$\u0018n\u001c8NK6|'/_\u0001\u0007y%t\u0017\u000e\u001e \u0015\u000bE\u001bF+\u0016,\u0011\u0005I\u0003Q\"A\u0016\t\u000b\u0001+\u0001\u0019\u0001\"\t\u000b\u0019+\u0001\u0019A$\t\u000b)+\u0001\u0019A&\t\u000b9+\u0001\u0019A&\u0002/=t\u0007*Z1q'R|'/Y4f\u001b\u0016lwN]=Q_>dW#A-\u0011\u0005IS\u0016BA.,\u0005E\u0019Fo\u001c:bO\u0016lU-\\8ssB{w\u000e\\\u0001\u0019_:DU-\u00199Ti>\u0014\u0018mZ3NK6|'/\u001f)p_2\u0004\u0003\u0006B\u0004_Q&\u0004\"a\u00184\u000e\u0003\u0001T!!\u00192\u0002\u0015\r|gnY;se\u0016tGO\u0003\u0002dI\u0006Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\u000b\u0003\u0015\fQA[1wCbL!a\u001a1\u0003\u0013\u001d+\u0018M\u001d3fI\nK\u0018!\u0002<bYV,\u0017%\u00016\u0002\tQD\u0017n]\u0001\u0019_\u001a4\u0007*Z1q'R|'/Y4f\u001b\u0016lwN]=Q_>d\u0017!G8gM\"+\u0017\r]*u_J\fw-Z'f[>\u0014\u0018\u0010U8pY\u0002BC!\u00030iS\u0006IrN\u001c%fCB,\u00050Z2vi&|g.T3n_JL\bk\\8m+\u0005\u0001\bC\u0001*r\u0013\t\u00118FA\nFq\u0016\u001cW\u000f^5p]6+Wn\u001c:z!>|G.\u0001\u000ep]\"+\u0017\r]#yK\u000e,H/[8o\u001b\u0016lwN]=Q_>d\u0007\u0005\u000b\u0003\f=\"L\u0017AG8gM\"+\u0017\r]#yK\u000e,H/[8o\u001b\u0016lwN]=Q_>d\u0017aG8gM\"+\u0017\r]#yK\u000e,H/[8o\u001b\u0016lwN]=Q_>d\u0007\u0005\u000b\u0003\u000e=\"L\u0017\u0001E7bq>3g\rS3ba6+Wn\u001c:z+\u0005Y\u0015!E7bq>3g\rS3ba6+Wn\u001c:zA\u0005!rN\u001a4IK\u0006\u00048\u000b^8sC\u001e,W*Z7pef\fQc\u001c4g\u0011\u0016\f\u0007o\u0015;pe\u0006<W-T3n_JL\b%\u0001\fnCb|e\u000eS3baN#xN]1hK6+Wn\u001c:z\u0003]i\u0017\r_(gM\"+\u0017\r]*u_J\fw-Z'f[>\u0014\u00180\u0001\btKRlU-\\8ssN#xN]3\u0015\t\u0005\r\u0011\u0011\u0002\t\u0004k\u0005\u0015\u0011bAA\u0004m\t!QK\\5u\u0011\u001d\tY\u0001\u0006a\u0001\u0003\u001b\tQa\u001d;pe\u0016\u0004B!a\u0004\u0002\u00185\u0011\u0011\u0011\u0003\u0006\u0004Y\u0005M!bAA\u000b[\u000591\u000f^8sC\u001e,\u0017\u0002BA\r\u0003#\u00111\"T3n_JL8\u000b^8sK\u0006!\u0012mY9vSJ,7\u000b^8sC\u001e,W*Z7pef$\u0002\"a\b\u0002&\u0005E\u0012Q\u0007\t\u0004k\u0005\u0005\u0012bAA\u0012m\t9!i\\8mK\u0006t\u0007bBA\u0014+\u0001\u0007\u0011\u0011F\u0001\bE2|7m[%e!\u0011\tY#!\f\u000e\u0005\u0005M\u0011\u0002BA\u0018\u0003'\u0011qA\u00117pG.LE\r\u0003\u0004\u00024U\u0001\raS\u0001\t]Vl')\u001f;fg\"9\u0011qG\u000bA\u0002\u0005e\u0012AC7f[>\u0014\u00180T8eKB\u0019!+a\u000f\n\u0007\u0005u2F\u0001\u0006NK6|'/_'pI\u0016\f1#Y2rk&\u0014X-\u00168s_2dW*Z7pef$\u0002\"a\b\u0002D\u0005\u0015\u0013q\t\u0005\b\u0003O1\u0002\u0019AA\u0015\u0011\u0019\t\u0019D\u0006a\u0001\u0017\"9\u0011q\u0007\fA\u0002\u0005e\u0012AF1dcVL'/Z#yK\u000e,H/[8o\u001b\u0016lwN]=\u0015\u000f-\u000bi%a\u0014\u0002T!1\u00111G\fA\u0002-Ca!!\u0015\u0018\u0001\u0004Y\u0015!\u0004;bg.\fE\u000f^3naRLE\rC\u0004\u00028]\u0001\r!!\u000f\u0002-I,G.Z1tK\u0016CXmY;uS>tW*Z7pef$\u0002\"a\u0001\u0002Z\u0005m\u0013Q\f\u0005\u0007\u0003gA\u0002\u0019A&\t\r\u0005E\u0003\u00041\u0001L\u0011\u001d\t9\u0004\u0007a\u0001\u0003s\t\u0001E]3mK\u0006\u001cX-\u00117m\u000bb,7-\u001e;j_:lU-\\8ss\u001a{'\u000fV1tWR\u00191*a\u0019\t\r\u0005E\u0013\u00041\u0001L\u0003Q\u0011X\r\\3bg\u0016\u001cFo\u001c:bO\u0016lU-\\8ssR1\u00111AA5\u0003WBa!a\r\u001b\u0001\u0004Y\u0005bBA\u001c5\u0001\u0007\u0011\u0011H\u0001\u0018e\u0016dW-Y:f\u00032d7\u000b^8sC\u001e,W*Z7pef$\"!a\u0001\u0002'I,G.Z1tKVs'o\u001c7m\u001b\u0016lwN]=\u0015\r\u0005\r\u0011QOA<\u0011\u0019\t\u0019\u0004\ba\u0001\u0017\"9\u0011q\u0007\u000fA\u0002\u0005e\u0012aE3yK\u000e,H/[8o\u001b\u0016lwN]=Vg\u0016$\u0017!E:u_J\fw-Z'f[>\u0014\u00180V:fI\u0006IrN\u001c%fCB,\u00050Z2vi&|g.T3n_JLXk]3e\u0003iygM\u001a%fCB,\u00050Z2vi&|g.T3n_JLXk]3e\u0003]yg\u000eS3baN#xN]1hK6+Wn\u001c:z+N,G-\u0001\rpM\u001aDU-\u00199Ti>\u0014\u0018mZ3NK6|'/_+tK\u0012\fadZ3u\u000bb,7-\u001e;j_:lU-\\8ssV\u001b\u0018mZ3G_J$\u0016m]6\u0015\u0007-\u000bI\t\u0003\u0004\u0002R\r\u0002\raS\u0001\u0013iVtwm\u001d;f]6+Wn\u001c:z\u001b>$W-\u0006\u0002\u0002:\u0005\u0019B/\u001e8hgR,g.T3n_JLXj\u001c3fA\u0005i\u0001/Y4f'&TXMQ=uKN\fa\u0002]1hKNK'0\u001a\"zi\u0016\u001c\b%A\fuk:<7\u000f^3o\u001b\u0016lwN]=BY2|7-\u0019;peV\u0011\u0011\u0011\u0014\t\u0005\u00037\u000b\u0019+\u0004\u0002\u0002\u001e*\u0019A&a(\u000b\u0007\u0005\u0005V&\u0001\u0004v]N\fg-Z\u0005\u0005\u0003K\u000biJA\bNK6|'/_!mY>\u001c\u0017\r^8s\u0003a!XO\\4ti\u0016tW*Z7pef\fE\u000e\\8dCR|'\u000f\t")
public abstract class MemoryManager
implements Logging {
    @GuardedBy(value="this")
    private final StorageMemoryPool onHeapStorageMemoryPool;
    @GuardedBy(value="this")
    private final StorageMemoryPool offHeapStorageMemoryPool;
    @GuardedBy(value="this")
    private final ExecutionMemoryPool onHeapExecutionMemoryPool;
    @GuardedBy(value="this")
    private final ExecutionMemoryPool offHeapExecutionMemoryPool;
    private final long maxOffHeapMemory;
    private final long offHeapStorageMemory;
    private final MemoryMode tungstenMemoryMode;
    private final long pageSizeBytes;
    private final MemoryAllocator tungstenMemoryAllocator;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    @Override
    public String logName() {
        return Logging.logName$(this);
    }

    @Override
    public Logger log() {
        return Logging.log$(this);
    }

    @Override
    public void logInfo(Function0<String> msg) {
        Logging.logInfo$(this, msg);
    }

    @Override
    public void logDebug(Function0<String> msg) {
        Logging.logDebug$(this, msg);
    }

    @Override
    public void logTrace(Function0<String> msg) {
        Logging.logTrace$(this, msg);
    }

    @Override
    public void logWarning(Function0<String> msg) {
        Logging.logWarning$(this, msg);
    }

    @Override
    public void logError(Function0<String> msg) {
        Logging.logError$(this, msg);
    }

    @Override
    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$(this, msg, throwable);
    }

    @Override
    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$(this, msg, throwable);
    }

    @Override
    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$(this, msg, throwable);
    }

    @Override
    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$(this, msg, throwable);
    }

    @Override
    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$(this, msg, throwable);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$(this, isInterpreter);
    }

    @Override
    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$(this, isInterpreter, silent);
    }

    @Override
    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$(this);
    }

    @Override
    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$(this, isInterpreter, silent);
    }

    @Override
    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    @Override
    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public StorageMemoryPool onHeapStorageMemoryPool() {
        return this.onHeapStorageMemoryPool;
    }

    public StorageMemoryPool offHeapStorageMemoryPool() {
        return this.offHeapStorageMemoryPool;
    }

    public ExecutionMemoryPool onHeapExecutionMemoryPool() {
        return this.onHeapExecutionMemoryPool;
    }

    public ExecutionMemoryPool offHeapExecutionMemoryPool() {
        return this.offHeapExecutionMemoryPool;
    }

    public long maxOffHeapMemory() {
        return this.maxOffHeapMemory;
    }

    public long offHeapStorageMemory() {
        return this.offHeapStorageMemory;
    }

    public abstract long maxOnHeapStorageMemory();

    public abstract long maxOffHeapStorageMemory();

    public final synchronized void setMemoryStore(MemoryStore store) {
        this.onHeapStorageMemoryPool().setMemoryStore(store);
        this.offHeapStorageMemoryPool().setMemoryStore(store);
    }

    public abstract boolean acquireStorageMemory(BlockId var1, long var2, MemoryMode var4);

    public abstract boolean acquireUnrollMemory(BlockId var1, long var2, MemoryMode var4);

    public abstract long acquireExecutionMemory(long var1, long var3, MemoryMode var5);

    public synchronized void releaseExecutionMemory(long numBytes, long taskAttemptId, MemoryMode memoryMode) {
        MemoryMode memoryMode2 = memoryMode;
        if (((Object)((Object)MemoryMode.ON_HEAP)).equals((Object)memoryMode2)) {
            this.onHeapExecutionMemoryPool().releaseMemory(numBytes, taskAttemptId);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (((Object)((Object)MemoryMode.OFF_HEAP)).equals((Object)memoryMode2)) {
            this.offHeapExecutionMemoryPool().releaseMemory(numBytes, taskAttemptId);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError((Object)memoryMode2);
        }
    }

    public synchronized long releaseAllExecutionMemoryForTask(long taskAttemptId) {
        return this.onHeapExecutionMemoryPool().releaseAllMemoryForTask(taskAttemptId) + this.offHeapExecutionMemoryPool().releaseAllMemoryForTask(taskAttemptId);
    }

    public synchronized void releaseStorageMemory(long numBytes, MemoryMode memoryMode) {
        MemoryMode memoryMode2 = memoryMode;
        if (((Object)((Object)MemoryMode.ON_HEAP)).equals((Object)memoryMode2)) {
            this.onHeapStorageMemoryPool().releaseMemory(numBytes);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (((Object)((Object)MemoryMode.OFF_HEAP)).equals((Object)memoryMode2)) {
            this.offHeapStorageMemoryPool().releaseMemory(numBytes);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError((Object)memoryMode2);
        }
    }

    public final synchronized void releaseAllStorageMemory() {
        this.onHeapStorageMemoryPool().releaseAllMemory();
        this.offHeapStorageMemoryPool().releaseAllMemory();
    }

    public final synchronized void releaseUnrollMemory(long numBytes, MemoryMode memoryMode) {
        this.releaseStorageMemory(numBytes, memoryMode);
    }

    public final synchronized long executionMemoryUsed() {
        return this.onHeapExecutionMemoryPool().memoryUsed() + this.offHeapExecutionMemoryPool().memoryUsed();
    }

    public final synchronized long storageMemoryUsed() {
        return this.onHeapStorageMemoryPool().memoryUsed() + this.offHeapStorageMemoryPool().memoryUsed();
    }

    public final synchronized long onHeapExecutionMemoryUsed() {
        return this.onHeapExecutionMemoryPool().memoryUsed();
    }

    public final synchronized long offHeapExecutionMemoryUsed() {
        return this.offHeapExecutionMemoryPool().memoryUsed();
    }

    public final synchronized long onHeapStorageMemoryUsed() {
        return this.onHeapStorageMemoryPool().memoryUsed();
    }

    public final synchronized long offHeapStorageMemoryUsed() {
        return this.offHeapStorageMemoryPool().memoryUsed();
    }

    public synchronized long getExecutionMemoryUsageForTask(long taskAttemptId) {
        return this.onHeapExecutionMemoryPool().getMemoryUsageForTask(taskAttemptId) + this.offHeapExecutionMemoryPool().getMemoryUsageForTask(taskAttemptId);
    }

    public final MemoryMode tungstenMemoryMode() {
        return this.tungstenMemoryMode;
    }

    public long pageSizeBytes() {
        return this.pageSizeBytes;
    }

    public final MemoryAllocator tungstenMemoryAllocator() {
        return this.tungstenMemoryAllocator;
    }

    public MemoryManager(SparkConf conf, int numCores, long onHeapStorageMemory, long onHeapExecutionMemory) {
        MemoryAllocator memoryAllocator;
        long l;
        MemoryMode memoryMode;
        Logging.$init$(this);
        Predef$.MODULE$.require(onHeapExecutionMemory > 0L, (Function0 & Serializable)() -> "onHeapExecutionMemory must be > 0");
        this.onHeapStorageMemoryPool = new StorageMemoryPool(this, MemoryMode.ON_HEAP);
        this.offHeapStorageMemoryPool = new StorageMemoryPool(this, MemoryMode.OFF_HEAP);
        this.onHeapExecutionMemoryPool = new ExecutionMemoryPool(this, MemoryMode.ON_HEAP);
        this.offHeapExecutionMemoryPool = new ExecutionMemoryPool(this, MemoryMode.OFF_HEAP);
        this.onHeapStorageMemoryPool().incrementPoolSize(onHeapStorageMemory);
        this.onHeapExecutionMemoryPool().incrementPoolSize(onHeapExecutionMemory);
        this.maxOffHeapMemory = BoxesRunTime.unboxToLong((Object)conf.get(org.apache.spark.internal.config.package$.MODULE$.MEMORY_OFFHEAP_SIZE()));
        this.offHeapStorageMemory = (long)((double)this.maxOffHeapMemory() * BoxesRunTime.unboxToDouble((Object)conf.get(org.apache.spark.internal.config.package$.MODULE$.MEMORY_STORAGE_FRACTION())));
        this.offHeapExecutionMemoryPool().incrementPoolSize(this.maxOffHeapMemory() - this.offHeapStorageMemory());
        this.offHeapStorageMemoryPool().incrementPoolSize(this.offHeapStorageMemory());
        if (BoxesRunTime.unboxToBoolean((Object)conf.get(org.apache.spark.internal.config.package$.MODULE$.MEMORY_OFFHEAP_ENABLED()))) {
            Predef$.MODULE$.require(BoxesRunTime.unboxToLong((Object)conf.get(org.apache.spark.internal.config.package$.MODULE$.MEMORY_OFFHEAP_SIZE())) > 0L, (Function0 & Serializable)() -> "spark.memory.offHeap.size must be > 0 when spark.memory.offHeap.enabled == true");
            Predef$.MODULE$.require(Platform.unaligned(), (Function0 & Serializable)() -> "No support for unaligned Unsafe. Set spark.memory.offHeap.enabled to false.");
            memoryMode = MemoryMode.OFF_HEAP;
        } else {
            memoryMode = MemoryMode.ON_HEAP;
        }
        this.tungstenMemoryMode = memoryMode;
        long minPageSize = 0x100000L;
        long maxPageSize = 64L * minPageSize;
        int cores = numCores > 0 ? numCores : Runtime.getRuntime().availableProcessors();
        int safetyFactor = 16;
        MemoryMode memoryMode2 = this.tungstenMemoryMode();
        if (((Object)((Object)MemoryMode.ON_HEAP)).equals((Object)memoryMode2)) {
            l = this.onHeapExecutionMemoryPool().poolSize();
        } else if (((Object)((Object)MemoryMode.OFF_HEAP)).equals((Object)memoryMode2)) {
            l = this.offHeapExecutionMemoryPool().poolSize();
        } else {
            throw new MatchError((Object)memoryMode2);
        }
        long maxTungstenMemory = l;
        long size = ByteArrayMethods.nextPowerOf2((long)(maxTungstenMemory / (long)cores / (long)safetyFactor));
        long l2 = package$.MODULE$.min(maxPageSize, package$.MODULE$.max(minPageSize, size));
        this.pageSizeBytes = BoxesRunTime.unboxToLong((Object)((Option)conf.get(org.apache.spark.internal.config.package$.MODULE$.BUFFER_PAGESIZE())).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable)() -> l2));
        MemoryMode memoryMode3 = this.tungstenMemoryMode();
        if (((Object)((Object)MemoryMode.ON_HEAP)).equals((Object)memoryMode3)) {
            memoryAllocator = MemoryAllocator.HEAP;
        } else if (((Object)((Object)MemoryMode.OFF_HEAP)).equals((Object)memoryMode3)) {
            memoryAllocator = MemoryAllocator.UNSAFE;
        } else {
            throw new MatchError((Object)memoryMode3);
        }
        this.tungstenMemoryAllocator = memoryAllocator;
    }
}

