/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.memory;

import org.apache.spark.SparkConf;
import org.apache.spark.internal.config.Tests$;
import org.apache.spark.internal.config.package$;
import org.apache.spark.memory.UnifiedMemoryManager;
import scala.Predef$;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichDouble$;

public final class UnifiedMemoryManager$ {
    public static final UnifiedMemoryManager$ MODULE$ = new UnifiedMemoryManager$();
    private static final int RESERVED_SYSTEM_MEMORY_BYTES = 314572800;

    private int RESERVED_SYSTEM_MEMORY_BYTES() {
        return RESERVED_SYSTEM_MEMORY_BYTES;
    }

    public UnifiedMemoryManager apply(SparkConf conf, int numCores) {
        long maxMemory = this.getMaxMemory(conf);
        return new UnifiedMemoryManager(conf, maxMemory, (long)((double)maxMemory * BoxesRunTime.unboxToDouble((Object)conf.get(package$.MODULE$.MEMORY_STORAGE_FRACTION()))), numCores);
    }

    private long getMaxMemory(SparkConf conf) {
        long executorMemory;
        long reservedMemory;
        long minSystemMemory;
        long systemMemory = BoxesRunTime.unboxToLong((Object)conf.get(Tests$.MODULE$.TEST_MEMORY()));
        if (systemMemory < (minSystemMemory = (long)RichDouble$.MODULE$.ceil$extension(Predef$.MODULE$.doubleWrapper((double)(reservedMemory = conf.getLong(Tests$.MODULE$.TEST_RESERVED_MEMORY().key(), conf.contains(Tests$.MODULE$.IS_TESTING()) ? 0L : (long)this.RESERVED_SYSTEM_MEMORY_BYTES())) * 1.5)))) {
            throw new IllegalArgumentException(new StringBuilder(0).append(new StringBuilder(20).append("System memory ").append(systemMemory).append(" must ").toString()).append(new StringBuilder(66).append("be at least ").append(minSystemMemory).append(". Please increase heap size using the --driver-memory ").toString()).append(new StringBuilder(34).append("option or ").append(package$.MODULE$.DRIVER_MEMORY().key()).append(" in Spark configuration.").toString()).toString());
        }
        if (conf.contains(package$.MODULE$.EXECUTOR_MEMORY()) && (executorMemory = conf.getSizeAsBytes(package$.MODULE$.EXECUTOR_MEMORY().key())) < minSystemMemory) {
            throw new IllegalArgumentException(new StringBuilder(0).append(new StringBuilder(34).append("Executor memory ").append(executorMemory).append(" must be at least ").toString()).append(new StringBuilder(44).append(minSystemMemory).append(". Please increase executor memory using the ").toString()).append(new StringBuilder(52).append("--executor-memory option or ").append(package$.MODULE$.EXECUTOR_MEMORY().key()).append(" in Spark configuration.").toString()).toString());
        }
        long usableMemory = systemMemory - reservedMemory;
        double memoryFraction = BoxesRunTime.unboxToDouble((Object)conf.get(package$.MODULE$.MEMORY_FRACTION()));
        return (long)((double)usableMemory * memoryFraction);
    }

    private UnifiedMemoryManager$() {
    }
}

