/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.metrics;

import java.io.Serializable;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import org.apache.spark.SparkEnv$;
import org.apache.spark.internal.Logging;
import org.apache.spark.memory.MemoryManager;
import org.apache.spark.metrics.ExecutorMetricType;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Product;
import scala.collection.IterableOnceOps;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

public final class GarbageCollectionMetrics$
implements ExecutorMetricType,
Logging,
Product,
Serializable {
    public static final GarbageCollectionMetrics$ MODULE$ = new GarbageCollectionMetrics$();
    private static Seq<String> youngGenerationGarbageCollector;
    private static Seq<String> oldGenerationGarbageCollector;
    private static Seq<String> nonBuiltInCollectors;
    private static final Seq<String> names;
    private static final Seq<String> YOUNG_GENERATION_BUILTIN_GARBAGE_COLLECTORS;
    private static final Seq<String> OLD_GENERATION_BUILTIN_GARBAGE_COLLECTORS;
    private static transient Logger org$apache$spark$internal$Logging$$log_;
    private static volatile byte bitmap$0;

    static {
        Logging.$init$(MODULE$);
        Product.$init$((Product)MODULE$);
        nonBuiltInCollectors = package$.MODULE$.Nil();
        names = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"MinorGCCount", "MinorGCTime", "MajorGCCount", "MajorGCTime"}));
        YOUNG_GENERATION_BUILTIN_GARBAGE_COLLECTORS = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Copy", "PS Scavenge", "ParNew", "G1 Young Generation"}));
        OLD_GENERATION_BUILTIN_GARBAGE_COLLECTORS = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"MarkSweepCompact", "PS MarkSweep", "ConcurrentMarkSweep", "G1 Old Generation"}));
    }

    public String productElementName(int n) {
        return Product.productElementName$((Product)this, (int)n);
    }

    public Iterator<String> productElementNames() {
        return Product.productElementNames$((Product)this);
    }

    @Override
    public String logName() {
        return Logging.logName$(this);
    }

    @Override
    public Logger log() {
        return Logging.log$(this);
    }

    @Override
    public void logInfo(Function0<String> msg) {
        Logging.logInfo$(this, msg);
    }

    @Override
    public void logDebug(Function0<String> msg) {
        Logging.logDebug$(this, msg);
    }

    @Override
    public void logTrace(Function0<String> msg) {
        Logging.logTrace$(this, msg);
    }

    @Override
    public void logWarning(Function0<String> msg) {
        Logging.logWarning$(this, msg);
    }

    @Override
    public void logError(Function0<String> msg) {
        Logging.logError$(this, msg);
    }

    @Override
    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$(this, msg, throwable);
    }

    @Override
    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$(this, msg, throwable);
    }

    @Override
    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$(this, msg, throwable);
    }

    @Override
    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$(this, msg, throwable);
    }

    @Override
    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$(this, msg, throwable);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$(this, isInterpreter);
    }

    @Override
    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$(this, isInterpreter, silent);
    }

    @Override
    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$(this);
    }

    @Override
    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$(this, isInterpreter, silent);
    }

    @Override
    public Logger org$apache$spark$internal$Logging$$log_() {
        return org$apache$spark$internal$Logging$$log_;
    }

    @Override
    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private Seq<String> nonBuiltInCollectors() {
        return nonBuiltInCollectors;
    }

    private void nonBuiltInCollectors_$eq(Seq<String> x$1) {
        nonBuiltInCollectors = x$1;
    }

    @Override
    public Seq<String> names() {
        return names;
    }

    public Seq<String> YOUNG_GENERATION_BUILTIN_GARBAGE_COLLECTORS() {
        return YOUNG_GENERATION_BUILTIN_GARBAGE_COLLECTORS;
    }

    public Seq<String> OLD_GENERATION_BUILTIN_GARBAGE_COLLECTORS() {
        return OLD_GENERATION_BUILTIN_GARBAGE_COLLECTORS;
    }

    private Seq<String> youngGenerationGarbageCollector$lzycompute() {
        GarbageCollectionMetrics$ garbageCollectionMetrics$ = this;
        synchronized (garbageCollectionMetrics$) {
            if ((byte)(bitmap$0 & 1) == 0) {
                youngGenerationGarbageCollector = SparkEnv$.MODULE$.get().conf().get(org.apache.spark.internal.config.package$.MODULE$.EVENT_LOG_GC_METRICS_YOUNG_GENERATION_GARBAGE_COLLECTORS());
                bitmap$0 = (byte)(bitmap$0 | 1);
            }
        }
        return youngGenerationGarbageCollector;
    }

    private Seq<String> youngGenerationGarbageCollector() {
        return (byte)(bitmap$0 & 1) == 0 ? this.youngGenerationGarbageCollector$lzycompute() : youngGenerationGarbageCollector;
    }

    private Seq<String> oldGenerationGarbageCollector$lzycompute() {
        GarbageCollectionMetrics$ garbageCollectionMetrics$ = this;
        synchronized (garbageCollectionMetrics$) {
            if ((byte)(bitmap$0 & 2) == 0) {
                oldGenerationGarbageCollector = SparkEnv$.MODULE$.get().conf().get(org.apache.spark.internal.config.package$.MODULE$.EVENT_LOG_GC_METRICS_OLD_GENERATION_GARBAGE_COLLECTORS());
                bitmap$0 = (byte)(bitmap$0 | 2);
            }
        }
        return oldGenerationGarbageCollector;
    }

    private Seq<String> oldGenerationGarbageCollector() {
        return (byte)(bitmap$0 & 2) == 0 ? this.oldGenerationGarbageCollector$lzycompute() : oldGenerationGarbageCollector;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public long[] getMetricValues(MemoryManager memoryManager) {
        void var2_2;
        long[] gcMetrics = new long[this.names().length()];
        ((IterableOnceOps)JavaConverters$.MODULE$.asScalaBufferConverter(ManagementFactory.getGarbageCollectorMXBeans()).asScala()).foreach((Function1 & Serializable)mxBean -> {
            GarbageCollectionMetrics$.$anonfun$getMetricValues$1(gcMetrics, mxBean);
            return BoxedUnit.UNIT;
        });
        return var2_2;
    }

    public String productPrefix() {
        return "GarbageCollectionMetrics";
    }

    public int productArity() {
        return 0;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        Object object = Statics.ioobe((int)x$1);
        return object;
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof GarbageCollectionMetrics$;
    }

    public int hashCode() {
        return 794585264;
    }

    public String toString() {
        return "GarbageCollectionMetrics";
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(GarbageCollectionMetrics$.class);
    }

    public static final /* synthetic */ void $anonfun$getMetricValues$1(long[] gcMetrics$1, GarbageCollectorMXBean mxBean) {
        block1: {
            block2: {
                block0: {
                    if (!MODULE$.youngGenerationGarbageCollector().contains((Object)mxBean.getName())) break block0;
                    gcMetrics$1[0] = mxBean.getCollectionCount();
                    gcMetrics$1[1] = mxBean.getCollectionTime();
                    break block1;
                }
                if (!MODULE$.oldGenerationGarbageCollector().contains((Object)mxBean.getName())) break block2;
                gcMetrics$1[2] = mxBean.getCollectionCount();
                gcMetrics$1[3] = mxBean.getCollectionTime();
                break block1;
            }
            if (MODULE$.nonBuiltInCollectors().contains((Object)mxBean.getName())) break block1;
            String string = mxBean.getName();
            MODULE$.nonBuiltInCollectors_$eq((Seq<String>)((Seq)MODULE$.nonBuiltInCollectors().$plus$colon((Object)string)));
            MODULE$.logWarning((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(0).append("To enable non-built-in garbage collector(s) ").append(new StringBuilder(37).append(MODULE$.nonBuiltInCollectors()).append(", users should configure it(them) to ").toString()).append(new StringBuilder(4).append(org.apache.spark.internal.config.package$.MODULE$.EVENT_LOG_GC_METRICS_YOUNG_GENERATION_GARBAGE_COLLECTORS().key()).append(" or ").toString()).append(String.valueOf(org.apache.spark.internal.config.package$.MODULE$.EVENT_LOG_GC_METRICS_OLD_GENERATION_GARBAGE_COLLECTORS().key())).toString());
        }
    }

    private GarbageCollectionMetrics$() {
    }
}

