/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.network.netty;

import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricSet;
import java.io.IOException;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import org.apache.spark.ExecutorDeadException;
import org.apache.spark.SecurityManager;
import org.apache.spark.SparkConf;
import org.apache.spark.internal.config.package$;
import org.apache.spark.network.BlockDataManager;
import org.apache.spark.network.BlockTransferService;
import org.apache.spark.network.TransportContext;
import org.apache.spark.network.buffer.ManagedBuffer;
import org.apache.spark.network.buffer.NioManagedBuffer;
import org.apache.spark.network.client.RpcResponseCallback;
import org.apache.spark.network.client.TransportClient;
import org.apache.spark.network.client.TransportClientFactory;
import org.apache.spark.network.crypto.AuthClientBootstrap;
import org.apache.spark.network.crypto.AuthServerBootstrap;
import org.apache.spark.network.netty.NettyBlockRpcServer;
import org.apache.spark.network.netty.NettyBlockTransferService$;
import org.apache.spark.network.netty.SparkTransportConf$;
import org.apache.spark.network.sasl.SecretKeyHolder;
import org.apache.spark.network.server.RpcHandler;
import org.apache.spark.network.server.TransportServer;
import org.apache.spark.network.server.TransportServerBootstrap;
import org.apache.spark.network.shuffle.BlockFetchingListener;
import org.apache.spark.network.shuffle.BlockTransferListener;
import org.apache.spark.network.shuffle.DownloadFileManager;
import org.apache.spark.network.shuffle.OneForOneBlockFetcher;
import org.apache.spark.network.shuffle.RetryingBlockTransferor;
import org.apache.spark.network.shuffle.protocol.UploadBlock;
import org.apache.spark.network.shuffle.protocol.UploadBlockStream;
import org.apache.spark.network.util.JavaUtils;
import org.apache.spark.network.util.TransportConf;
import org.apache.spark.rpc.RpcEndpointRef;
import org.apache.spark.serializer.JavaSerializer;
import org.apache.spark.storage.BlockId;
import org.apache.spark.storage.BlockManagerMessages;
import org.apache.spark.storage.StorageLevel;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.concurrent.Future;
import scala.concurrent.Promise;
import scala.concurrent.Promise$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.java8.JFunction0;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0005\t]c!B\u0010!\u0001\u0011R\u0003\u0002C\u0018\u0001\u0005\u0003\u0005\u000b\u0011B\u0019\t\u0011U\u0002!\u0011!Q\u0001\nYB\u0001\"\u000f\u0001\u0003\u0002\u0003\u0006IA\u000f\u0005\t\u000f\u0002\u0011)\u0019!C!\u0011\"A\u0011\n\u0001B\u0001B\u0003%!\b\u0003\u0005K\u0001\t\u0005\t\u0015!\u0003L\u0011!y\u0005A!A!\u0002\u0013Y\u0005\u0002\u0003)\u0001\u0005\u0003\u0005\u000b\u0011B)\t\u000b]\u0003A\u0011\u0001-\t\u000f\t\u0004!\u0019!C\u0005G\"1\u0011\u000e\u0001Q\u0001\n\u0011DqA\u001b\u0001C\u0002\u0013%1\u000e\u0003\u0004p\u0001\u0001\u0006I\u0001\u001c\u0005\na\u0002\u0001\r\u0011!Q!\nED\u0011\u0002\u001e\u0001A\u0002\u0003\u0005\u000b\u0015B;\t\u000bi\u0004A\u0011I>\t\u000f\u0005%\u0001\u0001\"\u0003\u0002\f!9\u0011\u0011\u0006\u0001\u0005B\u0005-\u0002bBA!\u0001\u0011\u0005\u00131\t\u0005\b\u0003\u0017\u0002A\u0011IA;\u0011\u001d\t9\b\u0001C!\u0003sBq!!9\u0001\t\u0003\n\u0019\u000f\u0003\u0007\u0002f\u0002\u0001\n\u0011!A\u0001\n\u0003\t9\u000f\u0003\u0007\u0002z\u0002\u0001\n\u0011!A\u0001\n\u0003\tY\u0010\u0003\u0007\u0003\u000e\u0001\u0001\n\u0011!A\u0001\n\u0003\u0011y\u0001\u0003\u0007\u0003 \u0001\u0001\n\u0011!A\u0001\n\u0003\u0011\tc\u0002\u0006\u00032\u0001\n\t\u0011#\u0001%\u0005g1\u0011b\b\u0011\u0002\u0002#\u0005AE!\u000e\t\r]cB\u0011\u0001B\u001f\u0011%\u0011y\u0004HI\u0001\n\u0003\u0011\tEA\rOKR$\u0018P\u00117pG.$&/\u00198tM\u0016\u00148+\u001a:wS\u000e,'BA\u0011#\u0003\u0015qW\r\u001e;z\u0015\t\u0019C%A\u0004oKR<xN]6\u000b\u0005\u00152\u0013!B:qCJ\\'BA\u0014)\u0003\u0019\t\u0007/Y2iK*\t\u0011&A\u0002pe\u001e\u001c\"\u0001A\u0016\u0011\u00051jS\"\u0001\u0012\n\u00059\u0012#\u0001\u0006\"m_\u000e\\GK]1og\u001a,'oU3sm&\u001cW-\u0001\u0003d_:47\u0001\u0001\t\u0003eMj\u0011\u0001J\u0005\u0003i\u0011\u0012\u0011b\u00159be.\u001cuN\u001c4\u0002\u001fM,7-\u001e:jifl\u0015M\\1hKJ\u0004\"AM\u001c\n\u0005a\"#aD*fGV\u0014\u0018\u000e^=NC:\fw-\u001a:\u0002\u0017\tLg\u000eZ!eIJ,7o\u001d\t\u0003w\u0011s!\u0001\u0010\"\u0011\u0005u\u0002U\"\u0001 \u000b\u0005}\u0002\u0014A\u0002\u001fs_>$hHC\u0001B\u0003\u0015\u00198-\u00197b\u0013\t\u0019\u0005)\u0001\u0004Qe\u0016$WMZ\u0005\u0003\u000b\u001a\u0013aa\u0015;sS:<'BA\"A\u0003!Awn\u001d;OC6,W#\u0001\u001e\u0002\u0013!|7\u000f\u001e(b[\u0016\u0004\u0013!B0q_J$\bC\u0001'N\u001b\u0005\u0001\u0015B\u0001(A\u0005\rIe\u000e^\u0001\t]Vl7i\u001c:fg\u0006\tBM]5wKJ,e\u000e\u001a)pS:$(+\u001a4\u0011\u0005I+V\"A*\u000b\u0005Q#\u0013a\u0001:qG&\u0011ak\u0015\u0002\u000f%B\u001cWI\u001c3q_&tGOU3g\u0003\u0019a\u0014N\\5u}QA\u0011l\u0017/^=~\u0003\u0017\r\u0005\u0002[\u00015\t\u0001\u0005C\u00030\u0013\u0001\u0007\u0011\u0007C\u00036\u0013\u0001\u0007a\u0007C\u0003:\u0013\u0001\u0007!\bC\u0003H\u0013\u0001\u0007!\bC\u0003K\u0013\u0001\u00071\nC\u0003P\u0013\u0001\u00071\nC\u0004Q\u0013A\u0005\t\u0019A)\u0002\u0015M,'/[1mSj,'/F\u0001e!\t)w-D\u0001g\u0015\t\u0011G%\u0003\u0002iM\nq!*\u0019<b'\u0016\u0014\u0018.\u00197ju\u0016\u0014\u0018aC:fe&\fG.\u001b>fe\u0002\n1\"Y;uQ\u0016s\u0017M\u00197fIV\tA\u000e\u0005\u0002M[&\u0011a\u000e\u0011\u0002\b\u0005>|G.Z1o\u00031\tW\u000f\u001e5F]\u0006\u0014G.\u001a3!\u0003A!(/\u00198ta>\u0014HoQ8oi\u0016DH\u000f\u0005\u0002-e&\u00111O\t\u0002\u0011)J\fgn\u001d9peR\u001cuN\u001c;fqR\faa]3sm\u0016\u0014\bC\u0001<y\u001b\u00059(B\u0001;#\u0013\tIxOA\bUe\u0006t7\u000f]8siN+'O^3s\u0003\u0011Ig.\u001b;\u0015\u0005q|\bC\u0001'~\u0013\tq\bI\u0001\u0003V]&$\bbBA\u0001!\u0001\u0007\u00111A\u0001\u0011E2|7m\u001b#bi\u0006l\u0015M\\1hKJ\u00042\u0001LA\u0003\u0013\r\t9A\t\u0002\u0011\u00052|7m\u001b#bi\u0006l\u0015M\\1hKJ\fAb\u0019:fCR,7+\u001a:wKJ$2!^A\u0007\u0011\u001d\ty!\u0005a\u0001\u0003#\t!BY8piN$(/\u00199t!\u0019\t\u0019\"!\b\u0002$9!\u0011QCA\r\u001d\ri\u0014qC\u0005\u0002\u0003&\u0019\u00111\u0004!\u0002\u000fA\f7m[1hK&!\u0011qDA\u0011\u0005\u0011a\u0015n\u001d;\u000b\u0007\u0005m\u0001\tE\u0002w\u0003KI1!a\nx\u0005a!&/\u00198ta>\u0014HoU3sm\u0016\u0014(i\\8ugR\u0014\u0018\r]\u0001\u000fg\",hM\u001a7f\u001b\u0016$(/[2t)\t\ti\u0003\u0005\u0003\u00020\u0005uRBAA\u0019\u0015\u0011\t\u0019$!\u000e\u0002\u000f5,GO]5dg*!\u0011qGA\u001d\u0003!\u0019w\u000eZ1iC2,'BAA\u001e\u0003\r\u0019w.\\\u0005\u0005\u0003\u007f\t\tDA\u0005NKR\u0014\u0018nY*fi\u0006Ya-\u001a;dQ\ncwnY6t)5a\u0018QIA%\u0003\u001b\n\t&a\u0017\u0002l!1\u0011qI\nA\u0002i\nA\u0001[8ti\"1\u00111J\nA\u0002-\u000bA\u0001]8si\"1\u0011qJ\nA\u0002i\na!\u001a=fG&#\u0007bBA*'\u0001\u0007\u0011QK\u0001\tE2|7m[%egB!A*a\u0016;\u0013\r\tI\u0006\u0011\u0002\u0006\u0003J\u0014\u0018-\u001f\u0005\b\u0003;\u001a\u0002\u0019AA0\u0003!a\u0017n\u001d;f]\u0016\u0014\b\u0003BA1\u0003Oj!!a\u0019\u000b\u0007\u0005\u0015$%A\u0004tQV4g\r\\3\n\t\u0005%\u00141\r\u0002\u0016\u00052|7m\u001b$fi\u000eD\u0017N\\4MSN$XM\\3s\u0011\u001d\tig\u0005a\u0001\u0003_\nq\u0002^3na\u001aKG.Z'b]\u0006<WM\u001d\t\u0005\u0003C\n\t(\u0003\u0003\u0002t\u0005\r$a\u0005#po:dw.\u00193GS2,W*\u00198bO\u0016\u0014X#A&\u0002\u0017U\u0004Hn\\1e\u00052|7m\u001b\u000b\u0011\u0003w\n9)a#\u0002\u000e\u0006=\u0015qTAX\u0003s\u0003R!! \u0002\u0004rl!!a \u000b\u0007\u0005\u0005\u0005)\u0001\u0006d_:\u001cWO\u001d:f]RLA!!\"\u0002\u0000\t1a)\u001e;ve\u0016Da!!#\u0016\u0001\u0004Q\u0014\u0001\u00035pgRt\u0017-\\3\t\r\u0005-S\u00031\u0001L\u0011\u0019\ty%\u0006a\u0001u!9\u0011\u0011S\u000bA\u0002\u0005M\u0015a\u00022m_\u000e\\\u0017\n\u001a\t\u0005\u0003+\u000bY*\u0004\u0002\u0002\u0018*\u0019\u0011\u0011\u0014\u0013\u0002\u000fM$xN]1hK&!\u0011QTAL\u0005\u001d\u0011En\\2l\u0013\u0012Dq!!)\u0016\u0001\u0004\t\u0019+A\u0005cY>\u001c7\u000eR1uCB!\u0011QUAV\u001b\t\t9KC\u0002\u0002*\n\naAY;gM\u0016\u0014\u0018\u0002BAW\u0003O\u0013Q\"T1oC\u001e,GMQ;gM\u0016\u0014\bbBAY+\u0001\u0007\u00111W\u0001\u0006Y\u00164X\r\u001c\t\u0005\u0003+\u000b),\u0003\u0003\u00028\u0006]%\u0001D*u_J\fw-\u001a'fm\u0016d\u0007bBA^+\u0001\u0007\u0011QX\u0001\tG2\f7o\u001d+bOB\"\u0011qXAh!\u0019\t\t-a2\u0002L6\u0011\u00111\u0019\u0006\u0004\u0003\u000b\u0004\u0015a\u0002:fM2,7\r^\u0005\u0005\u0003\u0013\f\u0019M\u0001\u0005DY\u0006\u001c8\u000fV1h!\u0011\ti-a4\r\u0001\u0011a\u0011\u0011[A]\u0003\u0003\u0005\tQ!\u0001\u0002T\n\u0019q\fJ\u0019\u0012\t\u0005U\u00171\u001c\t\u0004\u0019\u0006]\u0017bAAm\u0001\n9aj\u001c;iS:<\u0007c\u0001'\u0002^&\u0019\u0011q\u001c!\u0003\u0007\u0005s\u00170A\u0003dY>\u001cX\rF\u0001}\u0003]\u0001(o\u001c;fGR,G\rJ2mS\u0016tGOR1di>\u0014\u0018\u0010\u0006\u0003\u0002j\u0006U\b\u0003BAv\u0003cl!!!<\u000b\u0007\u0005=(%\u0001\u0004dY&,g\u000e^\u0005\u0005\u0003g\fiO\u0001\fUe\u0006t7\u000f]8si\u000ec\u0017.\u001a8u\r\u0006\u001cGo\u001c:z\u0011!\t9pFA\u0001\u0002\u0004I\u0016a\u0001=%c\u0005y\u0001O]8uK\u000e$X\r\u001a\u0013baBLE\r\u0006\u0003\u0002~\n-\u0001\u0003BA\u0000\u0005\u0013i!A!\u0001\u000b\t\t\r!QA\u0001\u0005Y\u0006twM\u0003\u0002\u0003\b\u0005!!.\u0019<b\u0013\r)%\u0011\u0001\u0005\t\u0003oD\u0012\u0011!a\u00013\u00069\u0002O]8uK\u000e$X\r\u001a\u0013ue\u0006t7\u000f]8si\u000e{gN\u001a\u000b\u0005\u0005#\u0011i\u0002\u0005\u0003\u0003\u0014\teQB\u0001B\u000b\u0015\r\u00119BI\u0001\u0005kRLG.\u0003\u0003\u0003\u001c\tU!!\u0004+sC:\u001c\bo\u001c:u\u0007>tg\r\u0003\u0005\u0002xf\t\t\u00111\u0001Z\u0003A\u0001(o\u001c;fGR,G\r\n7pO\u001e,'\u000f\u0006\u0003\u0003$\t=\u0002\u0003\u0002B\u0013\u0005Wi!Aa\n\u000b\u0007\t%\u0002&A\u0003tY\u001a$$.\u0003\u0003\u0003.\t\u001d\"A\u0002'pO\u001e,'\u000f\u0003\u0005\u0002xj\t\t\u00111\u0001Z\u0003eqU\r\u001e;z\u00052|7m\u001b+sC:\u001ch-\u001a:TKJ4\u0018nY3\u0011\u0005ic2c\u0001\u000f\u00038A\u0019AJ!\u000f\n\u0007\tm\u0002I\u0001\u0004B]f\u0014VM\u001a\u000b\u0003\u0005g\t1\u0004\n7fgNLg.\u001b;%OJ,\u0017\r^3sI\u0011,g-Y;mi\u0012:TC\u0001B\"U\r\t&QI\u0016\u0003\u0005\u000f\u0002BA!\u0013\u0003T5\u0011!1\n\u0006\u0005\u0005\u001b\u0012y%A\u0005v]\u000eDWmY6fI*\u0019!\u0011\u000b!\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0003V\t-#!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0002")
public class NettyBlockTransferService
extends BlockTransferService {
    private final SparkConf conf;
    private final SecurityManager securityManager;
    private final String bindAddress;
    private final String hostName;
    private final int _port;
    private final int numCores;
    public final RpcEndpointRef org$apache$spark$network$netty$NettyBlockTransferService$$driverEndPointRef;
    private final JavaSerializer serializer;
    private final boolean authEnabled;
    private TransportContext transportContext;
    public TransportServer org$apache$spark$network$netty$NettyBlockTransferService$$server;

    public static RpcEndpointRef $lessinit$greater$default$7() {
        return NettyBlockTransferService$.MODULE$.$lessinit$greater$default$7();
    }

    public /* synthetic */ TransportClientFactory protected$clientFactory(NettyBlockTransferService x$1) {
        return x$1.clientFactory;
    }

    public /* synthetic */ String protected$appId(NettyBlockTransferService x$1) {
        return x$1.appId;
    }

    public /* synthetic */ TransportConf protected$transportConf(NettyBlockTransferService x$1) {
        return x$1.transportConf;
    }

    public /* synthetic */ Logger protected$logger(NettyBlockTransferService x$1) {
        return x$1.logger;
    }

    @Override
    public String hostName() {
        return this.hostName;
    }

    private JavaSerializer serializer() {
        return this.serializer;
    }

    private boolean authEnabled() {
        return this.authEnabled;
    }

    @Override
    public void init(BlockDataManager blockDataManager) {
        NettyBlockRpcServer rpcHandler = new NettyBlockRpcServer(this.conf.getAppId(), this.serializer(), blockDataManager);
        None$ serverBootstrap = None$.MODULE$;
        None$ clientBootstrap = None$.MODULE$;
        this.transportConf = SparkTransportConf$.MODULE$.fromSparkConf(this.conf, "shuffle", this.numCores, SparkTransportConf$.MODULE$.fromSparkConf$default$4());
        if (this.authEnabled()) {
            serverBootstrap = new Some((Object)new AuthServerBootstrap(this.transportConf, (SecretKeyHolder)this.securityManager));
            clientBootstrap = new Some((Object)new AuthClientBootstrap(this.transportConf, this.conf.getAppId(), (SecretKeyHolder)this.securityManager));
        }
        this.transportContext = new TransportContext(this.transportConf, (RpcHandler)rpcHandler);
        this.clientFactory = this.transportContext.createClientFactory((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Option$.MODULE$.option2Iterable((Option)clientBootstrap).toSeq()).asJava());
        this.org$apache$spark$network$netty$NettyBlockTransferService$$server = this.createServer((List<TransportServerBootstrap>)serverBootstrap.toList());
        this.appId = this.conf.getAppId();
        this.logger.info(new StringBuilder(19).append("Server created on ").append(this.hostName()).append(":").append(this.org$apache$spark$network$netty$NettyBlockTransferService$$server.getPort()).toString());
    }

    private TransportServer createServer(List<TransportServerBootstrap> bootstraps) {
        return (TransportServer)Utils$.MODULE$.startServiceOnPort(this._port, (Function1 & Serializable)port -> this.startService$1(BoxesRunTime.unboxToInt((Object)port), bootstraps), this.conf, this.getClass().getName())._1();
    }

    public MetricSet shuffleMetrics() {
        Predef$.MODULE$.require(this.org$apache$spark$network$netty$NettyBlockTransferService$$server != null && this.clientFactory != null, (Function0 & Serializable)() -> "NettyBlockTransferServer is not initialized");
        return new MetricSet(this){
            private final HashMap<String, Metric> allMetrics;
            private final /* synthetic */ NettyBlockTransferService $outer;

            private HashMap<String, Metric> allMetrics() {
                return this.allMetrics;
            }

            public Map<String, Metric> getMetrics() {
                this.allMetrics().putAll(this.$outer.protected$clientFactory(this.$outer).getAllMetrics().getMetrics());
                this.allMetrics().putAll(this.$outer.org$apache$spark$network$netty$NettyBlockTransferService$$server.getAllMetrics().getMetrics());
                return this.allMetrics();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.allMetrics = new HashMap<K, V>();
            }
        };
    }

    public void fetchBlocks(String host, int port, String execId, String[] blockIds, BlockFetchingListener listener, DownloadFileManager tempFileManager) {
        block4: {
            if (this.logger.isTraceEnabled()) {
                this.logger.trace(new StringBuilder(34).append("Fetch blocks from ").append(host).append(":").append(port).append(" (executor id ").append(execId).append(")").toString());
            }
            try {
                int maxRetries = this.transportConf.maxIORetries();
                RetryingBlockTransferor.BlockTransferStarter blockFetchStarter = new RetryingBlockTransferor.BlockTransferStarter(this, host, port, maxRetries, execId, tempFileManager){
                    private final /* synthetic */ NettyBlockTransferService $outer;
                    private final String host$1;
                    private final int port$1;
                    private final int maxRetries$1;
                    private final String execId$1;
                    private final DownloadFileManager tempFileManager$1;

                    public void createAndStart(String[] blockIds, BlockTransferListener listener) {
                        Predef$.MODULE$.assert(listener instanceof BlockFetchingListener, (Function0 & Serializable)() -> new StringBuilder(43).append("Expecting a BlockFetchingListener, but got ").append(listener.getClass()).toString());
                        try {
                            TransportClient client = this.$outer.protected$clientFactory(this.$outer).createClient(this.host$1, this.port$1, this.maxRetries$1 > 0);
                            new OneForOneBlockFetcher(client, this.$outer.protected$appId(this.$outer), this.execId$1, blockIds, (BlockFetchingListener)listener, this.$outer.protected$transportConf(this.$outer), this.tempFileManager$1).start();
                        }
                        catch (IOException e) {
                            Success success;
                            boolean v;
                            Try try_ = Try$.MODULE$.apply((Function0)(JFunction0.mcZ.sp & Serializable)() -> BoxesRunTime.unboxToBoolean($this.$outer.org$apache$spark$network$netty$NettyBlockTransferService$$driverEndPointRef.askSync(new BlockManagerMessages.IsExecutorAlive($this.execId$1), ClassTag$.MODULE$.Boolean())));
                            if (try_ instanceof Success && !(v = BoxesRunTime.unboxToBoolean((Object)(success = (Success)try_).value()))) {
                                throw new ExecutorDeadException(new StringBuilder(49).append(new StringBuilder(35).append("The relative remote executor(Id: ").append(this.execId$1).append("),").toString()).append(" which maintains the block data to fetch is dead.").toString());
                            }
                            throw e;
                        }
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.host$1 = host$1;
                        this.port$1 = port$1;
                        this.maxRetries$1 = maxRetries$1;
                        this.execId$1 = execId$1;
                        this.tempFileManager$1 = tempFileManager$1;
                    }

                    private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                        return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createAndStart$1(org.apache.spark.network.shuffle.BlockTransferListener ), $anonfun$createAndStart$2(org.apache.spark.network.netty.NettyBlockTransferService$$anon$2 )}, serializedLambda);
                    }
                };
                if (maxRetries > 0) {
                    new RetryingBlockTransferor(this.transportConf, blockFetchStarter, blockIds, listener).start();
                    break block4;
                }
                blockFetchStarter.createAndStart(blockIds, (BlockTransferListener)listener);
            }
            catch (Exception e) {
                this.logger.error("Exception while beginning fetchBlocks", (Throwable)e);
                ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps((Object[])blockIds), (Function1 & Serializable)x$3 -> {
                    listener.onBlockFetchFailure(x$3, (Throwable)e);
                    return BoxedUnit.UNIT;
                });
            }
        }
    }

    @Override
    public int port() {
        return this.org$apache$spark$network$netty$NettyBlockTransferService$$server.getPort();
    }

    @Override
    public Future<BoxedUnit> uploadBlock(String hostname, int port, String execId, BlockId blockId, ManagedBuffer blockData, StorageLevel level, ClassTag<?> classTag) {
        long l;
        Promise result = Promise$.MODULE$.apply();
        TransportClient client = this.clientFactory.createClient(hostname, port);
        byte[] metadata = JavaUtils.bufferToArray((ByteBuffer)this.serializer().newInstance().serialize(new Tuple2((Object)level, classTag), ClassTag$.MODULE$.apply(Tuple2.class)));
        boolean asStream = blockData.size() > BoxesRunTime.unboxToLong((Object)this.conf.get(package$.MODULE$.MAX_REMOTE_BLOCK_SIZE_FETCH_TO_MEM())) || blockId.isShuffle();
        RpcResponseCallback callback = new RpcResponseCallback(this, blockId, asStream, result){
            private final /* synthetic */ NettyBlockTransferService $outer;
            private final BlockId blockId$1;
            private final boolean asStream$1;
            private final Promise result$1;

            public void onSuccess(ByteBuffer response) {
                if (this.$outer.protected$logger(this.$outer).isTraceEnabled()) {
                    this.$outer.protected$logger(this.$outer).trace(new StringBuilder(28).append("Successfully uploaded block ").append(this.blockId$1).append((Object)(this.asStream$1 ? " as stream" : "")).toString());
                }
                this.result$1.success((Object)BoxedUnit.UNIT);
            }

            public void onFailure(Throwable e) {
                this.$outer.protected$logger(this.$outer).error(new StringBuilder(22).append("Error while uploading ").append(this.blockId$1).append((Object)(this.asStream$1 ? " as stream" : "")).toString(), e);
                this.result$1.failure(e);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.blockId$1 = blockId$1;
                this.asStream$1 = asStream$1;
                this.result$1 = result$1;
            }
        };
        if (asStream) {
            ByteBuffer streamHeader = new UploadBlockStream(blockId.name(), metadata).toByteBuffer();
            l = client.uploadStream((ManagedBuffer)new NioManagedBuffer(streamHeader), blockData, callback);
        } else {
            byte[] array = JavaUtils.bufferToArray((ByteBuffer)blockData.nioByteBuffer());
            l = client.sendRpc(new UploadBlock(this.appId, execId, blockId.name(), metadata, array).toByteBuffer(), callback);
        }
        return result.future();
    }

    public void close() {
        block2: {
            if (this.org$apache$spark$network$netty$NettyBlockTransferService$$server != null) {
                this.org$apache$spark$network$netty$NettyBlockTransferService$$server.close();
            }
            if (this.clientFactory != null) {
                this.clientFactory.close();
            }
            if (this.transportContext == null) break block2;
            this.transportContext.close();
        }
    }

    private final Tuple2 startService$1(int port, List bootstraps$1) {
        TransportServer server = this.transportContext.createServer(this.bindAddress, port, (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)bootstraps$1).asJava());
        return new Tuple2((Object)server, (Object)BoxesRunTime.boxToInteger((int)server.getPort()));
    }

    public NettyBlockTransferService(SparkConf conf, SecurityManager securityManager, String bindAddress, String hostName, int _port, int numCores, RpcEndpointRef driverEndPointRef) {
        this.conf = conf;
        this.securityManager = securityManager;
        this.bindAddress = bindAddress;
        this.hostName = hostName;
        this._port = _port;
        this.numCores = numCores;
        this.org$apache$spark$network$netty$NettyBlockTransferService$$driverEndPointRef = driverEndPointRef;
        this.serializer = new JavaSerializer(conf);
        this.authEnabled = securityManager.isAuthenticationEnabled();
    }
}

