/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.scheduler;

import java.io.Serializable;
import java.util.Properties;
import org.apache.spark.scheduler.JobListener;
import org.apache.spark.scheduler.ResultStage;
import org.apache.spark.scheduler.ShuffleMapStage;
import org.apache.spark.scheduler.Stage;
import org.apache.spark.util.CallSite;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005%4Q\u0001F\u000b\u0001/uA\u0001\u0002\n\u0001\u0003\u0006\u0004%\tA\n\u0005\tU\u0001\u0011\t\u0011)A\u0005O!A1\u0006\u0001BC\u0002\u0013\u0005A\u0006\u0003\u00052\u0001\t\u0005\t\u0015!\u0003.\u0011!\u0011\u0004A!b\u0001\n\u0003\u0019\u0004\u0002\u0003\u001e\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u001b\t\u0011m\u0002!Q1A\u0005\u0002qB\u0001\u0002\u0011\u0001\u0003\u0002\u0003\u0006I!\u0010\u0005\t\u0003\u0002\u0011)\u0019!C\u0001\u0005\"A!\n\u0001B\u0001B\u0003%1\tC\u0003L\u0001\u0011\u0005A\nC\u0004T\u0001\t\u0007I\u0011\u0001\u0014\t\rQ\u0003\u0001\u0015!\u0003(\u0011\u001d)\u0006A1A\u0005\u0002YCa!\u0018\u0001!\u0002\u00139\u0006b\u00020\u0001\u0001\u0004%\tA\n\u0005\b?\u0002\u0001\r\u0011\"\u0001a\u0011\u00191\u0007\u0001)Q\u0005O!)q\r\u0001C\u0001Q\nI\u0011i\u0019;jm\u0016TuN\u0019\u0006\u0003-]\t\u0011b]2iK\u0012,H.\u001a:\u000b\u0005aI\u0012!B:qCJ\\'B\u0001\u000e\u001c\u0003\u0019\t\u0007/Y2iK*\tA$A\u0002pe\u001e\u001c\"\u0001\u0001\u0010\u0011\u0005}\u0011S\"\u0001\u0011\u000b\u0003\u0005\nQa]2bY\u0006L!a\t\u0011\u0003\r\u0005s\u0017PU3g\u0003\u0015QwNY%e\u0007\u0001)\u0012a\n\t\u0003?!J!!\u000b\u0011\u0003\u0007%sG/\u0001\u0004k_\nLE\rI\u0001\u000bM&t\u0017\r\\*uC\u001e,W#A\u0017\u0011\u00059zS\"A\u000b\n\u0005A*\"!B*uC\u001e,\u0017a\u00034j]\u0006d7\u000b^1hK\u0002\n\u0001bY1mYNKG/Z\u000b\u0002iA\u0011Q\u0007O\u0007\u0002m)\u0011qgF\u0001\u0005kRLG.\u0003\u0002:m\tA1)\u00197m'&$X-A\u0005dC2d7+\u001b;fA\u0005AA.[:uK:,'/F\u0001>!\tqc(\u0003\u0002@+\tY!j\u001c2MSN$XM\\3s\u0003%a\u0017n\u001d;f]\u0016\u0014\b%\u0001\u0006qe>\u0004XM\u001d;jKN,\u0012a\u0011\t\u0003\t\"k\u0011!\u0012\u0006\u0003o\u0019S\u0011aR\u0001\u0005U\u00064\u0018-\u0003\u0002J\u000b\nQ\u0001K]8qKJ$\u0018.Z:\u0002\u0017A\u0014x\u000e]3si&,7\u000fI\u0001\u0007y%t\u0017\u000e\u001e \u0015\r5su\nU)S!\tq\u0003\u0001C\u0003%\u0017\u0001\u0007q\u0005C\u0003,\u0017\u0001\u0007Q\u0006C\u00033\u0017\u0001\u0007A\u0007C\u0003<\u0017\u0001\u0007Q\bC\u0003B\u0017\u0001\u00071)A\u0007ok6\u0004\u0016M\u001d;ji&|gn]\u0001\u000f]Vl\u0007+\u0019:uSRLwN\\:!\u0003!1\u0017N\\5tQ\u0016$W#A,\u0011\u0007}A&,\u0003\u0002ZA\t)\u0011I\u001d:bsB\u0011qdW\u0005\u00039\u0002\u0012qAQ8pY\u0016\fg.A\u0005gS:L7\u000f[3eA\u0005Ya.^7GS:L7\u000f[3e\u0003=qW/\u001c$j]&\u001c\b.\u001a3`I\u0015\fHCA1e!\ty\"-\u0003\u0002dA\t!QK\\5u\u0011\u001d)\u0017#!AA\u0002\u001d\n1\u0001\u001f\u00132\u00031qW/\u001c$j]&\u001c\b.\u001a3!\u0003I\u0011Xm]3u\u00032d\u0007+\u0019:uSRLwN\\:\u0015\u0003\u0005\u0004")
public class ActiveJob {
    private final int jobId;
    private final Stage finalStage;
    private final CallSite callSite;
    private final JobListener listener;
    private final Properties properties;
    private final int numPartitions;
    private final boolean[] finished;
    private int numFinished;

    public int jobId() {
        return this.jobId;
    }

    public Stage finalStage() {
        return this.finalStage;
    }

    public CallSite callSite() {
        return this.callSite;
    }

    public JobListener listener() {
        return this.listener;
    }

    public Properties properties() {
        return this.properties;
    }

    public int numPartitions() {
        return this.numPartitions;
    }

    public boolean[] finished() {
        return this.finished;
    }

    public int numFinished() {
        return this.numFinished;
    }

    public void numFinished_$eq(int x$1) {
        this.numFinished = x$1;
    }

    public void resetAllPartitions() {
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), this.numPartitions()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)x$1 -> {
            $this.finished()[x$1] = false;
        });
        this.numFinished_$eq(0);
    }

    public ActiveJob(int jobId, Stage finalStage, CallSite callSite, JobListener listener, Properties properties) {
        int n;
        this.jobId = jobId;
        this.finalStage = finalStage;
        this.callSite = callSite;
        this.listener = listener;
        this.properties = properties;
        Stage stage = finalStage;
        if (stage instanceof ResultStage) {
            ResultStage resultStage = (ResultStage)stage;
            n = resultStage.partitions().length;
        } else if (stage instanceof ShuffleMapStage) {
            ShuffleMapStage shuffleMapStage = (ShuffleMapStage)stage;
            n = shuffleMapStage.rdd().partitions().length;
        } else {
            throw new MatchError((Object)stage);
        }
        this.numPartitions = n;
        this.finished = (boolean[])Array$.MODULE$.fill(this.numPartitions(), (Function0)(JFunction0.mcZ.sp & Serializable)() -> false, (ClassTag)ClassTag$.MODULE$.Boolean());
        this.numFinished = 0;
    }
}

