/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.scheduler;

import java.io.Serializable;
import org.apache.spark.executor.TaskMetrics;
import org.apache.spark.internal.Logging;
import org.apache.spark.scheduler.TaskInfo;
import org.apache.spark.util.Distribution;
import org.apache.spark.util.Distribution$;
import org.apache.spark.util.StatCounter;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.Iterable;
import scala.collection.StringOps$;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.Seq;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;

public final class StatsReportListener$
implements Logging {
    public static final StatsReportListener$ MODULE$ = new StatsReportListener$();
    private static final int[] percentiles;
    private static final double[] probabilities;
    private static final String percentilesHeader;
    private static final long seconds;
    private static final long minutes;
    private static final long hours;
    private static transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        Logging.$init$(MODULE$);
        percentiles = (int[])Array$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 5, 10, 25, 50, 75, 90, 95, 100}), (ClassTag)ClassTag$.MODULE$.Int());
        probabilities = (double[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.intArrayOps(MODULE$.percentiles()), (Function1)(JFunction1.mcDI.sp & Serializable)x$11 -> (double)x$11 / 100.0, (ClassTag)ClassTag$.MODULE$.Double());
        percentilesHeader = new StringBuilder(2).append("\t").append(Predef$.MODULE$.wrapIntArray(MODULE$.percentiles()).mkString("%\t")).append("%").toString();
        seconds = 1000L;
        minutes = MODULE$.seconds() * 60L;
        hours = MODULE$.minutes() * 60L;
    }

    @Override
    public String logName() {
        return Logging.logName$(this);
    }

    @Override
    public Logger log() {
        return Logging.log$(this);
    }

    @Override
    public void logInfo(Function0<String> msg) {
        Logging.logInfo$(this, msg);
    }

    @Override
    public void logDebug(Function0<String> msg) {
        Logging.logDebug$(this, msg);
    }

    @Override
    public void logTrace(Function0<String> msg) {
        Logging.logTrace$(this, msg);
    }

    @Override
    public void logWarning(Function0<String> msg) {
        Logging.logWarning$(this, msg);
    }

    @Override
    public void logError(Function0<String> msg) {
        Logging.logError$(this, msg);
    }

    @Override
    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$(this, msg, throwable);
    }

    @Override
    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$(this, msg, throwable);
    }

    @Override
    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$(this, msg, throwable);
    }

    @Override
    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$(this, msg, throwable);
    }

    @Override
    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$(this, msg, throwable);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$(this, isInterpreter);
    }

    @Override
    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$(this, isInterpreter, silent);
    }

    @Override
    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$(this);
    }

    @Override
    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$(this, isInterpreter, silent);
    }

    @Override
    public Logger org$apache$spark$internal$Logging$$log_() {
        return org$apache$spark$internal$Logging$$log_;
    }

    @Override
    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public int[] percentiles() {
        return percentiles;
    }

    public double[] probabilities() {
        return probabilities;
    }

    public String percentilesHeader() {
        return percentilesHeader;
    }

    public Option<Distribution> extractDoubleDistribution(Seq<Tuple2<TaskInfo, TaskMetrics>> taskInfoMetrics, Function2<TaskInfo, TaskMetrics, Object> getMetric) {
        return Distribution$.MODULE$.apply((Iterable<Object>)((Iterable)taskInfoMetrics.map((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToDouble((double)StatsReportListener$.$anonfun$extractDoubleDistribution$1(getMetric, x0$1)))));
    }

    public Option<Distribution> extractLongDistribution(Seq<Tuple2<TaskInfo, TaskMetrics>> taskInfoMetrics, Function2<TaskInfo, TaskMetrics, Object> getMetric) {
        return this.extractDoubleDistribution(taskInfoMetrics, (Function2<TaskInfo, TaskMetrics, Object>)(Function2 & Serializable)(info, metric) -> BoxesRunTime.boxToDouble((double)StatsReportListener$.$anonfun$extractLongDistribution$1(getMetric, info, metric)));
    }

    public void showDistribution(String heading, Distribution d, Function1<Object, String> formatNumber) {
        StatCounter stats = d.statCounter();
        IndexedSeq quantiles = (IndexedSeq)d.getQuantiles((Iterable<Object>)Predef$.MODULE$.wrapDoubleArray(this.probabilities())).map(formatNumber);
        this.logInfo((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(0).append(heading).append(stats).toString());
        this.logInfo((Function0<String>)(Function0 & Serializable)() -> MODULE$.percentilesHeader());
        this.logInfo((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(1).append("\t").append(quantiles.mkString("\t")).toString());
    }

    public void showDistribution(String heading, Option<Distribution> dOpt, Function1<Object, String> formatNumber) {
        dOpt.foreach((Function1 & Serializable)d -> {
            StatsReportListener$.MODULE$.showDistribution(heading, d, (Function1<Object, String>)formatNumber);
            return BoxedUnit.UNIT;
        });
    }

    public void showDistribution(String heading, Option<Distribution> dOpt, String format) {
        this.showDistribution(heading, dOpt, (Function1<Object, String>)(Function1 & Serializable)d -> StatsReportListener$.f$1(BoxesRunTime.unboxToDouble((Object)d), format));
    }

    public void showDistribution(String heading, String format, Function2<TaskInfo, TaskMetrics, Object> getMetric, Seq<Tuple2<TaskInfo, TaskMetrics>> taskInfoMetrics) {
        this.showDistribution(heading, this.extractDoubleDistribution(taskInfoMetrics, getMetric), format);
    }

    public void showBytesDistribution(String heading, Function2<TaskInfo, TaskMetrics, Object> getMetric, Seq<Tuple2<TaskInfo, TaskMetrics>> taskInfoMetrics) {
        this.showBytesDistribution(heading, this.extractLongDistribution(taskInfoMetrics, getMetric));
    }

    public void showBytesDistribution(String heading, Option<Distribution> dOpt) {
        dOpt.foreach((Function1 & Serializable)dist -> {
            StatsReportListener$.MODULE$.showBytesDistribution(heading, dist);
            return BoxedUnit.UNIT;
        });
    }

    public void showBytesDistribution(String heading, Distribution dist) {
        this.showDistribution(heading, dist, (Function1<Object, String>)(Function1 & Serializable)d -> Utils$.MODULE$.bytesToString((long)BoxesRunTime.unboxToDouble((Object)d)));
    }

    public void showMillisDistribution(String heading, Option<Distribution> dOpt) {
        this.showDistribution(heading, dOpt, (Function1<Object, String>)(Function1 & Serializable)d -> StatsReportListener$.MODULE$.millisToString((long)BoxesRunTime.unboxToDouble((Object)d)));
    }

    public void showMillisDistribution(String heading, Function2<TaskInfo, TaskMetrics, Object> getMetric, Seq<Tuple2<TaskInfo, TaskMetrics>> taskInfoMetrics) {
        this.showMillisDistribution(heading, this.extractLongDistribution(taskInfoMetrics, getMetric));
    }

    public long seconds() {
        return seconds;
    }

    public long minutes() {
        return minutes;
    }

    public long hours() {
        return hours;
    }

    public String millisToString(long ms) {
        Tuple2 tuple2;
        Tuple2 tuple22 = ms > this.hours() ? new Tuple2((Object)BoxesRunTime.boxToDouble((double)((double)ms / (double)this.hours())), (Object)"hours") : (ms > this.minutes() ? new Tuple2((Object)BoxesRunTime.boxToDouble((double)((double)ms / (double)this.minutes())), (Object)"min") : (tuple2 = ms > this.seconds() ? new Tuple2((Object)BoxesRunTime.boxToDouble((double)((double)ms / (double)this.seconds())), (Object)"s") : new Tuple2((Object)BoxesRunTime.boxToDouble((double)ms), (Object)"ms")));
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        double size = tuple2._1$mcD$sp();
        String units = (String)tuple2._2();
        Tuple2 tuple23 = new Tuple2((Object)BoxesRunTime.boxToDouble((double)size), (Object)units);
        Tuple2 tuple24 = tuple23;
        double size2 = tuple24._1$mcD$sp();
        String units2 = (String)tuple24._2();
        return StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("%.1f %s"), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)size2), units2}));
    }

    public static final /* synthetic */ double $anonfun$extractDoubleDistribution$1(Function2 getMetric$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        TaskInfo info = (TaskInfo)tuple2._1();
        TaskMetrics metric = (TaskMetrics)tuple2._2();
        double d = BoxesRunTime.unboxToDouble((Object)getMetric$1.apply((Object)info, (Object)metric));
        return d;
    }

    public static final /* synthetic */ double $anonfun$extractLongDistribution$1(Function2 getMetric$2, TaskInfo info, TaskMetrics metric) {
        return BoxesRunTime.unboxToLong((Object)getMetric$2.apply((Object)info, (Object)metric));
    }

    private static final String f$1(double d, String format$1) {
        return StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString(format$1), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)d)}));
    }

    private StatsReportListener$() {
    }
}

