/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.scheduler;

import java.io.Serializable;
import org.apache.spark.ExecutorAllocationClient;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext;
import org.apache.spark.internal.config.package$;
import org.apache.spark.resource.ResourceProfile;
import org.apache.spark.resource.ResourceProfile$;
import org.apache.spark.scheduler.HealthTracker;
import org.apache.spark.scheduler.HealthTracker$;
import org.apache.spark.scheduler.SchedulerBackend;
import org.apache.spark.scheduler.TaskSchedulerImpl;
import org.apache.spark.util.Clock;
import org.apache.spark.util.SystemClock;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.SeqOps;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.HashMap;
import scala.math.Numeric;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.java8.JFunction0;

public final class TaskSchedulerImpl$ {
    public static final TaskSchedulerImpl$ MODULE$ = new TaskSchedulerImpl$();
    private static final String SCHEDULER_MODE_PROPERTY = package$.MODULE$.SCHEDULER_MODE().key();

    public boolean $lessinit$greater$default$3() {
        return false;
    }

    public Clock $lessinit$greater$default$4() {
        return new SystemClock();
    }

    public String SCHEDULER_MODE_PROPERTY() {
        return SCHEDULER_MODE_PROPERTY;
    }

    public int calculateAvailableSlots(TaskSchedulerImpl scheduler, SparkConf conf, int rpId, int[] availableRPIds, int[] availableCpus, Map<String, Object>[] availableResources) {
        Tuple2 tuple2;
        String limiting;
        ResourceProfile resourceProfile = scheduler.sc().resourceProfileManager().resourceProfileFromId(rpId);
        boolean coresKnown = resourceProfile.isCoresLimitKnown();
        String string = limiting = resourceProfile.limitingResource(conf);
        String string2 = ResourceProfile$.MODULE$.CPUS();
        Tuple2 tuple22 = !(string == null ? string2 != null : !string.equals(string2)) || limiting.isEmpty() ? new Tuple2((Object)ResourceProfile$.MODULE$.CPUS(), (Object)BoxesRunTime.boxToBoolean((boolean)true)) : (tuple2 = new Tuple2((Object)limiting, (Object)BoxesRunTime.boxToBoolean((boolean)false)));
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String limitingResource = (String)tuple2._1();
        boolean limitedByCpu = tuple2._2$mcZ$sp();
        Tuple2 tuple23 = new Tuple2((Object)limitingResource, (Object)BoxesRunTime.boxToBoolean((boolean)limitedByCpu));
        Tuple2 tuple24 = tuple23;
        String limitingResource2 = (String)tuple24._1();
        boolean limitedByCpu2 = tuple24._2$mcZ$sp();
        int cpusPerTask = ResourceProfile$.MODULE$.getTaskCpusOrDefaultForProfile(resourceProfile, conf);
        double taskLimit = BoxesRunTime.unboxToDouble((Object)resourceProfile.taskResources().get((Object)limitingResource2).map((Function1 & Serializable)x$25 -> BoxesRunTime.boxToDouble((double)x$25.amount())).get());
        return BoxesRunTime.unboxToInt((Object)Predef$.MODULE$.wrapIntArray((int[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.filter$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.zip$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.zip$extension(Predef$.MODULE$.intArrayOps(availableCpus), (IterableOnce)Predef$.MODULE$.wrapRefArray((Object[])availableResources))), (IterableOnce)Predef$.MODULE$.wrapIntArray(availableRPIds))), (Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)TaskSchedulerImpl$.$anonfun$calculateAvailableSlots$2(rpId, x0$1)))), (Function1 & Serializable)x0$2 -> BoxesRunTime.boxToInteger((int)TaskSchedulerImpl$.$anonfun$calculateAvailableSlots$3(cpusPerTask, limitedByCpu2, limitingResource2, taskLimit, coresKnown, x0$2)), (ClassTag)ClassTag$.MODULE$.Int())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
    }

    public <K, T> List<T> prioritizeContainers(HashMap<K, ArrayBuffer<T>> map) {
        ArrayBuffer _keyList = new ArrayBuffer(map.size());
        _keyList.$plus$plus$eq((IterableOnce)map.keys());
        ArrayBuffer keyList = (ArrayBuffer)_keyList.sortWith((Function2 & Serializable)(left, right) -> BoxesRunTime.boxToBoolean((boolean)TaskSchedulerImpl$.$anonfun$prioritizeContainers$1(map, left, right)));
        ArrayBuffer retval = new ArrayBuffer(keyList.size() * 2);
        IntRef index = IntRef.create((int)0);
        BooleanRef found = BooleanRef.create((boolean)true);
        while (found.elem) {
            found.elem = false;
            keyList.foreach((Function1 & Serializable)key -> {
                TaskSchedulerImpl$.$anonfun$prioritizeContainers$2(map, index, retval, found, key);
                return BoxedUnit.UNIT;
            });
            ++index.elem;
        }
        return retval.toList();
    }

    public Option<HealthTracker> org$apache$spark$scheduler$TaskSchedulerImpl$$maybeCreateHealthTracker(SparkContext sc) {
        None$ none$;
        if (HealthTracker$.MODULE$.isExcludeOnFailureEnabled(sc.conf())) {
            None$ none$2;
            SchedulerBackend schedulerBackend = sc.schedulerBackend();
            if (schedulerBackend instanceof ExecutorAllocationClient) {
                SchedulerBackend schedulerBackend2 = schedulerBackend;
                none$2 = new Some((Object)schedulerBackend2);
            } else {
                none$2 = None$.MODULE$;
            }
            None$ executorAllocClient = none$2;
            none$ = new Some((Object)new HealthTracker(sc, (Option<ExecutorAllocationClient>)executorAllocClient));
        } else {
            none$ = None$.MODULE$;
        }
        return none$;
    }

    public static final /* synthetic */ boolean $anonfun$calculateAvailableSlots$2(int rpId$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        int id = tuple2._2$mcI$sp();
        boolean bl = id == rpId$1;
        return bl;
    }

    public static final /* synthetic */ int $anonfun$calculateAvailableSlots$3(int cpusPerTask$1, boolean limitedByCpu$1, String limitingResource$1, double taskLimit$1, boolean coresKnown$1, Tuple2 x0$2) {
        int n;
        Tuple2 tuple2;
        Tuple2 tuple22 = x0$2;
        if (tuple22 != null && (tuple2 = (Tuple2)tuple22._1()) != null) {
            int cpu = tuple2._1$mcI$sp();
            Map resources = (Map)tuple2._2();
            int numTasksPerExecCores = cpu / cpusPerTask$1;
            if (limitedByCpu$1) {
                n = numTasksPerExecCores;
            } else {
                int availAddrs = BoxesRunTime.unboxToInt((Object)resources.getOrElse((Object)limitingResource$1, (Function0)(JFunction0.mcI.sp & Serializable)() -> 0));
                int resourceLimit = (int)((double)availAddrs / taskLimit$1);
                n = !coresKnown$1 && numTasksPerExecCores <= resourceLimit ? numTasksPerExecCores : resourceLimit;
            }
        } else {
            throw new MatchError((Object)tuple22);
        }
        int n2 = n;
        return n2;
    }

    public static final /* synthetic */ boolean $anonfun$prioritizeContainers$1(HashMap map$1, Object left, Object right) {
        return ((SeqOps)map$1.apply(left)).size() > ((SeqOps)map$1.apply(right)).size();
    }

    public static final /* synthetic */ void $anonfun$prioritizeContainers$2(HashMap map$1, IntRef index$2, ArrayBuffer retval$1, BooleanRef found$1, Object key) {
        block0: {
            ArrayBuffer containerList = (ArrayBuffer)map$1.getOrElse(key, (Function0 & Serializable)() -> null);
            Predef$.MODULE$.assert(containerList != null);
            if (index$2.elem >= containerList.size()) break block0;
            retval$1.$plus$eq(containerList.apply(index$2.elem));
            found$1.elem = true;
        }
    }

    private TaskSchedulerImpl$() {
    }
}

