/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.serializer;

import java.io.NotSerializableException;
import java.io.ObjectStreamClass;
import java.io.Serializable;
import java.security.AccessController;
import org.apache.spark.internal.Logging;
import org.apache.spark.serializer.SerializationDebugger;
import org.apache.spark.serializer.SerializationDebugger$ObjectStreamClassMethods$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Tuple2;
import scala.collection.immutable.List;
import scala.package$;
import scala.util.control.NonFatal$;
import sun.security.action.GetBooleanAction;

public final class SerializationDebugger$
implements Logging {
    public static final SerializationDebugger$ MODULE$ = new SerializationDebugger$();
    private static boolean enableDebugging;
    private static final SerializationDebugger.ObjectStreamClassReflection org$apache$spark$serializer$SerializationDebugger$$reflect;
    private static transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        Logging.$init$(MODULE$);
        enableDebugging = AccessController.doPrivileged(new GetBooleanAction("sun.io.serialization.extendedDebugInfo")) == false;
        org$apache$spark$serializer$SerializationDebugger$$reflect = MODULE$.liftedTree1$1();
    }

    @Override
    public String logName() {
        return Logging.logName$(this);
    }

    @Override
    public Logger log() {
        return Logging.log$(this);
    }

    @Override
    public void logInfo(Function0<String> msg) {
        Logging.logInfo$(this, msg);
    }

    @Override
    public void logDebug(Function0<String> msg) {
        Logging.logDebug$(this, msg);
    }

    @Override
    public void logTrace(Function0<String> msg) {
        Logging.logTrace$(this, msg);
    }

    @Override
    public void logWarning(Function0<String> msg) {
        Logging.logWarning$(this, msg);
    }

    @Override
    public void logError(Function0<String> msg) {
        Logging.logError$(this, msg);
    }

    @Override
    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$(this, msg, throwable);
    }

    @Override
    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$(this, msg, throwable);
    }

    @Override
    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$(this, msg, throwable);
    }

    @Override
    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$(this, msg, throwable);
    }

    @Override
    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$(this, msg, throwable);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$(this, isInterpreter);
    }

    @Override
    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$(this, isInterpreter, silent);
    }

    @Override
    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$(this);
    }

    @Override
    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$(this, isInterpreter, silent);
    }

    @Override
    public Logger org$apache$spark$internal$Logging$$log_() {
        return org$apache$spark$internal$Logging$$log_;
    }

    @Override
    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public NotSerializableException improveException(Object obj, NotSerializableException e) {
        NotSerializableException notSerializableException;
        if (this.enableDebugging() && this.org$apache$spark$serializer$SerializationDebugger$$reflect() != null) {
            try {
                notSerializableException = new NotSerializableException(new StringBuilder(22).append(e.getMessage()).append("\nSerialization stack:\n").append(this.find(obj).map((Function1 & Serializable)x$1 -> new StringBuilder(3).append("\t- ").append((String)x$1).toString()).mkString("\n")).toString());
            }
            catch (Throwable throwable) {
                Option option;
                Throwable throwable2 = throwable;
                if (throwable2 == null || (option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                    throw throwable;
                }
                Throwable t = (Throwable)option.get();
                this.logWarning((Function0<String>)(Function0 & Serializable)() -> "Exception in serialization debugger", t);
                NotSerializableException notSerializableException2 = e;
                notSerializableException = notSerializableException2;
            }
        } else {
            notSerializableException = e;
        }
        return notSerializableException;
    }

    public List<String> find(Object obj) {
        return new SerializationDebugger.SerializationDebugger().visit(obj, (List<String>)package$.MODULE$.List().empty());
    }

    public boolean enableDebugging() {
        return enableDebugging;
    }

    public void enableDebugging_$eq(boolean x$1) {
        enableDebugging = x$1;
    }

    public Tuple2<Object, ObjectStreamClass> org$apache$spark$serializer$SerializationDebugger$$findObjectAndDescriptor(Object o) {
        Tuple2 tuple2;
        while (true) {
            Class<?> cl;
            ObjectStreamClass desc;
            if (!SerializationDebugger$ObjectStreamClassMethods$.MODULE$.hasWriteReplaceMethod$extension(this.ObjectStreamClassMethods(desc = ObjectStreamClass.lookupAny(cl = o.getClass())))) {
                tuple2 = new Tuple2(o, (Object)desc);
                break;
            }
            Object replaced = SerializationDebugger$ObjectStreamClassMethods$.MODULE$.invokeWriteReplace$extension(this.ObjectStreamClassMethods(desc), o);
            Class<?> clazz = replaced.getClass();
            Class<?> clazz2 = o.getClass();
            if (!(clazz != null ? !clazz.equals(clazz2) : clazz2 != null)) {
                tuple2 = new Tuple2(replaced, (Object)desc);
                break;
            }
            o = replaced;
        }
        return tuple2;
    }

    public ObjectStreamClass ObjectStreamClassMethods(ObjectStreamClass desc) {
        return desc;
    }

    public SerializationDebugger.ObjectStreamClassReflection org$apache$spark$serializer$SerializationDebugger$$reflect() {
        return org$apache$spark$serializer$SerializationDebugger$$reflect;
    }

    private final /* synthetic */ SerializationDebugger.ObjectStreamClassReflection liftedTree1$1() {
        SerializationDebugger.ObjectStreamClassReflection objectStreamClassReflection;
        try {
            objectStreamClassReflection = new SerializationDebugger.ObjectStreamClassReflection();
        }
        catch (Exception e) {
            this.logWarning((Function0<String>)(Function0 & Serializable)() -> "Cannot find private methods using reflection", e);
            objectStreamClassReflection = null;
        }
        return objectStreamClassReflection;
    }

    private SerializationDebugger$() {
    }
}

