/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.shuffle;

import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.nio.ByteBuffer;
import java.nio.LongBuffer;
import java.nio.channels.Channels;
import java.nio.channels.SeekableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkEnv$;
import org.apache.spark.SparkException;
import org.apache.spark.internal.Logging;
import org.apache.spark.io.NioBufferedFileInputStream;
import org.apache.spark.network.buffer.FileSegmentManagedBuffer;
import org.apache.spark.network.buffer.ManagedBuffer;
import org.apache.spark.network.client.StreamCallbackWithID;
import org.apache.spark.network.netty.SparkTransportConf$;
import org.apache.spark.network.shuffle.ExecutorDiskUtils;
import org.apache.spark.network.shuffle.MergedBlockMeta;
import org.apache.spark.network.shuffle.checksum.ShuffleChecksumHelper;
import org.apache.spark.network.util.TransportConf;
import org.apache.spark.serializer.SerializerManager;
import org.apache.spark.shuffle.IndexShuffleBlockResolver$;
import org.apache.spark.shuffle.MigratableResolver;
import org.apache.spark.shuffle.ShuffleBlockInfo;
import org.apache.spark.shuffle.ShuffleBlockResolver;
import org.apache.spark.storage.BlockId;
import org.apache.spark.storage.BlockManager;
import org.apache.spark.storage.BlockStatus;
import org.apache.spark.storage.ShuffleBlockBatchId;
import org.apache.spark.storage.ShuffleBlockId;
import org.apache.spark.storage.ShuffleChecksumBlockId;
import org.apache.spark.storage.ShuffleDataBlockId;
import org.apache.spark.storage.ShuffleIndexBlockId;
import org.apache.spark.storage.ShuffleMergedBlockId;
import org.apache.spark.storage.ShuffleMergedDataBlockId;
import org.apache.spark.storage.ShuffleMergedIndexBlockId;
import org.apache.spark.storage.ShuffleMergedMetaBlockId;
import org.apache.spark.storage.StorageLevel$;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple4;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.collection.mutable.ArrayBuffer;
import scala.math.Numeric;
import scala.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.runtime.java8.JFunction2;

@ScalaSignature(bytes="\u0006\u0005\t\u0005f!\u0002\u0016,\u00015\u001a\u0004\u0002C$\u0001\u0005\u0003\u0005\u000b\u0011B%\t\u00115\u0003!\u00111A\u0005\u00029C\u0001\"\u0016\u0001\u0003\u0002\u0004%\tA\u0016\u0005\t9\u0002\u0011\t\u0011)Q\u0005\u001f\")Q\f\u0001C\u0001=\"A!\r\u0001EC\u0002\u0013%a\nC\u0004d\u0001\t\u0007I\u0011\u00023\t\r5\u0004\u0001\u0015!\u0003f\u0011\u001dq\u0007A1A\u0005\n=DaA\u001e\u0001!\u0002\u0013\u0001\b\"B<\u0001\t\u0003A\bbBA\t\u0001\u0011\u0005\u00131\u0003\u0005\b\u0003g\u0001A\u0011BA\u001b\u0011\u00199\b\u0001\"\u0001\u00028!9\u0011\u0011\f\u0001\u0005\u0002\u0005m\u0003\"CA2\u0001E\u0005I\u0011AA3\u0011\u001d\tY\b\u0001C\u0005\u0003{B\u0011\"a$\u0001#\u0003%I!!\u001a\t\u000f\u0005E\u0005\u0001\"\u0003\u0002\u0014\"I\u0011q\u0014\u0001\u0012\u0002\u0013%\u0011Q\r\u0005\b\u0003C\u0003A\u0011BAR\u0011%\ty\u000bAI\u0001\n\u0013\t)\u0007C\u0004\u00022\u0002!\t!a-\t\u000f\u0005e\u0006\u0001\"\u0003\u0002<\"9\u00111\u001a\u0001\u0005B\u00055\u0007bBA{\u0001\u0011\u0005\u0011q\u001f\u0005\b\u0005+\u0001A\u0011\u0001B\f\u0011\u001d\u0011I\u0003\u0001C\u0005\u0005WAqAa\u0011\u0001\t\u0003\u0012)\u0005C\u0004\u0003T\u0001!\tE!\u0016\t\u0011\t\u0015\u0004\u0001\"\u0001,\u0005OBqA!\u001d\u0001\t\u0003\u0011\u0019\bC\u0005\u0003\u0000\u0001\t\n\u0011\"\u0001\u0002f!9!\u0011\u0011\u0001\u0005B\t\r\u0005b\u0002BE\u0001\u0011\u0005#1R\u0004\t\u0005\u001b[\u0003\u0012A\u0017\u0003\u0010\u001a9!f\u000bE\u0001[\tE\u0005BB/&\t\u0003\u0011\u0019\nC\u0005\u0003\u0016\u0016\u0012\r\u0011\"\u0001\u0003\u0018\"A!\u0011T\u0013!\u0002\u0013\t9\u0001C\u0005\u0003\u001c\u0016\n\n\u0011\"\u0001\u0003\u001e\nI\u0012J\u001c3fqNCWO\u001a4mK\ncwnY6SKN|GN^3s\u0015\taS&A\u0004tQV4g\r\\3\u000b\u00059z\u0013!B:qCJ\\'B\u0001\u00192\u0003\u0019\t\u0007/Y2iK*\t!'A\u0002pe\u001e\u001cR\u0001\u0001\u001b;}\u0011\u0003\"!\u000e\u001d\u000e\u0003YR\u0011aN\u0001\u0006g\u000e\fG.Y\u0005\u0003sY\u0012a!\u00118z%\u00164\u0007CA\u001e=\u001b\u0005Y\u0013BA\u001f,\u0005Q\u0019\u0006.\u001e4gY\u0016\u0014En\\2l%\u0016\u001cx\u000e\u001c<feB\u0011qHQ\u0007\u0002\u0001*\u0011\u0011)L\u0001\tS:$XM\u001d8bY&\u00111\t\u0011\u0002\b\u0019><w-\u001b8h!\tYT)\u0003\u0002GW\t\u0011R*[4sCR\f'\r\\3SKN|GN^3s\u0003\u0011\u0019wN\u001c4\u0004\u0001A\u0011!jS\u0007\u0002[%\u0011A*\f\u0002\n'B\f'o[\"p]\u001a\fQb\u00182m_\u000e\\W*\u00198bO\u0016\u0014X#A(\u0011\u0005A\u001bV\"A)\u000b\u0005Ik\u0013aB:u_J\fw-Z\u0005\u0003)F\u0013AB\u00117pG.l\u0015M\\1hKJ\f\u0011c\u00182m_\u000e\\W*\u00198bO\u0016\u0014x\fJ3r)\t9&\f\u0005\u000261&\u0011\u0011L\u000e\u0002\u0005+:LG\u000fC\u0004\\\u0007\u0005\u0005\t\u0019A(\u0002\u0007a$\u0013'\u0001\b`E2|7m['b]\u0006<WM\u001d\u0011\u0002\rqJg.\u001b;?)\ry\u0006-\u0019\t\u0003w\u0001AQaR\u0003A\u0002%Cq!T\u0003\u0011\u0002\u0003\u0007q*\u0001\u0007cY>\u001c7.T1oC\u001e,'/A\u0007ue\u0006t7\u000f]8si\u000e{gNZ\u000b\u0002KB\u0011am[\u0007\u0002O*\u0011\u0001.[\u0001\u0005kRLGN\u0003\u0002k[\u00059a.\u001a;x_J\\\u0017B\u00017h\u00055!&/\u00198ta>\u0014HoQ8oM\u0006qAO]1ogB|'\u000f^\"p]\u001a\u0004\u0013\u0001\u0006:f[>$Xm\u00155vM\u001adW-T1y\t&\u001c8.F\u0001q!\r)\u0014o]\u0005\u0003eZ\u0012aa\u00149uS>t\u0007CA\u001bu\u0013\t)hG\u0001\u0003M_:<\u0017!\u0006:f[>$Xm\u00155vM\u001adW-T1y\t&\u001c8\u000eI\u0001\fO\u0016$H)\u0019;b\r&dW\rF\u0003z\u0003\u0007\ti\u0001\u0005\u0002{\u007f6\t1P\u0003\u0002}{\u0006\u0011\u0011n\u001c\u0006\u0002}\u0006!!.\u0019<b\u0013\r\t\ta\u001f\u0002\u0005\r&dW\rC\u0004\u0002\u0006-\u0001\r!a\u0002\u0002\u0013MDWO\u001a4mK&#\u0007cA\u001b\u0002\n%\u0019\u00111\u0002\u001c\u0003\u0007%sG\u000f\u0003\u0004\u0002\u0010-\u0001\ra]\u0001\u0006[\u0006\u0004\u0018\nZ\u0001\u0012O\u0016$8\u000b^8sK\u0012\u001c\u0006.\u001e4gY\u0016\u001cHCAA\u000b!\u0019\t9\"a\n\u0002.9!\u0011\u0011DA\u0012\u001d\u0011\tY\"!\t\u000e\u0005\u0005u!bAA\u0010\u0011\u00061AH]8pizJ\u0011aN\u0005\u0004\u0003K1\u0014a\u00029bG.\fw-Z\u0005\u0005\u0003S\tYCA\u0002TKFT1!!\n7!\rY\u0014qF\u0005\u0004\u0003cY#\u0001E*ik\u001a4G.\u001a\"m_\u000e\\\u0017J\u001c4p\u0003U9W\r^*ik\u001a4G.\u001a\"zi\u0016\u001c8\u000b^8sK\u0012$\u0012a\u001d\u000b\bs\u0006e\u00121HA\u001f\u0011\u001d\t)A\u0004a\u0001\u0003\u000fAa!a\u0004\u000f\u0001\u0004\u0019\bbBA \u001d\u0001\u0007\u0011\u0011I\u0001\u0005I&\u00148\u000f\u0005\u00036c\u0006\r\u0003#B\u001b\u0002F\u0005%\u0013bAA$m\t)\u0011I\u001d:bsB!\u00111JA*\u001d\u0011\ti%a\u0014\u0011\u0007\u0005ma'C\u0002\u0002RY\na\u0001\u0015:fI\u00164\u0017\u0002BA+\u0003/\u0012aa\u0015;sS:<'bAA)m\u0005aq-\u001a;J]\u0012,\u0007PR5mKR9\u00110!\u0018\u0002`\u0005\u0005\u0004bBA\u0003\u001f\u0001\u0007\u0011q\u0001\u0005\u0007\u0003\u001fy\u0001\u0019A:\t\u0013\u0005}r\u0002%AA\u0002\u0005\u0005\u0013AF4fi&sG-\u001a=GS2,G\u0005Z3gCVdG\u000fJ\u001a\u0016\u0005\u0005\u001d$\u0006BA!\u0003SZ#!a\u001b\u0011\t\u00055\u0014qO\u0007\u0003\u0003_RA!!\u001d\u0002t\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003k2\u0014AC1o]>$\u0018\r^5p]&!\u0011\u0011PA8\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u0017O\u0016$X*\u001a:hK\u0012\u0014En\\2l\t\u0006$\u0018MR5mKRY\u00110a \u0002\u0004\u0006\u0015\u0015\u0011RAG\u0011\u001d\t\t)\u0005a\u0001\u0003\u0013\nQ!\u00199q\u0013\u0012Dq!!\u0002\u0012\u0001\u0004\t9\u0001C\u0004\u0002\bF\u0001\r!a\u0002\u0002\u001dMDWO\u001a4mK6+'oZ3JI\"9\u00111R\tA\u0002\u0005\u001d\u0011\u0001\u0003:fIV\u001cW-\u00133\t\u0013\u0005}\u0012\u0003%AA\u0002\u0005\u0005\u0013\u0001I4fi6+'oZ3e\u00052|7m\u001b#bi\u00064\u0015\u000e\\3%I\u00164\u0017-\u001e7uIU\nqcZ3u\u001b\u0016\u0014x-\u001a3CY>\u001c7.\u00138eKb4\u0015\u000e\\3\u0015\u0017e\f)*a&\u0002\u001a\u0006m\u0015Q\u0014\u0005\b\u0003\u0003\u001b\u0002\u0019AA%\u0011\u001d\t)a\u0005a\u0001\u0003\u000fAq!a\"\u0014\u0001\u0004\t9\u0001C\u0004\u0002\fN\u0001\r!a\u0002\t\u0013\u0005}2\u0003%AA\u0002\u0005\u0005\u0013!I4fi6+'oZ3e\u00052|7m[%oI\u0016Dh)\u001b7fI\u0011,g-Y;mi\u0012*\u0014AF4fi6+'oZ3e\u00052|7m['fi\u00064\u0015\u000e\\3\u0015\u0017e\f)+a*\u0002*\u0006-\u0016Q\u0016\u0005\b\u0003\u0003+\u0002\u0019AA%\u0011\u001d\t)!\u0006a\u0001\u0003\u000fAq!a\"\u0016\u0001\u0004\t9\u0001C\u0004\u0002\fV\u0001\r!a\u0002\t\u0013\u0005}R\u0003%AA\u0002\u0005\u0005\u0013\u0001I4fi6+'oZ3e\u00052|7m['fi\u00064\u0015\u000e\\3%I\u00164\u0017-\u001e7uIU\nqB]3n_Z,G)\u0019;b\u0005fl\u0015\r\u001d\u000b\u0006/\u0006U\u0016q\u0017\u0005\b\u0003\u000b9\u0002\u0019AA\u0004\u0011\u0019\tya\u0006a\u0001g\u0006)2\r[3dW&sG-\u001a=B]\u0012$\u0015\r^1GS2,G\u0003CA_\u0003\u007f\u000b\u0019-a2\u0011\tU\n)e\u001d\u0005\u0007\u0003\u0003D\u0002\u0019A=\u0002\u000b%tG-\u001a=\t\r\u0005\u0015\u0007\u00041\u0001z\u0003\u0011!\u0017\r^1\t\u000f\u0005%\u0007\u00041\u0001\u0002\b\u00051!\r\\8dWN\fq\u0003];u'\",hM\u001a7f\u00052|7m[!t'R\u0014X-Y7\u0015\r\u0005=\u00171\\As!\u0011\t\t.a6\u000e\u0005\u0005M'bAAkS\u000611\r\\5f]RLA!!7\u0002T\n!2\u000b\u001e:fC6\u001c\u0015\r\u001c7cC\u000e\\w+\u001b;i\u0013\u0012Cq!!8\u001a\u0001\u0004\ty.A\u0004cY>\u001c7.\u00133\u0011\u0007A\u000b\t/C\u0002\u0002dF\u0013qA\u00117pG.LE\rC\u0004\u0002hf\u0001\r!!;\u0002#M,'/[1mSj,'/T1oC\u001e,'\u000f\u0005\u0003\u0002l\u0006EXBAAw\u0015\r\ty/L\u0001\u000bg\u0016\u0014\u0018.\u00197ju\u0016\u0014\u0018\u0002BAz\u0003[\u0014\u0011cU3sS\u0006d\u0017N_3s\u001b\u0006t\u0017mZ3s\u0003I9W\r^'jOJ\fG/[8o\u00052|7m[:\u0015\t\u0005e(\u0011\u0003\t\u0007\u0003/\tY0a@\n\t\u0005u\u00181\u0006\u0002\u0005\u0019&\u001cH\u000fE\u00046\u0005\u0003\tyN!\u0002\n\u0007\t\raG\u0001\u0004UkBdWM\r\t\u0005\u0005\u000f\u0011i!\u0004\u0002\u0003\n)\u0019!1B5\u0002\r\t,hMZ3s\u0013\u0011\u0011yA!\u0003\u0003\u001b5\u000bg.Y4fI\n+hMZ3s\u0011\u001d\u0011\u0019B\u0007a\u0001\u0003[\t\u0001c\u001d5vM\u001adWM\u00117pG.LeNZ8\u00025]\u0014\u0018\u000e^3NKR\fG-\u0019;b\r&dW-\u00118e\u0007>lW.\u001b;\u0015\u0017]\u0013IBa\u0007\u0003\u001e\t\u0005\"Q\u0005\u0005\b\u0003\u000bY\u0002\u0019AA\u0004\u0011\u0019\tya\u0007a\u0001g\"9!qD\u000eA\u0002\u0005u\u0016a\u00027f]\u001e$\bn\u001d\u0005\b\u0005GY\u0002\u0019AA_\u0003%\u0019\u0007.Z2lgVl7\u000f\u0003\u0004\u0003(m\u0001\r!_\u0001\bI\u0006$\u0018\rV7q\u0003E9(/\u001b;f\u001b\u0016$\u0018\rZ1uC\u001aKG.\u001a\u000b\n/\n5\"\u0011\u0007B\u001b\u0005sAqAa\f\u001d\u0001\u0004\ti,\u0001\u0006nKR\fg+\u00197vKNDaAa\r\u001d\u0001\u0004I\u0018a\u0002;na\u001aKG.\u001a\u0005\u0007\u0005oa\u0002\u0019A=\u0002\u0015Q\f'oZ3u\r&dW\rC\u0004\u0003<q\u0001\rA!\u0010\u0002\u001dA\u0014x\u000e]1hCR,WI\u001d:peB\u0019QGa\u0010\n\u0007\t\u0005cGA\u0004C_>dW-\u00198\u0002%\u001d,G/T3sO\u0016$'\t\\8dW\u0012\u000bG/\u0019\u000b\u0007\u0005\u000f\u0012IE!\u0015\u0011\r\u0005]\u0011q\u0005B\u0003\u0011\u001d\ti.\ba\u0001\u0005\u0017\u00022\u0001\u0015B'\u0013\r\u0011y%\u0015\u0002\u0015'\",hM\u001a7f\u001b\u0016\u0014x-\u001a3CY>\u001c7.\u00133\t\u000f\u0005}R\u00041\u0001\u0002B\u0005\u0011r-\u001a;NKJ<W\r\u001a\"m_\u000e\\W*\u001a;b)\u0019\u00119F!\u0019\u0003dA!!\u0011\fB/\u001b\t\u0011YF\u0003\u0002-S&!!q\fB.\u0005=iUM]4fI\ncwnY6NKR\f\u0007bBAo=\u0001\u0007!1\n\u0005\b\u0003\u007fq\u0002\u0019AA!\u000319W\r^\"iK\u000e\\7/^7t)\u0019\tiL!\u001b\u0003n!1!1N\u0010A\u0002e\fAb\u00195fG.\u001cX/\u001c$jY\u0016DqAa\u001c \u0001\u0004\t9!\u0001\u0005cY>\u001c7NT;n\u0003=9W\r^\"iK\u000e\\7/^7GS2,G#C=\u0003v\t]$\u0011\u0010B?\u0011\u001d\t)\u0001\ta\u0001\u0003\u000fAa!a\u0004!\u0001\u0004\u0019\bb\u0002B>A\u0001\u0007\u0011\u0011J\u0001\nC2<wN]5uQ6D\u0011\"a\u0010!!\u0003\u0005\r!!\u0011\u00023\u001d,Go\u00115fG.\u001cX/\u001c$jY\u0016$C-\u001a4bk2$H\u0005N\u0001\rO\u0016$(\t\\8dW\u0012\u000bG/\u0019\u000b\u0007\u0005\u000b\u0011)Ia\"\t\u000f\u0005u'\u00051\u0001\u0002`\"I\u0011q\b\u0012\u0011\u0002\u0003\u0007\u0011\u0011I\u0001\u0005gR|\u0007\u000fF\u0001X\u0003eIe\u000eZ3y'\",hM\u001a7f\u00052|7m\u001b*fg>dg/\u001a:\u0011\u0005m*3CA\u00135)\t\u0011y)\u0001\bO\u001f>\u0003vLU#E+\u000e+u,\u0013#\u0016\u0005\u0005\u001d\u0011a\u0004(P\u001fB{&+\u0012#V\u0007\u0016{\u0016\n\u0012\u0011\u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00133+\t\u0011yJK\u0002P\u0003S\u0002")
public class IndexShuffleBlockResolver
implements ShuffleBlockResolver,
Logging,
MigratableResolver {
    private BlockManager org$apache$spark$shuffle$IndexShuffleBlockResolver$$blockManager;
    private final SparkConf conf;
    private BlockManager _blockManager;
    private final TransportConf transportConf;
    private final Option<Object> remoteShuffleMaxDisk;
    private transient Logger org$apache$spark$internal$Logging$$log_;
    private volatile boolean bitmap$0;

    public static BlockManager $lessinit$greater$default$2() {
        return IndexShuffleBlockResolver$.MODULE$.$lessinit$greater$default$2();
    }

    public static int NOOP_REDUCE_ID() {
        return IndexShuffleBlockResolver$.MODULE$.NOOP_REDUCE_ID();
    }

    @Override
    public String logName() {
        return Logging.logName$(this);
    }

    @Override
    public Logger log() {
        return Logging.log$(this);
    }

    @Override
    public void logInfo(Function0<String> msg) {
        Logging.logInfo$(this, msg);
    }

    @Override
    public void logDebug(Function0<String> msg) {
        Logging.logDebug$(this, msg);
    }

    @Override
    public void logTrace(Function0<String> msg) {
        Logging.logTrace$(this, msg);
    }

    @Override
    public void logWarning(Function0<String> msg) {
        Logging.logWarning$(this, msg);
    }

    @Override
    public void logError(Function0<String> msg) {
        Logging.logError$(this, msg);
    }

    @Override
    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$(this, msg, throwable);
    }

    @Override
    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$(this, msg, throwable);
    }

    @Override
    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$(this, msg, throwable);
    }

    @Override
    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$(this, msg, throwable);
    }

    @Override
    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$(this, msg, throwable);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$(this, isInterpreter);
    }

    @Override
    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$(this, isInterpreter, silent);
    }

    @Override
    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$(this);
    }

    @Override
    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$(this, isInterpreter, silent);
    }

    @Override
    public Option<String[]> getBlockData$default$2() {
        return ShuffleBlockResolver.getBlockData$default$2$(this);
    }

    @Override
    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    @Override
    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public BlockManager _blockManager() {
        return this._blockManager;
    }

    public void _blockManager_$eq(BlockManager x$1) {
        this._blockManager = x$1;
    }

    private BlockManager blockManager$lzycompute() {
        IndexShuffleBlockResolver indexShuffleBlockResolver = this;
        synchronized (indexShuffleBlockResolver) {
            if (!this.bitmap$0) {
                this.org$apache$spark$shuffle$IndexShuffleBlockResolver$$blockManager = (BlockManager)Option$.MODULE$.apply((Object)this._blockManager()).getOrElse((Function0 & Serializable)() -> SparkEnv$.MODULE$.get().blockManager());
                this.bitmap$0 = true;
            }
        }
        return this.org$apache$spark$shuffle$IndexShuffleBlockResolver$$blockManager;
    }

    public BlockManager org$apache$spark$shuffle$IndexShuffleBlockResolver$$blockManager() {
        return !this.bitmap$0 ? this.blockManager$lzycompute() : this.org$apache$spark$shuffle$IndexShuffleBlockResolver$$blockManager;
    }

    private TransportConf transportConf() {
        return this.transportConf;
    }

    private Option<Object> remoteShuffleMaxDisk() {
        return this.remoteShuffleMaxDisk;
    }

    public File getDataFile(int shuffleId, long mapId) {
        return this.getDataFile(shuffleId, mapId, (Option<String[]>)None$.MODULE$);
    }

    @Override
    public Seq<ShuffleBlockInfo> getStoredShuffles() {
        Seq<BlockId> allBlocks = this.org$apache$spark$shuffle$IndexShuffleBlockResolver$$blockManager().diskBlockManager().getAllBlocks();
        return (Seq)allBlocks.flatMap((Function1 & Serializable)x0$1 -> {
            None$ none$;
            BlockId blockId = x0$1;
            if (blockId instanceof ShuffleIndexBlockId) {
                ShuffleIndexBlockId shuffleIndexBlockId = (ShuffleIndexBlockId)blockId;
                int shuffleId = shuffleIndexBlockId.shuffleId();
                long mapId = shuffleIndexBlockId.mapId();
                none$ = new Some((Object)new ShuffleBlockInfo(shuffleId, mapId));
            } else {
                none$ = None$.MODULE$;
            }
            return none$;
        });
    }

    private long getShuffleBytesStored() {
        Seq shuffleFiles = (Seq)this.getStoredShuffles().map((Function1 & Serializable)si -> this.getDataFile(si.shuffleId(), si.mapId()));
        return BoxesRunTime.unboxToLong((Object)((IterableOnceOps)shuffleFiles.map((Function1 & Serializable)x$1 -> BoxesRunTime.boxToLong((long)x$1.length()))).sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
    }

    public File getDataFile(int shuffleId, long mapId, Option<String[]> dirs) {
        ShuffleDataBlockId blockId = new ShuffleDataBlockId(shuffleId, mapId, IndexShuffleBlockResolver$.MODULE$.NOOP_REDUCE_ID());
        return (File)dirs.map((Function1 & Serializable)x$2 -> ExecutorDiskUtils.getFile((String[])x$2, (int)this.org$apache$spark$shuffle$IndexShuffleBlockResolver$$blockManager().subDirsPerLocalDir(), (String)blockId.name())).getOrElse((Function0 & Serializable)() -> this.org$apache$spark$shuffle$IndexShuffleBlockResolver$$blockManager().diskBlockManager().getFile(blockId));
    }

    public File getIndexFile(int shuffleId, long mapId, Option<String[]> dirs) {
        ShuffleIndexBlockId blockId = new ShuffleIndexBlockId(shuffleId, mapId, IndexShuffleBlockResolver$.MODULE$.NOOP_REDUCE_ID());
        return (File)dirs.map((Function1 & Serializable)x$3 -> ExecutorDiskUtils.getFile((String[])x$3, (int)this.org$apache$spark$shuffle$IndexShuffleBlockResolver$$blockManager().subDirsPerLocalDir(), (String)blockId.name())).getOrElse((Function0 & Serializable)() -> this.org$apache$spark$shuffle$IndexShuffleBlockResolver$$blockManager().diskBlockManager().getFile(blockId));
    }

    public Option<String[]> getIndexFile$default$3() {
        return None$.MODULE$;
    }

    private File getMergedBlockDataFile(String appId, int shuffleId, int shuffleMergeId, int reduceId, Option<String[]> dirs) {
        return this.org$apache$spark$shuffle$IndexShuffleBlockResolver$$blockManager().diskBlockManager().getMergedShuffleFile(new ShuffleMergedDataBlockId(appId, shuffleId, shuffleMergeId, reduceId), dirs);
    }

    private File getMergedBlockIndexFile(String appId, int shuffleId, int shuffleMergeId, int reduceId, Option<String[]> dirs) {
        return this.org$apache$spark$shuffle$IndexShuffleBlockResolver$$blockManager().diskBlockManager().getMergedShuffleFile(new ShuffleMergedIndexBlockId(appId, shuffleId, shuffleMergeId, reduceId), dirs);
    }

    private Option<String[]> getMergedBlockIndexFile$default$5() {
        return None$.MODULE$;
    }

    private File getMergedBlockMetaFile(String appId, int shuffleId, int shuffleMergeId, int reduceId, Option<String[]> dirs) {
        return this.org$apache$spark$shuffle$IndexShuffleBlockResolver$$blockManager().diskBlockManager().getMergedShuffleFile(new ShuffleMergedMetaBlockId(appId, shuffleId, shuffleMergeId, reduceId), dirs);
    }

    public void removeDataByMap(int shuffleId, long mapId) {
        block2: {
            ObjectRef file = ObjectRef.create((Object)this.getDataFile(shuffleId, mapId));
            if (((File)file.elem).exists() && !((File)file.elem).delete()) {
                this.logWarning((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(20).append("Error deleting data ").append(((File)file$1.elem).getPath()).toString());
            }
            file.elem = this.getIndexFile(shuffleId, mapId, this.getIndexFile$default$3());
            if (((File)file.elem).exists() && !((File)file.elem).delete()) {
                this.logWarning((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(21).append("Error deleting index ").append(((File)file$1.elem).getPath()).toString());
            }
            file.elem = this.getChecksumFile(shuffleId, mapId, this.conf.get(org.apache.spark.internal.config.package$.MODULE$.SHUFFLE_CHECKSUM_ALGORITHM()), this.getChecksumFile$default$4());
            if (!((File)file.elem).exists() || ((File)file.elem).delete()) break block2;
            this.logWarning((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(24).append("Error deleting checksum ").append(((File)file$1.elem).getPath()).toString());
        }
    }

    private long[] checkIndexAndDataFile(File index, File data, int blocks) {
        long[] lengths;
        block11: {
            long[] lArray;
            block10: {
                DataInputStream dataInputStream;
                if (index.length() != (long)(blocks + 1) * 8L) {
                    return null;
                }
                lengths = new long[blocks];
                try {
                    dataInputStream = new DataInputStream(new NioBufferedFileInputStream(index));
                }
                catch (IOException e) {
                    return null;
                }
                try (DataInputStream in = dataInputStream;){
                    try {
                        long offset = in.readLong();
                        if (offset != 0L) {
                            lArray = null;
                            break block10;
                        }
                        for (int i = 0; i < blocks; ++i) {
                            long off = in.readLong();
                            lengths[i] = off - offset;
                            offset = off;
                        }
                        break block11;
                    }
                    catch (IOException e) {
                        lArray = null;
                    }
                }
            }
            return lArray;
        }
        return (long[])(data.length() == BoxesRunTime.unboxToLong((Object)Predef$.MODULE$.wrapLongArray(lengths).sum((Numeric)Numeric.LongIsIntegral$.MODULE$)) ? lengths : null);
    }

    @Override
    public StreamCallbackWithID putShuffleBlockAsStream(BlockId blockId, SerializerManager serializerManager) {
        File file;
        this.remoteShuffleMaxDisk().foreach((Function1)(JFunction1.mcVJ.sp & Serializable)maxBytes -> {
            long bytesUsed = this.getShuffleBytesStored();
            if (maxBytes < bytesUsed) {
                throw new SparkException(new StringBuilder(37).append("Not storing remote shuffles ").append(bytesUsed).append(" exceeds ").append(maxBytes).toString());
            }
        });
        BlockId blockId2 = blockId;
        if (blockId2 instanceof ShuffleIndexBlockId) {
            ShuffleIndexBlockId shuffleIndexBlockId = (ShuffleIndexBlockId)blockId2;
            int shuffleId = shuffleIndexBlockId.shuffleId();
            long mapId = shuffleIndexBlockId.mapId();
            file = this.getIndexFile(shuffleId, mapId, this.getIndexFile$default$3());
        } else if (blockId2 instanceof ShuffleDataBlockId) {
            ShuffleDataBlockId shuffleDataBlockId = (ShuffleDataBlockId)blockId2;
            int shuffleId = shuffleDataBlockId.shuffleId();
            long mapId = shuffleDataBlockId.mapId();
            file = this.getDataFile(shuffleId, mapId);
        } else {
            throw new IllegalStateException(new StringBuilder(0).append(new StringBuilder(38).append("Unexpected shuffle block transfer ").append(blockId).append(" as ").toString()).append(String.valueOf(blockId.getClass().getSimpleName())).toString());
        }
        File file2 = file;
        File fileTmp = Utils$.MODULE$.tempFileWith(file2);
        WritableByteChannel channel = Channels.newChannel(serializerManager.wrapStream(blockId, new FileOutputStream(fileTmp)));
        return new StreamCallbackWithID(this, blockId, channel, fileTmp, file2){
            private final /* synthetic */ IndexShuffleBlockResolver $outer;
            private final BlockId blockId$3;
            private final WritableByteChannel channel$1;
            private final File fileTmp$1;
            private final File file$2;

            public ByteBuffer getCompletionResponse() {
                return super.getCompletionResponse();
            }

            public String getID() {
                return this.blockId$3.name();
            }

            public void onData(String streamId, ByteBuffer buf) {
                while (buf.hasRemaining()) {
                    this.channel$1.write(buf);
                }
            }

            public void onComplete(String streamId) {
                this.$outer.logTrace((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(57).append("Done receiving shuffle block ").append($this.blockId$3).append(", now storing on local disk.").toString());
                this.channel$1.close();
                long diskSize = this.fileTmp$1.length();
                $anon$1 var4_3 = this;
                synchronized (var4_3) {
                    Object object = this.file$2.exists() ? BoxesRunTime.boxToBoolean((boolean)this.file$2.delete()) : BoxedUnit.UNIT;
                    if (!this.fileTmp$1.renameTo(this.file$2)) {
                        throw new IOException(new StringBuilder(24).append("fail to rename file ").append(this.fileTmp$1).append(" to ").append(this.file$2).toString());
                    }
                }
                this.$outer.org$apache$spark$shuffle$IndexShuffleBlockResolver$$blockManager().reportBlockStatus(this.blockId$3, new BlockStatus(StorageLevel$.MODULE$.DISK_ONLY(), 0L, diskSize), this.$outer.org$apache$spark$shuffle$IndexShuffleBlockResolver$$blockManager().reportBlockStatus$default$3());
            }

            public void onFailure(String streamId, Throwable cause) {
                this.$outer.logWarning((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(22).append("Error while uploading ").append($this.blockId$3).toString(), cause);
                this.channel$1.close();
                this.fileTmp$1.delete();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.blockId$3 = blockId$3;
                this.channel$1 = channel$1;
                this.fileTmp$1 = fileTmp$1;
                this.file$2 = file$2;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$onComplete$1(org.apache.spark.shuffle.IndexShuffleBlockResolver$$anon$1 ), $anonfun$onFailure$1(org.apache.spark.shuffle.IndexShuffleBlockResolver$$anon$1 )}, serializedLambda);
            }
        };
    }

    @Override
    public List<Tuple2<BlockId, ManagedBuffer>> getMigrationBlocks(ShuffleBlockInfo shuffleBlockInfo) {
        List list;
        block4: {
            try {
                int shuffleId = shuffleBlockInfo.shuffleId();
                long mapId = shuffleBlockInfo.mapId();
                File indexFile = this.getIndexFile(shuffleId, mapId, this.getIndexFile$default$3());
                ShuffleIndexBlockId indexBlockId = new ShuffleIndexBlockId(shuffleId, mapId, IndexShuffleBlockResolver$.MODULE$.NOOP_REDUCE_ID());
                long indexFileSize = indexFile.length();
                FileSegmentManagedBuffer indexBlockData = new FileSegmentManagedBuffer(this.transportConf(), indexFile, 0L, indexFileSize);
                File dataFile = this.getDataFile(shuffleId, mapId);
                ShuffleDataBlockId dataBlockId = new ShuffleDataBlockId(shuffleId, mapId, IndexShuffleBlockResolver$.MODULE$.NOOP_REDUCE_ID());
                FileSegmentManagedBuffer dataBlockData = new FileSegmentManagedBuffer(this.transportConf(), dataFile, 0L, dataFile.length());
                if (!indexFile.exists()) {
                    throw new FileNotFoundException("Index file is deleted already.");
                }
                if (dataFile.exists()) {
                    list = (List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)dataBlockId, (Object)dataBlockData), new Tuple2((Object)indexBlockId, (Object)indexBlockData)}));
                    break block4;
                }
                list = (List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)indexBlockId, (Object)indexBlockData)}));
            }
            catch (Exception exception) {
                this.logWarning((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(82).append(new StringBuilder(34).append("Failed to resolve shuffle block ").append(shuffleBlockInfo).append(". ").toString()).append("This is expected to occur if a block is removed after decommissioning has started.").toString());
                list = package$.MODULE$.List().empty();
            }
        }
        return list;
    }

    public void writeMetadataFileAndCommit(int shuffleId, long mapId, long[] lengths, long[] checksums, File dataTmp) {
        Tuple2 tuple2;
        Tuple2 tuple22;
        File indexFile = this.getIndexFile(shuffleId, mapId, this.getIndexFile$default$3());
        File indexTmp = Utils$.MODULE$.tempFileWith(indexFile);
        boolean checksumEnabled = ArrayOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.longArrayOps(checksums));
        if (checksumEnabled) {
            Predef$.MODULE$.assert(lengths.length == checksums.length, (Function0 & Serializable)() -> "The size of partition lengths and checksums should be equal");
            File checksumFile = this.getChecksumFile(shuffleId, mapId, this.conf.get(org.apache.spark.internal.config.package$.MODULE$.SHUFFLE_CHECKSUM_ALGORITHM()), this.getChecksumFile$default$4());
            tuple22 = new Tuple2((Object)new Some((Object)checksumFile), (Object)new Some((Object)Utils$.MODULE$.tempFileWith(checksumFile)));
        } else {
            tuple22 = tuple2 = new Tuple2((Object)None$.MODULE$, (Object)None$.MODULE$);
        }
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Option checksumFileOpt = (Option)tuple2._1();
        Option checksumTmpOpt = (Option)tuple2._2();
        Tuple2 tuple23 = new Tuple2((Object)checksumFileOpt, (Object)checksumTmpOpt);
        Tuple2 tuple24 = tuple23;
        Option checksumFileOpt2 = (Option)tuple24._1();
        Option checksumTmpOpt2 = (Option)tuple24._2();
        try {
            File dataFile = this.getDataFile(shuffleId, mapId);
            IndexShuffleBlockResolver indexShuffleBlockResolver = this;
            synchronized (indexShuffleBlockResolver) {
                Object object;
                long[] existingLengths = this.checkIndexAndDataFile(indexFile, dataFile, lengths.length);
                if (existingLengths != null) {
                    System.arraycopy(existingLengths, 0, lengths, 0, lengths.length);
                    if (checksumEnabled) {
                        long[] existingChecksums = this.getChecksums((File)checksumFileOpt2.get(), checksums.length);
                        if (existingChecksums != null) {
                            System.arraycopy(existingChecksums, 0, checksums, 0, lengths.length);
                        } else {
                            this.writeMetadataFile(checksums, (File)checksumTmpOpt2.get(), (File)checksumFileOpt2.get(), false);
                        }
                    }
                    object = dataTmp != null && dataTmp.exists() ? BoxesRunTime.boxToBoolean((boolean)dataTmp.delete()) : BoxedUnit.UNIT;
                } else {
                    long[] offsets = (long[])ArrayOps$.MODULE$.scanLeft$extension(Predef$.MODULE$.longArrayOps(lengths), (Object)BoxesRunTime.boxToLong((long)0L), (Function2)(JFunction2.mcJJJ.sp & Serializable)(x$5, x$6) -> x$5 + x$6, (ClassTag)ClassTag$.MODULE$.Long());
                    this.writeMetadataFile(offsets, indexTmp, indexFile, true);
                    Object object2 = dataFile.exists() ? BoxesRunTime.boxToBoolean((boolean)dataFile.delete()) : BoxedUnit.UNIT;
                    if (dataTmp != null && dataTmp.exists() && !dataTmp.renameTo(dataFile)) {
                        throw new IOException(new StringBuilder(24).append("fail to rename file ").append(dataTmp).append(" to ").append(dataFile).toString());
                    }
                    checksumTmpOpt2.zip(checksumFileOpt2).foreach((Function1 & Serializable)x0$1 -> {
                        IndexShuffleBlockResolver.$anonfun$writeMetadataFileAndCommit$3(this, checksums, x0$1);
                        return BoxedUnit.UNIT;
                    });
                    object = BoxedUnit.UNIT;
                }
            }
        }
        finally {
            this.logDebug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(26).append("Shuffle index for mapId ").append(mapId).append(": ").append(Predef$.MODULE$.wrapLongArray(lengths).mkString("[", ",", "]")).toString());
            if (indexTmp.exists() && !indexTmp.delete()) {
                this.logError((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(41).append("Failed to delete temporary index file at ").append(indexTmp.getAbsolutePath()).toString());
            }
            checksumTmpOpt2.foreach((Function1 & Serializable)checksumTmp -> {
                IndexShuffleBlockResolver.$anonfun$writeMetadataFileAndCommit$7(this, checksumTmp);
                return BoxedUnit.UNIT;
            });
        }
    }

    private void writeMetadataFile(long[] metaValues, File tmpFile, File targetFile, boolean propagateError) {
        block1: {
            DataOutputStream out = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(tmpFile)));
            Utils$.MODULE$.tryWithSafeFinally((JFunction0.mcV.sp & Serializable)() -> ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.longArrayOps(metaValues), (Function1)(JFunction1.mcVJ.sp & Serializable)x$1 -> out.writeLong(x$1)), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> out.close());
            Object object = targetFile.exists() ? BoxesRunTime.boxToBoolean((boolean)targetFile.delete()) : BoxedUnit.UNIT;
            if (tmpFile.renameTo(targetFile)) break block1;
            String errorMsg = new StringBuilder(24).append("fail to rename file ").append(tmpFile).append(" to ").append(targetFile).toString();
            if (propagateError) {
                throw new IOException(errorMsg);
            }
            this.logWarning((Function0<String>)(Function0 & Serializable)() -> errorMsg);
        }
    }

    @Override
    public Seq<ManagedBuffer> getMergedBlockData(ShuffleMergedBlockId blockId, Option<String[]> dirs) {
        File indexFile = this.getMergedBlockIndexFile(this.conf.getAppId(), blockId.shuffleId(), blockId.shuffleMergeId(), blockId.reduceId(), dirs);
        File dataFile = this.getMergedBlockDataFile(this.conf.getAppId(), blockId.shuffleId(), blockId.shuffleMergeId(), blockId.reduceId(), dirs);
        int size = (int)indexFile.length();
        LongBuffer offsets = (LongBuffer)Utils$.MODULE$.tryWithResource((Function0 & Serializable)() -> new DataInputStream(Files.newInputStream(indexFile.toPath(), new OpenOption[0])), (Function1 & Serializable)dis -> {
            ByteBuffer buffer = ByteBuffer.allocate(size);
            dis.readFully(buffer.array());
            return buffer.asLongBuffer();
        });
        int numChunks = size / 8 - 1;
        return RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), numChunks).map((Function1 & Serializable)index -> IndexShuffleBlockResolver.$anonfun$getMergedBlockData$3(this, dataFile, offsets, BoxesRunTime.unboxToInt((Object)index)));
    }

    private Option<String[]> getMergedBlockDataFile$default$5() {
        return None$.MODULE$;
    }

    @Override
    public MergedBlockMeta getMergedBlockMeta(ShuffleMergedBlockId blockId, Option<String[]> dirs) {
        File indexFile = this.getMergedBlockIndexFile(this.conf.getAppId(), blockId.shuffleId(), blockId.shuffleMergeId(), blockId.reduceId(), dirs);
        int size = (int)indexFile.length();
        int numChunks = size / 8 - 1;
        File metaFile = this.getMergedBlockMetaFile(this.conf.getAppId(), blockId.shuffleId(), blockId.shuffleMergeId(), blockId.reduceId(), dirs);
        FileSegmentManagedBuffer chunkBitMaps = new FileSegmentManagedBuffer(this.transportConf(), metaFile, 0L, metaFile.length());
        return new MergedBlockMeta(numChunks, (ManagedBuffer)chunkBitMaps);
    }

    private Option<String[]> getMergedBlockMetaFile$default$5() {
        return None$.MODULE$;
    }

    public long[] getChecksums(File checksumFile, int blockNum) {
        ArrayBuffer checksums;
        block8: {
            long[] lArray;
            block9: {
                if (!checksumFile.exists()) {
                    return null;
                }
                checksums = new ArrayBuffer();
                try (FilterInputStream in = null;){
                    try {
                        in = new DataInputStream(new NioBufferedFileInputStream(checksumFile));
                        while (checksums.size() < blockNum) {
                            checksums.$plus$eq((Object)BoxesRunTime.boxToLong((long)((DataInputStream)in).readLong()));
                        }
                        break block8;
                    }
                    catch (Throwable throwable) {
                        Throwable throwable2 = throwable;
                        boolean bl = throwable2 instanceof IOException ? true : throwable2 instanceof EOFException;
                        if (bl) {
                            lArray = null;
                            break block9;
                        }
                        throw throwable;
                    }
                }
            }
            return lArray;
        }
        return (long[])checksums.toArray((ClassTag)ClassTag$.MODULE$.Long());
    }

    public File getChecksumFile(int shuffleId, long mapId, String algorithm, Option<String[]> dirs) {
        ShuffleChecksumBlockId blockId = new ShuffleChecksumBlockId(shuffleId, mapId, IndexShuffleBlockResolver$.MODULE$.NOOP_REDUCE_ID());
        String fileName = ShuffleChecksumHelper.getChecksumFileName((String)blockId.name(), (String)algorithm);
        return (File)dirs.map((Function1 & Serializable)x$7 -> ExecutorDiskUtils.getFile((String[])x$7, (int)this.org$apache$spark$shuffle$IndexShuffleBlockResolver$$blockManager().subDirsPerLocalDir(), (String)fileName)).getOrElse((Function0 & Serializable)() -> this.org$apache$spark$shuffle$IndexShuffleBlockResolver$$blockManager().diskBlockManager().getFile(fileName));
    }

    public Option<String[]> getChecksumFile$default$4() {
        return None$.MODULE$;
    }

    @Override
    public ManagedBuffer getBlockData(BlockId blockId, Option<String[]> dirs) {
        FileSegmentManagedBuffer fileSegmentManagedBuffer;
        Tuple4 tuple4;
        BlockId blockId2 = blockId;
        if (blockId2 instanceof ShuffleBlockId) {
            ShuffleBlockId shuffleBlockId = (ShuffleBlockId)blockId2;
            tuple4 = new Tuple4((Object)BoxesRunTime.boxToInteger((int)shuffleBlockId.shuffleId()), (Object)BoxesRunTime.boxToLong((long)shuffleBlockId.mapId()), (Object)BoxesRunTime.boxToInteger((int)shuffleBlockId.reduceId()), (Object)BoxesRunTime.boxToInteger((int)(shuffleBlockId.reduceId() + 1)));
        } else if (blockId2 instanceof ShuffleBlockBatchId) {
            ShuffleBlockBatchId shuffleBlockBatchId = (ShuffleBlockBatchId)blockId2;
            tuple4 = new Tuple4((Object)BoxesRunTime.boxToInteger((int)shuffleBlockBatchId.shuffleId()), (Object)BoxesRunTime.boxToLong((long)shuffleBlockBatchId.mapId()), (Object)BoxesRunTime.boxToInteger((int)shuffleBlockBatchId.startReduceId()), (Object)BoxesRunTime.boxToInteger((int)shuffleBlockBatchId.endReduceId()));
        } else {
            throw new IllegalArgumentException(new StringBuilder(36).append("unexpected shuffle block id format: ").append(blockId).toString());
        }
        Tuple4 tuple42 = tuple4;
        if (tuple42 == null) {
            throw new MatchError((Object)tuple42);
        }
        int shuffleId = BoxesRunTime.unboxToInt((Object)tuple42._1());
        long mapId = BoxesRunTime.unboxToLong((Object)tuple42._2());
        int startReduceId = BoxesRunTime.unboxToInt((Object)tuple42._3());
        int endReduceId = BoxesRunTime.unboxToInt((Object)tuple42._4());
        Tuple4 tuple43 = new Tuple4((Object)BoxesRunTime.boxToInteger((int)shuffleId), (Object)BoxesRunTime.boxToLong((long)mapId), (Object)BoxesRunTime.boxToInteger((int)startReduceId), (Object)BoxesRunTime.boxToInteger((int)endReduceId));
        Tuple4 tuple44 = tuple43;
        int shuffleId2 = BoxesRunTime.unboxToInt((Object)tuple44._1());
        long mapId2 = BoxesRunTime.unboxToLong((Object)tuple44._2());
        int startReduceId2 = BoxesRunTime.unboxToInt((Object)tuple44._3());
        int endReduceId2 = BoxesRunTime.unboxToInt((Object)tuple44._4());
        File indexFile = this.getIndexFile(shuffleId2, mapId2, dirs);
        SeekableByteChannel channel = Files.newByteChannel(indexFile.toPath(), new OpenOption[0]);
        channel.position((long)startReduceId2 * 8L);
        try (DataInputStream in = new DataInputStream(Channels.newInputStream(channel));){
            long startOffset = in.readLong();
            channel.position((long)endReduceId2 * 8L);
            long endOffset = in.readLong();
            long actualPosition = channel.position();
            long expectedPosition = (long)endReduceId2 * 8L + 8L;
            if (actualPosition != expectedPosition) {
                throw new Exception(new StringBuilder(0).append("SPARK-22982: Incorrect channel position after index file reads: ").append(new StringBuilder(35).append("expected ").append(expectedPosition).append(" but actual position was ").append(actualPosition).append(".").toString()).toString());
            }
            fileSegmentManagedBuffer = new FileSegmentManagedBuffer(this.transportConf(), this.getDataFile(shuffleId2, mapId2, dirs), startOffset, endOffset - startOffset);
        }
        return fileSegmentManagedBuffer;
    }

    @Override
    public void stop() {
    }

    public static final /* synthetic */ void $anonfun$writeMetadataFileAndCommit$3(IndexShuffleBlockResolver $this, long[] checksums$1, Tuple2 x0$1) {
        BoxedUnit boxedUnit;
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            File checksumTmp = (File)tuple2._1();
            File checksumFile = (File)tuple2._2();
            try {
                $this.writeMetadataFile(checksums$1, checksumTmp, checksumFile, false);
                boxedUnit = BoxedUnit.UNIT;
            }
            catch (Exception e) {
                $this.logError((Function0<String>)(Function0 & Serializable)() -> "Failed to write checksum file", e);
                boxedUnit = BoxedUnit.UNIT;
            }
        } else {
            throw new MatchError((Object)tuple2);
        }
        BoxedUnit boxedUnit2 = boxedUnit;
    }

    public static final /* synthetic */ void $anonfun$writeMetadataFileAndCommit$7(IndexShuffleBlockResolver $this, File checksumTmp) {
        block3: {
            if (!checksumTmp.exists()) break block3;
            try {
                if (!checksumTmp.delete()) {
                    $this.logError((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(0).append("Failed to delete temporary checksum file ").append(new StringBuilder(3).append("at ").append(checksumTmp.getAbsolutePath()).toString()).toString());
                }
            }
            catch (Exception e) {
                $this.logError((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(0).append("Failed to delete temporary checksum file ").append(new StringBuilder(3).append("at ").append(checksumTmp.getAbsolutePath()).toString()).toString(), e);
            }
        }
    }

    public static final /* synthetic */ FileSegmentManagedBuffer $anonfun$getMergedBlockData$3(IndexShuffleBlockResolver $this, File dataFile$1, LongBuffer offsets$1, int index) {
        return new FileSegmentManagedBuffer($this.transportConf(), dataFile$1, offsets$1.get(index), offsets$1.get(index + 1) - offsets$1.get(index));
    }

    public IndexShuffleBlockResolver(SparkConf conf, BlockManager _blockManager) {
        this.conf = conf;
        this._blockManager = _blockManager;
        Logging.$init$(this);
        this.transportConf = SparkTransportConf$.MODULE$.fromSparkConf(conf, "shuffle", SparkTransportConf$.MODULE$.fromSparkConf$default$3(), SparkTransportConf$.MODULE$.fromSparkConf$default$4());
        this.remoteShuffleMaxDisk = (Option)conf.get(org.apache.spark.internal.config.package$.MODULE$.STORAGE_DECOMMISSION_SHUFFLE_MAX_DISK_SIZE());
    }
}

