/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.shuffle;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.net.ConnectException;
import java.nio.ByteBuffer;
import org.apache.spark.ShuffleDependency;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkEnv$;
import org.apache.spark.internal.Logging;
import org.apache.spark.network.buffer.FileSegmentManagedBuffer;
import org.apache.spark.network.buffer.ManagedBuffer;
import org.apache.spark.network.buffer.NioManagedBuffer;
import org.apache.spark.network.netty.SparkTransportConf$;
import org.apache.spark.network.server.BlockPushNonFatalFailure;
import org.apache.spark.network.shuffle.BlockPushingListener;
import org.apache.spark.network.shuffle.ErrorHandler;
import org.apache.spark.network.util.TransportConf;
import org.apache.spark.shuffle.ShuffleBlockPusher$;
import org.apache.spark.storage.BlockId;
import org.apache.spark.storage.BlockManagerId;
import org.apache.spark.storage.ShufflePushBlockId;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.Iterator;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashSet;
import scala.collection.mutable.Queue;
import scala.collection.mutable.Queue$;
import scala.math.Numeric;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.LambdaDeserialize;
import scala.runtime.LongRef;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\ruh!B,Y\u0001i\u0003\u0007\u0002C7\u0001\u0005\u0003\u0005\u000b\u0011B8\t\u000bM\u0004A\u0011\u0001;\t\ra\u0004\u0001\u0015!\u0003z\u0011\u0019a\b\u0001)A\u0005s\"1Q\u0010\u0001Q\u0001\neDaA \u0001!\u0002\u0013y\bbBA\u0003\u0001\u0001\u0006Ia \u0005\b\u0003\u000f\u0001\u0001\u0015)\u0003z\u0011\u001d\tI\u0001\u0001Q!\n}D\u0001\"a\u0003\u0001A\u0003%\u0011Q\u0002\u0005\t\u0003S\u0001\u0001\u0015!\u0003\u0002,!A1\u0011\u0001\u0001!\u0002\u0013\ti\u0003\u0003\u0005\u0004\u0004\u0001\u0001\u000b\u0011BB\u0003\u0011)\u0019i\u0002\u0001b\u0001\n\u0003A6q\u0004\u0005\t\u0007O\u0001\u0001\u0015!\u0003\u0004\"!A1\u0011\u0006\u0001\u0005\u0002a\u001bY\u0003\u0003\u0005\u0004.\u0001!\t\u0001WB\u0018\u0011!\u0019\t\b\u0001C\u00011\ne\bbBB:\u0001\u0011E1Q\u000f\u0005\b\u0007\u0003\u0003A\u0011\u0002B}\u0011\u001d\u0019\u0019\t\u0001C\u0005\u0007\u000bCqaa#\u0001\t\u0013\u0019i\tC\u0004\u0004\u001a\u0002!Iaa'\t\u0011\r=\u0006\u0001\"\u0001Y\u0007cCqa!8\u0001\t#\u0019yn\u0002\u0005\u0002NaC\tAWA(\r\u001d9\u0006\f#\u0001[\u0003#Baa]\u000e\u0005\u0002\u0005McaBA+7\u0001S\u0016q\u000b\u0005\u000b\u0003cj\"Q3A\u0005\u0002\u0005M\u0004BCA;;\tE\t\u0015!\u0003\u0002\u001e!Q\u0011qO\u000f\u0003\u0016\u0004%\t!!\u001f\t\u0015\u00055UD!E!\u0002\u0013\tY\b\u0003\u0006\u0002\u0010v\u0011)\u001a!C\u0001\u0003#C!\"a)\u001e\u0005#\u0005\u000b\u0011BAJ\u0011\u0019\u0019X\u0004\"\u0001\u0002&\"I\u0011\u0011W\u000fC\u0002\u0013\u0005\u00111\u0017\u0005\b\u0003kk\u0002\u0015!\u0003\u0000\u0011%\t9,HA\u0001\n\u0003\tI\fC\u0005\u0002Bv\t\n\u0011\"\u0001\u0002D\"I\u0011\u0011\\\u000f\u0012\u0002\u0013\u0005\u00111\u001c\u0005\n\u0003?l\u0012\u0013!C\u0001\u0003CD\u0011\"!:\u001e\u0003\u0003%\t%a:\t\u0013\u0005eX$!A\u0005\u0002\u0005M\u0006\"CA~;\u0005\u0005I\u0011AA\u007f\u0011%\u0011I!HA\u0001\n\u0003\u0012Y\u0001C\u0005\u0003\u0016u\t\t\u0011\"\u0001\u0003\u0018!I!\u0011E\u000f\u0002\u0002\u0013\u0005#1\u0005\u0005\n\u0005Oi\u0012\u0011!C!\u0005SA\u0011Ba\u000b\u001e\u0003\u0003%\tE!\f\t\u0013\t=R$!A\u0005B\tErA\u0003B\u001b7\u0005\u0005\t\u0012\u0001.\u00038\u0019Q\u0011QK\u000e\u0002\u0002#\u0005!L!\u000f\t\rM,D\u0011\u0001B)\u0011%\u0011Y#NA\u0001\n\u000b\u0012i\u0003C\u0005\u0003TU\n\t\u0011\"!\u0003V!I!QL\u001b\u0002\u0002\u0013\u0005%q\f\u0005\n\u0005c*\u0014\u0011!C\u0005\u0005g2aAa\u001f\u001c\t\nu\u0004B\u0003B@w\tU\r\u0011\"\u0001\u0003\u0002\"Q!\u0011S\u001e\u0003\u0012\u0003\u0006IAa!\t\u0015\tM5H!f\u0001\n\u0003\u0011)\n\u0003\u0006\u0003\u001en\u0012\t\u0012)A\u0005\u0005/Caa]\u001e\u0005\u0002\t}\u0005\"CA\\w\u0005\u0005I\u0011\u0001BT\u0011%\t\tmOI\u0001\n\u0003\u0011i\u000bC\u0005\u0002Zn\n\n\u0011\"\u0001\u00032\"I\u0011Q]\u001e\u0002\u0002\u0013\u0005\u0013q\u001d\u0005\n\u0003s\\\u0014\u0011!C\u0001\u0003gC\u0011\"a?<\u0003\u0003%\tA!.\t\u0013\t%1(!A\u0005B\t-\u0001\"\u0003B\u000bw\u0005\u0005I\u0011\u0001B]\u0011%\u0011\tcOA\u0001\n\u0003\u0012i\fC\u0005\u0003(m\n\t\u0011\"\u0011\u0003*!I!1F\u001e\u0002\u0002\u0013\u0005#Q\u0006\u0005\n\u0005_Y\u0014\u0011!C!\u0005\u0003<\u0011B!2\u001c\u0003\u0003EIAa2\u0007\u0013\tm4$!A\t\n\t%\u0007BB:O\t\u0003\u0011\t\u000eC\u0005\u0003,9\u000b\t\u0011\"\u0012\u0003.!I!1\u000b(\u0002\u0002\u0013\u0005%1\u001b\u0005\n\u0005;r\u0015\u0011!CA\u00053D\u0011B!\u001dO\u0003\u0003%IAa\u001d\t\u0013\t\u00058D1A\u0005\n\t\r\b\u0002\u0003B{7\u0001\u0006IA!:\t\u0011\t]8\u0004\"\u0001[\u0005s\u0014!c\u00155vM\u001adWM\u00117pG.\u0004Vo\u001d5fe*\u0011\u0011LW\u0001\bg\",hM\u001a7f\u0015\tYF,A\u0003ta\u0006\u00148N\u0003\u0002^=\u00061\u0011\r]1dQ\u0016T\u0011aX\u0001\u0004_J<7c\u0001\u0001bOB\u0011!-Z\u0007\u0002G*\tA-A\u0003tG\u0006d\u0017-\u0003\u0002gG\n1\u0011I\\=SK\u001a\u0004\"\u0001[6\u000e\u0003%T!A\u001b.\u0002\u0011%tG/\u001a:oC2L!\u0001\\5\u0003\u000f1{wmZ5oO\u0006!1m\u001c8g\u0007\u0001\u0001\"\u0001]9\u000e\u0003iK!A\u001d.\u0003\u0013M\u0003\u0018M]6D_:4\u0017A\u0002\u001fj]&$h\b\u0006\u0002voB\u0011a\u000fA\u0007\u00021\")QN\u0001a\u0001_\u0006\u0011R.\u0019=CY>\u001c7nU5{KR{\u0007+^:i!\t\u0011'0\u0003\u0002|G\n!Aj\u001c8h\u0003Ei\u0017\r\u001f\"m_\u000e\\')\u0019;dQNK'0Z\u0001\u0011[\u0006D()\u001f;fg&sg\t\\5hQR\fq\"\\1y%\u0016\f8/\u00138GY&<\u0007\u000e\u001e\t\u0004E\u0006\u0005\u0011bAA\u0002G\n\u0019\u0011J\u001c;\u000275\f\u0007P\u00117pG.\u001c\u0018J\u001c$mS\u001eDG\u000fU3s\u0003\u0012$'/Z:t\u00035\u0011\u0017\u0010^3t\u0013:4E.[4ii\u0006a!/Z9t\u0013:4E.[4ii\u0006Yb.^7CY>\u001c7n]%o\r2Lw\r\u001b;QKJ\fE\r\u001a:fgN\u0004r!a\u0004\u0002\u001a\u0005uq0\u0004\u0002\u0002\u0012)!\u00111CA\u000b\u0003\u001diW\u000f^1cY\u0016T1!a\u0006d\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u00037\t\tBA\u0004ICNDW*\u00199\u0011\t\u0005}\u0011QE\u0007\u0003\u0003CQ1!a\t[\u0003\u001d\u0019Ho\u001c:bO\u0016LA!a\n\u0002\"\tq!\t\\8dW6\u000bg.Y4fe&#\u0017\u0001\u00063fM\u0016\u0014(/\u001a3QkND'+Z9vKN$8\u000f\u0005\u0005\u0002\u0010\u0005e\u0011QDA\u0017!\u0019\ty!a\f\u00024%!\u0011\u0011GA\t\u0005\u0015\tV/Z;f!\r\t)$\b\b\u0004\u0003oQb\u0002BA\u001d\u0003\u0017rA!a\u000f\u0002J9!\u0011QHA$\u001d\u0011\ty$!\u0012\u000e\u0005\u0005\u0005#bAA\"]\u00061AH]8pizJ\u0011aX\u0005\u0003;zK!a\u0017/\n\u0005eS\u0016AE*ik\u001a4G.\u001a\"m_\u000e\\\u0007+^:iKJ\u0004\"A^\u000e\u0014\u0005m\tGCAA(\u0005-\u0001Vo\u001d5SKF,Xm\u001d;\u0014\ru\t\u0017\u0011LA0!\r\u0011\u00171L\u0005\u0004\u0003;\u001a'a\u0002)s_\u0012,8\r\u001e\t\u0005\u0003C\nYG\u0004\u0003\u0002d\u0005\u001dd\u0002BA \u0003KJ\u0011\u0001Z\u0005\u0004\u0003S\u001a\u0017a\u00029bG.\fw-Z\u0005\u0005\u0003[\nyG\u0001\u0007TKJL\u0017\r\\5{C\ndWMC\u0002\u0002j\r\fq!\u00193ee\u0016\u001c8/\u0006\u0002\u0002\u001e\u0005A\u0011\r\u001a3sKN\u001c\b%\u0001\u0004cY>\u001c7n]\u000b\u0003\u0003w\u0002b!!\u0019\u0002~\u0005\u0005\u0015\u0002BA@\u0003_\u00121aU3r!\u0019\u0011\u00171QAD\u007f&\u0019\u0011QQ2\u0003\rQ+\b\u000f\\33!\u0011\ty\"!#\n\t\u0005-\u0015\u0011\u0005\u0002\b\u00052|7m[%e\u0003\u001d\u0011Gn\\2lg\u0002\n\u0011B]3r\u0005V4g-\u001a:\u0016\u0005\u0005M\u0005\u0003BAK\u0003?k!!a&\u000b\t\u0005e\u00151T\u0001\u0007EV4g-\u001a:\u000b\u0007\u0005u%,A\u0004oKR<xN]6\n\t\u0005\u0005\u0016q\u0013\u0002\u000e\u001b\u0006t\u0017mZ3e\u0005V4g-\u001a:\u0002\u0015I,\u0017OQ;gM\u0016\u0014\b\u0005\u0006\u0005\u0002(\u0006-\u0016QVAX!\r\tI+H\u0007\u00027!9\u0011\u0011\u000f\u0013A\u0002\u0005u\u0001bBA<I\u0001\u0007\u00111\u0010\u0005\b\u0003\u001f#\u0003\u0019AAJ\u0003\u0011\u0019\u0018N_3\u0016\u0003}\fQa]5{K\u0002\nAaY8qsRA\u0011qUA^\u0003{\u000by\fC\u0005\u0002r\u001d\u0002\n\u00111\u0001\u0002\u001e!I\u0011qO\u0014\u0011\u0002\u0003\u0007\u00111\u0010\u0005\n\u0003\u001f;\u0003\u0013!a\u0001\u0003'\u000babY8qs\u0012\"WMZ1vYR$\u0013'\u0006\u0002\u0002F*\"\u0011QDAdW\t\tI\r\u0005\u0003\u0002L\u0006UWBAAg\u0015\u0011\ty-!5\u0002\u0013Ut7\r[3dW\u0016$'bAAjG\u0006Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005]\u0017Q\u001a\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017AD2paf$C-\u001a4bk2$HEM\u000b\u0003\u0003;TC!a\u001f\u0002H\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\u001aTCAArU\u0011\t\u0019*a2\u0002\u001bA\u0014x\u000eZ;diB\u0013XMZ5y+\t\tI\u000f\u0005\u0003\u0002l\u0006UXBAAw\u0015\u0011\ty/!=\u0002\t1\fgn\u001a\u0006\u0003\u0003g\fAA[1wC&!\u0011q_Aw\u0005\u0019\u0019FO]5oO\u0006a\u0001O]8ek\u000e$\u0018I]5us\u0006q\u0001O]8ek\u000e$X\t\\3nK:$H\u0003BA\u0000\u0005\u000b\u00012A\u0019B\u0001\u0013\r\u0011\u0019a\u0019\u0002\u0004\u0003:L\b\u0002\u0003B\u0004[\u0005\u0005\t\u0019A@\u0002\u0007a$\u0013'A\bqe>$Wo\u0019;Ji\u0016\u0014\u0018\r^8s+\t\u0011i\u0001\u0005\u0004\u0003\u0010\tE\u0011q`\u0007\u0003\u0003+IAAa\u0005\u0002\u0016\tA\u0011\n^3sCR|'/\u0001\u0005dC:,\u0015/^1m)\u0011\u0011IBa\b\u0011\u0007\t\u0014Y\"C\u0002\u0003\u001e\r\u0014qAQ8pY\u0016\fg\u000eC\u0005\u0003\b=\n\t\u00111\u0001\u0002\u0000\u0006\u0011\u0002O]8ek\u000e$X\t\\3nK:$h*Y7f)\u0011\tIO!\n\t\u0011\t\u001d\u0001'!AA\u0002}\f\u0001\u0002[1tQ\u000e{G-\u001a\u000b\u0002\u007f\u0006AAo\\*ue&tw\r\u0006\u0002\u0002j\u00061Q-];bYN$BA!\u0007\u00034!I!qA\u001a\u0002\u0002\u0003\u0007\u0011q`\u0001\f!V\u001c\bNU3rk\u0016\u001cH\u000fE\u0002\u0002*V\u001aR!\u000eB\u001e\u0005\u000f\u0002BB!\u0010\u0003D\u0005u\u00111PAJ\u0003Ok!Aa\u0010\u000b\u0007\t\u00053-A\u0004sk:$\u0018.\\3\n\t\t\u0015#q\b\u0002\u0012\u0003\n\u001cHO]1di\u001a+hn\u0019;j_:\u001c\u0004\u0003\u0002B%\u0005\u001fj!Aa\u0013\u000b\t\t5\u0013\u0011_\u0001\u0003S>LA!!\u001c\u0003LQ\u0011!qG\u0001\u0006CB\u0004H.\u001f\u000b\t\u0003O\u00139F!\u0017\u0003\\!9\u0011\u0011\u000f\u001dA\u0002\u0005u\u0001bBA<q\u0001\u0007\u00111\u0010\u0005\b\u0003\u001fC\u0004\u0019AAJ\u0003\u001d)h.\u00199qYf$BA!\u0019\u0003nA)!Ma\u0019\u0003h%\u0019!QM2\u0003\r=\u0003H/[8o!%\u0011'\u0011NA\u000f\u0003w\n\u0019*C\u0002\u0003l\r\u0014a\u0001V;qY\u0016\u001c\u0004\"\u0003B8s\u0005\u0005\t\u0019AAT\u0003\rAH\u0005M\u0001\roJLG/\u001a*fa2\f7-\u001a\u000b\u0003\u0005k\u0002B!a;\u0003x%!!\u0011PAw\u0005\u0019y%M[3di\nQ\u0001+^:i%\u0016\u001cX\u000f\u001c;\u0014\rm\n\u0017\u0011LA0\u0003\u001d\u0011Gn\\2l\u0013\u0012,\"Aa!\u0011\t\t\u0015%Q\u0012\b\u0005\u0005\u000f\u0013I\tE\u0002\u0002@\rL1Aa#d\u0003\u0019\u0001&/\u001a3fM&!\u0011q\u001fBH\u0015\r\u0011YiY\u0001\tE2|7m[%eA\u00059a-Y5mkJ,WC\u0001BL!\u0011\t\tG!'\n\t\tm\u0015q\u000e\u0002\n)\"\u0014xn^1cY\u0016\f\u0001BZ1jYV\u0014X\r\t\u000b\u0007\u0005C\u0013\u0019K!*\u0011\u0007\u0005%6\bC\u0004\u0003\u0000\u0001\u0003\rAa!\t\u000f\tM\u0005\t1\u0001\u0003\u0018R1!\u0011\u0015BU\u0005WC\u0011Ba B!\u0003\u0005\rAa!\t\u0013\tM\u0015\t%AA\u0002\t]UC\u0001BXU\u0011\u0011\u0019)a2\u0016\u0005\tM&\u0006\u0002BL\u0003\u000f$B!a@\u00038\"A!q\u0001$\u0002\u0002\u0003\u0007q\u0010\u0006\u0003\u0003\u001a\tm\u0006\"\u0003B\u0004\u0011\u0006\u0005\t\u0019AA\u0000)\u0011\tIOa0\t\u0011\t\u001d\u0011*!AA\u0002}$BA!\u0007\u0003D\"I!q\u0001'\u0002\u0002\u0003\u0007\u0011q`\u0001\u000b!V\u001c\bNU3tk2$\bcAAU\u001dN)aJa3\u0003HAQ!Q\bBg\u0005\u0007\u00139J!)\n\t\t='q\b\u0002\u0012\u0003\n\u001cHO]1di\u001a+hn\u0019;j_:\u0014DC\u0001Bd)\u0019\u0011\tK!6\u0003X\"9!qP)A\u0002\t\r\u0005b\u0002BJ#\u0002\u0007!q\u0013\u000b\u0005\u00057\u0014y\u000eE\u0003c\u0005G\u0012i\u000eE\u0004c\u0003\u0007\u0013\u0019Ia&\t\u0013\t=$+!AA\u0002\t\u0005\u0016!\u0005\"M\u001f\u000e[u\fU+T\u0011\u0016\u0013v\fU(P\u0019V\u0011!Q\u001d\t\u0005\u0005O\u0014\t0\u0004\u0002\u0003j*!!1\u001eBw\u0003)\u0019wN\\2veJ,g\u000e\u001e\u0006\u0005\u0005_\f\t0\u0001\u0003vi&d\u0017\u0002\u0002Bz\u0005S\u0014q\"\u0012=fGV$xN]*feZL7-Z\u0001\u0013\u00052{5iS0Q+NCUIU0Q\u001f>c\u0005%\u0001\u0003ti>\u0004HC\u0001B~!\r\u0011'Q`\u0005\u0004\u0005\u007f\u001c'\u0001B+oSR\fA\u0002];tQJ+\u0017/^3tiN\fA\"\u001a:s_JD\u0015M\u001c3mKJ\u0004Baa\u0002\u0004\u00189!1\u0011BB\t\u001d\u0011\u0019Yaa\u0004\u000f\t\u0005e2QB\u0005\u0004\u0003;S\u0016bA-\u0002\u001c&!11CB\u000b\u00031)%O]8s\u0011\u0006tG\r\\3s\u0015\rI\u00161T\u0005\u0005\u00073\u0019YBA\u000bCY>\u001c7\u000eU;tQ\u0016\u0013(o\u001c:IC:$G.\u001a:\u000b\t\rM1QC\u0001\u0015k:\u0014X-Y2iC\ndWM\u00117pG.luM]:\u0016\u0005\r\u0005\u0002CBA\b\u0007G\ti\"\u0003\u0003\u0004&\u0005E!a\u0002%bg\"\u001cV\r^\u0001\u0016k:\u0014X-Y2iC\ndWM\u00117pG.luM]:!\u0003I\u0019'/Z1uK\u0016\u0013(o\u001c:IC:$G.\u001a:\u0015\u0005\r\u0015\u0011!E5oSRL\u0017\r^3CY>\u001c7\u000eU;tQRQ!1`B\u0019\u0007w\u0019)e!\u001c\t\u000f\rM\u0012\u00031\u0001\u00046\u0005AA-\u0019;b\r&dW\r\u0005\u0003\u0003J\r]\u0012\u0002BB\u001d\u0005\u0017\u0012AAR5mK\"91QH\tA\u0002\r}\u0012\u0001\u00059beRLG/[8o\u0019\u0016tw\r\u001e5t!\u0011\u00117\u0011I=\n\u0007\r\r3MA\u0003BeJ\f\u0017\u0010C\u0004\u0004HE\u0001\ra!\u0013\u0002\u0007\u0011,\u0007\u000f\r\u0005\u0004L\rU31MB5!%\u00018QJB)\u0007C\u001a9'C\u0002\u0004Pi\u0013\u0011c\u00155vM\u001adW\rR3qK:$WM\\2z!\u0011\u0019\u0019f!\u0016\r\u0001\u0011a1qKB#\u0003\u0003\u0005\tQ!\u0001\u0004Z\t\u0019q\fJ\u0019\u0012\t\rm\u0013q \t\u0004E\u000eu\u0013bAB0G\n9aj\u001c;iS:<\u0007\u0003BB*\u0007G\"Ab!\u001a\u0004F\u0005\u0005\t\u0011!B\u0001\u00073\u00121a\u0018\u00133!\u0011\u0019\u0019f!\u001b\u0005\u0019\r-4QIA\u0001\u0002\u0003\u0015\ta!\u0017\u0003\u0007}#3\u0007\u0003\u0004\u0004pE\u0001\ra`\u0001\t[\u0006\u0004\u0018J\u001c3fq\u0006qAO]=QkNDW\u000b\u001d+p\u001b\u0006D\u0018AC:vE6LG\u000fV1tWR!!1`B<\u0011\u001d\u0019Ih\u0005a\u0001\u0007w\nA\u0001^1tWB!\u00111^B?\u0013\u0011\u0019y(!<\u0003\u0011I+hN\\1cY\u0016\f1\u0002];tQV\u0003Hk\\'bq\u0006Y1/\u001a8e%\u0016\fX/Z:u)\u0011\u0011Ypa\"\t\u000f\r%U\u00031\u0001\u00024\u00059!/Z9vKN$\u0018AH:mS\u000e,'+Z9Ck\u001a4WM]%oi>\u0014En\\2l\u0005V4g-\u001a:t)\u0019\u0019yi!%\u0004\u0014B)!m!\u0011\u0002\u0014\"9\u0011q\u0012\fA\u0002\u0005M\u0005bBBK-\u0001\u00071qS\u0001\u000bE2|7m[*ju\u0016\u001c\b#BA1\u0003{z\u0018!H;qI\u0006$Xm\u0015;bi\u0016\fe\u000eZ\"iK\u000e\\\u0017J\u001a)vg\"luN]3\u0015\u0015\te1QTBQ\u0007G\u001bI\u000b\u0003\u0004\u0004 ^\u0001\r!_\u0001\fEf$Xm\u001d)vg\",G\rC\u0004\u0002r]\u0001\r!!\b\t\u000f\r\u0015v\u00031\u0001\u0004(\u0006y!/Z7bS:Lgn\u001a\"m_\u000e\\7\u000f\u0005\u0004\u0002\u0010\r\r\"1\u0011\u0005\b\u0007W;\u0002\u0019ABW\u0003)\u0001Xo\u001d5SKN,H\u000e\u001e\t\u0004\u0003kY\u0014\u0001\u00079sKB\f'/\u001a\"m_\u000e\\\u0007+^:i%\u0016\fX/Z:ugR\u001121WB[\u0007s\u001bil!1\u0004F\u000e\u001d7\u0011ZBh!\u0019\t\t'! \u00024!11q\u0017\rA\u0002}\fQB\\;n!\u0006\u0014H/\u001b;j_:\u001c\bBBB^1\u0001\u0007q0A\u0006qCJ$\u0018\u000e^5p]&#\u0007BBB`1\u0001\u0007q0A\u0005tQV4g\r\\3JI\"111\u0019\rA\u0002}\fab\u001d5vM\u001adW-T3sO\u0016LE\rC\u0004\u00044a\u0001\ra!\u000e\t\u000f\ru\u0002\u00041\u0001\u0004@!911\u001a\rA\u0002\r5\u0017AC7fe\u001e,'\u000fT8dgB1\u0011\u0011MA?\u0003;Aqa!5\u0019\u0001\u0004\u0019\u0019.A\u0007ue\u0006t7\u000f]8si\u000e{gN\u001a\t\u0005\u0007+\u001cI.\u0004\u0002\u0004X*!!q^AN\u0013\u0011\u0019Yna6\u0003\u001bQ\u0013\u0018M\\:q_J$8i\u001c8g\u0003M\u0019'/Z1uKJ+\u0017/^3ti\n+hMZ3s))\t\u0019j!9\u0004d\u000e\u00158\u0011\u001e\u0005\u0007[f\u0001\raa5\t\u000f\rM\u0012\u00041\u0001\u00046!11q]\rA\u0002e\faa\u001c4gg\u0016$\bBBBv3\u0001\u0007\u00110\u0001\u0004mK:<G\u000f\u001b\u0015\u0006\u0001\r=8\u0011 \t\u0005\u0007c\u001c)0\u0004\u0002\u0004t*\u0019\u00111\u001b.\n\t\r]81\u001f\u0002\u0006'&t7-Z\u0011\u0003\u0007w\fQa\r\u00183]A\u0002")
public class ShuffleBlockPusher
implements Logging {
    private final SparkConf conf;
    private final long maxBlockSizeToPush;
    private final long maxBlockBatchSize;
    private final long maxBytesInFlight;
    private final int maxReqsInFlight;
    private final int maxBlocksInFlightPerAddress;
    private long bytesInFlight;
    private int reqsInFlight;
    private final HashMap<BlockManagerId, Object> numBlocksInFlightPerAddress;
    private final HashMap<BlockManagerId, Queue<PushRequest>> deferredPushRequests;
    private final Queue<PushRequest> pushRequests;
    public final ErrorHandler.BlockPushErrorHandler org$apache$spark$shuffle$ShuffleBlockPusher$$errorHandler;
    private final HashSet<BlockManagerId> unreachableBlockMgrs;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    @Override
    public String logName() {
        return Logging.logName$(this);
    }

    @Override
    public Logger log() {
        return Logging.log$(this);
    }

    @Override
    public void logInfo(Function0<String> msg) {
        Logging.logInfo$(this, msg);
    }

    @Override
    public void logDebug(Function0<String> msg) {
        Logging.logDebug$(this, msg);
    }

    @Override
    public void logTrace(Function0<String> msg) {
        Logging.logTrace$(this, msg);
    }

    @Override
    public void logWarning(Function0<String> msg) {
        Logging.logWarning$(this, msg);
    }

    @Override
    public void logError(Function0<String> msg) {
        Logging.logError$(this, msg);
    }

    @Override
    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$(this, msg, throwable);
    }

    @Override
    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$(this, msg, throwable);
    }

    @Override
    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$(this, msg, throwable);
    }

    @Override
    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$(this, msg, throwable);
    }

    @Override
    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$(this, msg, throwable);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$(this, isInterpreter);
    }

    @Override
    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$(this, isInterpreter, silent);
    }

    @Override
    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$(this);
    }

    @Override
    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$(this, isInterpreter, silent);
    }

    @Override
    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    @Override
    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public HashSet<BlockManagerId> unreachableBlockMgrs() {
        return this.unreachableBlockMgrs;
    }

    public ErrorHandler.BlockPushErrorHandler createErrorHandler() {
        return new ErrorHandler.BlockPushErrorHandler(null){

            public boolean shouldRetryError(Throwable t) {
                if (t.getCause() != null && t.getCause() instanceof FileNotFoundException) {
                    return false;
                }
                return !(t instanceof BlockPushNonFatalFailure) || !BlockPushNonFatalFailure.shouldNotRetryErrorCode((BlockPushNonFatalFailure.ReturnCode)((BlockPushNonFatalFailure)t).getReturnCode());
            }
        };
    }

    public void initiateBlockPush(File dataFile, long[] partitionLengths, ShuffleDependency<?, ?, ?> dep, int mapIndex) {
        int numPartitions = dep.partitioner().numPartitions();
        TransportConf transportConf = SparkTransportConf$.MODULE$.fromSparkConf(this.conf, "shuffle", SparkTransportConf$.MODULE$.fromSparkConf$default$3(), SparkTransportConf$.MODULE$.fromSparkConf$default$4());
        Seq<PushRequest> requests = this.prepareBlockPushRequests(numPartitions, mapIndex, dep.shuffleId(), dep.shuffleMergeId(), dataFile, partitionLengths, dep.getMergerLocs(), transportConf);
        this.pushRequests.$plus$plus$eq(Utils$.MODULE$.randomize(requests, ClassTag$.MODULE$.apply(PushRequest.class)));
        this.submitTask(() -> this.tryPushUpToMax());
    }

    public void tryPushUpToMax() {
        try {
            this.pushUpToMax();
        }
        catch (FileNotFoundException e) {
            this.logWarning((Function0<String>)(Function0 & Serializable)() -> "The shuffle files got deleted when this shuffle-block-push-thread was reading from them which could happen when the job finishes and the driver instructs the executor to cleanup the shuffle. In this case, push of the blocks belonging to this shuffle will stop.", e);
        }
    }

    public void submitTask(Runnable task) {
        block0: {
            if (ShuffleBlockPusher$.MODULE$.org$apache$spark$shuffle$ShuffleBlockPusher$$BLOCK_PUSHER_POOL() == null) break block0;
            ShuffleBlockPusher$.MODULE$.org$apache$spark$shuffle$ShuffleBlockPusher$$BLOCK_PUSHER_POOL().execute(task);
        }
    }

    private synchronized void pushUpToMax() {
        if (this.deferredPushRequests.nonEmpty()) {
            this.deferredPushRequests.withFilter((Function1 & Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)ShuffleBlockPusher.$anonfun$pushUpToMax$1(check$ifrefutable$1))).foreach((Function1 & Serializable)x$1 -> {
                ShuffleBlockPusher.$anonfun$pushUpToMax$2(this, x$1);
                return BoxedUnit.UNIT;
            });
        }
        while (this.isRemoteBlockPushable$1(this.pushRequests)) {
            BoxedUnit boxedUnit;
            PushRequest request = (PushRequest)this.pushRequests.dequeue();
            BlockManagerId remoteAddress = request.address();
            if (this.isRemoteAddressMaxedOut$1(remoteAddress, request)) {
                this.logDebug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(40).append("Deferring push request for ").append(remoteAddress).append(" with ").append(request.blocks().size()).append(" blocks").toString());
                boxedUnit = ((Queue)this.deferredPushRequests.getOrElseUpdate((Object)remoteAddress, (Function0 & Serializable)() -> new Queue(Queue$.MODULE$.$lessinit$greater$default$1()))).enqueue((Object)request);
                continue;
            }
            this.sendRequest(request);
            boxedUnit = BoxedUnit.UNIT;
        }
    }

    private void sendRequest(PushRequest request) {
        this.bytesInFlight += (long)request.size();
        ++this.reqsInFlight;
        this.numBlocksInFlightPerAddress.update((Object)request.address(), (Object)BoxesRunTime.boxToInteger((int)(BoxesRunTime.unboxToInt((Object)this.numBlocksInFlightPerAddress.getOrElseUpdate((Object)request.address(), (Function0)(JFunction0.mcI.sp & Serializable)() -> 0)) + request.blocks().length())));
        Map sizeMap = ((IterableOnceOps)request.blocks().map((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            BlockId blockId = (BlockId)tuple2._1();
            int size = tuple2._2$mcI$sp();
            Tuple2 tuple22 = new Tuple2((Object)blockId.toString(), (Object)BoxesRunTime.boxToInteger((int)size));
            return tuple22;
        })).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        BlockManagerId address = request.address();
        Seq blockIds = (Seq)request.blocks().map((Function1 & Serializable)x$2 -> ((BlockId)x$2._1()).toString());
        HashSet remainingBlocks = (HashSet)new HashSet().$plus$plus$eq((IterableOnce)blockIds);
        BlockPushingListener blockPushListener = new BlockPushingListener(this, sizeMap, address, remainingBlocks){
            private final /* synthetic */ ShuffleBlockPusher $outer;
            private final Map sizeMap$1;
            private final BlockManagerId address$1;
            private final HashSet remainingBlocks$1;

            public void onBlockTransferSuccess(String x$1, ManagedBuffer x$2) {
                super.onBlockTransferSuccess(x$1, x$2);
            }

            public void onBlockTransferFailure(String x$1, Throwable x$2) {
                super.onBlockTransferFailure(x$1, x$2);
            }

            public String getTransferType() {
                return super.getTransferType();
            }

            public void handleResult(PushResult result) {
                this.$outer.submitTask(() -> {
                    block0: {
                        if (!$this.$outer.org$apache$spark$shuffle$ShuffleBlockPusher$$updateStateAndCheckIfPushMore(BoxesRunTime.unboxToInt((Object)$this.sizeMap$1.apply((Object)result.blockId())), $this.address$1, (HashSet<String>)$this.remainingBlocks$1, result)) break block0;
                        $this.$outer.tryPushUpToMax();
                    }
                });
            }

            public void onBlockPushSuccess(String blockId, ManagedBuffer data) {
                this.$outer.logTrace((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(31).append("Push for block ").append(blockId).append(" to ").append($this.address$1).append(" successful.").toString());
                this.handleResult(new PushResult(blockId, null));
            }

            public void onBlockPushFailure(String blockId, Throwable exception) {
                if (!this.$outer.org$apache$spark$shuffle$ShuffleBlockPusher$$errorHandler.shouldLogError(exception)) {
                    this.$outer.logTrace((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(26).append("Pushing block ").append(blockId).append(" to ").append($this.address$1).append(" failed.").toString(), exception);
                } else {
                    this.$outer.logWarning((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(26).append("Pushing block ").append(blockId).append(" to ").append($this.address$1).append(" failed.").toString(), exception);
                }
                this.handleResult(new PushResult(blockId, exception));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.sizeMap$1 = sizeMap$1;
                this.address$1 = address$1;
                this.remainingBlocks$1 = remainingBlocks$1;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$onBlockPushFailure$1(org.apache.spark.shuffle.ShuffleBlockPusher$$anon$2 java.lang.String ), $anonfun$onBlockPushFailure$2(org.apache.spark.shuffle.ShuffleBlockPusher$$anon$2 java.lang.String ), $anonfun$onBlockPushSuccess$1(org.apache.spark.shuffle.ShuffleBlockPusher$$anon$2 java.lang.String )}, serializedLambda);
            }
        };
        Tuple2 tuple2 = Utils$.MODULE$.randomize((IterableOnce)blockIds.zip((IterableOnce)Predef$.MODULE$.wrapRefArray((Object[])this.sliceReqBufferIntoBlockBuffers(request.reqBuffer(), (Seq<Object>)((Seq)request.blocks().map((Function1 & Serializable)x$3 -> BoxesRunTime.boxToInteger((int)x$3._2$mcI$sp())))))), ClassTag$.MODULE$.apply(Tuple2.class)).unzip(Predef$.MODULE$.$conforms());
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Seq blockPushIds = (Seq)tuple2._1();
        Seq blockPushBuffers = (Seq)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)blockPushIds, (Object)blockPushBuffers);
        Tuple2 tuple23 = tuple22;
        Seq blockPushIds2 = (Seq)tuple23._1();
        Seq blockPushBuffers2 = (Seq)tuple23._2();
        SparkEnv$.MODULE$.get().blockManager().blockStoreClient().pushBlocks(address.host(), address.port(), (String[])blockPushIds2.toArray(ClassTag$.MODULE$.apply(String.class)), (ManagedBuffer[])blockPushBuffers2.toArray(ClassTag$.MODULE$.apply(ManagedBuffer.class)), blockPushListener);
    }

    private ManagedBuffer[] sliceReqBufferIntoBlockBuffers(ManagedBuffer reqBuffer, Seq<Object> blockSizes) {
        ManagedBuffer[] managedBufferArray;
        if (blockSizes.size() == 1) {
            managedBufferArray = (ManagedBuffer[])((Object[])new ManagedBuffer[]{reqBuffer});
        } else {
            ByteBuffer inMemoryBuffer = reqBuffer.nioByteBuffer();
            int[] blockOffsets = new int[blockSizes.size()];
            IntRef offset = IntRef.create((int)0);
            blockSizes.indices().foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)index -> {
                blockOffsets$1[index] = offset$1.elem;
                offset$1.elem += BoxesRunTime.unboxToInt((Object)blockSizes.apply(index));
            });
            managedBufferArray = (ManagedBuffer[])ArrayOps$.MODULE$.toArray$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.zip$extension(Predef$.MODULE$.intArrayOps(blockOffsets), blockSizes)), (Function1 & Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                int offset = tuple2._1$mcI$sp();
                int size = tuple2._2$mcI$sp();
                NioManagedBuffer nioManagedBuffer = new NioManagedBuffer(((ByteBuffer)inMemoryBuffer.duplicate().position(offset).limit(offset + size)).slice());
                return nioManagedBuffer;
            }, ClassTag$.MODULE$.apply(NioManagedBuffer.class))), ClassTag$.MODULE$.apply(ManagedBuffer.class));
        }
        return managedBufferArray;
    }

    public synchronized boolean org$apache$spark$shuffle$ShuffleBlockPusher$$updateStateAndCheckIfPushMore(long bytesPushed, BlockManagerId address, HashSet<String> remainingBlocks, PushResult pushResult) {
        remainingBlocks.$minus$eq((Object)pushResult.blockId());
        this.bytesInFlight -= bytesPushed;
        this.numBlocksInFlightPerAddress.update((Object)address, (Object)BoxesRunTime.boxToInteger((int)(BoxesRunTime.unboxToInt((Object)this.numBlocksInFlightPerAddress.apply((Object)address)) - 1)));
        if (remainingBlocks.isEmpty()) {
            --this.reqsInFlight;
        }
        if (pushResult.failure() != null && pushResult.failure().getCause() instanceof ConnectException && !this.unreachableBlockMgrs().contains((Object)address)) {
            IntRef removed = IntRef.create((int)0);
            this.unreachableBlockMgrs().add((Object)address);
            removed.elem += this.pushRequests.dequeueAll((Function1 & Serializable)req -> BoxesRunTime.boxToBoolean((boolean)ShuffleBlockPusher.$anonfun$updateStateAndCheckIfPushMore$1(address, req))).length();
            removed.elem += BoxesRunTime.unboxToInt((Object)this.deferredPushRequests.remove((Object)address).map((Function1 & Serializable)x$5 -> BoxesRunTime.boxToInteger((int)x$5.length())).getOrElse((Function0)(JFunction0.mcI.sp & Serializable)() -> 0));
            this.logWarning((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(0).append(new StringBuilder(35).append("Received a ConnectException from ").append(address).append(". ").toString()).append(new StringBuilder(28).append("Dropping ").append(removed$1.elem).append(" push-requests and ").toString()).append("not pushing any more blocks to this address.").toString());
        }
        if (pushResult.failure() != null && !this.org$apache$spark$shuffle$ShuffleBlockPusher$$errorHandler.shouldRetryError(pushResult.failure())) {
            this.logDebug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(0).append(new StringBuilder(66).append("Encountered an exception from ").append(address).append(" which indicates that push needs to ").toString()).append("stop.").toString());
            return false;
        }
        return remainingBlocks.isEmpty() && (this.pushRequests.nonEmpty() || this.deferredPushRequests.nonEmpty());
    }

    public Seq<PushRequest> prepareBlockPushRequests(int numPartitions, int partitionId, int shuffleId, int shuffleMergeId, File dataFile, long[] partitionLengths, Seq<BlockManagerId> mergerLocs, TransportConf transportConf) {
        LongRef offset = LongRef.create((long)0L);
        IntRef currentReqSize = IntRef.create((int)0);
        LongRef currentReqOffset = LongRef.create((long)0L);
        IntRef currentMergerId = IntRef.create((int)0);
        int numMergers = mergerLocs.length();
        ArrayBuffer requests = new ArrayBuffer();
        ObjectRef blocks = ObjectRef.create((Object)new ArrayBuffer());
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), numPartitions).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)reduceId -> {
            long blockSize = partitionLengths[reduceId];
            this.logDebug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(18).append("Block ").append(new ShufflePushBlockId(shuffleId, shuffleMergeId, partitionId, reduceId)).append(" is of size ").append(blockSize).toString());
            if (blockSize > 0L) {
                int mergerId = (int)package$.MODULE$.min(package$.MODULE$.floor((double)reduceId * 1.0 / (double)numPartitions * (double)numMergers), (double)(numMergers - 1));
                if ((long)currentReqSize$1.elem + blockSize <= $this.maxBlockBatchSize && ((ArrayBuffer)blocks$1.elem).size() < $this.maxBlocksInFlightPerAddress && mergerId == currentMergerId$1.elem && blockSize <= $this.maxBlockSizeToPush) {
                    currentReqSize$1.elem += (int)blockSize;
                } else {
                    if (((ArrayBuffer)blocks$1.elem).nonEmpty()) {
                        requests.$plus$eq((Object)new PushRequest((BlockManagerId)mergerLocs.apply(currentMergerId$1.elem), (Seq<Tuple2<BlockId, Object>>)((ArrayBuffer)blocks$1.elem).toSeq(), this.createRequestBuffer(transportConf, dataFile, currentReqOffset$1.elem, currentReqSize$1.elem)));
                        blocks$1.elem = new ArrayBuffer();
                    }
                    currentReqSize$1.elem = 0;
                    currentReqOffset$1.elem = -1L;
                    currentMergerId$1.elem = mergerId;
                }
                if (blockSize <= $this.maxBlockSizeToPush) {
                    int blockSizeInt = (int)blockSize;
                    ((ArrayBuffer)blocks$1.elem).$plus$eq((Object)new Tuple2((Object)new ShufflePushBlockId(shuffleId, shuffleMergeId, partitionId, reduceId), (Object)BoxesRunTime.boxToInteger((int)blockSizeInt)));
                    if (currentReqOffset$1.elem == -1L) {
                        currentReqOffset$1.elem = offset$2.elem;
                    }
                    if (currentReqSize$1.elem == 0) {
                        currentReqSize$1.elem += blockSizeInt;
                    }
                }
            }
            offset$2.elem += blockSize;
        });
        Object object = ((ArrayBuffer)blocks.elem).nonEmpty() ? requests.$plus$eq((Object)new PushRequest((BlockManagerId)mergerLocs.apply(currentMergerId.elem), (Seq<Tuple2<BlockId, Object>>)((ArrayBuffer)blocks.elem).toSeq(), this.createRequestBuffer(transportConf, dataFile, currentReqOffset.elem, currentReqSize.elem))) : BoxedUnit.UNIT;
        return requests.toSeq();
    }

    public ManagedBuffer createRequestBuffer(TransportConf conf, File dataFile, long offset, long length) {
        return new FileSegmentManagedBuffer(conf, dataFile, offset, length);
    }

    public static final /* synthetic */ boolean $anonfun$pushUpToMax$1(Tuple2 check$ifrefutable$1) {
        Tuple2 tuple2 = check$ifrefutable$1;
        boolean bl = tuple2 != null;
        return bl;
    }

    public static final /* synthetic */ void $anonfun$pushUpToMax$2(ShuffleBlockPusher $this, Tuple2 x$1) {
        Tuple2 tuple2 = x$1;
        if (tuple2 != null) {
            BlockManagerId remoteAddress = (BlockManagerId)tuple2._1();
            Queue defReqQueue = (Queue)tuple2._2();
            while ($this.isRemoteBlockPushable$1(defReqQueue) && !$this.isRemoteAddressMaxedOut$1(remoteAddress, (PushRequest)defReqQueue.front())) {
                PushRequest request = (PushRequest)defReqQueue.dequeue();
                $this.logDebug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(0).append(new StringBuilder(43).append("Processing deferred push request for ").append(remoteAddress).append(" with ").toString()).append(new StringBuilder(7).append(request.blocks().length()).append(" blocks").toString()).toString());
                $this.sendRequest(request);
                Object object = defReqQueue.isEmpty() ? $this.deferredPushRequests.$minus$eq((Object)remoteAddress) : BoxedUnit.UNIT;
            }
        } else {
            throw new MatchError((Object)tuple2);
        }
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    private final boolean isRemoteBlockPushable$1(Queue pushReqQueue) {
        return pushReqQueue.nonEmpty() && (this.bytesInFlight == 0L || this.reqsInFlight + 1 <= this.maxReqsInFlight && this.bytesInFlight + (long)((PushRequest)pushReqQueue.front()).size() <= this.maxBytesInFlight);
    }

    private final boolean isRemoteAddressMaxedOut$1(BlockManagerId remoteAddress, PushRequest request) {
        return BoxesRunTime.unboxToInt((Object)this.numBlocksInFlightPerAddress.getOrElse((Object)remoteAddress, (Function0)(JFunction0.mcI.sp & Serializable)() -> 0)) + request.blocks().size() > this.maxBlocksInFlightPerAddress;
    }

    public static final /* synthetic */ boolean $anonfun$updateStateAndCheckIfPushMore$1(BlockManagerId address$2, PushRequest req) {
        BlockManagerId blockManagerId = req.address();
        BlockManagerId blockManagerId2 = address$2;
        return !(blockManagerId != null ? !((Object)blockManagerId).equals(blockManagerId2) : blockManagerId2 != null);
    }

    public ShuffleBlockPusher(SparkConf conf) {
        this.conf = conf;
        Logging.$init$(this);
        this.maxBlockSizeToPush = BoxesRunTime.unboxToLong((Object)conf.get(org.apache.spark.internal.config.package$.MODULE$.SHUFFLE_MAX_BLOCK_SIZE_TO_PUSH()));
        this.maxBlockBatchSize = BoxesRunTime.unboxToLong((Object)conf.get(org.apache.spark.internal.config.package$.MODULE$.SHUFFLE_MAX_BLOCK_BATCH_SIZE_FOR_PUSH()));
        this.maxBytesInFlight = conf.getSizeAsMb("spark.reducer.maxSizeInFlight", "48m") * 1024L * 1024L;
        this.maxReqsInFlight = conf.getInt("spark.reducer.maxReqsInFlight", Integer.MAX_VALUE);
        this.maxBlocksInFlightPerAddress = BoxesRunTime.unboxToInt((Object)conf.get(org.apache.spark.internal.config.package$.MODULE$.REDUCER_MAX_BLOCKS_IN_FLIGHT_PER_ADDRESS()));
        this.bytesInFlight = 0L;
        this.reqsInFlight = 0;
        this.numBlocksInFlightPerAddress = new HashMap();
        this.deferredPushRequests = new HashMap();
        this.pushRequests = new Queue(Queue$.MODULE$.$lessinit$greater$default$1());
        this.org$apache$spark$shuffle$ShuffleBlockPusher$$errorHandler = this.createErrorHandler();
        this.unreachableBlockMgrs = new HashSet();
    }

    public static class PushRequest
    implements Product,
    Serializable {
        private final BlockManagerId address;
        private final Seq<Tuple2<BlockId, Object>> blocks;
        private final ManagedBuffer reqBuffer;
        private final int size;

        public Iterator<String> productElementNames() {
            return Product.productElementNames$((Product)this);
        }

        public BlockManagerId address() {
            return this.address;
        }

        public Seq<Tuple2<BlockId, Object>> blocks() {
            return this.blocks;
        }

        public ManagedBuffer reqBuffer() {
            return this.reqBuffer;
        }

        public int size() {
            return this.size;
        }

        public PushRequest copy(BlockManagerId address, Seq<Tuple2<BlockId, Object>> blocks, ManagedBuffer reqBuffer) {
            return new PushRequest(address, blocks, reqBuffer);
        }

        public BlockManagerId copy$default$1() {
            return this.address();
        }

        public Seq<Tuple2<BlockId, Object>> copy$default$2() {
            return this.blocks();
        }

        public ManagedBuffer copy$default$3() {
            return this.reqBuffer();
        }

        public String productPrefix() {
            return "PushRequest";
        }

        public int productArity() {
            return 3;
        }

        public Object productElement(int x$1) {
            Object object;
            int n = x$1;
            switch (n) {
                case 0: {
                    object = this.address();
                    break;
                }
                case 1: {
                    object = this.blocks();
                    break;
                }
                case 2: {
                    object = this.reqBuffer();
                    break;
                }
                default: {
                    object = Statics.ioobe((int)x$1);
                    break;
                }
            }
            return object;
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof PushRequest;
        }

        public String productElementName(int x$1) {
            String string;
            int n = x$1;
            switch (n) {
                case 0: {
                    string = "address";
                    break;
                }
                case 1: {
                    string = "blocks";
                    break;
                }
                case 2: {
                    string = "reqBuffer";
                    break;
                }
                default: {
                    string = (String)Statics.ioobe((int)x$1);
                    break;
                }
            }
            return string;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof PushRequest)) return false;
            boolean bl = true;
            if (!bl) return false;
            PushRequest pushRequest = (PushRequest)x$1;
            BlockManagerId blockManagerId = this.address();
            BlockManagerId blockManagerId2 = pushRequest.address();
            if (blockManagerId == null) {
                if (blockManagerId2 != null) {
                    return false;
                }
            } else if (!((Object)blockManagerId).equals(blockManagerId2)) return false;
            Seq<Tuple2<BlockId, Object>> seq = this.blocks();
            Seq<Tuple2<BlockId, Object>> seq2 = pushRequest.blocks();
            if (seq == null) {
                if (seq2 != null) {
                    return false;
                }
            } else if (!seq.equals(seq2)) return false;
            ManagedBuffer managedBuffer = this.reqBuffer();
            ManagedBuffer managedBuffer2 = pushRequest.reqBuffer();
            if (managedBuffer == null) {
                if (managedBuffer2 != null) {
                    return false;
                }
            } else if (!managedBuffer.equals(managedBuffer2)) return false;
            if (!pushRequest.canEqual(this)) return false;
            return true;
        }

        public PushRequest(BlockManagerId address, Seq<Tuple2<BlockId, Object>> blocks, ManagedBuffer reqBuffer) {
            this.address = address;
            this.blocks = blocks;
            this.reqBuffer = reqBuffer;
            Product.$init$((Product)this);
            this.size = BoxesRunTime.unboxToInt((Object)((IterableOnceOps)blocks.map((Function1 & Serializable)x$6 -> BoxesRunTime.boxToInteger((int)x$6._2$mcI$sp()))).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
        }
    }

    private static class PushResult
    implements Product,
    Serializable {
        private final String blockId;
        private final Throwable failure;

        public Iterator<String> productElementNames() {
            return Product.productElementNames$((Product)this);
        }

        public String blockId() {
            return this.blockId;
        }

        public Throwable failure() {
            return this.failure;
        }

        public PushResult copy(String blockId, Throwable failure) {
            return new PushResult(blockId, failure);
        }

        public String copy$default$1() {
            return this.blockId();
        }

        public Throwable copy$default$2() {
            return this.failure();
        }

        public String productPrefix() {
            return "PushResult";
        }

        public int productArity() {
            return 2;
        }

        public Object productElement(int x$1) {
            Object object;
            int n = x$1;
            switch (n) {
                case 0: {
                    object = this.blockId();
                    break;
                }
                case 1: {
                    object = this.failure();
                    break;
                }
                default: {
                    object = Statics.ioobe((int)x$1);
                    break;
                }
            }
            return object;
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof PushResult;
        }

        public String productElementName(int x$1) {
            String string;
            int n = x$1;
            switch (n) {
                case 0: {
                    string = "blockId";
                    break;
                }
                case 1: {
                    string = "failure";
                    break;
                }
                default: {
                    string = (String)Statics.ioobe((int)x$1);
                    break;
                }
            }
            return string;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof PushResult)) return false;
            boolean bl = true;
            if (!bl) return false;
            PushResult pushResult = (PushResult)x$1;
            String string = this.blockId();
            String string2 = pushResult.blockId();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            Throwable throwable = this.failure();
            Throwable throwable2 = pushResult.failure();
            if (throwable == null) {
                if (throwable2 != null) {
                    return false;
                }
            } else if (!throwable.equals(throwable2)) return false;
            if (!pushResult.canEqual(this)) return false;
            return true;
        }

        public PushResult(String blockId, Throwable failure) {
            this.blockId = blockId;
            this.failure = failure;
            Product.$init$((Product)this);
        }
    }
}

