/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.shuffle;

import java.io.File;
import java.io.Serializable;
import org.apache.spark.Partition;
import org.apache.spark.ShuffleDependency;
import org.apache.spark.SparkEnv$;
import org.apache.spark.TaskContext;
import org.apache.spark.internal.Logging;
import org.apache.spark.rdd.RDD;
import org.apache.spark.scheduler.MapStatus;
import org.apache.spark.shuffle.IndexShuffleBlockResolver;
import org.apache.spark.shuffle.ShuffleBlockPusher;
import org.apache.spark.shuffle.ShuffleBlockResolver;
import org.apache.spark.shuffle.ShuffleManager;
import org.apache.spark.shuffle.ShuffleWriteMetricsReporter;
import org.apache.spark.shuffle.ShuffleWriter;
import org.slf4j.Logger;
import scala.Function0;
import scala.Option;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0005-4Q\u0001B\u0003\u0001\u000f5AQa\n\u0001\u0005\u0002!BQa\u000b\u0001\u0005\u00121BQA\u000e\u0001\u0005\u0002]\u0012Qc\u00155vM\u001adWm\u0016:ji\u0016\u0004&o\\2fgN|'O\u0003\u0002\u0007\u000f\u000591\u000f[;gM2,'B\u0001\u0005\n\u0003\u0015\u0019\b/\u0019:l\u0015\tQ1\"\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u0019\u0005\u0019qN]4\u0014\t\u0001qA#\t\t\u0003\u001fIi\u0011\u0001\u0005\u0006\u0002#\u0005)1oY1mC&\u00111\u0003\u0005\u0002\u0007\u0003:L(+\u001a4\u0011\u0005UqbB\u0001\f\u001d\u001d\t92$D\u0001\u0019\u0015\tI\"$\u0001\u0004=e>|GOP\u0002\u0001\u0013\u0005\t\u0012BA\u000f\u0011\u0003\u001d\u0001\u0018mY6bO\u0016L!a\b\u0011\u0003\u0019M+'/[1mSj\f'\r\\3\u000b\u0005u\u0001\u0002C\u0001\u0012&\u001b\u0005\u0019#B\u0001\u0013\b\u0003!Ig\u000e^3s]\u0006d\u0017B\u0001\u0014$\u0005\u001daunZ4j]\u001e\fa\u0001P5oSRtD#A\u0015\u0011\u0005)\u0002Q\"A\u0003\u0002+\r\u0014X-\u0019;f\u001b\u0016$(/[2t%\u0016\u0004xN\u001d;feR\u0011Q\u0006\r\t\u0003U9J!aL\u0003\u00037MCWO\u001a4mK^\u0013\u0018\u000e^3NKR\u0014\u0018nY:SKB|'\u000f^3s\u0011\u0015\t$\u00011\u00013\u0003\u001d\u0019wN\u001c;fqR\u0004\"a\r\u001b\u000e\u0003\u001dI!!N\u0004\u0003\u0017Q\u000b7o[\"p]R,\u0007\u0010^\u0001\u0006oJLG/\u001a\u000b\u0007qy\n\u0006-\u001a4\u0011\u0005ebT\"\u0001\u001e\u000b\u0005m:\u0011!C:dQ\u0016$W\u000f\\3s\u0013\ti$HA\u0005NCB\u001cF/\u0019;vg\")qh\u0001a\u0001\u0001\u0006\u0019!\u000f\u001a31\u0005\u0005C\u0005c\u0001\"E\r6\t1I\u0003\u0002@\u000f%\u0011Qi\u0011\u0002\u0004%\u0012#\u0005CA$I\u0019\u0001!\u0011\"\u0013 \u0002\u0002\u0003\u0005)\u0011\u0001&\u0003\u0007}#\u0013'\u0005\u0002L\u001dB\u0011q\u0002T\u0005\u0003\u001bB\u0011qAT8uQ&tw\r\u0005\u0002\u0010\u001f&\u0011\u0001\u000b\u0005\u0002\u0004\u0003:L\b\"\u0002*\u0004\u0001\u0004\u0019\u0016a\u00013faB\"A\u000bW._!\u0015\u0019Tk\u0016.^\u0013\t1vAA\tTQV4g\r\\3EKB,g\u000eZ3oGf\u0004\"a\u0012-\u0005\u0013e\u000b\u0016\u0011!A\u0001\u0006\u0003Q%aA0%eA\u0011qi\u0017\u0003\n9F\u000b\t\u0011!A\u0003\u0002)\u00131a\u0018\u00134!\t9e\fB\u0005`#\u0006\u0005\t\u0011!B\u0001\u0015\n\u0019q\f\n\u001b\t\u000b\u0005\u001c\u0001\u0019\u00012\u0002\u000b5\f\u0007/\u00133\u0011\u0005=\u0019\u0017B\u00013\u0011\u0005\u0011auN\\4\t\u000bE\u001a\u0001\u0019\u0001\u001a\t\u000b\u001d\u001c\u0001\u0019\u00015\u0002\u0013A\f'\u000f^5uS>t\u0007CA\u001aj\u0013\tQwAA\u0005QCJ$\u0018\u000e^5p]\u0002")
public class ShuffleWriteProcessor
implements Serializable,
Logging {
    private transient Logger org$apache$spark$internal$Logging$$log_;

    @Override
    public String logName() {
        return Logging.logName$(this);
    }

    @Override
    public Logger log() {
        return Logging.log$(this);
    }

    @Override
    public void logInfo(Function0<String> msg) {
        Logging.logInfo$(this, msg);
    }

    @Override
    public void logDebug(Function0<String> msg) {
        Logging.logDebug$(this, msg);
    }

    @Override
    public void logTrace(Function0<String> msg) {
        Logging.logTrace$(this, msg);
    }

    @Override
    public void logWarning(Function0<String> msg) {
        Logging.logWarning$(this, msg);
    }

    @Override
    public void logError(Function0<String> msg) {
        Logging.logError$(this, msg);
    }

    @Override
    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$(this, msg, throwable);
    }

    @Override
    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$(this, msg, throwable);
    }

    @Override
    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$(this, msg, throwable);
    }

    @Override
    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$(this, msg, throwable);
    }

    @Override
    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$(this, msg, throwable);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$(this, isInterpreter);
    }

    @Override
    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$(this, isInterpreter, silent);
    }

    @Override
    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$(this);
    }

    @Override
    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$(this, isInterpreter, silent);
    }

    @Override
    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    @Override
    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public ShuffleWriteMetricsReporter createMetricsReporter(TaskContext context) {
        return context.taskMetrics().shuffleWriteMetrics();
    }

    public MapStatus write(RDD<?> rdd, ShuffleDependency<?, ?, ?> dep, long mapId, TaskContext context, Partition partition) {
        MapStatus mapStatus;
        ShuffleWriter writer = null;
        try {
            ShuffleManager manager = SparkEnv$.MODULE$.get().shuffleManager();
            writer = manager.getWriter(dep.shuffleHandle(), mapId, context, this.createMetricsReporter(context));
            writer.write(rdd.iterator(partition, context));
            Option<MapStatus> mapStatus2 = writer.stop(true);
            if (mapStatus2.isDefined() && dep.shuffleMergeEnabled() && dep.getMergerLocs().nonEmpty() && !dep.shuffleMergeFinalized()) {
                ShuffleBlockResolver shuffleBlockResolver = manager.shuffleBlockResolver();
                if (shuffleBlockResolver instanceof IndexShuffleBlockResolver) {
                    IndexShuffleBlockResolver indexShuffleBlockResolver = (IndexShuffleBlockResolver)shuffleBlockResolver;
                    File dataFile = indexShuffleBlockResolver.getDataFile(dep.shuffleId(), mapId);
                    new ShuffleBlockPusher(SparkEnv$.MODULE$.get().conf()).initiateBlockPush(dataFile, writer.getPartitionLengths(), dep, partition.index());
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else {
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                }
            }
            mapStatus = (MapStatus)mapStatus2.get();
        }
        catch (Exception e) {
            BoxedUnit boxedUnit;
            try {
                boxedUnit = writer != null ? writer.stop(false) : BoxedUnit.UNIT;
            }
            catch (Exception e2) {
                this.log().debug("Could not stop writer", (Throwable)e2);
                boxedUnit = BoxedUnit.UNIT;
            }
            throw e;
        }
        return mapStatus;
    }

    public ShuffleWriteProcessor() {
        Logging.$init$(this);
    }
}

