/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.status.api.v1;

import java.io.OutputStream;
import java.io.Serializable;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.zip.ZipOutputStream;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.StreamingOutput;
import org.apache.spark.JobExecutionStatus;
import org.apache.spark.SparkContext;
import org.apache.spark.SparkContext$;
import org.apache.spark.status.api.v1.ApiRequestContext;
import org.apache.spark.status.api.v1.ApplicationEnvironmentInfo;
import org.apache.spark.status.api.v1.BadParameterException;
import org.apache.spark.status.api.v1.BaseAppResource;
import org.apache.spark.status.api.v1.ExecutorSummary;
import org.apache.spark.status.api.v1.JobData;
import org.apache.spark.status.api.v1.NotFoundException;
import org.apache.spark.status.api.v1.OneApplicationAttemptResource;
import org.apache.spark.status.api.v1.ProcessSummary;
import org.apache.spark.status.api.v1.RDDStorageInfo;
import org.apache.spark.status.api.v1.ResourceProfileInfo;
import org.apache.spark.status.api.v1.ServiceUnavailable;
import org.apache.spark.status.api.v1.StagesResource;
import org.apache.spark.status.api.v1.ThreadStackTrace;
import org.apache.spark.status.api.v1.UIRoot;
import org.apache.spark.ui.SparkUI;
import org.apache.spark.util.Utils$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.control.NonFatal$;

@Produces(value={"application/json"})
@ScalaSignature(bytes="\u0006\u0005\u0005Mg!\u0002\b\u0010\u0001=Y\u0002\"\u0002\u0014\u0001\t\u0003A\u0003\"\u0002\u0016\u0001\t\u0003Y\u0003\"\u00021\u0001\t\u0003\t\u0007\"\u00029\u0001\t\u0003\t\b\"\u0002>\u0001\t\u0003Y\bBBA\u0014\u0001\u0011\u0005\u0011\u000fC\u0004\u00022\u0001!\t!a\r\t\u000f\u0005\u0015\u0003\u0001\"\u0001\u0002H!9\u0011\u0011\f\u0001\u0005\u0002\u0005m\u0003bBA7\u0001\u0011\u0005\u0011q\u000e\u0005\b\u0003\u0003\u0003A\u0011AAB\u0011\u001d\t\u0019\n\u0001C\u0001\u0003+Cq!!/\u0001\t\u0003\tYLA\u000eBEN$(/Y2u\u0003B\u0004H.[2bi&|gNU3t_V\u00148-\u001a\u0006\u0003!E\t!A^\u0019\u000b\u0005I\u0019\u0012aA1qS*\u0011A#F\u0001\u0007gR\fG/^:\u000b\u0005Y9\u0012!B:qCJ\\'B\u0001\r\u001a\u0003\u0019\t\u0007/Y2iK*\t!$A\u0002pe\u001e\u001c2\u0001\u0001\u000f#!\ti\u0002%D\u0001\u001f\u0015\u0005y\u0012!B:dC2\f\u0017BA\u0011\u001f\u0005\u0019\te.\u001f*fMB\u00111\u0005J\u0007\u0002\u001f%\u0011Qe\u0004\u0002\u0010\u0005\u0006\u001cX-\u00119q%\u0016\u001cx.\u001e:dK\u00061A(\u001b8jiz\u001a\u0001\u0001F\u0001*!\t\u0019\u0003!\u0001\u0005k_\n\u001cH*[:u)\ta3\bE\u0002.kar!AL\u001a\u000f\u0005=\u0012T\"\u0001\u0019\u000b\u0005E:\u0013A\u0002\u001fs_>$h(C\u0001 \u0013\t!d$A\u0004qC\u000e\\\u0017mZ3\n\u0005Y:$aA*fc*\u0011AG\b\t\u0003GeJ!AO\b\u0003\u000f){'\rR1uC\")AH\u0001a\u0001{\u0005A1\u000f^1ukN,7\u000fE\u0002?\u0007\u0016k\u0011a\u0010\u0006\u0003\u0001\u0006\u000bA!\u001e;jY*\t!)\u0001\u0003kCZ\f\u0017B\u0001#@\u0005\u0011a\u0015n\u001d;\u0011\u0005\u0019;U\"A\u000b\n\u0005!+\"A\u0005&pE\u0016CXmY;uS>t7\u000b^1ukNDCa\u000f&U+B\u00111JU\u0007\u0002\u0019*\u0011QJT\u0001\u0003eNT!a\u0014)\u0002\u0005]\u001c(\"A)\u0002\u000b)\fg/\u0019=\n\u0005Mc%AC)vKJL\b+\u0019:b[\u0006)a/\u00197vK\u0006\nA\u0003\u000b\u0003\u0003/RS\u0006CA&Y\u0013\tIFJ\u0001\u0003QCRD\u0017%A.\u0002\t)|'m\u001d\u0015\u0003\u0005u\u0003\"a\u00130\n\u0005}c%aA$F)\u00061qN\\3K_\n$\"\u0001\u000f2\t\u000b\r\u001c\u0001\u0019\u00013\u0002\u000b)|'-\u00133\u0011\u0005u)\u0017B\u00014\u001f\u0005\rIe\u000e\u001e\u0015\u0005E\"$6\u000e\u0005\u0002LS&\u0011!\u000e\u0014\u0002\n!\u0006$\b\u000eU1sC6\f\u0013a\u0019\u0015\u0005\u0007]#V.I\u0001o\u0003EQwNY:0w*|'-\u00133;Aq#7& \u0015\u0003\u0007u\u000bA\"\u001a=fGV$xN\u001d'jgR$\u0012A\u001d\t\u0004[U\u001a\bCA\u0012u\u0013\t)xBA\bFq\u0016\u001cW\u000f^8s'VlW.\u0019:zQ\u0011!q\u000bV<\"\u0003a\f\u0011\"\u001a=fGV$xN]:)\u0005\u0011i\u0016A\u0003;ie\u0016\fG\rR;naR\u0019A0!\u0002\u0011\u0007uix0\u0003\u0002\u007f=\t)\u0011I\u001d:bsB\u00191%!\u0001\n\u0007\u0005\rqB\u0001\tUQJ,\u0017\rZ*uC\u000e\\GK]1dK\"9\u0011qA\u0003A\u0002\u0005%\u0011AB3yK\u000eLE\r\u0005\u0003\u0002\f\u0005Ma\u0002BA\u0007\u0003\u001f\u0001\"a\f\u0010\n\u0007\u0005Ea$\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003+\t9B\u0001\u0004TiJLgn\u001a\u0006\u0004\u0003#q\u0002FBA\u0003QR\u000bY\"\t\u0002\u0002\u001e\u0005QQ\r_3dkR|'/\u00133)\u000b\u00159F+!\t\"\u0005\u0005\r\u0012AH3yK\u000e,Ho\u001c:t_m,\u00070Z2vi>\u0014\u0018\nZ?0i\"\u0014X-\u00193tQ\t)Q,A\bbY2,\u00050Z2vi>\u0014H*[:uQ\u00151q\u000bVA\u0016C\t\ti#\u0001\u0007bY2,\u00070Z2vi>\u00148\u000f\u000b\u0002\u0007;\u0006q\u0011\r\u001c7Qe>\u001cWm]:MSN$HCAA\u001b!\u0011iS'a\u000e\u0011\u0007\r\nI$C\u0002\u0002<=\u0011a\u0002\u0015:pG\u0016\u001c8oU;n[\u0006\u0014\u0018\u0010K\u0003\b/R\u000by$\t\u0002\u0002B\u00059\u0012\r\u001c7nSN\u001cW\r\u001c7b]\u0016|Wo\u001d9s_\u000e,7o\u001d\u0015\u0003\u000fu\u000baa\u001d;bO\u0016\u001cHCAA%!\u0019\tY!a\u0013\u0002P%!\u0011QJA\f\u0005\u0015\u0019E.Y:t!\r\u0019\u0013\u0011K\u0005\u0004\u0003'z!AD*uC\u001e,7OU3t_V\u00148-\u001a\u0015\u0006\u0011]#\u0016qK\u0011\u0003\u0003\u000b\nqA\u001d3e\u0019&\u001cH\u000f\u0006\u0002\u0002^A!Q&NA0!\r\u0019\u0013\u0011M\u0005\u0004\u0003Gz!A\u0004*E\tN#xN]1hK&sgm\u001c\u0015\u0006\u0013]#\u0016qM\u0011\u0003\u0003S\n1b\u001d;pe\u0006<Wm\f:eI\"\u0012\u0011\"X\u0001\be\u0012$G)\u0019;b)\u0011\ty&!\u001d\t\r\u0005M$\u00021\u0001e\u0003\u0015\u0011H\rZ%eQ\u0019\t\t\b\u001b+\u0002x\u0005\u0012\u00111\u000f\u0015\u0006\u0015]#\u00161P\u0011\u0003\u0003{\n\u0001d\u001d;pe\u0006<Wm\f:eI>Z(\u000f\u001a3JIj\u0002C\fZ\u0016~Q\tQQ,A\bf]ZL'o\u001c8nK:$\u0018J\u001c4p)\t\t)\tE\u0002$\u0003\u000fK1!!#\u0010\u0005i\t\u0005\u000f\u001d7jG\u0006$\u0018n\u001c8F]ZL'o\u001c8nK:$\u0018J\u001c4pQ\u0015Yq\u000bVAGC\t\ty)A\u0006f]ZL'o\u001c8nK:$\bFA\u0006^\u000319W\r^#wK:$Hj\\4t)\t\t9\n\u0005\u0003\u0002\u001a\u0006}UBAAN\u0015\r\ti\nT\u0001\u0005G>\u0014X-\u0003\u0003\u0002\"\u0006m%\u0001\u0003*fgB|gn]3)\r1\t)\u000bVAV!\rY\u0015qU\u0005\u0004\u0003Sc%\u0001\u0003)s_\u0012,8-Z:-\u0005\u00055\u0016EAAX\u0003a\t\u0007\u000f\u001d7jG\u0006$\u0018n\u001c80_\u000e$X\r^\u0017tiJ,\u0017-\u001c\u0015\u0006\u0019]#\u00161W\u0011\u0003\u0003k\u000bA\u0001\\8hg\"\u0012A\"X\u0001\u0013CB\u0004H.[2bi&|g.\u0011;uK6\u0004H\u000f\u0006\u0002\u0002>B1\u00111BA&\u0003\u007f\u00032aIAa\u0013\r\t\u0019m\u0004\u0002\u001e\u001f:,\u0017\t\u001d9mS\u000e\fG/[8o\u0003R$X-\u001c9u%\u0016\u001cx.\u001e:dK\"*Qb\u0016+\u0002H\u0006\u0012\u0011\u0011Z\u0001\fw\u0006$H/Z7qi&#W\u0010\u000b\u0004\u0001\u0003K#\u0016Q\u001a\u0017\u0003\u0003\u001f\f#!!5\u0002!\u0005\u0004\b\u000f\\5dCRLwN\\\u0018kg>t\u0007")
public class AbstractApplicationResource
implements BaseAppResource {
    @PathParam(value="appId")
    private String appId;
    @PathParam(value="attemptId")
    private String attemptId;
    @Context
    private ServletContext servletContext;
    @Context
    private HttpServletRequest httpRequest;

    @Override
    public <T> T withUI(Function1<SparkUI, T> fn) {
        return (T)BaseAppResource.withUI$(this, fn);
    }

    @Override
    public void checkUIViewPermissions() {
        BaseAppResource.checkUIViewPermissions$(this);
    }

    @Override
    public UIRoot uiRoot() {
        return ApiRequestContext.uiRoot$(this);
    }

    @Override
    public String appId() {
        return this.appId;
    }

    @Override
    public void appId_$eq(String x$1) {
        this.appId = x$1;
    }

    @Override
    public String attemptId() {
        return this.attemptId;
    }

    @Override
    public void attemptId_$eq(String x$1) {
        this.attemptId = x$1;
    }

    @Override
    public ServletContext servletContext() {
        return this.servletContext;
    }

    @Override
    public void servletContext_$eq(ServletContext x$1) {
        this.servletContext = x$1;
    }

    @Override
    public HttpServletRequest httpRequest() {
        return this.httpRequest;
    }

    @Override
    public void httpRequest_$eq(HttpServletRequest x$1) {
        this.httpRequest = x$1;
    }

    @GET
    @Path(value="jobs")
    public Seq<JobData> jobsList(@QueryParam(value="status") List<JobExecutionStatus> statuses) {
        return (Seq)this.withUI((Function1 & Serializable)x$1 -> x$1.store().jobsList(statuses));
    }

    @GET
    @Path(value="jobs/{jobId: \\d+}")
    public JobData oneJob(@PathParam(value="jobId") int jobId) {
        return (JobData)this.withUI((Function1 & Serializable)ui -> {
            JobData jobData;
            try {
                jobData = ui.store().job(jobId);
            }
            catch (NoSuchElementException noSuchElementException) {
                throw new NotFoundException(new StringBuilder(13).append("unknown job: ").append(jobId).toString());
            }
            return jobData;
        });
    }

    @GET
    @Path(value="executors")
    public Seq<ExecutorSummary> executorList() {
        return (Seq)this.withUI((Function1 & Serializable)x$2 -> x$2.store().executorList(true));
    }

    @GET
    @Path(value="executors/{executorId}/threads")
    public ThreadStackTrace[] threadDump(@PathParam(value="executorId") String execId) {
        return (ThreadStackTrace[])this.withUI((Function1 & Serializable)ui -> {
            ThreadStackTrace[] safeThreadDump;
            SparkContext safeSparkContext;
            block6: {
                boolean bl;
                block5: {
                    String string = execId;
                    String string2 = SparkContext$.MODULE$.DRIVER_IDENTIFIER();
                    if ((string == null ? string2 != null : !string.equals(string2)) && !StringOps$.MODULE$.forall$extension(Predef$.MODULE$.augmentString(execId), (Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)AbstractApplicationResource.$anonfun$threadDump$2(BoxesRunTime.unboxToChar((Object)x$1))))) {
                        throw new BadParameterException(new StringBuilder(42).append("Invalid executorId: neither '").append(SparkContext$.MODULE$.DRIVER_IDENTIFIER()).append("' nor number.").toString());
                    }
                    safeSparkContext = (SparkContext)ui.sc().getOrElse((Function0 & Serializable)() -> {
                        throw new ServiceUnavailable("Thread dumps not available through the history server.");
                    });
                    bl = false;
                    Some some = null;
                    Option option = ui.store().asOption((Function0 & Serializable)() -> ui.store().executorSummary(execId));
                    if (!(option instanceof Some)) break block5;
                    bl = true;
                    some = (Some)option;
                    ExecutorSummary executorSummary = (ExecutorSummary)some.value();
                    if (executorSummary.isActive()) break block6;
                }
                if (bl) {
                    throw new BadParameterException("Executor is not active.");
                }
                throw new NotFoundException("Executor does not exist.");
            }
            ThreadStackTrace[] threadStackTraceArray = safeThreadDump = (ThreadStackTrace[])safeSparkContext.getExecutorThreadDump(execId).getOrElse((Function0 & Serializable)() -> {
                throw new NotFoundException("No thread dump is available.");
            });
            return threadStackTraceArray;
        });
    }

    @GET
    @Path(value="allexecutors")
    public Seq<ExecutorSummary> allExecutorList() {
        return (Seq)this.withUI((Function1 & Serializable)x$3 -> x$3.store().executorList(false));
    }

    @GET
    @Path(value="allmiscellaneousprocess")
    public Seq<ProcessSummary> allProcessList() {
        return (Seq)this.withUI((Function1 & Serializable)x$4 -> x$4.store().miscellaneousProcessList(false));
    }

    @Path(value="stages")
    public Class<StagesResource> stages() {
        return StagesResource.class;
    }

    @GET
    @Path(value="storage/rdd")
    public Seq<RDDStorageInfo> rddList() {
        return (Seq)this.withUI((Function1 & Serializable)x$5 -> x$5.store().rddList(x$5.store().rddList$default$1()));
    }

    @GET
    @Path(value="storage/rdd/{rddId: \\d+}")
    public RDDStorageInfo rddData(@PathParam(value="rddId") int rddId) {
        return (RDDStorageInfo)this.withUI((Function1 & Serializable)ui -> {
            RDDStorageInfo rDDStorageInfo;
            try {
                rDDStorageInfo = ui.store().rdd(rddId);
            }
            catch (NoSuchElementException noSuchElementException) {
                throw new NotFoundException(new StringBuilder(19).append("no rdd found w/ id ").append(rddId).toString());
            }
            return rDDStorageInfo;
        });
    }

    @GET
    @Path(value="environment")
    public ApplicationEnvironmentInfo environmentInfo() {
        return (ApplicationEnvironmentInfo)this.withUI((Function1 & Serializable)ui -> {
            ApplicationEnvironmentInfo envInfo = ui.store().environmentInfo();
            Seq<ResourceProfileInfo> resourceProfileInfo = ui.store().resourceProfileInfo();
            return new ApplicationEnvironmentInfo(envInfo.runtime(), (Seq<Tuple2<String, String>>)((Seq)Utils$.MODULE$.redact(ui.conf(), envInfo.sparkProperties()).sortBy((Function1 & Serializable)x$6 -> (String)x$6._1(), (Ordering)Ordering.String$.MODULE$)), (Seq<Tuple2<String, String>>)((Seq)Utils$.MODULE$.redact(ui.conf(), envInfo.hadoopProperties()).sortBy((Function1 & Serializable)x$7 -> (String)x$7._1(), (Ordering)Ordering.String$.MODULE$)), (Seq<Tuple2<String, String>>)((Seq)Utils$.MODULE$.redact(ui.conf(), envInfo.systemProperties()).sortBy((Function1 & Serializable)x$8 -> (String)x$8._1(), (Ordering)Ordering.String$.MODULE$)), (Seq<Tuple2<String, String>>)((Seq)envInfo.classpathEntries().sortBy((Function1 & Serializable)x$9 -> (String)x$9._1(), (Ordering)Ordering.String$.MODULE$)), resourceProfileInfo);
        });
    }

    @GET
    @Path(value="logs")
    @Produces(value={"application/octet-stream"})
    public Response getEventLogs() {
        Response response;
        try {
            this.checkUIViewPermissions();
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable2 instanceof NotFoundException && this.attemptId() == null) {
                this.attemptId_$eq("1");
                this.checkUIViewPermissions();
                this.attemptId_$eq(null);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            throw throwable;
        }
        try {
            String fileName = this.attemptId() != null ? new StringBuilder(15).append("eventLogs-").append(this.appId()).append("-").append(this.attemptId()).append(".zip").toString() : new StringBuilder(14).append("eventLogs-").append(this.appId()).append(".zip").toString();
            StreamingOutput stream = new StreamingOutput(this){
                private final /* synthetic */ AbstractApplicationResource $outer;

                public void write(OutputStream output) {
                    try (ZipOutputStream zipStream = new ZipOutputStream(output);){
                        this.$outer.uiRoot().writeEventLogs(this.$outer.appId(), (Option<String>)Option$.MODULE$.apply((Object)this.$outer.attemptId()), zipStream);
                    }
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            };
            response = Response.ok((Object)stream).header("Content-Disposition", (Object)new StringBuilder(21).append("attachment; filename=").append(fileName).toString()).header("Content-Type", (Object)"application/octet-stream").build();
        }
        catch (Throwable throwable) {
            Option option;
            Throwable throwable3 = throwable;
            if (throwable3 != null && !(option = NonFatal$.MODULE$.unapply(throwable3)).isEmpty()) {
                throw new ServiceUnavailable(new StringBuilder(39).append("Event logs are not available for app: ").append(this.appId()).append(".").toString());
            }
            throw throwable;
        }
        return response;
    }

    @Path(value="{attemptId}")
    public Class<OneApplicationAttemptResource> applicationAttempt() {
        if (this.attemptId() != null) {
            throw new NotFoundException(this.httpRequest().getRequestURI());
        }
        return OneApplicationAttemptResource.class;
    }

    public static final /* synthetic */ boolean $anonfun$threadDump$2(char x$1) {
        return Character.isDigit(x$1);
    }

    public AbstractApplicationResource() {
        ApiRequestContext.$init$(this);
        BaseAppResource.$init$(this);
    }
}

