/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.storage;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.channels.ClosedByInterruptException;
import java.nio.channels.FileChannel;
import java.util.zip.Checksum;
import org.apache.spark.internal.Logging;
import org.apache.spark.io.MutableCheckedOutputStream;
import org.apache.spark.serializer.SerializationStream;
import org.apache.spark.serializer.SerializerInstance;
import org.apache.spark.serializer.SerializerManager;
import org.apache.spark.shuffle.ShuffleWriteMetricsReporter;
import org.apache.spark.storage.BlockId;
import org.apache.spark.storage.DiskBlockObjectWriter;
import org.apache.spark.storage.DiskBlockObjectWriter$;
import org.apache.spark.storage.FileSegment;
import org.apache.spark.storage.TimeTrackingOutputStream;
import org.apache.spark.util.Utils$;
import org.apache.spark.util.collection.PairsWriter;
import org.slf4j.Logger;
import scala.Function0;
import scala.Predef$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\t%g!\u0002(P\u0001E;\u0006\u0002\u00038\u0001\u0005\u000b\u0007I\u0011\u00019\t\u0011Q\u0004!\u0011!Q\u0001\nED\u0001\"\u001e\u0001\u0003\u0002\u0003\u0006IA\u001e\u0005\ty\u0002\u0011\t\u0011)A\u0005{\"Q\u0011\u0011\u0001\u0001\u0003\u0002\u0003\u0006I!a\u0001\t\u0015\u0005=\u0001A!A!\u0002\u0013\t\t\u0002\u0003\u0006\u0002\u0018\u0001\u0011\t\u0011)A\u0005\u00033A!\"!\n\u0001\u0005\u000b\u0007I\u0011AA\u0014\u0011)\t\t\u0004\u0001B\u0001B\u0003%\u0011\u0011\u0006\u0005\b\u0003g\u0001A\u0011AA\u001b\r%\t9\u0005\u0001I\u0001\u0004\u0013\tI\u0005C\u0004\u0002L-!\t!!\u0014\t\u0011\u0005U3\u0002%C\u0001\u0003\u001bBq!a\u0016\f\t\u0003\ti\u0005\u0003\b\u0002Z-\u0001\n1!A\u0001\n\u0013\ti%a\u0017\t\u0013\u0005u\u0003\u00011A\u0005\n\u0005}\u0003\"CA9\u0001\u0001\u0007I\u0011BA:\u0011!\tI\b\u0001Q!\n\u0005\u0005\u0004\"CA>\u0001\u0001\u0007I\u0011BA?\u0011%\t\u0019\t\u0001a\u0001\n\u0013\t)\t\u0003\u0005\u0002\n\u0002\u0001\u000b\u0015BA@\u0011%\tY\t\u0001a\u0001\n\u0013\ti\tC\u0005\u0002\u0010\u0002\u0001\r\u0011\"\u0003\u0002\u0012\"9\u0011Q\u0013\u0001!B\u0013A\u0006\"CAL\u0001\u0001\u0007I\u0011BAM\u0011%\t\t\u000b\u0001a\u0001\n\u0013\t\u0019\u000b\u0003\u0005\u0002(\u0002\u0001\u000b\u0015BAN\u0011%\tI\u000b\u0001a\u0001\n\u0013\tY\u000bC\u0005\u00024\u0002\u0001\r\u0011\"\u0003\u00026\"A\u0011\u0011\u0018\u0001!B\u0013\ti\u000bC\u0005\u0002<\u0002\u0001\r\u0011\"\u0003\u0002>\"I\u0011Q\u0019\u0001A\u0002\u0013%\u0011q\u0019\u0005\t\u0003\u0017\u0004\u0001\u0015)\u0003\u0002@\"I\u0011Q\u001a\u0001A\u0002\u0013%\u0011q\u001a\u0005\n\u0003#\u0004\u0001\u0019!C\u0005\u0003'D\u0001\"a6\u0001A\u0003&\u0011\u0011\u0003\u0005\n\u00033\u0004\u0001\u0019!C\u0005\u0003\u001fD\u0011\"a7\u0001\u0001\u0004%I!!8\t\u0011\u0005\u0005\b\u0001)Q\u0005\u0003#A\u0011\"a9\u0001\u0001\u0004%I!a4\t\u0013\u0005\u0015\b\u00011A\u0005\n\u0005\u001d\b\u0002CAv\u0001\u0001\u0006K!!\u0005\t\u0013\u00055\b\u00011A\u0005\n\u0005=\u0007\"CAx\u0001\u0001\u0007I\u0011BAy\u0011!\t)\u0010\u0001Q!\n\u0005E\u0001bCA|\u0001\u0001\u0007\t\u0019!C\u0005\u0003sD1B!\u0002\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0003\b!Y!1\u0002\u0001A\u0002\u0003\u0005\u000b\u0015BA~\u0011-\u0011i\u0001\u0001a\u0001\u0002\u0004%IAa\u0004\t\u0017\t}\u0001\u00011AA\u0002\u0013%!\u0011\u0005\u0005\f\u0005K\u0001\u0001\u0019!A!B\u0013\u0011\t\u0002C\u0005\u0003(\u0001\u0001\r\u0011\"\u0003\u0003*!I!\u0011\u0007\u0001A\u0002\u0013%!1\u0007\u0005\t\u0005o\u0001\u0001\u0015)\u0003\u0003,!I!\u0011\b\u0001A\u0002\u0013%!\u0011\u0006\u0005\n\u0005w\u0001\u0001\u0019!C\u0005\u0005{A\u0001B!\u0011\u0001A\u0003&!1\u0006\u0005\n\u0005\u0007\u0002\u0001\u0019!C\u0005\u0005\u000bB\u0011Ba\u0012\u0001\u0001\u0004%IA!\u0013\t\u0011\t5\u0003\u0001)Q\u0005\u0003\u0007AqAa\u0014\u0001\t\u0003\u0011\t\u0006C\u0004\u0003V\u0001!I!!\u0014\t\u000f\t]\u0003\u0001\"\u0001\u0003Z!9!1\f\u0001\u0005\n\u00055\u0003bBA+\u0001\u0011\u0005\u0013Q\n\u0005\b\u0005;\u0002A\u0011\u0001B0\u0011\u001d\u00119\u0007\u0001C\u0001\u0005SBqAa\u001b\u0001\t\u0003\u0012i\u0007C\u0004\u0003l\u0001!\tE! \t\u000f\t-\u0004\u0001\"\u0011\u0003\u0004\"9!Q\u0014\u0001\u0005\u0002\u00055\u0003b\u0002BP\u0001\u0011%\u0011Q\n\u0005\t\u0005C\u0003A\u0011I)\u0002N\u001dQ!1U(\u0002\u0002#\u0005\u0011K!*\u0007\u00139{\u0015\u0011!E\u0001#\n\u001d\u0006bBA\u001a\u0017\u0012\u0005!q\u0016\u0005\n\u0005c[\u0015\u0013!C\u0001\u0005g\u0013Q\u0003R5tW\ncwnY6PE*,7\r^,sSR,'O\u0003\u0002Q#\u000691\u000f^8sC\u001e,'B\u0001*T\u0003\u0015\u0019\b/\u0019:l\u0015\t!V+\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002-\u0006\u0019qN]4\u0014\t\u0001A\u0006M\u001a\t\u00033zk\u0011A\u0017\u0006\u00037r\u000b!![8\u000b\u0003u\u000bAA[1wC&\u0011qL\u0017\u0002\r\u001fV$\b/\u001e;TiJ,\u0017-\u001c\t\u0003C\u0012l\u0011A\u0019\u0006\u0003GF\u000b\u0001\"\u001b8uKJt\u0017\r\\\u0005\u0003K\n\u0014q\u0001T8hO&tw\r\u0005\u0002hY6\t\u0001N\u0003\u0002jU\u0006Q1m\u001c7mK\u000e$\u0018n\u001c8\u000b\u0005-\f\u0016\u0001B;uS2L!!\u001c5\u0003\u0017A\u000b\u0017N]:Xe&$XM]\u0001\u0005M&dWm\u0001\u0001\u0016\u0003E\u0004\"!\u0017:\n\u0005MT&\u0001\u0002$jY\u0016\fQAZ5mK\u0002\n\u0011c]3sS\u0006d\u0017N_3s\u001b\u0006t\u0017mZ3s!\t9(0D\u0001y\u0015\tI\u0018+\u0001\u0006tKJL\u0017\r\\5{KJL!a\u001f=\u0003#M+'/[1mSj,'/T1oC\u001e,'/\u0001\ntKJL\u0017\r\\5{KJLen\u001d;b]\u000e,\u0007CA<\u007f\u0013\ty\bP\u0001\nTKJL\u0017\r\\5{KJLen\u001d;b]\u000e,\u0017A\u00032vM\u001a,'oU5{KB!\u0011QAA\u0006\u001b\t\t9A\u0003\u0002\u0002\n\u0005)1oY1mC&!\u0011QBA\u0004\u0005\rIe\u000e^\u0001\u000bgft7m\u0016:ji\u0016\u001c\b\u0003BA\u0003\u0003'IA!!\u0006\u0002\b\t9!i\\8mK\u0006t\u0017\u0001D<sSR,W*\u001a;sS\u000e\u001c\b\u0003BA\u000e\u0003Ci!!!\b\u000b\u0007\u0005}\u0011+A\u0004tQV4g\r\\3\n\t\u0005\r\u0012Q\u0004\u0002\u001c'\",hM\u001a7f/JLG/Z'fiJL7m\u001d*fa>\u0014H/\u001a:\u0002\u000f\tdwnY6JIV\u0011\u0011\u0011\u0006\t\u0005\u0003W\ti#D\u0001P\u0013\r\tyc\u0014\u0002\b\u00052|7m[%e\u0003!\u0011Gn\\2l\u0013\u0012\u0004\u0013A\u0002\u001fj]&$h\b\u0006\t\u00028\u0005e\u00121HA\u001f\u0003\u007f\t\t%a\u0011\u0002FA\u0019\u00111\u0006\u0001\t\u000b9T\u0001\u0019A9\t\u000bUT\u0001\u0019\u0001<\t\u000bqT\u0001\u0019A?\t\u000f\u0005\u0005!\u00021\u0001\u0002\u0004!9\u0011q\u0002\u0006A\u0002\u0005E\u0001bBA\f\u0015\u0001\u0007\u0011\u0011\u0004\u0005\n\u0003KQ\u0001\u0013!a\u0001\u0003S\u0011q#T1ok\u0006d7\t\\8tK>+H\u000f];u'R\u0014X-Y7\u0014\u0005-A\u0016A\u0002\u0013j]&$H\u0005\u0006\u0002\u0002PA!\u0011QAA)\u0013\u0011\t\u0019&a\u0002\u0003\tUs\u0017\u000e^\u0001\u0006G2|7/Z\u0001\f[\u0006tW/\u00197DY>\u001cX-A\u0006tkB,'\u000fJ2m_N,\u0017bAA+=\u000691\r[1o]\u0016dWCAA1!\u0011\t\u0019'!\u001c\u000e\u0005\u0005\u0015$\u0002BA4\u0003S\n\u0001b\u00195b]:,Gn\u001d\u0006\u0004\u0003Wb\u0016a\u00018j_&!\u0011qNA3\u0005-1\u0015\u000e\\3DQ\u0006tg.\u001a7\u0002\u0017\rD\u0017M\u001c8fY~#S-\u001d\u000b\u0005\u0003\u001f\n)\bC\u0005\u0002xE\t\t\u00111\u0001\u0002b\u0005\u0019\u0001\u0010J\u0019\u0002\u0011\rD\u0017M\u001c8fY\u0002\n1!\\2t+\t\ty\bE\u0002\u0002\u0002.i\u0011\u0001A\u0001\b[\u000e\u001cx\fJ3r)\u0011\ty%a\"\t\u0013\u0005]D#!AA\u0002\u0005}\u0014\u0001B7dg\u0002\n!AY:\u0016\u0003a\u000baAY:`I\u0015\fH\u0003BA(\u0003'C\u0001\"a\u001e\u0018\u0003\u0003\u0005\r\u0001W\u0001\u0004EN\u0004\u0013a\u00014pgV\u0011\u00111\u0014\t\u00043\u0006u\u0015bAAP5\n\u0001b)\u001b7f\u001fV$\b/\u001e;TiJ,\u0017-\\\u0001\bM>\u001cx\fJ3r)\u0011\ty%!*\t\u0013\u0005]$$!AA\u0002\u0005m\u0015\u0001\u00024pg\u0002\n!\u0001^:\u0016\u0005\u00055\u0006\u0003BA\u0016\u0003_K1!!-P\u0005a!\u0016.\\3Ue\u0006\u001c7.\u001b8h\u001fV$\b/\u001e;TiJ,\u0017-\\\u0001\u0007iN|F%Z9\u0015\t\u0005=\u0013q\u0017\u0005\n\u0003oj\u0012\u0011!a\u0001\u0003[\u000b1\u0001^:!\u0003\u0019y'M[(viV\u0011\u0011q\u0018\t\u0004o\u0006\u0005\u0017bAAbq\n\u00192+\u001a:jC2L'0\u0019;j_:\u001cFO]3b[\u0006QqN\u00196PkR|F%Z9\u0015\t\u0005=\u0013\u0011\u001a\u0005\n\u0003o\u0002\u0013\u0011!a\u0001\u0003\u007f\u000bqa\u001c2k\u001fV$\b%A\u0006j]&$\u0018.\u00197ju\u0016$WCAA\t\u0003=Ig.\u001b;jC2L'0\u001a3`I\u0015\fH\u0003BA(\u0003+D\u0011\"a\u001e$\u0003\u0003\u0005\r!!\u0005\u0002\u0019%t\u0017\u000e^5bY&TX\r\u001a\u0011\u0002\u0015M$(/Z1n\u001fB,g.\u0001\btiJ,\u0017-\\(qK:|F%Z9\u0015\t\u0005=\u0013q\u001c\u0005\n\u0003o2\u0013\u0011!a\u0001\u0003#\t1b\u001d;sK\u0006lw\n]3oA\u0005i\u0001.Y:CK\u0016t7\t\\8tK\u0012\f\u0011\u0003[1t\u0005\u0016,gn\u00117pg\u0016$w\fJ3r)\u0011\ty%!;\t\u0013\u0005]\u0014&!AA\u0002\u0005E\u0011A\u00045bg\n+WM\\\"m_N,G\rI\u0001\u0010G\",7m[:v[\u0016s\u0017M\u00197fI\u0006\u00192\r[3dWN,X.\u00128bE2,Gm\u0018\u0013fcR!\u0011qJAz\u0011%\t9\bLA\u0001\u0002\u0004\t\t\"\u0001\tdQ\u0016\u001c7n];n\u000b:\f'\r\\3eA\u0005!2\r[3dWN,XnT;uaV$8\u000b\u001e:fC6,\"!a?\u0011\t\u0005u(\u0011A\u0007\u0003\u0003\u007fT!aW)\n\t\t\r\u0011q \u0002\u001b\u001bV$\u0018M\u00197f\u0007\",7m[3e\u001fV$\b/\u001e;TiJ,\u0017-\\\u0001\u0019G\",7m[:v[>+H\u000f];u'R\u0014X-Y7`I\u0015\fH\u0003BA(\u0005\u0013A\u0011\"a\u001e0\u0003\u0003\u0005\r!a?\u0002+\rDWmY6tk6|U\u000f\u001e9viN#(/Z1nA\u0005A1\r[3dWN,X.\u0006\u0002\u0003\u0012A!!1\u0003B\u000e\u001b\t\u0011)B\u0003\u0003\u0003\u0018\te\u0011a\u0001>ja*\u00111\u000eX\u0005\u0005\u0005;\u0011)B\u0001\u0005DQ\u0016\u001c7n];n\u00031\u0019\u0007.Z2lgVlw\fJ3r)\u0011\tyEa\t\t\u0013\u0005]$'!AA\u0002\tE\u0011!C2iK\u000e\\7/^7!\u0003E\u0019w.\\7jiR,G\rU8tSRLwN\\\u000b\u0003\u0005W\u0001B!!\u0002\u0003.%!!qFA\u0004\u0005\u0011auN\\4\u0002+\r|W.\\5ui\u0016$\u0007k\\:ji&|gn\u0018\u0013fcR!\u0011q\nB\u001b\u0011%\t9(NA\u0001\u0002\u0004\u0011Y#\u0001\nd_6l\u0017\u000e\u001e;fIB{7/\u001b;j_:\u0004\u0013\u0001\u0005:fa>\u0014H/\u001a3Q_NLG/[8o\u0003Q\u0011X\r]8si\u0016$\u0007k\\:ji&|gn\u0018\u0013fcR!\u0011q\nB \u0011%\t9\bOA\u0001\u0002\u0004\u0011Y#A\tsKB|'\u000f^3e!>\u001c\u0018\u000e^5p]\u0002\n\u0011C\\;n%\u0016\u001cwN\u001d3t/JLG\u000f^3o+\t\t\u0019!A\u000bok6\u0014VmY8sIN<&/\u001b;uK:|F%Z9\u0015\t\u0005=#1\n\u0005\n\u0003oZ\u0014\u0011!a\u0001\u0003\u0007\t!C\\;n%\u0016\u001cwN\u001d3t/JLG\u000f^3oA\u0005Y1/\u001a;DQ\u0016\u001c7n];n)\u0011\tyEa\u0015\t\u000f\t5Q\b1\u0001\u0003\u0012\u0005Q\u0011N\\5uS\u0006d\u0017N_3\u0002\t=\u0004XM\u001c\u000b\u0003\u0003o\tab\u00197pg\u0016\u0014Vm]8ve\u000e,7/\u0001\u0007d_6l\u0017\u000e^!oI\u001e+G\u000f\u0006\u0002\u0003bA!\u00111\u0006B2\u0013\r\u0011)g\u0014\u0002\f\r&dWmU3h[\u0016tG/A\u000esKZ,'\u000f\u001e)beRL\u0017\r\\,sSR,7/\u00118e\u00072|7/\u001a\u000b\u0002c\u0006)qO]5uKR1\u0011q\nB8\u0005sBqA!\u001dE\u0001\u0004\u0011\u0019(A\u0002lKf\u0004B!!\u0002\u0003v%!!qOA\u0004\u0005\r\te.\u001f\u0005\b\u0005w\"\u0005\u0019\u0001B:\u0003\u00151\u0018\r\\;f)\u0011\tyEa \t\u000f\t\u0005U\t1\u0001\u0002\u0004\u0005\t!\r\u0006\u0005\u0002P\t\u0015%Q\u0013BM\u0011\u001d\u00119I\u0012a\u0001\u0005\u0013\u000bqa\u001b<CsR,7\u000f\u0005\u0004\u0002\u0006\t-%qR\u0005\u0005\u0005\u001b\u000b9AA\u0003BeJ\f\u0017\u0010\u0005\u0003\u0002\u0006\tE\u0015\u0002\u0002BJ\u0003\u000f\u0011AAQ=uK\"9!q\u0013$A\u0002\u0005\r\u0011\u0001B8gMNDqAa'G\u0001\u0004\t\u0019!A\u0002mK:\fQB]3d_J$wK]5ui\u0016t\u0017AE;qI\u0006$XMQ=uKN<&/\u001b;uK:\fQA\u001a7vg\"\fQ\u0003R5tW\ncwnY6PE*,7\r^,sSR,'\u000fE\u0002\u0002,-\u001b2a\u0013BU!\u0011\t)Aa+\n\t\t5\u0016q\u0001\u0002\u0007\u0003:L(+\u001a4\u0015\u0005\t\u0015\u0016a\u0007\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$s'\u0006\u0002\u00036*\"\u0011\u0011\u0006B\\W\t\u0011I\f\u0005\u0003\u0003<\n\u0015WB\u0001B_\u0015\u0011\u0011yL!1\u0002\u0013Ut7\r[3dW\u0016$'\u0002\u0002Bb\u0003\u000f\t!\"\u00198o_R\fG/[8o\u0013\u0011\u00119M!0\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW\r")
public class DiskBlockObjectWriter
extends OutputStream
implements Logging,
PairsWriter {
    private final File file;
    private final SerializerManager serializerManager;
    private final SerializerInstance serializerInstance;
    public final int org$apache$spark$storage$DiskBlockObjectWriter$$bufferSize;
    private final boolean syncWrites;
    private final ShuffleWriteMetricsReporter writeMetrics;
    private final BlockId blockId;
    private FileChannel channel;
    private ManualCloseOutputStream mcs;
    private OutputStream bs;
    private FileOutputStream fos;
    private TimeTrackingOutputStream org$apache$spark$storage$DiskBlockObjectWriter$$ts;
    private SerializationStream objOut;
    private boolean initialized;
    private boolean streamOpen;
    private boolean hasBeenClosed;
    private boolean org$apache$spark$storage$DiskBlockObjectWriter$$checksumEnabled;
    private MutableCheckedOutputStream org$apache$spark$storage$DiskBlockObjectWriter$$checksumOutputStream;
    private Checksum checksum;
    private long committedPosition;
    private long reportedPosition;
    private int numRecordsWritten;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public static BlockId $lessinit$greater$default$7() {
        return DiskBlockObjectWriter$.MODULE$.$lessinit$greater$default$7();
    }

    @Override
    public String logName() {
        return Logging.logName$(this);
    }

    @Override
    public Logger log() {
        return Logging.log$(this);
    }

    @Override
    public void logInfo(Function0<String> msg) {
        Logging.logInfo$(this, msg);
    }

    @Override
    public void logDebug(Function0<String> msg) {
        Logging.logDebug$(this, msg);
    }

    @Override
    public void logTrace(Function0<String> msg) {
        Logging.logTrace$(this, msg);
    }

    @Override
    public void logWarning(Function0<String> msg) {
        Logging.logWarning$(this, msg);
    }

    @Override
    public void logError(Function0<String> msg) {
        Logging.logError$(this, msg);
    }

    @Override
    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$(this, msg, throwable);
    }

    @Override
    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$(this, msg, throwable);
    }

    @Override
    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$(this, msg, throwable);
    }

    @Override
    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$(this, msg, throwable);
    }

    @Override
    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$(this, msg, throwable);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$(this, isInterpreter);
    }

    @Override
    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$(this, isInterpreter, silent);
    }

    @Override
    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$(this);
    }

    @Override
    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$(this, isInterpreter, silent);
    }

    @Override
    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    @Override
    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public File file() {
        return this.file;
    }

    public BlockId blockId() {
        return this.blockId;
    }

    private FileChannel channel() {
        return this.channel;
    }

    private void channel_$eq(FileChannel x$1) {
        this.channel = x$1;
    }

    private ManualCloseOutputStream mcs() {
        return this.mcs;
    }

    private void mcs_$eq(ManualCloseOutputStream x$1) {
        this.mcs = x$1;
    }

    private OutputStream bs() {
        return this.bs;
    }

    private void bs_$eq(OutputStream x$1) {
        this.bs = x$1;
    }

    private FileOutputStream fos() {
        return this.fos;
    }

    private void fos_$eq(FileOutputStream x$1) {
        this.fos = x$1;
    }

    public TimeTrackingOutputStream org$apache$spark$storage$DiskBlockObjectWriter$$ts() {
        return this.org$apache$spark$storage$DiskBlockObjectWriter$$ts;
    }

    private void org$apache$spark$storage$DiskBlockObjectWriter$$ts_$eq(TimeTrackingOutputStream x$1) {
        this.org$apache$spark$storage$DiskBlockObjectWriter$$ts = x$1;
    }

    private SerializationStream objOut() {
        return this.objOut;
    }

    private void objOut_$eq(SerializationStream x$1) {
        this.objOut = x$1;
    }

    private boolean initialized() {
        return this.initialized;
    }

    private void initialized_$eq(boolean x$1) {
        this.initialized = x$1;
    }

    private boolean streamOpen() {
        return this.streamOpen;
    }

    private void streamOpen_$eq(boolean x$1) {
        this.streamOpen = x$1;
    }

    private boolean hasBeenClosed() {
        return this.hasBeenClosed;
    }

    private void hasBeenClosed_$eq(boolean x$1) {
        this.hasBeenClosed = x$1;
    }

    public boolean org$apache$spark$storage$DiskBlockObjectWriter$$checksumEnabled() {
        return this.org$apache$spark$storage$DiskBlockObjectWriter$$checksumEnabled;
    }

    private void org$apache$spark$storage$DiskBlockObjectWriter$$checksumEnabled_$eq(boolean x$1) {
        this.org$apache$spark$storage$DiskBlockObjectWriter$$checksumEnabled = x$1;
    }

    public MutableCheckedOutputStream org$apache$spark$storage$DiskBlockObjectWriter$$checksumOutputStream() {
        return this.org$apache$spark$storage$DiskBlockObjectWriter$$checksumOutputStream;
    }

    private void org$apache$spark$storage$DiskBlockObjectWriter$$checksumOutputStream_$eq(MutableCheckedOutputStream x$1) {
        this.org$apache$spark$storage$DiskBlockObjectWriter$$checksumOutputStream = x$1;
    }

    private Checksum checksum() {
        return this.checksum;
    }

    private void checksum_$eq(Checksum x$1) {
        this.checksum = x$1;
    }

    private long committedPosition() {
        return this.committedPosition;
    }

    private void committedPosition_$eq(long x$1) {
        this.committedPosition = x$1;
    }

    private long reportedPosition() {
        return this.reportedPosition;
    }

    private void reportedPosition_$eq(long x$1) {
        this.reportedPosition = x$1;
    }

    private int numRecordsWritten() {
        return this.numRecordsWritten;
    }

    private void numRecordsWritten_$eq(int x$1) {
        this.numRecordsWritten = x$1;
    }

    public void setChecksum(Checksum checksum) {
        if (this.org$apache$spark$storage$DiskBlockObjectWriter$$checksumOutputStream() == null) {
            this.org$apache$spark$storage$DiskBlockObjectWriter$$checksumEnabled_$eq(true);
            this.checksum_$eq(checksum);
        } else {
            this.org$apache$spark$storage$DiskBlockObjectWriter$$checksumOutputStream().setChecksum(checksum);
        }
    }

    private void initialize() {
        this.fos_$eq(new FileOutputStream(this.file(), true));
        this.channel_$eq(this.fos().getChannel());
        this.org$apache$spark$storage$DiskBlockObjectWriter$$ts_$eq(new TimeTrackingOutputStream(this.writeMetrics, this.fos()));
        if (this.org$apache$spark$storage$DiskBlockObjectWriter$$checksumEnabled()) {
            Predef$.MODULE$.assert(this.checksum() != null, (Function0 & Serializable)() -> "Checksum is not set");
            this.org$apache$spark$storage$DiskBlockObjectWriter$$checksumOutputStream_$eq(new MutableCheckedOutputStream(this.org$apache$spark$storage$DiskBlockObjectWriter$$ts()));
            this.org$apache$spark$storage$DiskBlockObjectWriter$$checksumOutputStream().setChecksum(this.checksum());
        }
        public class Org_apache_spark_storage_DiskBlockObjectWriter$ManualCloseBufferedOutputStream$1
        extends BufferedOutputStream
        implements ManualCloseOutputStream {
            private final /* synthetic */ DiskBlockObjectWriter $outer;

            public /* synthetic */ void org$apache$spark$storage$DiskBlockObjectWriter$ManualCloseOutputStream$$super$close() {
                super.close();
            }

            public void close() {
                ManualCloseOutputStream.close$(this);
            }

            public void manualClose() {
                ManualCloseOutputStream.manualClose$(this);
            }

            public /* synthetic */ DiskBlockObjectWriter org$apache$spark$storage$DiskBlockObjectWriter$ManualCloseOutputStream$$$outer() {
                return this.$outer;
            }

            public Org_apache_spark_storage_DiskBlockObjectWriter$ManualCloseBufferedOutputStream$1(DiskBlockObjectWriter $outer) {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                super($outer.org$apache$spark$storage$DiskBlockObjectWriter$$checksumEnabled() ? $outer.org$apache$spark$storage$DiskBlockObjectWriter$$checksumOutputStream() : $outer.org$apache$spark$storage$DiskBlockObjectWriter$$ts(), $outer.org$apache$spark$storage$DiskBlockObjectWriter$$bufferSize);
                ManualCloseOutputStream.$init$(this);
            }
        }
        this.mcs_$eq(new Org_apache_spark_storage_DiskBlockObjectWriter$ManualCloseBufferedOutputStream$1(this));
    }

    public DiskBlockObjectWriter open() {
        if (this.hasBeenClosed()) {
            throw new IllegalStateException("Writer already closed. Cannot be reopened.");
        }
        if (!this.initialized()) {
            this.initialize();
            this.initialized_$eq(true);
        }
        this.bs_$eq(this.serializerManager.wrapStream(this.blockId(), (OutputStream)((Object)this.mcs())));
        this.objOut_$eq(this.serializerInstance.serializeStream(this.bs()));
        this.streamOpen_$eq(true);
        return this;
    }

    private void closeResources() {
        block0: {
            if (!this.initialized()) break block0;
            Utils$.MODULE$.tryWithSafeFinally((JFunction0.mcV.sp & Serializable)() -> this.mcs().manualClose(), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
                this.channel_$eq(null);
                this.mcs_$eq(null);
                this.bs_$eq(null);
                this.fos_$eq(null);
                this.org$apache$spark$storage$DiskBlockObjectWriter$$ts_$eq(null);
                this.objOut_$eq(null);
                this.initialized_$eq(false);
                this.streamOpen_$eq(false);
                this.hasBeenClosed_$eq(true);
            });
        }
    }

    @Override
    public void close() {
        block0: {
            if (!this.initialized()) break block0;
            Utils$.MODULE$.tryWithSafeFinally((Function0 & Serializable)() -> this.commitAndGet(), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.closeResources());
        }
    }

    public FileSegment commitAndGet() {
        FileSegment fileSegment;
        if (this.streamOpen()) {
            this.objOut().flush();
            this.bs().flush();
            this.objOut().close();
            this.streamOpen_$eq(false);
            if (this.syncWrites) {
                long start = System.nanoTime();
                this.fos().getFD().sync();
                this.writeMetrics.incWriteTime(System.nanoTime() - start);
            }
            long pos = this.channel().position();
            FileSegment fileSegment2 = new FileSegment(this.file(), this.committedPosition(), pos - this.committedPosition());
            this.committedPosition_$eq(pos);
            this.writeMetrics.incBytesWritten(this.committedPosition() - this.reportedPosition());
            this.reportedPosition_$eq(this.committedPosition());
            this.numRecordsWritten_$eq(0);
            fileSegment = fileSegment2;
        } else {
            fileSegment = new FileSegment(this.file(), this.committedPosition(), 0L);
        }
        return fileSegment;
    }

    public File revertPartialWritesAndClose() {
        Utils$.MODULE$.tryWithSafeFinally((JFunction0.mcV.sp & Serializable)() -> {
            block0: {
                if (!this.initialized()) break block0;
                $this.writeMetrics.decBytesWritten(this.reportedPosition() - this.committedPosition());
                $this.writeMetrics.decRecordsWritten(this.numRecordsWritten());
                this.streamOpen_$eq(false);
                this.closeResources();
            }
        }, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
            FileOutputStream truncateStream = null;
            try {
                try {
                    truncateStream = new FileOutputStream(this.file(), true);
                    truncateStream.getChannel().truncate(this.committedPosition());
                }
                catch (ClosedByInterruptException ce) {
                    this.logError((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(60).append("Exception occurred while reverting partial writes to file ").append(this.file()).append(", ").append(ce.getMessage()).toString());
                }
                catch (Exception e) {
                    this.logError((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(58).append("Uncaught exception while reverting partial writes to file ").append(this.file()).toString(), e);
                }
            }
            finally {
                if (truncateStream != null) {
                    truncateStream.close();
                    truncateStream = null;
                }
            }
        });
        return this.file();
    }

    @Override
    public void write(Object key, Object value) {
        Object object = !this.streamOpen() ? this.open() : BoxedUnit.UNIT;
        this.objOut().writeKey(key, ClassTag$.MODULE$.Any());
        this.objOut().writeValue(value, ClassTag$.MODULE$.Any());
        this.recordWritten();
    }

    @Override
    public void write(int b) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void write(byte[] kvBytes, int offs, int len) {
        Object object = !this.streamOpen() ? this.open() : BoxedUnit.UNIT;
        this.bs().write(kvBytes, offs, len);
    }

    public void recordWritten() {
        block0: {
            this.numRecordsWritten_$eq(this.numRecordsWritten() + 1);
            this.writeMetrics.incRecordsWritten(1L);
            if (this.numRecordsWritten() % 16384 != 0) break block0;
            this.updateBytesWritten();
        }
    }

    private void updateBytesWritten() {
        long pos = this.channel().position();
        this.writeMetrics.incBytesWritten(pos - this.reportedPosition());
        this.reportedPosition_$eq(pos);
    }

    @Override
    public void flush() {
        this.objOut().flush();
        this.bs().flush();
    }

    public DiskBlockObjectWriter(File file, SerializerManager serializerManager, SerializerInstance serializerInstance, int bufferSize, boolean syncWrites, ShuffleWriteMetricsReporter writeMetrics, BlockId blockId) {
        this.file = file;
        this.serializerManager = serializerManager;
        this.serializerInstance = serializerInstance;
        this.org$apache$spark$storage$DiskBlockObjectWriter$$bufferSize = bufferSize;
        this.syncWrites = syncWrites;
        this.writeMetrics = writeMetrics;
        this.blockId = blockId;
        Logging.$init$(this);
        this.channel = null;
        this.mcs = null;
        this.bs = null;
        this.fos = null;
        this.org$apache$spark$storage$DiskBlockObjectWriter$$ts = null;
        this.objOut = null;
        this.initialized = false;
        this.streamOpen = false;
        this.hasBeenClosed = false;
        this.org$apache$spark$storage$DiskBlockObjectWriter$$checksumEnabled = false;
        this.committedPosition = file.length();
        this.reportedPosition = this.committedPosition();
        this.numRecordsWritten = 0;
    }

    private interface ManualCloseOutputStream {
        public /* synthetic */ void org$apache$spark$storage$DiskBlockObjectWriter$ManualCloseOutputStream$$super$close();

        public static /* synthetic */ void close$(ManualCloseOutputStream $this) {
            $this.close();
        }

        default public void close() {
            ((OutputStream)((Object)this)).flush();
        }

        public static /* synthetic */ void manualClose$(ManualCloseOutputStream $this) {
            $this.manualClose();
        }

        default public void manualClose() {
            try {
                this.org$apache$spark$storage$DiskBlockObjectWriter$ManualCloseOutputStream$$super$close();
            }
            catch (IOException e) {
                this.org$apache$spark$storage$DiskBlockObjectWriter$ManualCloseOutputStream$$$outer().logError((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(68).append("Exception occurred while manually close the output stream to file ").append(this.org$apache$spark$storage$DiskBlockObjectWriter$ManualCloseOutputStream$$$outer().file()).append(", ").append(e.getMessage()).toString());
            }
        }

        public /* synthetic */ DiskBlockObjectWriter org$apache$spark$storage$DiskBlockObjectWriter$ManualCloseOutputStream$$$outer();

        public static void $init$(ManualCloseOutputStream $this) {
        }
    }
}

