/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.storage;

import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.nio.channels.FileChannel;
import java.nio.channels.WritableByteChannel;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.FileUtils;
import org.apache.spark.SecurityManager;
import org.apache.spark.SparkConf;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.config.package$;
import org.apache.spark.security.CryptoStreamUtils$;
import org.apache.spark.storage.BlockData;
import org.apache.spark.storage.BlockId;
import org.apache.spark.storage.CountingWritableChannel;
import org.apache.spark.storage.DiskBlockData;
import org.apache.spark.storage.DiskBlockManager;
import org.apache.spark.storage.EncryptedBlockData;
import org.apache.spark.util.Utils$;
import org.apache.spark.util.io.ChunkedByteBuffer;
import org.slf4j.Logger;
import org.sparkproject.guava.io.Closeables;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Some;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005\u0005}b!\u0002\u000b\u0016\u0001]i\u0002\u0002\u0003\u0016\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u0017\t\u0011A\u0002!\u0011!Q\u0001\nEB\u0001\"\u000e\u0001\u0003\u0002\u0003\u0006IA\u000e\u0005\u0006s\u0001!\tA\u000f\u0005\b\u007f\u0001\u0011\r\u0011\"\u0003A\u0011\u0019!\u0005\u0001)A\u0005\u0003\"9Q\t\u0001b\u0001\n\u0013\u0001\u0005B\u0002$\u0001A\u0003%\u0011\tC\u0004H\u0001\t\u0007I\u0011\u0002%\t\rY\u0003\u0001\u0015!\u0003J\u0011\u00159\u0006\u0001\"\u0001Y\u0011\u0015Y\u0006\u0001\"\u0001]\u0011\u0015y\u0007\u0001\"\u0001q\u0011\u0015Y\b\u0001\"\u0001}\u0011\u0019Y\b\u0001\"\u0001\u0002\u0004!9\u0011q\u0003\u0001\u0005\u0002\u0005e\u0001bBA\u0012\u0001\u0011\u0005\u0011Q\u0005\u0005\b\u0003c\u0001A\u0011AA\u001a\u0011\u001d\t9\u0004\u0001C\u0005\u0003s\u0011\u0011\u0002R5tWN#xN]3\u000b\u0005Y9\u0012aB:u_J\fw-\u001a\u0006\u00031e\tQa\u001d9be.T!AG\u000e\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005a\u0012aA8sON\u0019\u0001A\b\u0013\u0011\u0005}\u0011S\"\u0001\u0011\u000b\u0003\u0005\nQa]2bY\u0006L!a\t\u0011\u0003\r\u0005s\u0017PU3g!\t)\u0003&D\u0001'\u0015\t9s#\u0001\u0005j]R,'O\\1m\u0013\tIcEA\u0004M_\u001e<\u0017N\\4\u0002\t\r|gNZ\u0002\u0001!\tic&D\u0001\u0018\u0013\tysCA\u0005Ta\u0006\u00148nQ8oM\u0006YA-[:l\u001b\u0006t\u0017mZ3s!\t\u00114'D\u0001\u0016\u0013\t!TC\u0001\tESN\\'\t\\8dW6\u000bg.Y4fe\u0006y1/Z2ve&$\u00180T1oC\u001e,'\u000f\u0005\u0002.o%\u0011\u0001h\u0006\u0002\u0010'\u0016\u001cWO]5us6\u000bg.Y4fe\u00061A(\u001b8jiz\"Ba\u000f\u001f>}A\u0011!\u0007\u0001\u0005\u0006U\u0011\u0001\r\u0001\f\u0005\u0006a\u0011\u0001\r!\r\u0005\u0006k\u0011\u0001\rAN\u0001\u0012[&tW*Z7pefl\u0015\r\u001d\"zi\u0016\u001cX#A!\u0011\u0005}\u0011\u0015BA\"!\u0005\u0011auN\\4\u0002%5Lg.T3n_JLX*\u00199CsR,7\u000fI\u0001\u0012[\u0006DX*Z7pefl\u0015\r\u001d\"zi\u0016\u001c\u0018AE7bq6+Wn\u001c:z\u001b\u0006\u0004()\u001f;fg\u0002\n!B\u00197pG.\u001c\u0016N_3t+\u0005I\u0005\u0003\u0002&R'\u0006k\u0011a\u0013\u0006\u0003\u00196\u000b!bY8oGV\u0014(/\u001a8u\u0015\tqu*\u0001\u0003vi&d'\"\u0001)\u0002\t)\fg/Y\u0005\u0003%.\u0013\u0011cQ8oGV\u0014(/\u001a8u\u0011\u0006\u001c\b.T1q!\t\u0011D+\u0003\u0002V+\t9!\t\\8dW&#\u0017a\u00032m_\u000e\\7+\u001b>fg\u0002\nqaZ3u'&TX\r\u0006\u0002B3\")!l\u0003a\u0001'\u00069!\r\\8dW&#\u0017a\u00019viR\u0011QL\u001c\u000b\u0003=\u0006\u0004\"aH0\n\u0005\u0001\u0004#\u0001B+oSRDQA\u0019\u0007A\u0002\r\f\u0011b\u001e:ji\u00164UO\\2\u0011\t}!gMX\u0005\u0003K\u0002\u0012\u0011BR;oGRLwN\\\u0019\u0011\u0005\u001ddW\"\u00015\u000b\u0005%T\u0017\u0001C2iC:tW\r\\:\u000b\u0005-|\u0015a\u00018j_&\u0011Q\u000e\u001b\u0002\u0014/JLG/\u00192mK\nKH/Z\"iC:tW\r\u001c\u0005\u000652\u0001\raU\u0001\taV$()\u001f;fgR\u0019a,\u001d:\t\u000bik\u0001\u0019A*\t\u000bMl\u0001\u0019\u0001;\u0002\u000b\tLH/Z:\u0011\u0005ULX\"\u0001<\u000b\u0005]D\u0018AA5p\u0015\tqu#\u0003\u0002{m\n\t2\t[;oW\u0016$')\u001f;f\u0005V4g-\u001a:\u0002\u0011\u001d,GOQ=uKN$2!`A\u0001!\t\u0011d0\u0003\u0002\u0000+\tI!\t\\8dW\u0012\u000bG/\u0019\u0005\u00065:\u0001\ra\u0015\u000b\u0006{\u0006\u0015\u00111\u0003\u0005\b\u0003\u000fy\u0001\u0019AA\u0005\u0003\u00051\u0007\u0003BA\u0006\u0003\u001fi!!!\u0004\u000b\u0005]|\u0015\u0002BA\t\u0003\u001b\u0011AAR5mK\"1\u0011QC\bA\u0002\u0005\u000b\u0011B\u00197pG.\u001c\u0016N_3\u0002\rI,Wn\u001c<f)\u0011\tY\"!\t\u0011\u0007}\ti\"C\u0002\u0002 \u0001\u0012qAQ8pY\u0016\fg\u000eC\u0003[!\u0001\u00071+A\bn_Z,g)\u001b7f)>\u0014En\\2l)\u001dq\u0016qEA\u0016\u0003[Aq!!\u000b\u0012\u0001\u0004\tI!\u0001\u0006t_V\u00148-\u001a$jY\u0016Da!!\u0006\u0012\u0001\u0004\t\u0005BBA\u0018#\u0001\u00071+A\u0007uCJ<W\r\u001e\"m_\u000e\\\u0017\nZ\u0001\tG>tG/Y5ogR!\u00111DA\u001b\u0011\u0015Q&\u00031\u0001T\u00031y\u0007/\u001a8G_J<&/\u001b;f)\r1\u00171\b\u0005\b\u0003{\u0019\u0002\u0019AA\u0005\u0003\u00111\u0017\u000e\\3")
public class DiskStore
implements Logging {
    private final SparkConf conf;
    private final DiskBlockManager diskManager;
    private final SecurityManager securityManager;
    private final long minMemoryMapBytes;
    private final long maxMemoryMapBytes;
    private final ConcurrentHashMap<BlockId, Object> blockSizes;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    @Override
    public String logName() {
        return Logging.logName$(this);
    }

    @Override
    public Logger log() {
        return Logging.log$(this);
    }

    @Override
    public void logInfo(Function0<String> msg) {
        Logging.logInfo$(this, msg);
    }

    @Override
    public void logDebug(Function0<String> msg) {
        Logging.logDebug$(this, msg);
    }

    @Override
    public void logTrace(Function0<String> msg) {
        Logging.logTrace$(this, msg);
    }

    @Override
    public void logWarning(Function0<String> msg) {
        Logging.logWarning$(this, msg);
    }

    @Override
    public void logError(Function0<String> msg) {
        Logging.logError$(this, msg);
    }

    @Override
    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$(this, msg, throwable);
    }

    @Override
    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$(this, msg, throwable);
    }

    @Override
    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$(this, msg, throwable);
    }

    @Override
    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$(this, msg, throwable);
    }

    @Override
    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$(this, msg, throwable);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$(this, isInterpreter);
    }

    @Override
    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$(this, isInterpreter, silent);
    }

    @Override
    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$(this);
    }

    @Override
    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$(this, isInterpreter, silent);
    }

    @Override
    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    @Override
    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private long minMemoryMapBytes() {
        return this.minMemoryMapBytes;
    }

    private long maxMemoryMapBytes() {
        return this.maxMemoryMapBytes;
    }

    private ConcurrentHashMap<BlockId, Object> blockSizes() {
        return this.blockSizes;
    }

    public long getSize(BlockId blockId) {
        return BoxesRunTime.unboxToLong((Object)this.blockSizes().get(blockId));
    }

    public void put(BlockId blockId, Function1<WritableByteChannel, BoxedUnit> writeFunc) {
        if (this.contains(blockId)) {
            throw new IllegalStateException(new StringBuilder(43).append("Block ").append(blockId).append(" is already present in the disk store").toString());
        }
        this.logDebug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(24).append("Attempting to put block ").append(blockId).toString());
        long startTimeNs = System.nanoTime();
        File file = this.diskManager.getFile(blockId);
        CountingWritableChannel out = new CountingWritableChannel(this.openForWrite(file));
        boolean threwException = true;
        try {
            writeFunc.apply((Object)out);
            this.blockSizes().put(blockId, BoxesRunTime.boxToLong((long)out.getCount()));
            threwException = false;
        }
        finally {
            try {
                try {
                    out.close();
                }
                catch (IOException ioe) {
                    if (!threwException) {
                        threwException = true;
                        throw ioe;
                    }
                }
            }
            finally {
                if (threwException) {
                    this.remove(blockId);
                }
            }
        }
        this.logDebug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(0).append(new StringBuilder(22).append("Block ").append(file.getName()).append(" stored as ").append(Utils$.MODULE$.bytesToString(file.length())).append(" file").toString()).append(new StringBuilder(15).append(" on disk in ").append(TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - startTimeNs)).append(" ms").toString()).toString());
    }

    public void putBytes(BlockId blockId, ChunkedByteBuffer bytes) {
        this.put(blockId, (Function1<WritableByteChannel, BoxedUnit>)(Function1 & Serializable)channel -> {
            bytes.writeFully(channel);
            return BoxedUnit.UNIT;
        });
    }

    public BlockData getBytes(BlockId blockId) {
        return this.getBytes(this.diskManager.getFile(blockId.name()), this.getSize(blockId));
    }

    public BlockData getBytes(File f, long blockSize) {
        BlockData blockData;
        Option<byte[]> option = this.securityManager.getIOEncryptionKey();
        if (option instanceof Some) {
            Some some = (Some)option;
            byte[] key = (byte[])some.value();
            blockData = new EncryptedBlockData(f, blockSize, this.conf, key);
        } else {
            blockData = new DiskBlockData(this.minMemoryMapBytes(), this.maxMemoryMapBytes(), f, blockSize);
        }
        return blockData;
    }

    /*
     * WARNING - void declaration
     */
    public boolean remove(BlockId blockId) {
        boolean bl;
        this.blockSizes().remove(blockId);
        File file = this.diskManager.getFile(blockId.name());
        if (file.exists()) {
            void var3_3;
            boolean ret = file.delete();
            if (!ret) {
                this.logWarning((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(15).append("Error deleting ").append(file.getPath()).toString());
            }
            bl = var3_3;
        } else {
            bl = false;
        }
        return bl;
    }

    public void moveFileToBlock(File sourceFile, long blockSize, BlockId targetBlockId) {
        this.blockSizes().put(targetBlockId, BoxesRunTime.boxToLong((long)blockSize));
        File targetFile = this.diskManager.getFile(targetBlockId.name());
        FileUtils.moveFile((File)sourceFile, (File)targetFile);
    }

    public boolean contains(BlockId blockId) {
        File file = this.diskManager.getFile(blockId.name());
        return file.exists();
    }

    private WritableByteChannel openForWrite(File file) {
        WritableByteChannel writableByteChannel;
        FileChannel out = new FileOutputStream(file).getChannel();
        try {
            writableByteChannel = (WritableByteChannel)this.securityManager.getIOEncryptionKey().map((Function1 & Serializable)key -> CryptoStreamUtils$.MODULE$.createWritableChannel(out, $this.conf, (byte[])key)).getOrElse((Function0 & Serializable)() -> out);
        }
        catch (Exception e) {
            Closeables.close((Closeable)out, (boolean)true);
            file.delete();
            throw e;
        }
        return writableByteChannel;
    }

    public DiskStore(SparkConf conf, DiskBlockManager diskManager, SecurityManager securityManager) {
        this.conf = conf;
        this.diskManager = diskManager;
        this.securityManager = securityManager;
        Logging.$init$(this);
        this.minMemoryMapBytes = BoxesRunTime.unboxToLong((Object)conf.get(package$.MODULE$.STORAGE_MEMORY_MAP_THRESHOLD()));
        this.maxMemoryMapBytes = BoxesRunTime.unboxToLong((Object)conf.get(package$.MODULE$.MEMORY_MAP_LIMIT_FOR_TESTS()));
        this.blockSizes = new ConcurrentHashMap();
    }
}

