/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.storage;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import org.apache.spark.SparkConf;
import org.apache.spark.network.util.JavaUtils;
import org.apache.spark.security.CryptoStreamUtils$;
import org.apache.spark.storage.BlockData;
import org.apache.spark.storage.ReadableChannelFileRegion;
import org.apache.spark.unsafe.array.ByteArrayMethods;
import org.apache.spark.util.io.ChunkedByteBuffer;
import org.sparkproject.guava.io.Closeables;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.collection.mutable.ListBuffer;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005]4Q!\u0004\b\u0001!YA\u0001\"\t\u0001\u0003\u0002\u0003\u0006Ia\t\u0005\tW\u0001\u0011\t\u0011)A\u0005Y!Aq\u0006\u0001B\u0001B\u0003%\u0001\u0007\u0003\u00055\u0001\t\u0005\t\u0015!\u00036\u0011\u0015Y\u0004\u0001\"\u0001=\u0011\u0015\u0011\u0005\u0001\"\u0011D\u0011\u00159\u0005\u0001\"\u0011I\u0011\u0015y\u0005\u0001\"\u0011Q\u0011\u00151\u0007\u0001\"\u0011h\u0011\u0015A\u0007\u0001\"\u0011j\u0011\u0015Q\u0007\u0001\"\u0011l\u0011\u0015y\u0007\u0001\"\u0003q\u0005I)en\u0019:zaR,GM\u00117pG.$\u0015\r^1\u000b\u0005=\u0001\u0012aB:u_J\fw-\u001a\u0006\u0003#I\tQa\u001d9be.T!a\u0005\u000b\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005)\u0012aA8sON\u0019\u0001aF\u000f\u0011\u0005aYR\"A\r\u000b\u0003i\tQa]2bY\u0006L!\u0001H\r\u0003\r\u0005s\u0017PU3g!\tqr$D\u0001\u000f\u0013\t\u0001cBA\u0005CY>\u001c7\u000eR1uC\u0006!a-\u001b7f\u0007\u0001\u0001\"\u0001J\u0015\u000e\u0003\u0015R!AJ\u0014\u0002\u0005%|'\"\u0001\u0015\u0002\t)\fg/Y\u0005\u0003U\u0015\u0012AAR5mK\u0006I!\r\\8dWNK'0\u001a\t\u000315J!AL\r\u0003\t1{gnZ\u0001\u0005G>tg\r\u0005\u00022e5\t\u0001#\u0003\u00024!\tI1\u000b]1sW\u000e{gNZ\u0001\u0004W\u0016L\bc\u0001\r7q%\u0011q'\u0007\u0002\u0006\u0003J\u0014\u0018-\u001f\t\u00031eJ!AO\r\u0003\t\tKH/Z\u0001\u0007y%t\u0017\u000e\u001e \u0015\u000burt\bQ!\u0011\u0005y\u0001\u0001\"B\u0011\u0006\u0001\u0004\u0019\u0003\"B\u0016\u0006\u0001\u0004a\u0003\"B\u0018\u0006\u0001\u0004\u0001\u0004\"\u0002\u001b\u0006\u0001\u0004)\u0014!\u0004;p\u0013:\u0004X\u000f^*ue\u0016\fW\u000eF\u0001E!\t!S)\u0003\u0002GK\tY\u0011J\u001c9viN#(/Z1n\u0003\u001d!xNT3uif$\u0012!\u0013\t\u0003\u00156k\u0011a\u0013\u0006\u0003\u0019\u001e\nA\u0001\\1oO&\u0011aj\u0013\u0002\u0007\u001f\nTWm\u0019;\u0002'Q|7\t[;oW\u0016$')\u001f;f\u0005V4g-\u001a:\u0015\u0005EC\u0006C\u0001*W\u001b\u0005\u0019&B\u0001\u0014U\u0015\t)\u0006#\u0001\u0003vi&d\u0017BA,T\u0005E\u0019\u0005.\u001e8lK\u0012\u0014\u0015\u0010^3Ck\u001a4WM\u001d\u0005\u00063\"\u0001\rAW\u0001\nC2dwnY1u_J\u0004B\u0001G.^A&\u0011A,\u0007\u0002\n\rVt7\r^5p]F\u0002\"\u0001\u00070\n\u0005}K\"aA%oiB\u0011\u0011\rZ\u0007\u0002E*\u00111mJ\u0001\u0004]&|\u0017BA3c\u0005)\u0011\u0015\u0010^3Ck\u001a4WM]\u0001\ri>\u0014\u0015\u0010^3Ck\u001a4WM\u001d\u000b\u0002A\u0006!1/\u001b>f+\u0005a\u0013a\u00023jgB|7/\u001a\u000b\u0002YB\u0011\u0001$\\\u0005\u0003]f\u0011A!\u00168ji\u0006!q\u000e]3o)\u0005\t\bC\u0001:v\u001b\u0005\u0019(B\u0001;c\u0003!\u0019\u0007.\u00198oK2\u001c\u0018B\u0001<t\u0005M\u0011V-\u00193bE2,')\u001f;f\u0007\"\fgN\\3m\u0001")
public class EncryptedBlockData
implements BlockData {
    private final File file;
    private final long blockSize;
    private final SparkConf conf;
    private final byte[] key;

    @Override
    public InputStream toInputStream() {
        return Channels.newInputStream(this.open());
    }

    @Override
    public Object toNetty() {
        return new ReadableChannelFileRegion(this.open(), this.blockSize);
    }

    @Override
    public ChunkedByteBuffer toChunkedByteBuffer(Function1<Object, ByteBuffer> allocator) {
        ChunkedByteBuffer chunkedByteBuffer;
        try (ReadableByteChannel source = this.open();){
            long chunkSize;
            ListBuffer chunks = new ListBuffer();
            for (long remaining = this.blockSize; remaining > 0L; remaining -= chunkSize) {
                chunkSize = package$.MODULE$.min(remaining, (long)ByteArrayMethods.MAX_ROUNDED_ARRAY_LENGTH);
                ByteBuffer chunk = (ByteBuffer)allocator.apply((Object)BoxesRunTime.boxToInteger((int)((int)chunkSize)));
                JavaUtils.readFully((ReadableByteChannel)source, (ByteBuffer)chunk);
                chunk.flip();
                chunks.$plus$eq((Object)chunk);
            }
            chunkedByteBuffer = new ChunkedByteBuffer((ByteBuffer[])chunks.toArray(ClassTag$.MODULE$.apply(ByteBuffer.class)));
        }
        return chunkedByteBuffer;
    }

    @Override
    public ByteBuffer toByteBuffer() {
        ByteBuffer byteBuffer;
        Predef$.MODULE$.assert(this.blockSize <= (long)ByteArrayMethods.MAX_ROUNDED_ARRAY_LENGTH, (Function0 & Serializable)() -> "Block is too large to be wrapped in a byte buffer.");
        ByteBuffer dst = ByteBuffer.allocate((int)this.blockSize);
        ReadableByteChannel in = this.open();
        try {
            JavaUtils.readFully((ReadableByteChannel)in, (ByteBuffer)dst);
            dst.flip();
            byteBuffer = dst;
        }
        finally {
            Closeables.close((Closeable)in, (boolean)true);
        }
        return byteBuffer;
    }

    @Override
    public long size() {
        return this.blockSize;
    }

    @Override
    public void dispose() {
    }

    private ReadableByteChannel open() {
        ReadableByteChannel readableByteChannel;
        FileChannel channel = new FileInputStream(this.file).getChannel();
        try {
            readableByteChannel = CryptoStreamUtils$.MODULE$.createReadableChannel(channel, this.conf, this.key);
        }
        catch (Exception e) {
            Closeables.close((Closeable)channel, (boolean)true);
            throw e;
        }
        return readableByteChannel;
    }

    public EncryptedBlockData(File file, long blockSize, SparkConf conf, byte[] key) {
        this.file = file;
        this.blockSize = blockSize;
        this.conf = conf;
        this.key = key;
    }
}

