/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.storage;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.concurrent.TimeUnit;
import org.apache.spark.MapOutputTracker;
import org.apache.spark.MapOutputTracker$;
import org.apache.spark.internal.Logging;
import org.apache.spark.network.shuffle.BlockStoreClient;
import org.apache.spark.network.shuffle.MergedBlockMeta;
import org.apache.spark.network.shuffle.MergedBlocksMetaListener;
import org.apache.spark.storage.BlockId;
import org.apache.spark.storage.BlockManager;
import org.apache.spark.storage.BlockManagerId;
import org.apache.spark.storage.BlockManagerId$;
import org.apache.spark.storage.HostLocalDirManager;
import org.apache.spark.storage.ShuffleBlockChunkId;
import org.apache.spark.storage.ShuffleBlockFetcherIterator;
import org.apache.spark.storage.ShuffleMergedBlockId;
import org.roaringbitmap.RoaringBitmap;
import org.slf4j.Logger;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnceOps;
import scala.collection.Iterator;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashSet;
import scala.collection.mutable.LinkedHashSet;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;

@ScalaSignature(bytes="\u0006\u0005\u0005}f\u0001B\r\u001b\t\rB\u0001\u0002\r\u0001\u0003\u0006\u0004%I!\r\u0005\tm\u0001\u0011\t\u0011)A\u0005e!Aq\u0007\u0001BC\u0002\u0013%\u0001\b\u0003\u0005B\u0001\t\u0005\t\u0015!\u0003:\u0011!\u0011\u0005A!b\u0001\n\u0013\u0019\u0005\u0002C$\u0001\u0005\u0003\u0005\u000b\u0011\u0002#\t\u0011!\u0003!Q1A\u0005\n%C\u0001B\u0014\u0001\u0003\u0002\u0003\u0006IA\u0013\u0005\u0006\u001f\u0002!\t\u0001\u0015\u0005\u0007-\u0002\u0001\u000b\u0011B,\t\u0011i\u0003!\u0019!C\u00015mCaa\u0018\u0001!\u0002\u0013a\u0006B\u00021\u0001A\u0003%\u0011\rC\u0003s\u0001\u0011\u00051\u000fC\u0003z\u0001\u0011\u0005!\u0010C\u0003}\u0001\u0011\u0005Q\u0010\u0003\u0004\u0000\u0001\u0011\u0005\u0011\u0011\u0001\u0005\b\u0003\u001b\u0001A\u0011AA\b\u0011\u001d\t9\u0002\u0001C\u0001\u00033Aq!!\u0014\u0001\t\u0003\ty\u0005C\u0004\u0002z\u0001!\t!a\u001f\t\u000f\u0005\u001d\u0005\u0001\"\u0003\u0002\n\"A\u0011q\u0013\u0001!\n\u0013\tI\nC\u0004\u00028\u0002!\t!!/\u0003)A+8\u000f\u001b\"bg\u0016$g)\u001a;dQ\"+G\u000e]3s\u0015\tYB$A\u0004ti>\u0014\u0018mZ3\u000b\u0005uq\u0012!B:qCJ\\'BA\u0010!\u0003\u0019\t\u0007/Y2iK*\t\u0011%A\u0002pe\u001e\u001c\u0001aE\u0002\u0001I)\u0002\"!\n\u0015\u000e\u0003\u0019R\u0011aJ\u0001\u0006g\u000e\fG.Y\u0005\u0003S\u0019\u0012a!\u00118z%\u00164\u0007CA\u0016/\u001b\u0005a#BA\u0017\u001d\u0003!Ig\u000e^3s]\u0006d\u0017BA\u0018-\u0005\u001daunZ4j]\u001e\f\u0001\"\u001b;fe\u0006$xN]\u000b\u0002eA\u00111\u0007N\u0007\u00025%\u0011QG\u0007\u0002\u001c'\",hM\u001a7f\u00052|7m\u001b$fi\u000eDWM]%uKJ\fGo\u001c:\u0002\u0013%$XM]1u_J\u0004\u0013!D:ik\u001a4G.Z\"mS\u0016tG/F\u0001:!\tQt(D\u0001<\u0015\taT(A\u0004tQV4g\r\\3\u000b\u0005yb\u0012a\u00028fi^|'o[\u0005\u0003\u0001n\u0012\u0001C\u00117pG.\u001cFo\u001c:f\u00072LWM\u001c;\u0002\u001dMDWO\u001a4mK\u000ec\u0017.\u001a8uA\u0005a!\r\\8dW6\u000bg.Y4feV\tA\t\u0005\u00024\u000b&\u0011aI\u0007\u0002\r\u00052|7m['b]\u0006<WM]\u0001\u000eE2|7m['b]\u0006<WM\u001d\u0011\u0002!5\f\u0007oT;uaV$HK]1dW\u0016\u0014X#\u0001&\u0011\u0005-cU\"\u0001\u000f\n\u00055c\"\u0001E'ba>+H\u000f];u)J\f7m[3s\u0003Ei\u0017\r](viB,H\u000f\u0016:bG.,'\u000fI\u0001\u0007y%t\u0017\u000e\u001e \u0015\u000bE\u00136\u000bV+\u0011\u0005M\u0002\u0001\"\u0002\u0019\n\u0001\u0004\u0011\u0004\"B\u001c\n\u0001\u0004I\u0004\"\u0002\"\n\u0001\u0004!\u0005\"\u0002%\n\u0001\u0004Q\u0015aC:uCJ$H+[7f\u001dN\u0004\"!\n-\n\u0005e3#\u0001\u0002'p]\u001e\fA\u0004\\8dC2\u001c\u0006.\u001e4gY\u0016lUM]4fe\ncwnY6NOJLE-F\u0001]!\t\u0019T,\u0003\u0002_5\tq!\t\\8dW6\u000bg.Y4fe&#\u0017!\b7pG\u0006d7\u000b[;gM2,W*\u001a:hKJ\u0014En\\2l\u001b\u001e\u0014\u0018\n\u001a\u0011\u0002\u001b\rDWO\\6t\u001b\u0016$\u0018-T1q!\u0011\u0011w-\u001b7\u000e\u0003\rT!\u0001Z3\u0002\u000f5,H/\u00192mK*\u0011aMJ\u0001\u000bG>dG.Z2uS>t\u0017B\u00015d\u0005\u001dA\u0015m\u001d5NCB\u0004\"a\r6\n\u0005-T\"aE*ik\u001a4G.\u001a\"m_\u000e\\7\t[;oW&#\u0007CA7q\u001b\u0005q'BA8!\u00035\u0011x.\u0019:j]\u001e\u0014\u0017\u000e^7ba&\u0011\u0011O\u001c\u0002\u000e%>\f'/\u001b8h\u0005&$X.\u00199\u0002?%\u001c\b+^:i\u001b\u0016\u0014x-\u001a3TQV4g\r\\3CY>\u001c7.\u00113ee\u0016\u001c8\u000f\u0006\u0002uoB\u0011Q%^\u0005\u0003m\u001a\u0012qAQ8pY\u0016\fg\u000eC\u0003y\u001d\u0001\u0007A,A\u0004bI\u0012\u0014Xm]:\u0002=%\u001c(+Z7pi\u0016\u0004Vo\u001d5NKJ<W\r\u001a\"m_\u000e\\\u0017\t\u001a3sKN\u001cHC\u0001;|\u0011\u0015Ax\u00021\u0001]\u0003uI7\u000fT8dC2\u0004Vo\u001d5NKJ<W\r\u001a\"m_\u000e\\\u0017\t\u001a3sKN\u001cHC\u0001;\u007f\u0011\u0015A\b\u00031\u0001]\u0003-\u0011X-\\8wK\u000eCWO\\6\u0015\t\u0005\r\u0011\u0011\u0002\t\u0004K\u0005\u0015\u0011bAA\u0004M\t!QK\\5u\u0011\u0019\tY!\u0005a\u0001S\u00069!\r\\8dW&#\u0017\u0001C1eI\u000eCWO\\6\u0015\r\u0005\r\u0011\u0011CA\n\u0011\u0019\tYA\u0005a\u0001S\"1\u0011Q\u0003\nA\u00021\f\u0011b\u00195v].lU\r^1\u0002K\r\u0014X-\u0019;f\u0007\",hn\u001b\"m_\u000e\\\u0017J\u001c4pg\u001a\u0013x.\\'fi\u0006\u0014Vm\u001d9p]N,G\u0003DA\u000e\u0003g\t9$a\u000f\u0002@\u0005\r\u0003#\u00022\u0002\u001e\u0005\u0005\u0012bAA\u0010G\nY\u0011I\u001d:bs\n+hMZ3s!!)\u00131EA\u0014/\u00065\u0012bAA\u0013M\t1A+\u001e9mKN\u00022aMA\u0015\u0013\r\tYC\u0007\u0002\b\u00052|7m[%e!\r)\u0013qF\u0005\u0004\u0003c1#aA%oi\"9\u0011QG\nA\u0002\u00055\u0012!C:ik\u001a4G.Z%e\u0011\u001d\tId\u0005a\u0001\u0003[\tab\u001d5vM\u001adW-T3sO\u0016LE\rC\u0004\u0002>M\u0001\r!!\f\u0002\u0011I,G-^2f\u0013\u0012Da!!\u0011\u0014\u0001\u00049\u0016!\u00032m_\u000e\\7+\u001b>f\u0011\u001d\t)e\u0005a\u0001\u0003\u000f\nqAY5u[\u0006\u00048\u000f\u0005\u0003&\u0003\u0013b\u0017bAA&M\t)\u0011I\u001d:bs\u0006a2/\u001a8e\r\u0016$8\r['fe\u001e,Gm\u0015;biV\u001c(+Z9vKN$H\u0003BA\u0002\u0003#Bq!a\u0015\u0015\u0001\u0004\t)&A\u0002sKF\u0004B!a\u0016\u0002t9!\u0011\u0011LA8\u001d\u0011\tY&!\u001c\u000f\t\u0005u\u00131\u000e\b\u0005\u0003?\nIG\u0004\u0003\u0002b\u0005\u001dTBAA2\u0015\r\t)GI\u0001\u0007yI|w\u000e\u001e \n\u0003\u0005J!a\b\u0011\n\u0005uq\u0012BA\u000e\u001d\u0013\r\t\tHG\u0001\u001c'\",hM\u001a7f\u00052|7m\u001b$fi\u000eDWM]%uKJ\fGo\u001c:\n\t\u0005U\u0014q\u000f\u0002\r\r\u0016$8\r\u001b*fcV,7\u000f\u001e\u0006\u0004\u0003cR\u0012!\b4fi\u000eD\u0017\t\u001c7QkNDW*\u001a:hK\u0012dunY1m\u00052|7m[:\u0015\t\u0005\r\u0011Q\u0010\u0005\b\u0003\u007f*\u0002\u0019AAA\u0003U\u0001Xo\u001d5NKJ<W\r\u001a'pG\u0006d'\t\\8dWN\u0004RAYAB\u0003OI1!!\"d\u00055a\u0015N\\6fI\"\u000b7\u000f[*fi\u0006Qb-\u001a;dQB+8\u000f['fe\u001e,G\rT8dC2\u0014En\\2lgR1\u00111AAF\u0003+Cq!!$\u0017\u0001\u0004\ty)A\ni_N$Hj\\2bY\u0012K'/T1oC\u001e,'\u000fE\u00024\u0003#K1!a%\u001b\u0005MAun\u001d;M_\u000e\fG\u000eR5s\u001b\u0006t\u0017mZ3s\u0011\u001d\tyH\u0006a\u0001\u0003\u0003\u000b\u0011DZ3uG\"\u0004Vo\u001d5NKJ<W\r\u001a'pG\u0006d'\t\\8dWRA\u00111AAN\u0003;\u000b\u0019\fC\u0004\u0002\f]\u0001\r!a\n\t\u000f\u0005}u\u00031\u0001\u0002\"\u0006IAn\\2bY\u0012K'o\u001d\t\u0006K\u0005%\u00131\u0015\t\u0005\u0003K\u000biK\u0004\u0003\u0002(\u0006%\u0006cAA1M%\u0019\u00111\u0016\u0014\u0002\rA\u0013X\rZ3g\u0013\u0011\ty+!-\u0003\rM#(/\u001b8h\u0015\r\tYK\n\u0005\u0007\u0003k;\u0002\u0019\u0001/\u0002\u001d\tdwnY6NC:\fw-\u001a:JI\u00069\u0013N\\5uS\u0006$XMR1mY\n\f7m\u001b$fi\u000eDgi\u001c:QkNDW*\u001a:hK\u0012\u0014En\\2l)\u0019\t\u0019!a/\u0002>\"9\u00111\u0002\rA\u0002\u0005\u001d\u0002\"\u0002=\u0019\u0001\u0004a\u0006")
public class PushBasedFetchHelper
implements Logging {
    private final ShuffleBlockFetcherIterator org$apache$spark$storage$PushBasedFetchHelper$$iterator;
    private final BlockStoreClient shuffleClient;
    private final BlockManager blockManager;
    private final MapOutputTracker mapOutputTracker;
    private final long startTimeNs;
    private final BlockManagerId localShuffleMergerBlockMgrId;
    private final HashMap<ShuffleBlockChunkId, RoaringBitmap> chunksMetaMap;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    @Override
    public String logName() {
        return Logging.logName$(this);
    }

    @Override
    public Logger log() {
        return Logging.log$(this);
    }

    @Override
    public void logInfo(Function0<String> msg) {
        Logging.logInfo$(this, msg);
    }

    @Override
    public void logDebug(Function0<String> msg) {
        Logging.logDebug$(this, msg);
    }

    @Override
    public void logTrace(Function0<String> msg) {
        Logging.logTrace$(this, msg);
    }

    @Override
    public void logWarning(Function0<String> msg) {
        Logging.logWarning$(this, msg);
    }

    @Override
    public void logError(Function0<String> msg) {
        Logging.logError$(this, msg);
    }

    @Override
    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$(this, msg, throwable);
    }

    @Override
    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$(this, msg, throwable);
    }

    @Override
    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$(this, msg, throwable);
    }

    @Override
    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$(this, msg, throwable);
    }

    @Override
    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$(this, msg, throwable);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$(this, isInterpreter);
    }

    @Override
    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$(this, isInterpreter, silent);
    }

    @Override
    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$(this);
    }

    @Override
    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$(this, isInterpreter, silent);
    }

    @Override
    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    @Override
    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public ShuffleBlockFetcherIterator org$apache$spark$storage$PushBasedFetchHelper$$iterator() {
        return this.org$apache$spark$storage$PushBasedFetchHelper$$iterator;
    }

    private BlockStoreClient shuffleClient() {
        return this.shuffleClient;
    }

    private BlockManager blockManager() {
        return this.blockManager;
    }

    private MapOutputTracker mapOutputTracker() {
        return this.mapOutputTracker;
    }

    public BlockManagerId localShuffleMergerBlockMgrId() {
        return this.localShuffleMergerBlockMgrId;
    }

    public boolean isPushMergedShuffleBlockAddress(BlockManagerId address) {
        String string = BlockManagerId$.MODULE$.SHUFFLE_MERGER_IDENTIFIER();
        String string2 = address.executorId();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isRemotePushMergedBlockAddress(BlockManagerId address) {
        if (!this.isPushMergedShuffleBlockAddress(address)) return false;
        String string = address.host();
        String string2 = this.blockManager().blockManagerId().host();
        if (string == null) {
            if (string2 == null) return false;
            return true;
        } else if (string.equals(string2)) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isLocalPushMergedBlockAddress(BlockManagerId address) {
        if (!this.isPushMergedShuffleBlockAddress(address)) return false;
        String string = address.host();
        String string2 = this.blockManager().blockManagerId().host();
        if (string != null) {
            if (!string.equals(string2)) return false;
            return true;
        }
        if (string2 == null) return true;
        return false;
    }

    public void removeChunk(ShuffleBlockChunkId blockId) {
        this.chunksMetaMap.remove((Object)blockId);
    }

    public void addChunk(ShuffleBlockChunkId blockId, RoaringBitmap chunkMeta) {
        this.chunksMetaMap.update((Object)blockId, (Object)chunkMeta);
    }

    public ArrayBuffer<Tuple3<BlockId, Object, Object>> createChunkBlockInfosFromMetaResponse(int shuffleId, int shuffleMergeId, int reduceId, long blockSize, RoaringBitmap[] bitmaps) {
        long approxChunkSize = blockSize / (long)bitmaps.length;
        ArrayBuffer blocksToFetch = new ArrayBuffer();
        ArrayOps$.MODULE$.indices$extension(Predef$.MODULE$.refArrayOps((Object[])bitmaps)).foreach((Function1 & Serializable)i -> PushBasedFetchHelper.$anonfun$createChunkBlockInfosFromMetaResponse$1(this, shuffleId, shuffleMergeId, reduceId, bitmaps, approxChunkSize, blocksToFetch, BoxesRunTime.unboxToInt((Object)i)));
        return blocksToFetch;
    }

    public void sendFetchMergedStatusRequest(ShuffleBlockFetcherIterator.FetchRequest req) {
        Map sizeMap = ((IterableOnceOps)req.blocks().map((Function1 & Serializable)x0$1 -> {
            ShuffleBlockFetcherIterator.FetchBlockInfo fetchBlockInfo = x0$1;
            if (fetchBlockInfo == null) {
                throw new MatchError((Object)fetchBlockInfo);
            }
            BlockId blockId = fetchBlockInfo.blockId();
            long size = fetchBlockInfo.size();
            ShuffleMergedBlockId shuffleBlockId = (ShuffleMergedBlockId)blockId;
            Tuple2 tuple2 = new Tuple2((Object)new Tuple2.mcII.sp(shuffleBlockId.shuffleId(), shuffleBlockId.reduceId()), (Object)BoxesRunTime.boxToLong((long)size));
            return tuple2;
        })).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        BlockManagerId address = req.address();
        MergedBlocksMetaListener mergedBlocksMetaListener = new MergedBlocksMetaListener(this, req, sizeMap, address){
            private final /* synthetic */ PushBasedFetchHelper $outer;
            private final ShuffleBlockFetcherIterator.FetchRequest req$1;
            private final Map sizeMap$1;
            private final BlockManagerId address$1;

            public void onSuccess(int shuffleId, int shuffleMergeId, int reduceId, MergedBlockMeta meta) {
                this.$outer.logDebug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(0).append(new StringBuilder(47).append("Received the meta of push-merged block for (").append(shuffleId).append(", ").append(shuffleMergeId).append(",").toString()).append(new StringBuilder(9).append(" ").append(reduceId).append(") from ").append($this.req$1.address().host()).append(":").append($this.req$1.address().port()).toString()).toString());
                try {
                    this.$outer.org$apache$spark$storage$PushBasedFetchHelper$$iterator().addToResultsQueue(new ShuffleBlockFetcherIterator.PushMergedRemoteMetaFetchResult(shuffleId, shuffleMergeId, reduceId, BoxesRunTime.unboxToLong((Object)this.sizeMap$1.apply((Object)new Tuple2.mcII.sp(shuffleId, reduceId))), meta.readChunkBitmaps(), this.address$1));
                }
                catch (Exception exception) {
                    this.$outer.logError((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(0).append(new StringBuilder(53).append("Failed to parse the meta of push-merged block for (").append(shuffleId).append(", ").toString()).append(new StringBuilder(8).append(shuffleMergeId).append(", ").append(reduceId).append(") from").toString()).append(new StringBuilder(2).append(" ").append($this.req$1.address().host()).append(":").append($this.req$1.address().port()).toString()).toString(), exception);
                    this.$outer.org$apache$spark$storage$PushBasedFetchHelper$$iterator().addToResultsQueue(new ShuffleBlockFetcherIterator.PushMergedRemoteMetaFailedFetchResult(shuffleId, shuffleMergeId, reduceId, this.address$1));
                }
            }

            public void onFailure(int shuffleId, int shuffleMergeId, int reduceId, Throwable exception) {
                this.$outer.logError((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(0).append(new StringBuilder(53).append("Failed to get the meta of push-merged block for (").append(shuffleId).append(", ").append(reduceId).append(") ").toString()).append(new StringBuilder(6).append("from ").append($this.req$1.address().host()).append(":").append($this.req$1.address().port()).toString()).toString(), exception);
                this.$outer.org$apache$spark$storage$PushBasedFetchHelper$$iterator().addToResultsQueue(new ShuffleBlockFetcherIterator.PushMergedRemoteMetaFailedFetchResult(shuffleId, shuffleMergeId, reduceId, this.address$1));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.req$1 = req$1;
                this.sizeMap$1 = sizeMap$1;
                this.address$1 = address$1;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$onFailure$1(org.apache.spark.storage.PushBasedFetchHelper$$anon$1 int int ), $anonfun$onSuccess$1(org.apache.spark.storage.PushBasedFetchHelper$$anon$1 int int int ), $anonfun$onSuccess$2(org.apache.spark.storage.PushBasedFetchHelper$$anon$1 int int int )}, serializedLambda);
            }
        };
        req.blocks().foreach((Function1 & Serializable)block -> {
            PushBasedFetchHelper.$anonfun$sendFetchMergedStatusRequest$2(this, address, mergedBlocksMetaListener, block);
            return BoxedUnit.UNIT;
        });
    }

    public void fetchAllPushMergedLocalBlocks(LinkedHashSet<BlockId> pushMergedLocalBlocks) {
        block0: {
            if (!pushMergedLocalBlocks.nonEmpty()) break block0;
            this.blockManager().hostLocalDirManager().foreach((Function1 & Serializable)x$1 -> {
                this.fetchPushMergedLocalBlocks(x$1, (LinkedHashSet<BlockId>)pushMergedLocalBlocks);
                return BoxedUnit.UNIT;
            });
        }
    }

    private void fetchPushMergedLocalBlocks(HostLocalDirManager hostLocalDirManager, LinkedHashSet<BlockId> pushMergedLocalBlocks) {
        Option<String[]> cachedPushedMergedDirs = hostLocalDirManager.getCachedHostLocalDirsFor(BlockManagerId$.MODULE$.SHUFFLE_MERGER_IDENTIFIER());
        if (cachedPushedMergedDirs.isDefined()) {
            this.logDebug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(0).append("Fetch the push-merged-local blocks with cached merged dirs: ").append(String.valueOf(Predef$.MODULE$.wrapRefArray((Object[])cachedPushedMergedDirs.get()).mkString(", "))).toString());
            pushMergedLocalBlocks.foreach((Function1 & Serializable)blockId -> {
                this.fetchPushMergedLocalBlock(blockId, (String[])cachedPushedMergedDirs.get(), this.localShuffleMergerBlockMgrId());
                return BoxedUnit.UNIT;
            });
        } else {
            this.logDebug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(0).append("Asynchronous fetch the push-merged-local blocks without cached merged ").append("dirs from the external shuffle service").toString());
            hostLocalDirManager.getHostLocalDirs(this.blockManager().blockManagerId().host(), this.blockManager().externalShuffleServicePort(), (String[])((Object[])new String[]{BlockManagerId$.MODULE$.SHUFFLE_MERGER_IDENTIFIER()}), (Function1<Try<Map<String, String[]>>, BoxedUnit>)(Function1 & Serializable)x0$1 -> {
                PushBasedFetchHelper.$anonfun$fetchPushMergedLocalBlocks$4(this, pushMergedLocalBlocks, x0$1);
                return BoxedUnit.UNIT;
            });
        }
    }

    private void fetchPushMergedLocalBlock(BlockId blockId, String[] localDirs, BlockManagerId blockManagerId) {
        try {
            ShuffleMergedBlockId shuffleBlockId = (ShuffleMergedBlockId)blockId;
            MergedBlockMeta chunksMeta = this.blockManager().getLocalMergedBlockMeta(shuffleBlockId, localDirs);
            this.org$apache$spark$storage$PushBasedFetchHelper$$iterator().addToResultsQueue(new ShuffleBlockFetcherIterator.PushMergedLocalMetaFetchResult(shuffleBlockId.shuffleId(), shuffleBlockId.shuffleMergeId(), shuffleBlockId.reduceId(), chunksMeta.readChunkBitmaps(), localDirs));
        }
        catch (Exception e) {
            this.logWarning((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(0).append("Error occurred while fetching push-merged-local meta, ").append("prepare to fetch the original blocks").toString(), e);
            this.org$apache$spark$storage$PushBasedFetchHelper$$iterator().addToResultsQueue(new ShuffleBlockFetcherIterator.FallbackOnPushMergedFailureResult(blockId, blockManagerId, 0L, false));
        }
    }

    public void initiateFallbackFetchForPushMergedBlock(BlockId blockId, BlockManagerId address) {
        Iterator<Tuple2<BlockManagerId, Seq<Tuple3<BlockId, Object, Object>>>> iterator;
        Predef$.MODULE$.assert(blockId instanceof ShuffleMergedBlockId || blockId instanceof ShuffleBlockChunkId);
        this.logWarning((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(64).append("Falling back to fetch the original blocks for push-merged block ").append(blockId).toString());
        BlockId blockId2 = blockId;
        if (blockId2 instanceof ShuffleMergedBlockId) {
            ShuffleMergedBlockId shuffleMergedBlockId = (ShuffleMergedBlockId)blockId2;
            this.org$apache$spark$storage$PushBasedFetchHelper$$iterator().decreaseNumBlocksToFetch(1);
            iterator = this.mapOutputTracker().getMapSizesForMergeResult(shuffleMergedBlockId.shuffleId(), shuffleMergedBlockId.reduceId());
        } else {
            ShuffleBlockChunkId shuffleChunkId = (ShuffleBlockChunkId)blockId;
            RoaringBitmap chunkBitmap = (RoaringBitmap)this.chunksMetaMap.remove((Object)shuffleChunkId).get();
            int blocksProcessed = 1;
            if (this.isRemotePushMergedBlockAddress(address)) {
                HashSet<ShuffleBlockChunkId> pendingShuffleChunks = this.org$apache$spark$storage$PushBasedFetchHelper$$iterator().removePendingChunks(shuffleChunkId, address);
                pendingShuffleChunks.foreach((Function1 & Serializable)pendingBlockId -> {
                    PushBasedFetchHelper.$anonfun$initiateFallbackFetchForPushMergedBlock$2(this, chunkBitmap, pendingBlockId);
                    return BoxedUnit.UNIT;
                });
                blocksProcessed += pendingShuffleChunks.size();
            }
            this.org$apache$spark$storage$PushBasedFetchHelper$$iterator().decreaseNumBlocksToFetch(blocksProcessed);
            iterator = this.mapOutputTracker().getMapSizesForMergeResult(shuffleChunkId.shuffleId(), shuffleChunkId.reduceId(), chunkBitmap);
        }
        Iterator<Tuple2<BlockManagerId, Seq<Tuple3<BlockId, Object, Object>>>> fallbackBlocksByAddr = iterator;
        this.org$apache$spark$storage$PushBasedFetchHelper$$iterator().fallbackFetch(fallbackBlocksByAddr);
    }

    public static final /* synthetic */ ArrayBuffer $anonfun$createChunkBlockInfosFromMetaResponse$1(PushBasedFetchHelper $this, int shuffleId$1, int shuffleMergeId$1, int reduceId$1, RoaringBitmap[] bitmaps$1, long approxChunkSize$1, ArrayBuffer blocksToFetch$1, int i) {
        ShuffleBlockChunkId blockChunkId = new ShuffleBlockChunkId(shuffleId$1, shuffleMergeId$1, reduceId$1, i);
        $this.chunksMetaMap.put((Object)blockChunkId, (Object)bitmaps$1[i]);
        $this.logDebug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(28).append("adding block chunk ").append(blockChunkId).append(" of size ").append(approxChunkSize$1).toString());
        return (ArrayBuffer)blocksToFetch$1.$plus$eq((Object)new Tuple3((Object)blockChunkId, (Object)BoxesRunTime.boxToLong((long)approxChunkSize$1), (Object)BoxesRunTime.boxToInteger((int)MapOutputTracker$.MODULE$.SHUFFLE_PUSH_MAP_ID())));
    }

    public static final /* synthetic */ void $anonfun$sendFetchMergedStatusRequest$2(PushBasedFetchHelper $this, BlockManagerId address$1, MergedBlocksMetaListener mergedBlocksMetaListener$1, ShuffleBlockFetcherIterator.FetchBlockInfo block) {
        ShuffleMergedBlockId shuffleBlockId = (ShuffleMergedBlockId)block.blockId();
        $this.shuffleClient().getMergedBlockMeta(address$1.host(), address$1.port(), shuffleBlockId.shuffleId(), shuffleBlockId.shuffleMergeId(), shuffleBlockId.reduceId(), mergedBlocksMetaListener$1);
    }

    public static final /* synthetic */ void $anonfun$fetchPushMergedLocalBlocks$6(PushBasedFetchHelper $this, Map dirs$1, BlockId blockId) {
        $this.logDebug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(0).append("Successfully fetched local dirs: ").append(String.valueOf(Option$.MODULE$.option2Iterable(dirs$1.get((Object)BlockManagerId$.MODULE$.SHUFFLE_MERGER_IDENTIFIER())).mkString(", "))).toString());
        $this.fetchPushMergedLocalBlock(blockId, (String[])dirs$1.apply((Object)BlockManagerId$.MODULE$.SHUFFLE_MERGER_IDENTIFIER()), $this.localShuffleMergerBlockMgrId());
    }

    public static final /* synthetic */ void $anonfun$fetchPushMergedLocalBlocks$9(PushBasedFetchHelper $this, BlockId blockId) {
        $this.org$apache$spark$storage$PushBasedFetchHelper$$iterator().addToResultsQueue(new ShuffleBlockFetcherIterator.FallbackOnPushMergedFailureResult(blockId, $this.localShuffleMergerBlockMgrId(), 0L, false));
    }

    public static final /* synthetic */ void $anonfun$fetchPushMergedLocalBlocks$4(PushBasedFetchHelper $this, LinkedHashSet pushMergedLocalBlocks$2, Try x0$1) {
        Try try_ = x0$1;
        if (try_ instanceof Success) {
            Success success = (Success)try_;
            Map dirs = (Map)success.value();
            $this.logDebug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(0).append("Fetched merged dirs in ").append(new StringBuilder(3).append(TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - $this.startTimeNs)).append(" ms").toString()).toString());
            pushMergedLocalBlocks$2.foreach((Function1 & Serializable)blockId -> {
                PushBasedFetchHelper.$anonfun$fetchPushMergedLocalBlocks$6($this, dirs, blockId);
                return BoxedUnit.UNIT;
            });
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable throwable = failure.exception();
            $this.logWarning((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(0).append("Error while fetching the merged dirs for push-merged-local ").append(new StringBuilder(43).append("blocks: ").append(pushMergedLocalBlocks$2.mkString(", ")).append(". Fetch the original blocks instead").toString()).toString(), throwable);
            pushMergedLocalBlocks$2.foreach((Function1 & Serializable)blockId -> {
                PushBasedFetchHelper.$anonfun$fetchPushMergedLocalBlocks$9($this, blockId);
                return BoxedUnit.UNIT;
            });
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError((Object)try_);
        }
    }

    public static final /* synthetic */ void $anonfun$initiateFallbackFetchForPushMergedBlock$2(PushBasedFetchHelper $this, RoaringBitmap chunkBitmap$1, ShuffleBlockChunkId pendingBlockId) {
        $this.logInfo((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(43).append("Falling back immediately for shuffle chunk ").append(pendingBlockId).toString());
        RoaringBitmap bitmapOfPendingChunk = (RoaringBitmap)$this.chunksMetaMap.remove((Object)pendingBlockId).get();
        chunkBitmap$1.or(bitmapOfPendingChunk);
    }

    public PushBasedFetchHelper(ShuffleBlockFetcherIterator iterator, BlockStoreClient shuffleClient, BlockManager blockManager, MapOutputTracker mapOutputTracker) {
        this.org$apache$spark$storage$PushBasedFetchHelper$$iterator = iterator;
        this.shuffleClient = shuffleClient;
        this.blockManager = blockManager;
        this.mapOutputTracker = mapOutputTracker;
        Logging.$init$(this);
        this.startTimeNs = System.nanoTime();
        this.localShuffleMergerBlockMgrId = BlockManagerId$.MODULE$.apply(BlockManagerId$.MODULE$.SHUFFLE_MERGER_IDENTIFIER(), blockManager.blockManagerId().host(), blockManager.blockManagerId().port(), blockManager.blockManagerId().topologyInfo());
        this.chunksMetaMap = new HashMap();
    }
}

