/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ui.jobs;

import java.io.Serializable;
import java.util.Date;
import java.util.Locale;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.text.StringEscapeUtils;
import org.apache.spark.JobExecutionStatus;
import org.apache.spark.internal.config.UI$;
import org.apache.spark.scheduler.SchedulingMode$;
import org.apache.spark.status.AppStatusStore;
import org.apache.spark.status.AppSummary;
import org.apache.spark.status.api.v1.ApplicationAttemptInfo;
import org.apache.spark.status.api.v1.ApplicationInfo;
import org.apache.spark.status.api.v1.ExecutorSummary;
import org.apache.spark.status.api.v1.JobData;
import org.apache.spark.ui.ToolTips$;
import org.apache.spark.ui.UIUtils$;
import org.apache.spark.ui.WebUIPage;
import org.apache.spark.ui.jobs.ApiHelper$;
import org.apache.spark.ui.jobs.JobPagedTable;
import org.apache.spark.ui.jobs.JobsTab;
import org.apache.spark.util.Utils$;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Seq;
import scala.collection.SeqOps;
import scala.collection.StringOps$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.math.Ordering;
import scala.math.Ordering$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.java8.JFunction0;
import scala.xml.Elem;
import scala.xml.MetaData;
import scala.xml.NamespaceBinding;
import scala.xml.Node;
import scala.xml.NodeBuffer;
import scala.xml.NodeSeq;
import scala.xml.NodeSeq$;
import scala.xml.Null$;
import scala.xml.Text;
import scala.xml.TopScope$;
import scala.xml.Unparsed$;
import scala.xml.UnprefixedAttribute;
import scala.xml.Utility$;

@ScalaSignature(bytes="\u0006\u0005\u00055b!B\t\u0013\u0001Qa\u0002\u0002C\u0011\u0001\u0005\u0003\u0005\u000b\u0011B\u0012\t\u0011\u001d\u0002!\u0011!Q\u0001\n!BQA\f\u0001\u0005\u0002=Bqa\r\u0001C\u0002\u0013%A\u0007\u0003\u0004<\u0001\u0001\u0006I!\u000e\u0005\by\u0001\u0011\r\u0011\"\u00035\u0011\u0019i\u0004\u0001)A\u0005k!9a\b\u0001b\u0001\n\u0013y\u0004BB&\u0001A\u0003%\u0001\tC\u0004M\u0001\t\u0007I\u0011B \t\r5\u0003\u0001\u0015!\u0003A\u0011\u0015q\u0005\u0001\"\u0003P\u0011\u0015\u0019\u0007\u0001\"\u0003e\u0011\u0015Y\u0007\u0001\"\u0003m\u0011\u0015Y\b\u0001\"\u0003}\u0011\u001d\t9\u0003\u0001C\u0001\u0003S\u00111\"\u00117m\u0015>\u00147\u000fU1hK*\u00111\u0003F\u0001\u0005U>\u00147O\u0003\u0002\u0016-\u0005\u0011Q/\u001b\u0006\u0003/a\tQa\u001d9be.T!!\u0007\u000e\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005Y\u0012aA8sON\u0011\u0001!\b\t\u0003=}i\u0011\u0001F\u0005\u0003AQ\u0011\u0011bV3c+&\u0003\u0016mZ3\u0002\rA\f'/\u001a8u\u0007\u0001\u0001\"\u0001J\u0013\u000e\u0003II!A\n\n\u0003\u000f){'m\u001d+bE\u0006)1\u000f^8sKB\u0011\u0011\u0006L\u0007\u0002U)\u00111FF\u0001\u0007gR\fG/^:\n\u00055R#AD!qaN#\u0018\r^;t'R|'/Z\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0007A\n$\u0007\u0005\u0002%\u0001!)\u0011e\u0001a\u0001G!)qe\u0001a\u0001Q\u0005\tR*\u0011-`)&kU\tT%O\u000b~SuJQ*\u0016\u0003U\u0002\"AN\u001d\u000e\u0003]R\u0011\u0001O\u0001\u0006g\u000e\fG.Y\u0005\u0003u]\u00121!\u00138u\u0003Ii\u0015\tW0U\u00136+E*\u0013(F?*{%i\u0015\u0011\u0002-5\u000b\u0005l\u0018+J\u001b\u0016c\u0015JT#`\u000bb+5)\u0016+P%N\u000bq#T!Y?RKU*\u0012'J\u001d\u0016{V\tW#D+R{%k\u0015\u0011\u0002\u0017){%iU0M\u000b\u001e+e\nR\u000b\u0002\u0001B\u0011\u0011\t\u0013\b\u0003\u0005\u001a\u0003\"aQ\u001c\u000e\u0003\u0011S!!\u0012\u0012\u0002\rq\u0012xn\u001c;?\u0013\t9u'\u0001\u0004Qe\u0016$WMZ\u0005\u0003\u0013*\u0013aa\u0015;sS:<'BA$8\u00031QuJQ*`\u0019\u0016;UI\u0014#!\u0003A)\u0005,R\"V)>\u00136k\u0018'F\u000f\u0016sE)A\tF1\u0016\u001bU\u000bV(S'~cUiR#O\t\u0002\nA\"\\1lK*{'-\u0012<f]R$\"\u0001U-\u0011\u0007E3\u0006I\u0004\u0002S):\u00111iU\u0005\u0002q%\u0011QkN\u0001\ba\u0006\u001c7.Y4f\u0013\t9\u0006LA\u0002TKFT!!V\u001c\t\u000bMa\u0001\u0019\u0001.\u0011\u0007E36\f\u0005\u0002]C6\tQL\u0003\u0002_?\u0006\u0011a/\r\u0006\u0003A*\n1!\u00199j\u0013\t\u0011WLA\u0004K_\n$\u0015\r^1\u0002#5\f7.Z#yK\u000e,Ho\u001c:Fm\u0016tG\u000f\u0006\u0002QK\")a-\u0004a\u0001O\u0006IQ\r_3dkR|'o\u001d\t\u0004#ZC\u0007C\u0001/j\u0013\tQWLA\bFq\u0016\u001cW\u000f^8s'VlW.\u0019:z\u00031i\u0017m[3US6,G.\u001b8f)\u0011iG/\u001e<\u0011\u0007E3f\u000e\u0005\u0002pe6\t\u0001O\u0003\u0002ro\u0005\u0019\u00010\u001c7\n\u0005M\u0004(\u0001\u0002(pI\u0016DQa\u0005\bA\u0002iCQA\u001a\bA\u0002\u001dDQa\u001e\bA\u0002a\f\u0011b\u001d;beR$\u0016.\\3\u0011\u0005YJ\u0018B\u0001>8\u0005\u0011auN\\4\u0002\u0013)|'m\u001d+bE2,GCC7~\u0003'\t9\"a\u0007\u0002\u001e!)ap\u0004a\u0001\u007f\u00069!/Z9vKN$\b\u0003BA\u0001\u0003\u001fi!!a\u0001\u000b\t\u0005\u0015\u0011qA\u0001\u0005QR$\bO\u0003\u0003\u0002\n\u0005-\u0011aB:feZdW\r\u001e\u0006\u0003\u0003\u001b\tQA[1wCbLA!!\u0005\u0002\u0004\t\u0011\u0002\n\u001e;q'\u0016\u0014h\u000f\\3u%\u0016\fX/Z:u\u0011\u0019\t)b\u0004a\u0001\u0001\u0006iA/\u00192mK\"+\u0017\rZ3s\u0013\u0012Da!!\u0007\u0010\u0001\u0004\u0001\u0015A\u00026pER\u000bw\rC\u0003\u0014\u001f\u0001\u0007!\fC\u0004\u0002 =\u0001\r!!\t\u0002\u0017-LG\u000e\\#oC\ndW\r\u001a\t\u0004m\u0005\r\u0012bAA\u0013o\t9!i\\8mK\u0006t\u0017A\u0002:f]\u0012,'\u000fF\u0002n\u0003WAQA \tA\u0002}\u0004")
public class AllJobsPage
extends WebUIPage {
    private final JobsTab parent;
    private final AppStatusStore store;
    private final int MAX_TIMELINE_JOBS;
    private final int MAX_TIMELINE_EXECUTORS;
    private final String JOBS_LEGEND;
    private final String EXECUTORS_LEGEND;

    private int MAX_TIMELINE_JOBS() {
        return this.MAX_TIMELINE_JOBS;
    }

    private int MAX_TIMELINE_EXECUTORS() {
        return this.MAX_TIMELINE_EXECUTORS;
    }

    private String JOBS_LEGEND() {
        return this.JOBS_LEGEND;
    }

    private String EXECUTORS_LEGEND() {
        return this.EXECUTORS_LEGEND;
    }

    private scala.collection.immutable.Seq<String> makeJobEvent(scala.collection.immutable.Seq<JobData> jobs) {
        long now = System.currentTimeMillis();
        return (scala.collection.immutable.Seq)((IterableOps)((IterableOps)((SeqOps)jobs.filter((Function1 & Serializable)job -> BoxesRunTime.boxToBoolean((boolean)AllJobsPage.$anonfun$makeJobEvent$1(job)))).sortBy((Function1 & Serializable)j -> new Tuple2.mcJJ.sp(BoxesRunTime.unboxToLong((Object)j.completionTime().map((Function1 & Serializable)x$3 -> BoxesRunTime.boxToLong((long)x$3.getTime())).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable)() -> now)), ((Date)j.submissionTime().get()).getTime()), Ordering$.MODULE$.Tuple2((Ordering)Ordering.Long$.MODULE$, (Ordering)Ordering.Long$.MODULE$))).takeRight(this.MAX_TIMELINE_JOBS())).map((Function1 & Serializable)job -> {
            String string;
            String lastStageDescription;
            int jobId = job.jobId();
            JobExecutionStatus status = job.status();
            Tuple2<String, String> tuple2 = ApiHelper$.MODULE$.lastStageNameAndDescription($this.store, (JobData)job);
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            String string2 = lastStageDescription = (String)tuple2._2();
            String lastStageDescription2 = string2;
            String jobDescription = UIUtils$.MODULE$.makeDescription((String)job.description().getOrElse((Function0 & Serializable)() -> lastStageDescription2), "", true).text();
            long submissionTime = ((Date)job.submissionTime().get()).getTime();
            long completionTime = BoxesRunTime.unboxToLong((Object)job.completionTime().map((Function1 & Serializable)x$4 -> BoxesRunTime.boxToLong((long)x$4.getTime())).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable)() -> now));
            JobExecutionStatus jobExecutionStatus = status;
            if (((Object)((Object)JobExecutionStatus.SUCCEEDED)).equals((Object)jobExecutionStatus)) {
                string = "succeeded";
            } else if (((Object)((Object)JobExecutionStatus.FAILED)).equals((Object)jobExecutionStatus)) {
                string = "failed";
            } else if (((Object)((Object)JobExecutionStatus.RUNNING)).equals((Object)jobExecutionStatus)) {
                string = "running";
            } else if (((Object)((Object)JobExecutionStatus.UNKNOWN)).equals((Object)jobExecutionStatus)) {
                string = "unknown";
            } else {
                throw new MatchError((Object)jobExecutionStatus);
            }
            String classNameByStatus = string;
            String escapedDesc = Utility$.MODULE$.escape(jobDescription);
            String jsEscapedDescForTooltip = StringEscapeUtils.escapeEcmaScript((String)Utility$.MODULE$.escape(escapedDesc));
            String jsEscapedDescForLabel = StringEscapeUtils.escapeEcmaScript((String)escapedDesc);
            JobExecutionStatus jobExecutionStatus2 = status;
            JobExecutionStatus jobExecutionStatus3 = JobExecutionStatus.RUNNING;
            String jobEventJsonAsStr = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(520).append("\n           |{\n           |  'className': 'job application-timeline-object ").append(classNameByStatus).append("',\n           |  'group': 'jobs',\n           |  'start': new Date(").append(submissionTime).append("),\n           |  'end': new Date(").append(completionTime).append("),\n           |  'content': '<div class=\"application-timeline-content\"' +\n           |     'data-html=\"true\" data-placement=\"top\" data-toggle=\"tooltip\"' +\n           |     'data-title=\"").append(jsEscapedDescForTooltip).append(" (Job ").append(jobId).append(")<br>' +\n           |     'Status: ").append((Object)status).append("<br>' +\n           |     'Submitted: ").append(UIUtils$.MODULE$.formatDate(new Date(submissionTime))).append("' +\n           |     '").append((Object)((jobExecutionStatus2 == null ? jobExecutionStatus3 != null : !((Object)((Object)jobExecutionStatus2)).equals((Object)jobExecutionStatus3)) ? new StringBuilder(15).append("<br>Completed: ").append(UIUtils$.MODULE$.formatDate(new Date(completionTime))).toString() : "")).append("\">' +\n           |    '").append(jsEscapedDescForLabel).append(" (Job ").append(jobId).append(")</div>'\n           |}\n         ").toString()));
            return jobEventJsonAsStr;
        });
    }

    private scala.collection.immutable.Seq<String> makeExecutorEvent(scala.collection.immutable.Seq<ExecutorSummary> executors) {
        ListBuffer events = (ListBuffer)ListBuffer$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$);
        ((IterableOnceOps)((IterableOps)executors.sortBy((Function1 & Serializable)e -> BoxesRunTime.boxToLong((long)AllJobsPage.$anonfun$makeExecutorEvent$1(e)), (Ordering)Ordering.Long$.MODULE$)).takeRight(this.MAX_TIMELINE_EXECUTORS())).foreach((Function1 & Serializable)e -> {
            AllJobsPage.$anonfun$makeExecutorEvent$4(events, e);
            return BoxedUnit.UNIT;
        });
        return events.toSeq();
    }

    private scala.collection.immutable.Seq<Node> makeTimeline(scala.collection.immutable.Seq<JobData> jobs, scala.collection.immutable.Seq<ExecutorSummary> executors, long startTime) {
        Elem elem;
        Elem elem2;
        scala.collection.immutable.Seq<String> jobEventJsonAsStrSeq = this.makeJobEvent(jobs);
        scala.collection.immutable.Seq<String> executorEventJsonAsStrSeq = this.makeExecutorEvent(executors);
        String groupJsonArrayAsStr = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(254).append("\n          |[\n          |  {\n          |    'id': 'executors',\n          |    'content': '<div>Executors</div>").append(this.EXECUTORS_LEGEND()).append("',\n          |  },\n          |  {\n          |    'id': 'jobs',\n          |    'content': '<div>Jobs</div>").append(this.JOBS_LEGEND()).append("',\n          |  }\n          |]\n        ").toString()));
        String eventArrayAsStr = ((IterableOnceOps)jobEventJsonAsStrSeq.$plus$plus(executorEventJsonAsStrSeq)).mkString("[", ",", "]");
        Null$ $md = Null$.MODULE$;
        $md = new UnprefixedAttribute("class", (Seq)new Text("expand-application-timeline"), (MetaData)$md);
        NodeBuffer $buf = new NodeBuffer();
        $buf.$amp$plus((Object)new Text("\n      "));
        Null$ $md2 = Null$.MODULE$;
        $md2 = new UnprefixedAttribute("class", (Seq)new Text("expand-application-timeline-arrow arrow-closed"), (MetaData)$md2);
        $buf.$amp$plus((Object)new Elem(null, "span", (MetaData)$md2, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)Nil$.MODULE$));
        $buf.$amp$plus((Object)new Text("\n      "));
        Null$ $md3 = Null$.MODULE$;
        $md3 = new UnprefixedAttribute("data-placement", (Seq)new Text("top"), (MetaData)$md3);
        $md3 = new UnprefixedAttribute("title", ToolTips$.MODULE$.JOB_TIMELINE(), (MetaData)$md3);
        $md3 = new UnprefixedAttribute("data-toggle", (Seq)new Text("tooltip"), (MetaData)$md3);
        NodeBuffer $buf2 = new NodeBuffer();
        $buf2.$amp$plus((Object)new Text("\n        Event Timeline\n      "));
        $buf.$amp$plus((Object)new Elem(null, "a", (MetaData)$md3, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf2)));
        $buf.$amp$plus((Object)new Text("\n    "));
        Elem elem3 = new Elem(null, "span", (MetaData)$md, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf));
        Null$ $md4 = Null$.MODULE$;
        $md4 = new UnprefixedAttribute("class", (Seq)new Text("collapsed"), (MetaData)$md4);
        $md4 = new UnprefixedAttribute("id", (Seq)new Text("application-timeline"), (MetaData)$md4);
        NodeBuffer $buf3 = new NodeBuffer();
        $buf3.$amp$plus((Object)new Text("\n      "));
        if (this.MAX_TIMELINE_JOBS() < jobs.size()) {
            NodeBuffer $buf4 = new NodeBuffer();
            $buf4.$amp$plus((Object)new Text("\n            "));
            NodeBuffer $buf5 = new NodeBuffer();
            $buf5.$amp$plus((Object)new Text("\n              Only the most recent "));
            $buf5.$amp$plus((Object)BoxesRunTime.boxToInteger((int)this.MAX_TIMELINE_JOBS()));
            $buf5.$amp$plus((Object)new Text(" submitted/completed jobs\n              (of "));
            $buf5.$amp$plus((Object)BoxesRunTime.boxToInteger((int)jobs.size()));
            $buf5.$amp$plus((Object)new Text(" total) are shown.\n            "));
            $buf4.$amp$plus((Object)new Elem(null, "strong", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf5)));
            $buf4.$amp$plus((Object)new Text("\n          "));
            Elem elem4 = new Elem(null, "div", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf4));
            elem2 = elem4;
        } else {
            elem2 = package$.MODULE$.Seq().empty();
        }
        $buf3.$amp$plus((Object)elem2);
        $buf3.$amp$plus((Object)new Text("\n      "));
        if (this.MAX_TIMELINE_EXECUTORS() < executors.size()) {
            NodeBuffer $buf6 = new NodeBuffer();
            $buf6.$amp$plus((Object)new Text("\n            "));
            NodeBuffer $buf7 = new NodeBuffer();
            $buf7.$amp$plus((Object)new Text("\n              Only the most recent "));
            $buf7.$amp$plus((Object)BoxesRunTime.boxToInteger((int)this.MAX_TIMELINE_EXECUTORS()));
            $buf7.$amp$plus((Object)new Text(" added/removed executors\n              (of "));
            $buf7.$amp$plus((Object)BoxesRunTime.boxToInteger((int)executors.size()));
            $buf7.$amp$plus((Object)new Text(" total) are shown.\n            "));
            $buf6.$amp$plus((Object)new Elem(null, "strong", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf7)));
            $buf6.$amp$plus((Object)new Text("\n          "));
            Elem elem5 = new Elem(null, "div", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf6));
            elem = elem5;
        } else {
            elem = package$.MODULE$.Seq().empty();
        }
        $buf3.$amp$plus((Object)elem);
        $buf3.$amp$plus((Object)new Text("\n      "));
        Null$ $md5 = Null$.MODULE$;
        $md5 = new UnprefixedAttribute("class", (Seq)new Text("control-panel"), (MetaData)$md5);
        NodeBuffer $buf8 = new NodeBuffer();
        $buf8.$amp$plus((Object)new Text("\n        "));
        Null$ $md6 = Null$.MODULE$;
        $md6 = new UnprefixedAttribute("id", (Seq)new Text("application-timeline-zoom-lock"), (MetaData)$md6);
        NodeBuffer $buf9 = new NodeBuffer();
        $buf9.$amp$plus((Object)new Text("\n          "));
        Null$ $md7 = Null$.MODULE$;
        $md7 = new UnprefixedAttribute("type", (Seq)new Text("checkbox"), (MetaData)$md7);
        $buf9.$amp$plus((Object)new Elem(null, "input", (MetaData)$md7, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)Nil$.MODULE$));
        $buf9.$amp$plus((Object)new Text("\n          "));
        NodeBuffer $buf10 = new NodeBuffer();
        $buf10.$amp$plus((Object)new Text("Enable zooming"));
        $buf9.$amp$plus((Object)new Elem(null, "span", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf10)));
        $buf9.$amp$plus((Object)new Text("\n        "));
        $buf8.$amp$plus((Object)new Elem(null, "div", (MetaData)$md6, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf9)));
        $buf8.$amp$plus((Object)new Text("\n      "));
        $buf3.$amp$plus((Object)new Elem(null, "div", (MetaData)$md5, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf8)));
        $buf3.$amp$plus((Object)new Text("\n    "));
        IterableOps iterableOps = (IterableOps)elem3.$plus$plus((IterableOnce)new Elem(null, "div", (MetaData)$md4, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf3)));
        Null$ $md8 = Null$.MODULE$;
        $md8 = new UnprefixedAttribute("type", (Seq)new Text("text/javascript"), (MetaData)$md8);
        NodeBuffer $buf11 = new NodeBuffer();
        $buf11.$amp$plus((Object)new Text("\n      "));
        $buf11.$amp$plus((Object)Unparsed$.MODULE$.apply(new StringBuilder(0).append(new StringBuilder(25).append("drawApplicationTimeline(").append(groupJsonArrayAsStr).append(",").toString()).append(new StringBuilder(6).append(eventArrayAsStr).append(", ").append(startTime).append(", ").append(UIUtils$.MODULE$.getTimeZoneOffset()).append(");").toString()).toString()));
        $buf11.$amp$plus((Object)new Text("\n    "));
        return (scala.collection.immutable.Seq)iterableOps.$plus$plus((IterableOnce)new Elem(null, "script", (MetaData)$md8, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf11)));
    }

    private scala.collection.immutable.Seq<Node> jobsTable(HttpServletRequest request, String tableHeaderId, String jobTag, scala.collection.immutable.Seq<JobData> jobs, boolean killEnabled) {
        Elem elem;
        boolean someJobHasJobGroup = jobs.exists((Function1 & Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)AllJobsPage.$anonfun$jobsTable$1(x$6)));
        String jobIdTitle = someJobHasJobGroup ? "Job Id (Job Group)" : "Job Id";
        int jobPage = BoxesRunTime.unboxToInt((Object)Option$.MODULE$.apply((Object)request.getParameter(new StringBuilder(5).append(jobTag).append(".page").toString())).map((Function1 & Serializable)x$7 -> BoxesRunTime.boxToInteger((int)StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(x$7)))).getOrElse((Function0)(JFunction0.mcI.sp & Serializable)() -> 1));
        try {
            elem = new JobPagedTable(request, this.store, jobs, tableHeaderId, jobTag, UIUtils$.MODULE$.prependBaseUri(request, this.parent.basePath(), UIUtils$.MODULE$.prependBaseUri$default$3()), "jobs", killEnabled, jobIdTitle).table(jobPage);
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            boolean bl = throwable2 instanceof IllegalArgumentException ? true : throwable2 instanceof IndexOutOfBoundsException;
            if (!bl) {
                throw throwable;
            }
            Null$ $md = Null$.MODULE$;
            $md = new UnprefixedAttribute("class", (Seq)new Text("alert alert-error"), (MetaData)$md);
            NodeBuffer $buf = new NodeBuffer();
            $buf.$amp$plus((Object)new Text("\n          "));
            NodeBuffer $buf2 = new NodeBuffer();
            $buf2.$amp$plus((Object)new Text("Error while rendering job table:"));
            $buf.$amp$plus((Object)new Elem(null, "p", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf2)));
            $buf.$amp$plus((Object)new Text("\n          "));
            NodeBuffer $buf3 = new NodeBuffer();
            $buf3.$amp$plus((Object)new Text("\n            "));
            $buf3.$amp$plus((Object)Utils$.MODULE$.exceptionString(throwable2));
            $buf3.$amp$plus((Object)new Text("\n          "));
            $buf.$amp$plus((Object)new Elem(null, "pre", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf3)));
            $buf.$amp$plus((Object)new Text("\n        "));
            Elem elem2 = new Elem(null, "div", (MetaData)$md, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf));
            elem = elem2;
        }
        return elem;
    }

    @Override
    public scala.collection.immutable.Seq<Node> render(HttpServletRequest request) {
        BoxedUnit boxedUnit;
        BoxedUnit boxedUnit2;
        BoxedUnit boxedUnit3;
        ApplicationInfo appInfo = this.store.applicationInfo();
        long startTime = ((ApplicationAttemptInfo)appInfo.attempts().head()).startTime().getTime();
        long endTime = ((ApplicationAttemptInfo)appInfo.attempts().head()).endTime().getTime();
        ListBuffer activeJobs = new ListBuffer();
        ListBuffer completedJobs = new ListBuffer();
        ListBuffer failedJobs = new ListBuffer();
        this.store.jobsList(null).foreach((Function1 & Serializable)job -> {
            JobExecutionStatus jobExecutionStatus = job.status();
            ListBuffer listBuffer = ((Object)((Object)JobExecutionStatus.SUCCEEDED)).equals((Object)jobExecutionStatus) ? (ListBuffer)completedJobs.$plus$eq(job) : (((Object)((Object)JobExecutionStatus.FAILED)).equals((Object)jobExecutionStatus) ? (ListBuffer)failedJobs.$plus$eq(job) : (ListBuffer)activeJobs.$plus$eq(job));
            return listBuffer;
        });
        scala.collection.immutable.Seq<Node> activeJobsTable = this.jobsTable(request, "active", "activeJob", (scala.collection.immutable.Seq<JobData>)activeJobs.toSeq(), this.parent.killEnabled());
        scala.collection.immutable.Seq<Node> completedJobsTable = this.jobsTable(request, "completed", "completedJob", (scala.collection.immutable.Seq<JobData>)completedJobs.toSeq(), false);
        scala.collection.immutable.Seq<Node> failedJobsTable = this.jobsTable(request, "failed", "failedJob", (scala.collection.immutable.Seq<JobData>)failedJobs.toSeq(), false);
        boolean shouldShowActiveJobs = activeJobs.nonEmpty();
        boolean shouldShowCompletedJobs = completedJobs.nonEmpty();
        boolean shouldShowFailedJobs = failedJobs.nonEmpty();
        AppSummary appSummary = this.store.appSummary();
        String completedJobNumStr = completedJobs.size() == appSummary.numCompletedJobs() ? String.valueOf(BoxesRunTime.boxToInteger((int)completedJobs.size())) : new StringBuilder(15).append(appSummary.numCompletedJobs()).append(", only showing ").append(completedJobs.size()).toString();
        String schedulingMode = (String)this.store.environmentInfo().sparkProperties().toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()).get((Object)org.apache.spark.internal.config.package$.MODULE$.SCHEDULER_MODE().key()).map((Function1 & Serializable)mode -> SchedulingMode$.MODULE$.withName(mode.toUpperCase(Locale.ROOT)).toString()).getOrElse((Function0 & Serializable)() -> "Unknown");
        NodeBuffer $buf = new NodeBuffer();
        $buf.$amp$plus((Object)new Text("\n        "));
        Null$ $md = Null$.MODULE$;
        $md = new UnprefixedAttribute("class", (Seq)new Text("list-unstyled"), (MetaData)$md);
        NodeBuffer $buf2 = new NodeBuffer();
        $buf2.$amp$plus((Object)new Text("\n          "));
        NodeBuffer $buf3 = new NodeBuffer();
        $buf3.$amp$plus((Object)new Text("\n\n            "));
        NodeBuffer $buf4 = new NodeBuffer();
        $buf4.$amp$plus((Object)new Text("User:"));
        $buf3.$amp$plus((Object)new Elem(null, "strong", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf4)));
        $buf3.$amp$plus((Object)new Text("\n            "));
        $buf3.$amp$plus((Object)this.parent.getSparkUser());
        $buf3.$amp$plus((Object)new Text("\n          "));
        $buf2.$amp$plus((Object)new Elem(null, "li", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf3)));
        $buf2.$amp$plus((Object)new Text("\n          "));
        NodeBuffer $buf5 = new NodeBuffer();
        $buf5.$amp$plus((Object)new Text("\n            "));
        NodeBuffer $buf6 = new NodeBuffer();
        $buf6.$amp$plus((Object)new Text("Total Uptime:"));
        $buf5.$amp$plus((Object)new Elem(null, "strong", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf6)));
        $buf5.$amp$plus((Object)new Text("\n            "));
        $buf5.$amp$plus((Object)(endTime < 0L && this.parent.sc().isDefined() ? UIUtils$.MODULE$.formatDuration(System.currentTimeMillis() - startTime) : (endTime > 0L ? UIUtils$.MODULE$.formatDuration(endTime - startTime) : BoxedUnit.UNIT)));
        $buf5.$amp$plus((Object)new Text("\n          "));
        $buf2.$amp$plus((Object)new Elem(null, "li", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf5)));
        $buf2.$amp$plus((Object)new Text("\n          "));
        NodeBuffer $buf7 = new NodeBuffer();
        $buf7.$amp$plus((Object)new Text("\n            "));
        NodeBuffer $buf8 = new NodeBuffer();
        $buf8.$amp$plus((Object)new Text("Scheduling Mode: "));
        $buf7.$amp$plus((Object)new Elem(null, "strong", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf8)));
        $buf7.$amp$plus((Object)new Text("\n            "));
        $buf7.$amp$plus((Object)schedulingMode);
        $buf7.$amp$plus((Object)new Text("\n          "));
        $buf2.$amp$plus((Object)new Elem(null, "li", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf7)));
        $buf2.$amp$plus((Object)new Text("\n          "));
        if (shouldShowActiveJobs) {
            NodeBuffer $buf9 = new NodeBuffer();
            $buf9.$amp$plus((Object)new Text("\n                "));
            Null$ $md2 = Null$.MODULE$;
            $md2 = new UnprefixedAttribute("href", (Seq)new Text("#active"), (MetaData)$md2);
            NodeBuffer $buf10 = new NodeBuffer();
            NodeBuffer $buf11 = new NodeBuffer();
            $buf11.$amp$plus((Object)new Text("Active Jobs:"));
            $buf10.$amp$plus((Object)new Elem(null, "strong", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf11)));
            $buf9.$amp$plus((Object)new Elem(null, "a", (MetaData)$md2, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf10)));
            $buf9.$amp$plus((Object)new Text("\n                "));
            $buf9.$amp$plus((Object)BoxesRunTime.boxToInteger((int)activeJobs.size()));
            $buf9.$amp$plus((Object)new Text("\n              "));
            Elem elem = new Elem(null, "li", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf9));
            boxedUnit3 = elem;
        } else {
            boxedUnit3 = BoxedUnit.UNIT;
        }
        $buf2.$amp$plus((Object)boxedUnit3);
        $buf2.$amp$plus((Object)new Text("\n          "));
        if (shouldShowCompletedJobs) {
            Null$ $md3 = Null$.MODULE$;
            $md3 = new UnprefixedAttribute("id", (Seq)new Text("completed-summary"), (MetaData)$md3);
            NodeBuffer $buf12 = new NodeBuffer();
            $buf12.$amp$plus((Object)new Text("\n                "));
            Null$ $md4 = Null$.MODULE$;
            $md4 = new UnprefixedAttribute("href", (Seq)new Text("#completed"), (MetaData)$md4);
            NodeBuffer $buf13 = new NodeBuffer();
            NodeBuffer $buf14 = new NodeBuffer();
            $buf14.$amp$plus((Object)new Text("Completed Jobs:"));
            $buf13.$amp$plus((Object)new Elem(null, "strong", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf14)));
            $buf12.$amp$plus((Object)new Elem(null, "a", (MetaData)$md4, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf13)));
            $buf12.$amp$plus((Object)new Text("\n                "));
            $buf12.$amp$plus((Object)completedJobNumStr);
            $buf12.$amp$plus((Object)new Text("\n              "));
            Elem elem = new Elem(null, "li", (MetaData)$md3, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf12));
            boxedUnit2 = elem;
        } else {
            boxedUnit2 = BoxedUnit.UNIT;
        }
        $buf2.$amp$plus((Object)boxedUnit2);
        $buf2.$amp$plus((Object)new Text("\n          "));
        if (shouldShowFailedJobs) {
            NodeBuffer $buf15 = new NodeBuffer();
            $buf15.$amp$plus((Object)new Text("\n                "));
            Null$ $md5 = Null$.MODULE$;
            $md5 = new UnprefixedAttribute("href", (Seq)new Text("#failed"), (MetaData)$md5);
            NodeBuffer $buf16 = new NodeBuffer();
            NodeBuffer $buf17 = new NodeBuffer();
            $buf17.$amp$plus((Object)new Text("Failed Jobs:"));
            $buf16.$amp$plus((Object)new Elem(null, "strong", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf17)));
            $buf15.$amp$plus((Object)new Elem(null, "a", (MetaData)$md5, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf16)));
            $buf15.$amp$plus((Object)new Text("\n                "));
            $buf15.$amp$plus((Object)BoxesRunTime.boxToInteger((int)failedJobs.size()));
            $buf15.$amp$plus((Object)new Text("\n              "));
            Elem elem = new Elem(null, "li", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf15));
            boxedUnit = elem;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        $buf2.$amp$plus((Object)boxedUnit);
        $buf2.$amp$plus((Object)new Text("\n        "));
        $buf.$amp$plus((Object)new Elem(null, "ul", (MetaData)$md, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf2)));
        $buf.$amp$plus((Object)new Text("\n      "));
        Elem summary = new Elem(null, "div", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf));
        ObjectRef content = ObjectRef.create((Object)summary);
        content.elem = NodeSeq$.MODULE$.seqToNodeSeq((Seq)((NodeSeq)content.elem).$plus$plus(this.makeTimeline((scala.collection.immutable.Seq<JobData>)((IterableOnceOps)((IterableOps)activeJobs.$plus$plus((IterableOnce)completedJobs)).$plus$plus((IterableOnce)failedJobs)).toSeq(), this.store.executorList(false), startTime)));
        if (shouldShowActiveJobs) {
            NodeSeq nodeSeq = (NodeSeq)content.elem;
            Null$ $md6 = Null$.MODULE$;
            $md6 = new UnprefixedAttribute("onClick", (Seq)new Text("collapseTable('collapse-aggregated-activeJobs','aggregated-activeJobs')"), (MetaData)$md6);
            $md6 = new UnprefixedAttribute("class", (Seq)new Text("collapse-aggregated-activeJobs collapse-table"), (MetaData)$md6);
            $md6 = new UnprefixedAttribute("id", (Seq)new Text("active"), (MetaData)$md6);
            NodeBuffer $buf18 = new NodeBuffer();
            $buf18.$amp$plus((Object)new Text("\n          "));
            NodeBuffer $buf19 = new NodeBuffer();
            $buf19.$amp$plus((Object)new Text("\n            "));
            Null$ $md7 = Null$.MODULE$;
            $md7 = new UnprefixedAttribute("class", (Seq)new Text("collapse-table-arrow arrow-open"), (MetaData)$md7);
            $buf19.$amp$plus((Object)new Elem(null, "span", (MetaData)$md7, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)Nil$.MODULE$));
            $buf19.$amp$plus((Object)new Text("\n            "));
            NodeBuffer $buf20 = new NodeBuffer();
            $buf20.$amp$plus((Object)new Text("Active Jobs ("));
            $buf20.$amp$plus((Object)BoxesRunTime.boxToInteger((int)activeJobs.size()));
            $buf20.$amp$plus((Object)new Text(")"));
            $buf19.$amp$plus((Object)new Elem(null, "a", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf20)));
            $buf19.$amp$plus((Object)new Text("\n          "));
            $buf18.$amp$plus((Object)new Elem(null, "h4", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf19)));
            $buf18.$amp$plus((Object)new Text("\n        "));
            Elem elem = new Elem(null, "span", (MetaData)$md6, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf18));
            Null$ $md8 = Null$.MODULE$;
            $md8 = new UnprefixedAttribute("class", (Seq)new Text("aggregated-activeJobs collapsible-table"), (MetaData)$md8);
            NodeBuffer $buf21 = new NodeBuffer();
            $buf21.$amp$plus((Object)new Text("\n          "));
            $buf21.$amp$plus(activeJobsTable);
            $buf21.$amp$plus((Object)new Text("\n        "));
            content.elem = NodeSeq$.MODULE$.seqToNodeSeq((Seq)nodeSeq.$plus$plus((IterableOnce)elem.$plus$plus((IterableOnce)new Elem(null, "div", (MetaData)$md8, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf21)))));
        }
        if (shouldShowCompletedJobs) {
            NodeSeq nodeSeq = (NodeSeq)content.elem;
            Null$ $md9 = Null$.MODULE$;
            $md9 = new UnprefixedAttribute("onClick", (Seq)new Text("collapseTable('collapse-aggregated-completedJobs','aggregated-completedJobs')"), (MetaData)$md9);
            $md9 = new UnprefixedAttribute("class", (Seq)new Text("collapse-aggregated-completedJobs collapse-table"), (MetaData)$md9);
            $md9 = new UnprefixedAttribute("id", (Seq)new Text("completed"), (MetaData)$md9);
            NodeBuffer $buf22 = new NodeBuffer();
            $buf22.$amp$plus((Object)new Text("\n          "));
            NodeBuffer $buf23 = new NodeBuffer();
            $buf23.$amp$plus((Object)new Text("\n            "));
            Null$ $md10 = Null$.MODULE$;
            $md10 = new UnprefixedAttribute("class", (Seq)new Text("collapse-table-arrow arrow-open"), (MetaData)$md10);
            $buf23.$amp$plus((Object)new Elem(null, "span", (MetaData)$md10, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)Nil$.MODULE$));
            $buf23.$amp$plus((Object)new Text("\n            "));
            NodeBuffer $buf24 = new NodeBuffer();
            $buf24.$amp$plus((Object)new Text("Completed Jobs ("));
            $buf24.$amp$plus((Object)completedJobNumStr);
            $buf24.$amp$plus((Object)new Text(")"));
            $buf23.$amp$plus((Object)new Elem(null, "a", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf24)));
            $buf23.$amp$plus((Object)new Text("\n          "));
            $buf22.$amp$plus((Object)new Elem(null, "h4", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf23)));
            $buf22.$amp$plus((Object)new Text("\n        "));
            Elem elem = new Elem(null, "span", (MetaData)$md9, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf22));
            Null$ $md11 = Null$.MODULE$;
            $md11 = new UnprefixedAttribute("class", (Seq)new Text("aggregated-completedJobs collapsible-table"), (MetaData)$md11);
            NodeBuffer $buf25 = new NodeBuffer();
            $buf25.$amp$plus((Object)new Text("\n          "));
            $buf25.$amp$plus(completedJobsTable);
            $buf25.$amp$plus((Object)new Text("\n        "));
            content.elem = NodeSeq$.MODULE$.seqToNodeSeq((Seq)nodeSeq.$plus$plus((IterableOnce)elem.$plus$plus((IterableOnce)new Elem(null, "div", (MetaData)$md11, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf25)))));
        }
        if (shouldShowFailedJobs) {
            NodeSeq nodeSeq = (NodeSeq)content.elem;
            Null$ $md12 = Null$.MODULE$;
            $md12 = new UnprefixedAttribute("onClick", (Seq)new Text("collapseTable('collapse-aggregated-failedJobs','aggregated-failedJobs')"), (MetaData)$md12);
            $md12 = new UnprefixedAttribute("class", (Seq)new Text("collapse-aggregated-failedJobs collapse-table"), (MetaData)$md12);
            $md12 = new UnprefixedAttribute("id", (Seq)new Text("failed"), (MetaData)$md12);
            NodeBuffer $buf26 = new NodeBuffer();
            $buf26.$amp$plus((Object)new Text("\n          "));
            NodeBuffer $buf27 = new NodeBuffer();
            $buf27.$amp$plus((Object)new Text("\n            "));
            Null$ $md13 = Null$.MODULE$;
            $md13 = new UnprefixedAttribute("class", (Seq)new Text("collapse-table-arrow arrow-open"), (MetaData)$md13);
            $buf27.$amp$plus((Object)new Elem(null, "span", (MetaData)$md13, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)Nil$.MODULE$));
            $buf27.$amp$plus((Object)new Text("\n            "));
            NodeBuffer $buf28 = new NodeBuffer();
            $buf28.$amp$plus((Object)new Text("Failed Jobs ("));
            $buf28.$amp$plus((Object)BoxesRunTime.boxToInteger((int)failedJobs.size()));
            $buf28.$amp$plus((Object)new Text(")"));
            $buf27.$amp$plus((Object)new Elem(null, "a", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf28)));
            $buf27.$amp$plus((Object)new Text("\n          "));
            $buf26.$amp$plus((Object)new Elem(null, "h4", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf27)));
            $buf26.$amp$plus((Object)new Text("\n        "));
            Elem elem = new Elem(null, "span", (MetaData)$md12, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf26));
            Null$ $md14 = Null$.MODULE$;
            $md14 = new UnprefixedAttribute("class", (Seq)new Text("aggregated-failedJobs collapsible-table"), (MetaData)$md14);
            NodeBuffer $buf29 = new NodeBuffer();
            $buf29.$amp$plus((Object)new Text("\n        "));
            $buf29.$amp$plus(failedJobsTable);
            $buf29.$amp$plus((Object)new Text("\n      "));
            content.elem = NodeSeq$.MODULE$.seqToNodeSeq((Seq)nodeSeq.$plus$plus((IterableOnce)elem.$plus$plus((IterableOnce)new Elem(null, "div", (MetaData)$md14, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf29)))));
        }
        String helpText = "A job is triggered by an action, like count() or saveAsTextFile(). Click on a job to see information about the stages of tasks inside it.";
        return UIUtils$.MODULE$.headerSparkPage(request, "Spark Jobs", (Function0<scala.collection.immutable.Seq<Node>>)(Function0 & Serializable)() -> (NodeSeq)content$1.elem, this.parent, (Option<String>)new Some((Object)helpText), UIUtils$.MODULE$.headerSparkPage$default$6(), UIUtils$.MODULE$.headerSparkPage$default$7());
    }

    public static final /* synthetic */ boolean $anonfun$JOBS_LEGEND$1(char x$1) {
        return x$1 != '\n';
    }

    public static final /* synthetic */ boolean $anonfun$EXECUTORS_LEGEND$1(char x$2) {
        return x$2 != '\n';
    }

    public static final /* synthetic */ boolean $anonfun$makeJobEvent$1(JobData job) {
        JobExecutionStatus jobExecutionStatus = job.status();
        JobExecutionStatus jobExecutionStatus2 = JobExecutionStatus.UNKNOWN;
        return (jobExecutionStatus == null ? jobExecutionStatus2 != null : !((Object)((Object)jobExecutionStatus)).equals((Object)jobExecutionStatus2)) && job.submissionTime().isDefined();
    }

    public static final /* synthetic */ long $anonfun$makeExecutorEvent$1(ExecutorSummary e) {
        return BoxesRunTime.unboxToLong((Object)e.removeTime().map((Function1 & Serializable)x$5 -> BoxesRunTime.boxToLong((long)x$5.getTime())).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable)() -> e.addTime().getTime()));
    }

    public static final /* synthetic */ void $anonfun$makeExecutorEvent$4(ListBuffer events$1, ExecutorSummary e) {
        String addedEvent = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(416).append("\n           |{\n           |  'className': 'executor added',\n           |  'group': 'executors',\n           |  'start': new Date(").append(e.addTime().getTime()).append("),\n           |  'content': '<div class=\"executor-event-content\"' +\n           |    'data-toggle=\"tooltip\" data-placement=\"top\"' +\n           |    'data-title=\"Executor ").append(e.id()).append("<br>' +\n           |    'Added at ").append(UIUtils$.MODULE$.formatDate(e.addTime())).append("\"' +\n           |    'data-html=\"true\">Executor ").append(e.id()).append(" added</div>'\n           |}\n         ").toString()));
        events$1.$plus$eq((Object)addedEvent);
        e.removeTime().foreach((Function1 & Serializable)removeTime -> {
            String removedEvent = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(467).append("\n             |{\n             |  'className': 'executor removed',\n             |  'group': 'executors',\n             |  'start': new Date(").append(removeTime.getTime()).append("),\n             |  'content': '<div class=\"executor-event-content\"' +\n             |    'data-toggle=\"tooltip\" data-placement=\"top\"' +\n             |    'data-title=\"Executor ").append(e.id()).append("<br>' +\n             |    'Removed at ").append(UIUtils$.MODULE$.formatDate((Date)removeTime)).append("' +\n             |    '").append(e.removeReason().map((Function1 & Serializable)reason -> new StringBuilder(12).append("<br>Reason: ").append(StringEscapeUtils.escapeEcmaScript((String)reason.replace("\n", " "))).toString()).getOrElse((Function0 & Serializable)() -> "")).append("\"' +\n             |    'data-html=\"true\">Executor ").append(e.id()).append(" removed</div>'\n             |}\n           ").toString()));
            return (ListBuffer)events$1.$plus$eq((Object)removedEvent);
        });
    }

    public static final /* synthetic */ boolean $anonfun$jobsTable$1(JobData x$6) {
        return x$6.jobGroup().isDefined();
    }

    public AllJobsPage(JobsTab parent, AppStatusStore store) {
        this.parent = parent;
        this.store = store;
        super("");
        this.MAX_TIMELINE_JOBS = BoxesRunTime.unboxToInt((Object)parent.conf().get(UI$.MODULE$.UI_TIMELINE_JOBS_MAXIMUM()));
        this.MAX_TIMELINE_EXECUTORS = BoxesRunTime.unboxToInt((Object)parent.conf().get(UI$.MODULE$.UI_TIMELINE_EXECUTORS_MAXIMUM()));
        Null$ $md = Null$.MODULE$;
        $md = new UnprefixedAttribute("class", (Seq)new Text("legend-area"), (MetaData)$md);
        NodeBuffer $buf = new NodeBuffer();
        Null$ $md2 = Null$.MODULE$;
        $md2 = new UnprefixedAttribute("height", (Seq)new Text("85px"), (MetaData)$md2);
        $md2 = new UnprefixedAttribute("width", (Seq)new Text("150px"), (MetaData)$md2);
        NodeBuffer $buf2 = new NodeBuffer();
        $buf2.$amp$plus((Object)new Text("\n      "));
        Null$ $md3 = Null$.MODULE$;
        $md3 = new UnprefixedAttribute("ry", (Seq)new Text("2px"), (MetaData)$md3);
        $md3 = new UnprefixedAttribute("rx", (Seq)new Text("2px"), (MetaData)$md3);
        $md3 = new UnprefixedAttribute("height", (Seq)new Text("15px"), (MetaData)$md3);
        $md3 = new UnprefixedAttribute("width", (Seq)new Text("20px"), (MetaData)$md3);
        $md3 = new UnprefixedAttribute("y", (Seq)new Text("5px"), (MetaData)$md3);
        $md3 = new UnprefixedAttribute("x", (Seq)new Text("5px"), (MetaData)$md3);
        $md3 = new UnprefixedAttribute("class", (Seq)new Text("succeeded-job-legend"), (MetaData)$md3);
        $buf2.$amp$plus((Object)new Elem(null, "rect", (MetaData)$md3, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)Nil$.MODULE$));
        $buf2.$amp$plus((Object)new Text("\n      "));
        Null$ $md4 = Null$.MODULE$;
        $md4 = new UnprefixedAttribute("y", (Seq)new Text("17px"), (MetaData)$md4);
        $md4 = new UnprefixedAttribute("x", (Seq)new Text("35px"), (MetaData)$md4);
        NodeBuffer $buf3 = new NodeBuffer();
        $buf3.$amp$plus((Object)new Text("Succeeded"));
        $buf2.$amp$plus((Object)new Elem(null, "text", (MetaData)$md4, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf3)));
        $buf2.$amp$plus((Object)new Text("\n      "));
        Null$ $md5 = Null$.MODULE$;
        $md5 = new UnprefixedAttribute("ry", (Seq)new Text("2px"), (MetaData)$md5);
        $md5 = new UnprefixedAttribute("rx", (Seq)new Text("2px"), (MetaData)$md5);
        $md5 = new UnprefixedAttribute("height", (Seq)new Text("15px"), (MetaData)$md5);
        $md5 = new UnprefixedAttribute("width", (Seq)new Text("20px"), (MetaData)$md5);
        $md5 = new UnprefixedAttribute("y", (Seq)new Text("30px"), (MetaData)$md5);
        $md5 = new UnprefixedAttribute("x", (Seq)new Text("5px"), (MetaData)$md5);
        $md5 = new UnprefixedAttribute("class", (Seq)new Text("failed-job-legend"), (MetaData)$md5);
        $buf2.$amp$plus((Object)new Elem(null, "rect", (MetaData)$md5, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)Nil$.MODULE$));
        $buf2.$amp$plus((Object)new Text("\n      "));
        Null$ $md6 = Null$.MODULE$;
        $md6 = new UnprefixedAttribute("y", (Seq)new Text("42px"), (MetaData)$md6);
        $md6 = new UnprefixedAttribute("x", (Seq)new Text("35px"), (MetaData)$md6);
        NodeBuffer $buf4 = new NodeBuffer();
        $buf4.$amp$plus((Object)new Text("Failed"));
        $buf2.$amp$plus((Object)new Elem(null, "text", (MetaData)$md6, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf4)));
        $buf2.$amp$plus((Object)new Text("\n      "));
        Null$ $md7 = Null$.MODULE$;
        $md7 = new UnprefixedAttribute("ry", (Seq)new Text("2px"), (MetaData)$md7);
        $md7 = new UnprefixedAttribute("rx", (Seq)new Text("2px"), (MetaData)$md7);
        $md7 = new UnprefixedAttribute("height", (Seq)new Text("15px"), (MetaData)$md7);
        $md7 = new UnprefixedAttribute("width", (Seq)new Text("20px"), (MetaData)$md7);
        $md7 = new UnprefixedAttribute("y", (Seq)new Text("55px"), (MetaData)$md7);
        $md7 = new UnprefixedAttribute("x", (Seq)new Text("5px"), (MetaData)$md7);
        $md7 = new UnprefixedAttribute("class", (Seq)new Text("running-job-legend"), (MetaData)$md7);
        $buf2.$amp$plus((Object)new Elem(null, "rect", (MetaData)$md7, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)Nil$.MODULE$));
        $buf2.$amp$plus((Object)new Text("\n      "));
        Null$ $md8 = Null$.MODULE$;
        $md8 = new UnprefixedAttribute("y", (Seq)new Text("67px"), (MetaData)$md8);
        $md8 = new UnprefixedAttribute("x", (Seq)new Text("35px"), (MetaData)$md8);
        NodeBuffer $buf5 = new NodeBuffer();
        $buf5.$amp$plus((Object)new Text("Running"));
        $buf2.$amp$plus((Object)new Elem(null, "text", (MetaData)$md8, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf5)));
        $buf2.$amp$plus((Object)new Text("\n    "));
        $buf.$amp$plus((Object)new Elem(null, "svg", (MetaData)$md2, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf2)));
        this.JOBS_LEGEND = StringOps$.MODULE$.filter$extension(Predef$.MODULE$.augmentString(new Elem(null, "div", (MetaData)$md, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf)).toString()), (Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)AllJobsPage.$anonfun$JOBS_LEGEND$1(BoxesRunTime.unboxToChar((Object)x$1))));
        Null$ $md9 = Null$.MODULE$;
        $md9 = new UnprefixedAttribute("class", (Seq)new Text("legend-area"), (MetaData)$md9);
        NodeBuffer $buf6 = new NodeBuffer();
        Null$ $md10 = Null$.MODULE$;
        $md10 = new UnprefixedAttribute("height", (Seq)new Text("55px"), (MetaData)$md10);
        $md10 = new UnprefixedAttribute("width", (Seq)new Text("150px"), (MetaData)$md10);
        NodeBuffer $buf7 = new NodeBuffer();
        $buf7.$amp$plus((Object)new Text("\n      "));
        Null$ $md11 = Null$.MODULE$;
        $md11 = new UnprefixedAttribute("ry", (Seq)new Text("2px"), (MetaData)$md11);
        $md11 = new UnprefixedAttribute("rx", (Seq)new Text("2px"), (MetaData)$md11);
        $md11 = new UnprefixedAttribute("height", (Seq)new Text("15px"), (MetaData)$md11);
        $md11 = new UnprefixedAttribute("width", (Seq)new Text("20px"), (MetaData)$md11);
        $md11 = new UnprefixedAttribute("y", (Seq)new Text("5px"), (MetaData)$md11);
        $md11 = new UnprefixedAttribute("x", (Seq)new Text("5px"), (MetaData)$md11);
        $md11 = new UnprefixedAttribute("class", (Seq)new Text("executor-added-legend"), (MetaData)$md11);
        $buf7.$amp$plus((Object)new Elem(null, "rect", (MetaData)$md11, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)Nil$.MODULE$));
        $buf7.$amp$plus((Object)new Text("\n      "));
        Null$ $md12 = Null$.MODULE$;
        $md12 = new UnprefixedAttribute("y", (Seq)new Text("17px"), (MetaData)$md12);
        $md12 = new UnprefixedAttribute("x", (Seq)new Text("35px"), (MetaData)$md12);
        NodeBuffer $buf8 = new NodeBuffer();
        $buf8.$amp$plus((Object)new Text("Added"));
        $buf7.$amp$plus((Object)new Elem(null, "text", (MetaData)$md12, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf8)));
        $buf7.$amp$plus((Object)new Text("\n      "));
        Null$ $md13 = Null$.MODULE$;
        $md13 = new UnprefixedAttribute("ry", (Seq)new Text("2px"), (MetaData)$md13);
        $md13 = new UnprefixedAttribute("rx", (Seq)new Text("2px"), (MetaData)$md13);
        $md13 = new UnprefixedAttribute("height", (Seq)new Text("15px"), (MetaData)$md13);
        $md13 = new UnprefixedAttribute("width", (Seq)new Text("20px"), (MetaData)$md13);
        $md13 = new UnprefixedAttribute("y", (Seq)new Text("30px"), (MetaData)$md13);
        $md13 = new UnprefixedAttribute("x", (Seq)new Text("5px"), (MetaData)$md13);
        $md13 = new UnprefixedAttribute("class", (Seq)new Text("executor-removed-legend"), (MetaData)$md13);
        $buf7.$amp$plus((Object)new Elem(null, "rect", (MetaData)$md13, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)Nil$.MODULE$));
        $buf7.$amp$plus((Object)new Text("\n      "));
        Null$ $md14 = Null$.MODULE$;
        $md14 = new UnprefixedAttribute("y", (Seq)new Text("42px"), (MetaData)$md14);
        $md14 = new UnprefixedAttribute("x", (Seq)new Text("35px"), (MetaData)$md14);
        NodeBuffer $buf9 = new NodeBuffer();
        $buf9.$amp$plus((Object)new Text("Removed"));
        $buf7.$amp$plus((Object)new Elem(null, "text", (MetaData)$md14, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf9)));
        $buf7.$amp$plus((Object)new Text("\n    "));
        $buf6.$amp$plus((Object)new Elem(null, "svg", (MetaData)$md10, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf7)));
        this.EXECUTORS_LEGEND = StringOps$.MODULE$.filter$extension(Predef$.MODULE$.augmentString(new Elem(null, "div", (MetaData)$md9, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf6)).toString()), (Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)AllJobsPage.$anonfun$EXECUTORS_LEGEND$1(BoxesRunTime.unboxToChar((Object)x$2))));
    }
}

