/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.util;

import java.io.FileNotFoundException;
import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.BlockLocation;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocatedFileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.fs.RemoteIterator;
import org.apache.hadoop.fs.viewfs.ViewFileSystem;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.spark.SparkContext;
import org.apache.spark.SparkContext$;
import org.apache.spark.internal.Logging;
import org.apache.spark.metrics.source.HiveCatalogMetrics$;
import org.apache.spark.rdd.RDD;
import org.apache.spark.util.HadoopFSUtils;
import org.apache.spark.util.SerializableConfiguration;
import org.slf4j.Logger;
import scala.;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.BufferedIterator;
import scala.collection.Factory;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.Iterator;
import scala.collection.Stepper;
import scala.collection.StepperShape;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.collection.immutable.Stream;
import scala.collection.immutable.Vector;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.StringBuilder;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;

public final class HadoopFSUtils$
implements Logging {
    public static final HadoopFSUtils$ MODULE$ = new HadoopFSUtils$();
    private static transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        Logging.$init$(MODULE$);
    }

    @Override
    public String logName() {
        return Logging.logName$(this);
    }

    @Override
    public Logger log() {
        return Logging.log$(this);
    }

    @Override
    public void logInfo(Function0<String> msg) {
        Logging.logInfo$(this, msg);
    }

    @Override
    public void logDebug(Function0<String> msg) {
        Logging.logDebug$(this, msg);
    }

    @Override
    public void logTrace(Function0<String> msg) {
        Logging.logTrace$(this, msg);
    }

    @Override
    public void logWarning(Function0<String> msg) {
        Logging.logWarning$(this, msg);
    }

    @Override
    public void logError(Function0<String> msg) {
        Logging.logError$(this, msg);
    }

    @Override
    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$(this, msg, throwable);
    }

    @Override
    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$(this, msg, throwable);
    }

    @Override
    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$(this, msg, throwable);
    }

    @Override
    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$(this, msg, throwable);
    }

    @Override
    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$(this, msg, throwable);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$(this, isInterpreter);
    }

    @Override
    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$(this, isInterpreter, silent);
    }

    @Override
    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$(this);
    }

    @Override
    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$(this, isInterpreter, silent);
    }

    @Override
    public Logger org$apache$spark$internal$Logging$$log_() {
        return org$apache$spark$internal$Logging$$log_;
    }

    @Override
    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public Seq<Tuple2<Path, Seq<FileStatus>>> parallelListLeafFiles(SparkContext sc, Seq<Path> paths, Configuration hadoopConf, PathFilter filter, boolean ignoreMissingFiles, boolean ignoreLocality, int parallelismThreshold, int parallelismMax) {
        return this.parallelListLeafFilesInternal(sc, paths, hadoopConf, filter, true, ignoreMissingFiles, ignoreLocality, parallelismThreshold, parallelismMax);
    }

    private Seq<Tuple2<Path, Seq<FileStatus>>> parallelListLeafFilesInternal(SparkContext sc, Seq<Path> paths, Configuration hadoopConf, PathFilter filter, boolean isRootLevel, boolean ignoreMissingFiles, boolean ignoreLocality, int parallelismThreshold, int parallelismMax) {
        Tuple2[] tuple2Array;
        if (paths.size() <= parallelismThreshold) {
            return (Seq)paths.map((Function1 & Serializable)path -> {
                Seq<FileStatus> leafFiles = MODULE$.listLeafFiles((Path)path, hadoopConf, filter, (Option<SparkContext>)new Some((Object)sc), ignoreMissingFiles, ignoreLocality, isRootLevel, parallelismThreshold, parallelismMax);
                return new Tuple2(path, leafFiles);
            });
        }
        this.logInfo((Function0<String>)(Function0 & Serializable)() -> new java.lang.StringBuilder(0).append(new java.lang.StringBuilder(60).append("Listing leaf files and directories in parallel under ").append(paths.length()).append(" paths.").toString()).append(new java.lang.StringBuilder(31).append(" The first several paths are: ").append(((IterableOnceOps)paths.take(10)).mkString(", ")).append(".").toString()).toString());
        HiveCatalogMetrics$.MODULE$.incrementParallelListingJobCount(1);
        SerializableConfiguration serializableConfiguration = new SerializableConfiguration(hadoopConf);
        Seq serializedPaths = (Seq)paths.map((Function1 & Serializable)x$1 -> x$1.toString());
        int numParallelism = Math.min(paths.size(), parallelismMax);
        String previousJobDescription = sc.getLocalProperty(SparkContext$.MODULE$.SPARK_JOB_DESCRIPTION());
        try {
            String string;
            int n = paths.size();
            switch (n) {
                case 0: {
                    string = "Listing leaf files and directories 0 paths";
                    break;
                }
                case 1: {
                    string = new java.lang.StringBuilder(51).append("Listing leaf files and directories for 1 path:<br/>").append(paths.apply(0)).toString();
                    break;
                }
                default: {
                    string = new java.lang.StringBuilder(56).append("Listing leaf files and directories for ").append(n).append(" paths:<br/>").append(paths.apply(0)).append(", ...").toString();
                    break;
                }
            }
            String description = string;
            sc.setJobDescription(description);
            RDD qual$1 = sc.parallelize(serializedPaths, numParallelism, ClassTag$.MODULE$.apply(String.class));
            Function1 & Serializable x$12 = (Function1 & Serializable)pathStrings -> {
                Configuration hadoopConf = serializableConfiguration.value();
                return ((IterableOnce)pathStrings.map((Function1 & Serializable)x$2 -> new Path(x$2)).toSeq().map((Function1 & Serializable)path -> {
                    Seq<FileStatus> leafFiles = MODULE$.listLeafFiles((Path)path, hadoopConf, filter, (Option<SparkContext>)None$.MODULE$, ignoreMissingFiles, ignoreLocality, isRootLevel, Integer.MAX_VALUE, 0);
                    return new Tuple2(path, leafFiles);
                })).iterator();
            };
            boolean x$2 = qual$1.mapPartitions$default$2();
            tuple2Array = (Tuple2[])qual$1.mapPartitions(x$12, x$2, ClassTag$.MODULE$.apply(Tuple2.class)).map((Function1 & Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                Path path = (Path)tuple2._1();
                Seq statuses = (Seq)tuple2._2();
                Seq serializableStatuses = (Seq)statuses.map((Function1 & Serializable)status -> {
                    HadoopFSUtils.SerializableBlockLocation[] serializableBlockLocationArray;
                    FileStatus fileStatus = status;
                    if (fileStatus instanceof LocatedFileStatus) {
                        LocatedFileStatus locatedFileStatus = (LocatedFileStatus)fileStatus;
                        serializableBlockLocationArray = (HadoopFSUtils.SerializableBlockLocation[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])locatedFileStatus.getBlockLocations()), (Function1 & Serializable)loc -> new HadoopFSUtils.SerializableBlockLocation(loc.getNames(), loc.getHosts(), loc.getOffset(), loc.getLength()), ClassTag$.MODULE$.apply(HadoopFSUtils.SerializableBlockLocation.class));
                    } else {
                        serializableBlockLocationArray = (HadoopFSUtils.SerializableBlockLocation[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(HadoopFSUtils.SerializableBlockLocation.class));
                    }
                    HadoopFSUtils.SerializableBlockLocation[] blockLocations = serializableBlockLocationArray;
                    return new HadoopFSUtils.SerializableFileStatus(status.getPath().toString(), status.getLen(), status.isDirectory(), status.getReplication(), status.getBlockSize(), status.getModificationTime(), status.getAccessTime(), blockLocations);
                });
                Tuple2 tuple22 = new Tuple2((Object)path.toString(), (Object)serializableStatuses);
                return tuple22;
            }, ClassTag$.MODULE$.apply(Tuple2.class)).collect();
        }
        finally {
            sc.setJobDescription(previousJobDescription);
        }
        Tuple2[] statusMap = tuple2Array;
        return Predef$.MODULE$.copyArrayToImmutableIndexedSeq(ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])statusMap), (Function1 & Serializable)x0$2 -> {
            Tuple2 tuple2 = x0$2;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String path = (String)tuple2._1();
            Seq serializableStatuses = (Seq)tuple2._2();
            Seq statuses = (Seq)serializableStatuses.map((Function1 & Serializable)f -> {
                BlockLocation[] blockLocations = (BlockLocation[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])f.blockLocations()), (Function1 & Serializable)loc -> new BlockLocation(loc.names(), loc.hosts(), loc.offset(), loc.length()), ClassTag$.MODULE$.apply(BlockLocation.class));
                return new LocatedFileStatus(new FileStatus(f.length(), f.isDir(), (int)f.blockReplication(), f.blockSize(), f.modificationTime(), new Path(f.path())), blockLocations);
            });
            Tuple2 tuple22 = new Tuple2((Object)new Path(path), (Object)statuses);
            return tuple22;
        }, ClassTag$.MODULE$.apply(Tuple2.class)));
    }

    /*
     * Unable to fully structure code
     */
    private Seq<FileStatus> listLeafFiles(Path path, Configuration hadoopConf, PathFilter filter, Option<SparkContext> contextOpt, boolean ignoreMissingFiles, boolean ignoreLocality, boolean isRootPath, int parallelismThreshold, int parallelismMax) {
        block8: {
            this.logTrace((Function0<String>)(Function0 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$listLeafFiles$1(org.apache.hadoop.fs.Path ), ()Ljava/lang/String;)((Path)path));
            fs = path.getFileSystem(hadoopConf);
            try {
                var17_11 = fs;
                var14_12 = var17_11 instanceof DistributedFileSystem != false ? true : var17_11 instanceof ViewFileSystem != false;
                if (var14_12 && !ignoreLocality) {
                    remoteIter = fs.listLocatedStatus(path);
                    var13_14 = (FileStatus[])new Iterator<LocatedFileStatus>(remoteIter){
                        private final RemoteIterator remoteIter$1;

                        public final boolean hasDefiniteSize() {
                            return Iterator.hasDefiniteSize$((Iterator)this);
                        }

                        public final Iterator<LocatedFileStatus> iterator() {
                            return Iterator.iterator$((Iterator)this);
                        }

                        public Option<LocatedFileStatus> nextOption() {
                            return Iterator.nextOption$((Iterator)this);
                        }

                        public boolean contains(Object elem) {
                            return Iterator.contains$((Iterator)this, (Object)elem);
                        }

                        public BufferedIterator<LocatedFileStatus> buffered() {
                            return Iterator.buffered$((Iterator)this);
                        }

                        public <B> Iterator<B> padTo(int len, B elem) {
                            return Iterator.padTo$((Iterator)this, (int)len, elem);
                        }

                        public Tuple2<Iterator<LocatedFileStatus>, Iterator<LocatedFileStatus>> partition(Function1<LocatedFileStatus, Object> p) {
                            return Iterator.partition$((Iterator)this, p);
                        }

                        public <B> Iterator.GroupedIterator<B> grouped(int size) {
                            return Iterator.grouped$((Iterator)this, (int)size);
                        }

                        public <B> Iterator.GroupedIterator<B> sliding(int size, int step) {
                            return Iterator.sliding$((Iterator)this, (int)size, (int)step);
                        }

                        public <B> int sliding$default$2() {
                            return Iterator.sliding$default$2$((Iterator)this);
                        }

                        public <B> Iterator<B> scanLeft(B z, Function2<B, LocatedFileStatus, B> op) {
                            return Iterator.scanLeft$((Iterator)this, z, op);
                        }

                        public <B> Iterator<B> scanRight(B z, Function2<LocatedFileStatus, B, B> op) {
                            return Iterator.scanRight$((Iterator)this, z, op);
                        }

                        public int indexWhere(Function1<LocatedFileStatus, Object> p, int from) {
                            return Iterator.indexWhere$((Iterator)this, p, (int)from);
                        }

                        public int indexWhere$default$2() {
                            return Iterator.indexWhere$default$2$((Iterator)this);
                        }

                        public <B> int indexOf(B elem) {
                            return Iterator.indexOf$((Iterator)this, elem);
                        }

                        public <B> int indexOf(B elem, int from) {
                            return Iterator.indexOf$((Iterator)this, elem, (int)from);
                        }

                        public final int length() {
                            return Iterator.length$((Iterator)this);
                        }

                        public boolean isEmpty() {
                            return Iterator.isEmpty$((Iterator)this);
                        }

                        public Iterator<LocatedFileStatus> filter(Function1<LocatedFileStatus, Object> p) {
                            return Iterator.filter$((Iterator)this, p);
                        }

                        public Iterator<LocatedFileStatus> filterNot(Function1<LocatedFileStatus, Object> p) {
                            return Iterator.filterNot$((Iterator)this, p);
                        }

                        public Iterator<LocatedFileStatus> filterImpl(Function1<LocatedFileStatus, Object> p, boolean isFlipped) {
                            return Iterator.filterImpl$((Iterator)this, p, (boolean)isFlipped);
                        }

                        public Iterator<LocatedFileStatus> withFilter(Function1<LocatedFileStatus, Object> p) {
                            return Iterator.withFilter$((Iterator)this, p);
                        }

                        public <B> Iterator<B> collect(PartialFunction<LocatedFileStatus, B> pf) {
                            return Iterator.collect$((Iterator)this, pf);
                        }

                        public Iterator<LocatedFileStatus> distinct() {
                            return Iterator.distinct$((Iterator)this);
                        }

                        public <B> Iterator<LocatedFileStatus> distinctBy(Function1<LocatedFileStatus, B> f) {
                            return Iterator.distinctBy$((Iterator)this, f);
                        }

                        public <B> Iterator<B> map(Function1<LocatedFileStatus, B> f) {
                            return Iterator.map$((Iterator)this, f);
                        }

                        public <B> Iterator<B> flatMap(Function1<LocatedFileStatus, IterableOnce<B>> f) {
                            return Iterator.flatMap$((Iterator)this, f);
                        }

                        public <B> Iterator<B> flatten(Function1<LocatedFileStatus, IterableOnce<B>> ev) {
                            return Iterator.flatten$((Iterator)this, ev);
                        }

                        public <B> Iterator<B> concat(Function0<IterableOnce<B>> xs) {
                            return Iterator.concat$((Iterator)this, xs);
                        }

                        public final <B> Iterator<B> $plus$plus(Function0<IterableOnce<B>> xs) {
                            return Iterator.$plus$plus$((Iterator)this, xs);
                        }

                        public Iterator<LocatedFileStatus> take(int n) {
                            return Iterator.take$((Iterator)this, (int)n);
                        }

                        public Iterator<LocatedFileStatus> takeWhile(Function1<LocatedFileStatus, Object> p) {
                            return Iterator.takeWhile$((Iterator)this, p);
                        }

                        public Iterator<LocatedFileStatus> drop(int n) {
                            return Iterator.drop$((Iterator)this, (int)n);
                        }

                        public Iterator<LocatedFileStatus> dropWhile(Function1<LocatedFileStatus, Object> p) {
                            return Iterator.dropWhile$((Iterator)this, p);
                        }

                        public Tuple2<Iterator<LocatedFileStatus>, Iterator<LocatedFileStatus>> span(Function1<LocatedFileStatus, Object> p) {
                            return Iterator.span$((Iterator)this, p);
                        }

                        public Iterator<LocatedFileStatus> slice(int from, int until) {
                            return Iterator.slice$((Iterator)this, (int)from, (int)until);
                        }

                        public Iterator<LocatedFileStatus> sliceIterator(int from, int until) {
                            return Iterator.sliceIterator$((Iterator)this, (int)from, (int)until);
                        }

                        public <B> Iterator<Tuple2<LocatedFileStatus, B>> zip(IterableOnce<B> that) {
                            return Iterator.zip$((Iterator)this, that);
                        }

                        public <A1, B> Iterator<Tuple2<A1, B>> zipAll(IterableOnce<B> that, A1 thisElem, B thatElem) {
                            return Iterator.zipAll$((Iterator)this, that, thisElem, thatElem);
                        }

                        public Iterator<Tuple2<LocatedFileStatus, Object>> zipWithIndex() {
                            return Iterator.zipWithIndex$((Iterator)this);
                        }

                        public <B> boolean sameElements(IterableOnce<B> that) {
                            return Iterator.sameElements$((Iterator)this, that);
                        }

                        public Tuple2<Iterator<LocatedFileStatus>, Iterator<LocatedFileStatus>> duplicate() {
                            return Iterator.duplicate$((Iterator)this);
                        }

                        public <B> Iterator<B> patch(int from, Iterator<B> patchElems, int replaced) {
                            return Iterator.patch$((Iterator)this, (int)from, patchElems, (int)replaced);
                        }

                        public <U$> Iterator<LocatedFileStatus> tapEach(Function1<LocatedFileStatus, U$> f) {
                            return Iterator.tapEach$((Iterator)this, f);
                        }

                        public String toString() {
                            return Iterator.toString$((Iterator)this);
                        }

                        public Iterator<LocatedFileStatus> seq() {
                            return Iterator.seq$((Iterator)this);
                        }

                        public Tuple2<Iterator<LocatedFileStatus>, Iterator<LocatedFileStatus>> splitAt(int n) {
                            return IterableOnceOps.splitAt$((IterableOnceOps)this, (int)n);
                        }

                        public boolean isTraversableAgain() {
                            return IterableOnceOps.isTraversableAgain$((IterableOnceOps)this);
                        }

                        public <U$> void foreach(Function1<LocatedFileStatus, U$> f) {
                            IterableOnceOps.foreach$((IterableOnceOps)this, f);
                        }

                        public boolean forall(Function1<LocatedFileStatus, Object> p) {
                            return IterableOnceOps.forall$((IterableOnceOps)this, p);
                        }

                        public boolean exists(Function1<LocatedFileStatus, Object> p) {
                            return IterableOnceOps.exists$((IterableOnceOps)this, p);
                        }

                        public int count(Function1<LocatedFileStatus, Object> p) {
                            return IterableOnceOps.count$((IterableOnceOps)this, p);
                        }

                        public Option<LocatedFileStatus> find(Function1<LocatedFileStatus, Object> p) {
                            return IterableOnceOps.find$((IterableOnceOps)this, p);
                        }

                        public <B$> B$ foldLeft(B$ z, Function2<B$, LocatedFileStatus, B$> op) {
                            return (B$)IterableOnceOps.foldLeft$((IterableOnceOps)this, z, op);
                        }

                        public <B$> B$ foldRight(B$ z, Function2<LocatedFileStatus, B$, B$> op) {
                            return (B$)IterableOnceOps.foldRight$((IterableOnceOps)this, z, op);
                        }

                        public final <B$> B$ $div$colon(B$ z, Function2<B$, LocatedFileStatus, B$> op) {
                            return (B$)IterableOnceOps.$div$colon$((IterableOnceOps)this, z, op);
                        }

                        public final <B$> B$ $colon$bslash(B$ z, Function2<LocatedFileStatus, B$, B$> op) {
                            return (B$)IterableOnceOps.$colon$bslash$((IterableOnceOps)this, z, op);
                        }

                        public <A1> A1 fold(A1 z, Function2<A1, A1, A1> op) {
                            return (A1)IterableOnceOps.fold$((IterableOnceOps)this, z, op);
                        }

                        public <B> B reduce(Function2<B, B, B> op) {
                            return (B)IterableOnceOps.reduce$((IterableOnceOps)this, op);
                        }

                        public <B> Option<B> reduceOption(Function2<B, B, B> op) {
                            return IterableOnceOps.reduceOption$((IterableOnceOps)this, op);
                        }

                        public <B> B reduceLeft(Function2<B, LocatedFileStatus, B> op) {
                            return (B)IterableOnceOps.reduceLeft$((IterableOnceOps)this, op);
                        }

                        public <B> B reduceRight(Function2<LocatedFileStatus, B, B> op) {
                            return (B)IterableOnceOps.reduceRight$((IterableOnceOps)this, op);
                        }

                        public <B> Option<B> reduceLeftOption(Function2<B, LocatedFileStatus, B> op) {
                            return IterableOnceOps.reduceLeftOption$((IterableOnceOps)this, op);
                        }

                        public <B> Option<B> reduceRightOption(Function2<LocatedFileStatus, B, B> op) {
                            return IterableOnceOps.reduceRightOption$((IterableOnceOps)this, op);
                        }

                        public boolean nonEmpty() {
                            return IterableOnceOps.nonEmpty$((IterableOnceOps)this);
                        }

                        public int size() {
                            return IterableOnceOps.size$((IterableOnceOps)this);
                        }

                        public final <B> void copyToBuffer(Buffer<B> dest) {
                            IterableOnceOps.copyToBuffer$((IterableOnceOps)this, dest);
                        }

                        public <B> int copyToArray(Object xs) {
                            return IterableOnceOps.copyToArray$((IterableOnceOps)this, (Object)xs);
                        }

                        public <B> int copyToArray(Object xs, int start) {
                            return IterableOnceOps.copyToArray$((IterableOnceOps)this, (Object)xs, (int)start);
                        }

                        public <B> int copyToArray(Object xs, int start, int len) {
                            return IterableOnceOps.copyToArray$((IterableOnceOps)this, (Object)xs, (int)start, (int)len);
                        }

                        public <B> B sum(Numeric<B> num) {
                            return (B)IterableOnceOps.sum$((IterableOnceOps)this, num);
                        }

                        public <B> B product(Numeric<B> num) {
                            return (B)IterableOnceOps.product$((IterableOnceOps)this, num);
                        }

                        public Object min(Ordering ord) {
                            return IterableOnceOps.min$((IterableOnceOps)this, (Ordering)ord);
                        }

                        public <B> Option<LocatedFileStatus> minOption(Ordering<B> ord) {
                            return IterableOnceOps.minOption$((IterableOnceOps)this, ord);
                        }

                        public Object max(Ordering ord) {
                            return IterableOnceOps.max$((IterableOnceOps)this, (Ordering)ord);
                        }

                        public <B> Option<LocatedFileStatus> maxOption(Ordering<B> ord) {
                            return IterableOnceOps.maxOption$((IterableOnceOps)this, ord);
                        }

                        public Object maxBy(Function1 f, Ordering cmp) {
                            return IterableOnceOps.maxBy$((IterableOnceOps)this, (Function1)f, (Ordering)cmp);
                        }

                        public <B$> Option<LocatedFileStatus> maxByOption(Function1<LocatedFileStatus, B$> f, Ordering<B$> cmp) {
                            return IterableOnceOps.maxByOption$((IterableOnceOps)this, f, cmp);
                        }

                        public Object minBy(Function1 f, Ordering cmp) {
                            return IterableOnceOps.minBy$((IterableOnceOps)this, (Function1)f, (Ordering)cmp);
                        }

                        public <B$> Option<LocatedFileStatus> minByOption(Function1<LocatedFileStatus, B$> f, Ordering<B$> cmp) {
                            return IterableOnceOps.minByOption$((IterableOnceOps)this, f, cmp);
                        }

                        public <B$> Option<B$> collectFirst(PartialFunction<LocatedFileStatus, B$> pf) {
                            return IterableOnceOps.collectFirst$((IterableOnceOps)this, pf);
                        }

                        public <B$> B$ aggregate(Function0<B$> z, Function2<B$, LocatedFileStatus, B$> seqop, Function2<B$, B$, B$> combop) {
                            return (B$)IterableOnceOps.aggregate$((IterableOnceOps)this, z, seqop, combop);
                        }

                        public <B$> boolean corresponds(IterableOnce<B$> that, Function2<LocatedFileStatus, B$, Object> p) {
                            return IterableOnceOps.corresponds$((IterableOnceOps)this, that, p);
                        }

                        public final String mkString(String start, String sep, String end) {
                            return IterableOnceOps.mkString$((IterableOnceOps)this, (String)start, (String)sep, (String)end);
                        }

                        public final String mkString(String sep) {
                            return IterableOnceOps.mkString$((IterableOnceOps)this, (String)sep);
                        }

                        public final String mkString() {
                            return IterableOnceOps.mkString$((IterableOnceOps)this);
                        }

                        public StringBuilder addString(StringBuilder b, String start, String sep, String end) {
                            return IterableOnceOps.addString$((IterableOnceOps)this, (StringBuilder)b, (String)start, (String)sep, (String)end);
                        }

                        public final StringBuilder addString(StringBuilder b, String sep) {
                            return IterableOnceOps.addString$((IterableOnceOps)this, (StringBuilder)b, (String)sep);
                        }

                        public final StringBuilder addString(StringBuilder b) {
                            return IterableOnceOps.addString$((IterableOnceOps)this, (StringBuilder)b);
                        }

                        public <C1> C1 to(Factory<LocatedFileStatus, C1> factory) {
                            return (C1)IterableOnceOps.to$((IterableOnceOps)this, factory);
                        }

                        public final Iterator<LocatedFileStatus> toIterator() {
                            return IterableOnceOps.toIterator$((IterableOnceOps)this);
                        }

                        public List<LocatedFileStatus> toList() {
                            return IterableOnceOps.toList$((IterableOnceOps)this);
                        }

                        public Vector<LocatedFileStatus> toVector() {
                            return IterableOnceOps.toVector$((IterableOnceOps)this);
                        }

                        public <K$, V$> Map<K$, V$> toMap(.less.colon.less<LocatedFileStatus, Tuple2<K$, V$>> ev) {
                            return IterableOnceOps.toMap$((IterableOnceOps)this, ev);
                        }

                        public <B> Set<B> toSet() {
                            return IterableOnceOps.toSet$((IterableOnceOps)this);
                        }

                        public Seq<LocatedFileStatus> toSeq() {
                            return IterableOnceOps.toSeq$((IterableOnceOps)this);
                        }

                        public IndexedSeq<LocatedFileStatus> toIndexedSeq() {
                            return IterableOnceOps.toIndexedSeq$((IterableOnceOps)this);
                        }

                        public final Stream<LocatedFileStatus> toStream() {
                            return IterableOnceOps.toStream$((IterableOnceOps)this);
                        }

                        public final <B> Buffer<B> toBuffer() {
                            return IterableOnceOps.toBuffer$((IterableOnceOps)this);
                        }

                        public <B> Object toArray(ClassTag<B> evidence$2) {
                            return IterableOnceOps.toArray$((IterableOnceOps)this, evidence$2);
                        }

                        public Iterable<LocatedFileStatus> reversed() {
                            return IterableOnceOps.reversed$((IterableOnceOps)this);
                        }

                        public <S extends Stepper<?>> S stepper(StepperShape<LocatedFileStatus, S> shape) {
                            return (S)IterableOnce.stepper$((IterableOnce)this, shape);
                        }

                        public int knownSize() {
                            return IterableOnce.knownSize$((IterableOnce)this);
                        }

                        public LocatedFileStatus next() {
                            return (LocatedFileStatus)this.remoteIter$1.next();
                        }

                        public boolean hasNext() {
                            return this.remoteIter$1.hasNext();
                        }
                        {
                            this.remoteIter$1 = remoteIter$1;
                            IterableOnce.$init$((IterableOnce)this);
                            IterableOnceOps.$init$((IterableOnceOps)this);
                            Iterator.$init$((Iterator)this);
                        }
                    }.toArray(ClassTag$.MODULE$.apply(FileStatus.class));
                } else {
                    var13_14 = fs.listStatus(path);
                }
                v0 = var13_14;
            }
            catch (Throwable var19_15) {
                var20_16 = var19_15;
                if (!(var20_16 instanceof FileNotFoundException) || !isRootPath && !ignoreMissingFiles) {
                    throw var19_15;
                }
                this.logWarning((Function0<String>)(Function0 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$listLeafFiles$2(org.apache.hadoop.fs.Path ), ()Ljava/lang/String;)((Path)path));
                var12_17 = (FileStatus[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(FileStatus.class));
                v0 = var12_17;
            }
            statuses = v0;
            filteredStatuses = (FileStatus[])ArrayOps$.MODULE$.filterNot$extension(Predef$.MODULE$.refArrayOps((Object[])statuses), (Function1)(Function1 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$listLeafFiles$3$adapted(org.apache.hadoop.fs.FileStatus ), (Lorg/apache/hadoop/fs/FileStatus;)Ljava/lang/Object;)());
            var24_20 = ArrayOps$.MODULE$.partition$extension(Predef$.MODULE$.refArrayOps((Object[])filteredStatuses), (Function1)(Function1 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$listLeafFiles$4$adapted(org.apache.hadoop.fs.FileStatus ), (Lorg/apache/hadoop/fs/FileStatus;)Ljava/lang/Object;)());
            if (var24_20 == null) {
                throw new MatchError((Object)var24_20);
            }
            dirs = (FileStatus[])var24_20._1();
            topLevelFiles = (FileStatus[])var24_20._2();
            var11_23 = new Tuple2((Object)dirs, (Object)topLevelFiles);
            var23_24 = var11_23;
            dirs = (FileStatus[])var23_24._1();
            topLevelFiles = (FileStatus[])var23_24._2();
            var30_27 = contextOpt;
            if (!(var30_27 instanceof Some)) ** GOTO lbl-1000
            var31_28 = (Some)var30_27;
            context = (SparkContext)var31_28.value();
            if (ArrayOps$.MODULE$.size$extension(Predef$.MODULE$.refArrayOps((Object[])dirs)) > parallelismThreshold) {
                var10_30 = (Seq)this.parallelListLeafFilesInternal(context, (Seq<Path>)Predef$.MODULE$.copyArrayToImmutableIndexedSeq(ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])dirs), (Function1)(Function1 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$listLeafFiles$5(org.apache.hadoop.fs.FileStatus ), (Lorg/apache/hadoop/fs/FileStatus;)Lorg/apache/hadoop/fs/Path;)(), ClassTag$.MODULE$.apply(Path.class))), hadoopConf, filter, false, ignoreMissingFiles, ignoreLocality, parallelismThreshold, parallelismMax).flatMap((Function1)(Function1 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$listLeafFiles$6(scala.Tuple2 ), (Lscala/Tuple2;)Lscala/collection/immutable/Seq;)());
            } else lbl-1000:
            // 2 sources

            {
                var10_30 = Predef$.MODULE$.copyArrayToImmutableIndexedSeq(ArrayOps$.MODULE$.flatMap$extension(Predef$.MODULE$.refArrayOps((Object[])dirs), (Function1)(Function1 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$listLeafFiles$7(org.apache.hadoop.conf.Configuration org.apache.hadoop.fs.PathFilter scala.Option boolean boolean int int org.apache.hadoop.fs.FileStatus ), (Lorg/apache/hadoop/fs/FileStatus;)Lscala/collection/immutable/Seq;)((Configuration)hadoopConf, (PathFilter)filter, contextOpt, (boolean)ignoreMissingFiles, (boolean)ignoreLocality, (int)parallelismThreshold, (int)parallelismMax), ClassTag$.MODULE$.apply(FileStatus.class)));
            }
            nestedFiles = var10_30;
            allFiles = (FileStatus[])ArrayOps$.MODULE$.$plus$plus$extension(Predef$.MODULE$.refArrayOps((Object[])topLevelFiles), (IterableOnce)nestedFiles, ClassTag$.MODULE$.apply(FileStatus.class));
            allLeafStatuses = filter != null ? (FileStatus[])ArrayOps$.MODULE$.filter$extension(Predef$.MODULE$.refArrayOps((Object[])allFiles), (Function1)(Function1 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$listLeafFiles$8$adapted(org.apache.hadoop.fs.PathFilter org.apache.hadoop.fs.FileStatus ), (Lorg/apache/hadoop/fs/FileStatus;)Ljava/lang/Object;)((PathFilter)filter)) : allFiles;
            missingFiles = ArrayBuffer$.MODULE$.empty();
            resolvedLeafStatuses = (FileStatus[])ArrayOps$.MODULE$.flatMap$extension(Predef$.MODULE$.refArrayOps((Object[])allLeafStatuses), (Function1)(Function1 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$listLeafFiles$9(boolean org.apache.hadoop.fs.FileSystem boolean scala.collection.mutable.ArrayBuffer org.apache.hadoop.fs.FileStatus ), (Lorg/apache/hadoop/fs/FileStatus;)Lscala/Option;)((boolean)ignoreLocality, (FileSystem)fs, (boolean)ignoreMissingFiles, (ArrayBuffer)missingFiles), ClassTag$.MODULE$.apply(FileStatus.class));
            if (!missingFiles.nonEmpty()) break block8;
            this.logWarning((Function0<String>)(Function0 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$listLeafFiles$11(scala.collection.mutable.ArrayBuffer ), ()Ljava/lang/String;)((ArrayBuffer)missingFiles));
        }
        return Predef$.MODULE$.copyArrayToImmutableIndexedSeq((Object)resolvedLeafStatuses);
    }

    public boolean shouldFilterOutPathName(String pathName) {
        boolean exclude = pathName.startsWith("_") && !pathName.contains("=") || pathName.startsWith(".") || pathName.endsWith("._COPYING_");
        boolean include = pathName.startsWith("_common_metadata") || pathName.startsWith("_metadata");
        return exclude && !include;
    }

    public static final /* synthetic */ String $anonfun$listLeafFiles$1(Path path$1) {
        return new java.lang.StringBuilder(8).append("Listing ").append(path$1).toString();
    }

    public static final /* synthetic */ String $anonfun$listLeafFiles$2(Path path$1) {
        return new java.lang.StringBuilder(59).append("The directory ").append(path$1).append(" was not found. Was it deleted very recently?").toString();
    }

    public static final /* synthetic */ Path $anonfun$listLeafFiles$5(FileStatus x$5) {
        return x$5.getPath();
    }

    public static final /* synthetic */ Seq $anonfun$listLeafFiles$6(Tuple2 x$6) {
        return (Seq)x$6._2();
    }

    public static final /* synthetic */ Seq $anonfun$listLeafFiles$7(Configuration hadoopConf$3, PathFilter filter$2, Option contextOpt$1, boolean ignoreMissingFiles$2, boolean ignoreLocality$2, int parallelismThreshold$2, int parallelismMax$2, FileStatus dir) {
        return MODULE$.listLeafFiles(dir.getPath(), hadoopConf$3, filter$2, (Option<SparkContext>)contextOpt$1, ignoreMissingFiles$2, ignoreLocality$2, false, parallelismThreshold$2, parallelismMax$2);
    }

    public static final /* synthetic */ Option $anonfun$listLeafFiles$9(boolean ignoreLocality$2, FileSystem fs$1, boolean ignoreMissingFiles$2, ArrayBuffer missingFiles$1, FileStatus x0$1) {
        Some some;
        FileStatus fileStatus = x0$1;
        if (fileStatus instanceof LocatedFileStatus) {
            LocatedFileStatus locatedFileStatus = (LocatedFileStatus)fileStatus;
            some = new Some((Object)locatedFileStatus);
        } else if (!ignoreLocality$2) {
            None$ none$;
            try {
                BlockLocation[] locations = (BlockLocation[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])fs$1.getFileBlockLocations(fileStatus, 0L, fileStatus.getLen())), (Function1 & Serializable)loc -> {
                    Class clazz = loc.getClass();
                    Class<BlockLocation> clazz2 = BlockLocation.class;
                    return !(clazz != null ? !clazz.equals(clazz2) : clazz2 != null) ? loc : new BlockLocation(loc.getNames(), loc.getHosts(), loc.getOffset(), loc.getLength());
                }, ClassTag$.MODULE$.apply(BlockLocation.class));
                LocatedFileStatus lfs = new LocatedFileStatus(fileStatus.getLen(), fileStatus.isDirectory(), (int)fileStatus.getReplication(), fileStatus.getBlockSize(), fileStatus.getModificationTime(), 0L, null, null, null, null, fileStatus.getPath(), locations);
                if (fileStatus.isSymlink()) {
                    lfs.setSymlink(fileStatus.getSymlink());
                }
                none$ = new Some((Object)lfs);
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                if (!(throwable2 instanceof FileNotFoundException) || !ignoreMissingFiles$2) {
                    throw throwable;
                }
                missingFiles$1.$plus$eq((Object)fileStatus.getPath().toString());
                None$ none$2 = None$.MODULE$;
                none$ = none$2;
            }
            some = none$;
        } else {
            some = new Some((Object)fileStatus);
        }
        return some;
    }

    public static final /* synthetic */ String $anonfun$listLeafFiles$11(ArrayBuffer missingFiles$1) {
        return new java.lang.StringBuilder(53).append("the following files were missing during file scan:\n  ").append(missingFiles$1.mkString("\n  ")).toString();
    }

    private HadoopFSUtils$() {
    }

    public static final /* synthetic */ Object $anonfun$listLeafFiles$3$adapted(FileStatus status) {
        return BoxesRunTime.boxToBoolean((boolean)HadoopFSUtils$.MODULE$.shouldFilterOutPathName(status.getPath().getName()));
    }

    public static final /* synthetic */ Object $anonfun$listLeafFiles$4$adapted(FileStatus x$3) {
        return BoxesRunTime.boxToBoolean((boolean)x$3.isDirectory());
    }

    public static final /* synthetic */ Object $anonfun$listLeafFiles$8$adapted(PathFilter filter$2, FileStatus f) {
        return BoxesRunTime.boxToBoolean((boolean)filter$2.accept(f.getPath()));
    }
}

