/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.util;

import java.io.File;
import java.io.Serializable;
import org.apache.spark.internal.Logging;
import org.apache.spark.util.SparkShutdownHookManager;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.collection.ArrayOps$;
import scala.collection.mutable.HashSet;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

public final class ShutdownHookManager$
implements Logging {
    public static final ShutdownHookManager$ MODULE$ = new ShutdownHookManager$();
    private static SparkShutdownHookManager shutdownHooks;
    private static final int DEFAULT_SHUTDOWN_PRIORITY;
    private static final int SPARK_CONTEXT_SHUTDOWN_PRIORITY;
    private static final int TEMP_DIR_SHUTDOWN_PRIORITY;
    private static final HashSet<String> shutdownDeletePaths;
    private static transient Logger org$apache$spark$internal$Logging$$log_;
    private static volatile boolean bitmap$0;

    static {
        Logging.$init$(MODULE$);
        DEFAULT_SHUTDOWN_PRIORITY = 100;
        SPARK_CONTEXT_SHUTDOWN_PRIORITY = 50;
        TEMP_DIR_SHUTDOWN_PRIORITY = 25;
        shutdownDeletePaths = new HashSet();
        MODULE$.logDebug((Function0<String>)(Function0 & Serializable)() -> "Adding shutdown hook");
        MODULE$.addShutdownHook(MODULE$.TEMP_DIR_SHUTDOWN_PRIORITY(), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
            MODULE$.logInfo((Function0<String>)(Function0 & Serializable)() -> "Shutdown hook called");
            ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps((Object[])MODULE$.shutdownDeletePaths().toArray(ClassTag$.MODULE$.apply(String.class))), (Function1 & Serializable)dirPath -> {
                ShutdownHookManager$.$anonfun$new$4(dirPath);
                return BoxedUnit.UNIT;
            });
        });
    }

    @Override
    public String logName() {
        return Logging.logName$(this);
    }

    @Override
    public Logger log() {
        return Logging.log$(this);
    }

    @Override
    public void logInfo(Function0<String> msg) {
        Logging.logInfo$(this, msg);
    }

    @Override
    public void logDebug(Function0<String> msg) {
        Logging.logDebug$(this, msg);
    }

    @Override
    public void logTrace(Function0<String> msg) {
        Logging.logTrace$(this, msg);
    }

    @Override
    public void logWarning(Function0<String> msg) {
        Logging.logWarning$(this, msg);
    }

    @Override
    public void logError(Function0<String> msg) {
        Logging.logError$(this, msg);
    }

    @Override
    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$(this, msg, throwable);
    }

    @Override
    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$(this, msg, throwable);
    }

    @Override
    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$(this, msg, throwable);
    }

    @Override
    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$(this, msg, throwable);
    }

    @Override
    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$(this, msg, throwable);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$(this, isInterpreter);
    }

    @Override
    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$(this, isInterpreter, silent);
    }

    @Override
    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$(this);
    }

    @Override
    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$(this, isInterpreter, silent);
    }

    @Override
    public Logger org$apache$spark$internal$Logging$$log_() {
        return org$apache$spark$internal$Logging$$log_;
    }

    @Override
    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public int DEFAULT_SHUTDOWN_PRIORITY() {
        return DEFAULT_SHUTDOWN_PRIORITY;
    }

    public int SPARK_CONTEXT_SHUTDOWN_PRIORITY() {
        return SPARK_CONTEXT_SHUTDOWN_PRIORITY;
    }

    public int TEMP_DIR_SHUTDOWN_PRIORITY() {
        return TEMP_DIR_SHUTDOWN_PRIORITY;
    }

    /*
     * WARNING - void declaration
     */
    private SparkShutdownHookManager shutdownHooks$lzycompute() {
        ShutdownHookManager$ shutdownHookManager$ = this;
        synchronized (shutdownHookManager$) {
            if (!bitmap$0) {
                void var2_2;
                SparkShutdownHookManager manager = new SparkShutdownHookManager();
                manager.install();
                shutdownHooks = var2_2;
                bitmap$0 = true;
            }
        }
        return shutdownHooks;
    }

    private SparkShutdownHookManager shutdownHooks() {
        return !bitmap$0 ? this.shutdownHooks$lzycompute() : shutdownHooks;
    }

    private HashSet<String> shutdownDeletePaths() {
        return shutdownDeletePaths;
    }

    public void registerShutdownDeleteDir(File file) {
        String absolutePath = file.getAbsolutePath();
        HashSet<String> hashSet = this.shutdownDeletePaths();
        synchronized (hashSet) {
            HashSet cfr_ignored_0 = (HashSet)this.shutdownDeletePaths().$plus$eq((Object)absolutePath);
        }
    }

    public void removeShutdownDeleteDir(File file) {
        String absolutePath = file.getAbsolutePath();
        HashSet<String> hashSet = this.shutdownDeletePaths();
        synchronized (hashSet) {
            this.shutdownDeletePaths().remove((Object)absolutePath);
        }
    }

    public boolean hasShutdownDeleteDir(File file) {
        boolean bl;
        String absolutePath = file.getAbsolutePath();
        HashSet<String> hashSet = this.shutdownDeletePaths();
        synchronized (hashSet) {
            bl = this.shutdownDeletePaths().contains((Object)absolutePath);
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    public boolean hasRootAsShutdownDeleteDir(File file) {
        void var3_5;
        block3: {
            boolean bl;
            String absolutePath = file.getAbsolutePath();
            HashSet<String> hashSet = this.shutdownDeletePaths();
            synchronized (hashSet) {
                bl = this.shutdownDeletePaths().exists((Function1 & Serializable)path -> BoxesRunTime.boxToBoolean((boolean)ShutdownHookManager$.$anonfun$hasRootAsShutdownDeleteDir$1(absolutePath, path)));
            }
            boolean retval = bl;
            if (!retval) break block3;
            this.logInfo((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(46).append("path = ").append(file).append(", already present as root for deletion.").toString());
        }
        return (boolean)var3_5;
    }

    public boolean inShutdown() {
        try {
            Thread hook = new Thread(){

                public void run() {
                }
            };
            Runtime.getRuntime().addShutdownHook(hook);
            Runtime.getRuntime().removeShutdownHook(hook);
        }
        catch (IllegalStateException ise) {
            return true;
        }
        return false;
    }

    public Object addShutdownHook(Function0<BoxedUnit> hook) {
        return this.addShutdownHook(this.DEFAULT_SHUTDOWN_PRIORITY(), hook);
    }

    public Object addShutdownHook(int priority, Function0<BoxedUnit> hook) {
        return this.shutdownHooks().add(priority, hook);
    }

    public boolean removeShutdownHook(Object ref) {
        return this.shutdownHooks().remove(ref);
    }

    public static final /* synthetic */ void $anonfun$new$4(String dirPath) {
        try {
            MODULE$.logInfo((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(19).append("Deleting directory ").append(dirPath).toString());
            Utils$.MODULE$.deleteRecursively(new File(dirPath));
        }
        catch (Exception e) {
            MODULE$.logError((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(41).append("Exception while deleting Spark temp dir: ").append(dirPath).toString(), e);
        }
    }

    public static final /* synthetic */ boolean $anonfun$hasRootAsShutdownDeleteDir$1(String absolutePath$1, String path) {
        return !absolutePath$1.equals(path) && absolutePath$1.startsWith(path);
    }

    private ShutdownHookManager$() {
    }
}

