/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.util;

import java.io.Serializable;
import org.apache.commons.lang3.SystemUtils;
import org.apache.spark.internal.Logging;
import org.apache.spark.util.SignalUtils;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.collection.immutable.Seq;
import scala.collection.mutable.HashMap;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import sun.misc.Signal;

public final class SignalUtils$
implements Logging {
    public static final SignalUtils$ MODULE$ = new SignalUtils$();
    private static boolean loggerRegistered;
    private static final HashMap<String, SignalUtils.ActionHandler> handlers;
    private static transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        Logging.$init$(MODULE$);
        loggerRegistered = false;
        handlers = new HashMap();
    }

    @Override
    public String logName() {
        return Logging.logName$(this);
    }

    @Override
    public Logger log() {
        return Logging.log$(this);
    }

    @Override
    public void logInfo(Function0<String> msg) {
        Logging.logInfo$(this, msg);
    }

    @Override
    public void logDebug(Function0<String> msg) {
        Logging.logDebug$(this, msg);
    }

    @Override
    public void logTrace(Function0<String> msg) {
        Logging.logTrace$(this, msg);
    }

    @Override
    public void logWarning(Function0<String> msg) {
        Logging.logWarning$(this, msg);
    }

    @Override
    public void logError(Function0<String> msg) {
        Logging.logError$(this, msg);
    }

    @Override
    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$(this, msg, throwable);
    }

    @Override
    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$(this, msg, throwable);
    }

    @Override
    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$(this, msg, throwable);
    }

    @Override
    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$(this, msg, throwable);
    }

    @Override
    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$(this, msg, throwable);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$(this, isInterpreter);
    }

    @Override
    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$(this, isInterpreter, silent);
    }

    @Override
    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$(this);
    }

    @Override
    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$(this, isInterpreter, silent);
    }

    @Override
    public Logger org$apache$spark$internal$Logging$$log_() {
        return org$apache$spark$internal$Logging$$log_;
    }

    @Override
    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private boolean loggerRegistered() {
        return loggerRegistered;
    }

    private void loggerRegistered_$eq(boolean x$1) {
        loggerRegistered = x$1;
    }

    public synchronized void registerLogger(Logger log) {
        block0: {
            if (this.loggerRegistered()) break block0;
            package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"TERM", "HUP", "INT"})).foreach((Function1 & Serializable)sig -> {
                SignalUtils$.MODULE$.register(sig, (Function0<Object>)(JFunction0.mcZ.sp & Serializable)() -> {
                    log$1.error(new StringBuilder(16).append("RECEIVED SIGNAL ").append(sig).toString());
                    return false;
                });
                return BoxedUnit.UNIT;
            });
            this.loggerRegistered_$eq(true);
        }
    }

    public void register(String signal, Function0<Object> action) {
        block0: {
            if (!SystemUtils.IS_OS_UNIX) break block0;
            this.register(signal, new StringBuilder(38).append("Failed to register signal handler for ").append(signal).toString(), true, action);
        }
    }

    public synchronized void register(String signal, String failMessage, boolean logStackTrace, Function0<Object> action) {
        block3: {
            try {
                SignalUtils.ActionHandler handler = (SignalUtils.ActionHandler)this.handlers().getOrElseUpdate((Object)signal, (Function0 & Serializable)() -> {
                    MODULE$.logInfo((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(31).append("Registering signal handler for ").append(signal).toString());
                    return new SignalUtils.ActionHandler(new Signal(signal));
                });
                handler.register(action);
            }
            catch (Exception ex) {
                if (logStackTrace) {
                    this.logWarning((Function0<String>)(Function0 & Serializable)() -> failMessage, ex);
                    break block3;
                }
                this.logWarning((Function0<String>)(Function0 & Serializable)() -> failMessage);
            }
        }
    }

    public boolean register$default$3() {
        return true;
    }

    private HashMap<String, SignalUtils.ActionHandler> handlers() {
        return handlers;
    }

    private SignalUtils$() {
    }
}

