/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.util;

import java.io.Serializable;
import org.apache.spark.util.StatCounter$;
import scala.Function1;
import scala.Predef$;
import scala.collection.IterableOnce;
import scala.collection.IterableOnce$;
import scala.collection.IterableOnceExtensionMethods$;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\u0005Md\u0001B\u0015+\u0001MB\u0001B\u0012\u0001\u0003\u0002\u0003\u0006Ia\u0012\u0005\u0006\u001b\u0002!\tA\u0014\u0005\b%\u0002\u0001\r\u0011\"\u0003T\u0011\u001d9\u0006\u00011A\u0005\naCaA\u0018\u0001!B\u0013!\u0006bB0\u0001\u0001\u0004%I\u0001\u0019\u0005\bC\u0002\u0001\r\u0011\"\u0003c\u0011\u0019!\u0007\u0001)Q\u0005\u0015\"9Q\r\u0001a\u0001\n\u0013\u0001\u0007b\u00024\u0001\u0001\u0004%Ia\u001a\u0005\u0007S\u0002\u0001\u000b\u0015\u0002&\t\u000f)\u0004\u0001\u0019!C\u0005A\"91\u000e\u0001a\u0001\n\u0013a\u0007B\u00028\u0001A\u0003&!\nC\u0004p\u0001\u0001\u0007I\u0011\u00021\t\u000fA\u0004\u0001\u0019!C\u0005c\"11\u000f\u0001Q!\n)CQ!\u0014\u0001\u0005\u0002QDQ!\u001e\u0001\u0005\u0002YDQ!\u001e\u0001\u0005\u0002eDQ!\u001e\u0001\u0005\u0002mDQA \u0001\u0005\u0002QDQa \u0001\u0005\u0002MCa!!\u0001\u0001\t\u0003\u0001\u0007BBA\u0002\u0001\u0011\u0005\u0001\r\u0003\u0004\u0002\u0006\u0001!\t\u0001\u0019\u0005\u0007\u0003\u000f\u0001A\u0011\u00011\t\r\u0005%\u0001\u0001\"\u0001a\u0011\u0019\tY\u0001\u0001C\u0001A\"1\u0011q\u0004\u0001\u0005\u0002\u0001Da!!\t\u0001\t\u0003\u0001\u0007BBA\u0012\u0001\u0011\u0005\u0001\r\u0003\u0004\u0002(\u0001!\t\u0001\u0019\u0005\b\u0003S\u0001A\u0011IA\u0016\u000f\u001d\tiD\u000bE\u0001\u0003\u007f1a!\u000b\u0016\t\u0002\u0005\u0005\u0003BB'%\t\u0003\t\t\u0006C\u0004\u0002T\u0011\"\t!!\u0016\t\u000f\u0005MC\u0005\"\u0001\u0002Z!I\u00111\r\u0013\u0002\u0002\u0013%\u0011Q\r\u0002\f'R\fGoQ8v]R,'O\u0003\u0002,Y\u0005!Q\u000f^5m\u0015\tic&A\u0003ta\u0006\u00148N\u0003\u00020a\u00051\u0011\r]1dQ\u0016T\u0011!M\u0001\u0004_J<7\u0001A\n\u0004\u0001QR\u0004CA\u001b9\u001b\u00051$\"A\u001c\u0002\u000bM\u001c\u0017\r\\1\n\u0005e2$AB!osJ+g\r\u0005\u0002<\u0007:\u0011A(\u0011\b\u0003{\u0001k\u0011A\u0010\u0006\u0003\u007fI\na\u0001\u0010:p_Rt\u0014\"A\u001c\n\u0005\t3\u0014a\u00029bG.\fw-Z\u0005\u0003\t\u0016\u0013AbU3sS\u0006d\u0017N_1cY\u0016T!A\u0011\u001c\u0002\rY\fG.^3t!\rY\u0004JS\u0005\u0003\u0013\u0016\u0013q\u0002\u0016:bm\u0016\u00148/\u00192mK>s7-\u001a\t\u0003k-K!\u0001\u0014\u001c\u0003\r\u0011{WO\u00197f\u0003\u0019a\u0014N\\5u}Q\u0011q*\u0015\t\u0003!\u0002i\u0011A\u000b\u0005\u0006\r\n\u0001\raR\u0001\u0002]V\tA\u000b\u0005\u00026+&\u0011aK\u000e\u0002\u0005\u0019>tw-A\u0003o?\u0012*\u0017\u000f\u0006\u0002Z9B\u0011QGW\u0005\u00037Z\u0012A!\u00168ji\"9Q\fBA\u0001\u0002\u0004!\u0016a\u0001=%c\u0005\u0011a\u000eI\u0001\u0003[V,\u0012AS\u0001\u0007[V|F%Z9\u0015\u0005e\u001b\u0007bB/\b\u0003\u0003\u0005\rAS\u0001\u0004[V\u0004\u0013AA73\u0003\u0019i'g\u0018\u0013fcR\u0011\u0011\f\u001b\u0005\b;*\t\t\u00111\u0001K\u0003\ri'\u0007I\u0001\t[\u0006Dh+\u00197vK\u0006aQ.\u0019=WC2,Xm\u0018\u0013fcR\u0011\u0011,\u001c\u0005\b;6\t\t\u00111\u0001K\u0003%i\u0017\r\u001f,bYV,\u0007%\u0001\u0005nS:4\u0016\r\\;f\u00031i\u0017N\u001c,bYV,w\fJ3r)\tI&\u000fC\u0004^!\u0005\u0005\t\u0019\u0001&\u0002\u00135LgNV1mk\u0016\u0004C#A(\u0002\u000b5,'oZ3\u0015\u0005=;\b\"\u0002=\u0014\u0001\u0004Q\u0015!\u0002<bYV,GCA({\u0011\u00151E\u00031\u0001H)\tyE\u0010C\u0003~+\u0001\u0007q*A\u0003pi\",'/\u0001\u0003d_BL\u0018!B2pk:$\u0018\u0001B7fC:\f1a];n\u0003\ri\u0017\r_\u0001\u0004[&t\u0017\u0001\u0003<be&\fgnY3\u0002\u0017A|\u0007OV1sS\u0006t7-\u001a\u0015\u0006;\u0005=\u00111\u0004\t\u0005\u0003#\t9\"\u0004\u0002\u0002\u0014)\u0019\u0011Q\u0003\u0017\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002\u001a\u0005M!!B*j]\u000e,\u0017EAA\u000f\u0003\u0015\u0011d&\r\u00181\u00039\u0019\u0018-\u001c9mKZ\u000b'/[1oG\u0016\fQa\u001d;eKZ\f\u0001\u0002]8q'R$WM\u001e\u0015\u0006A\u0005=\u00111D\u0001\fg\u0006l\u0007\u000f\\3Ti\u0012,g/\u0001\u0005u_N#(/\u001b8h)\t\ti\u0003\u0005\u0003\u00020\u0005]b\u0002BA\u0019\u0003g\u0001\"!\u0010\u001c\n\u0007\u0005Ub'\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003s\tYD\u0001\u0004TiJLgn\u001a\u0006\u0004\u0003k1\u0014aC*uCR\u001cu.\u001e8uKJ\u0004\"\u0001\u0015\u0013\u0014\t\u0011\"\u00141\t\t\u0005\u0003\u000b\ny%\u0004\u0002\u0002H)!\u0011\u0011JA&\u0003\tIwN\u0003\u0002\u0002N\u0005!!.\u0019<b\u0013\r!\u0015q\t\u000b\u0003\u0003\u007f\tQ!\u00199qYf$2aTA,\u0011\u00151e\u00051\u0001H)\ry\u00151\f\u0005\u0007\r\u001e\u0002\r!!\u0018\u0011\tU\nyFS\u0005\u0004\u0003C2$A\u0003\u001fsKB,\u0017\r^3e}\u0005aqO]5uKJ+\u0007\u000f\\1dKR\u0011\u0011q\r\t\u0005\u0003S\ny'\u0004\u0002\u0002l)!\u0011QNA&\u0003\u0011a\u0017M\\4\n\t\u0005E\u00141\u000e\u0002\u0007\u001f\nTWm\u0019;")
public class StatCounter
implements Serializable {
    private long n = 0L;
    private double mu = 0.0;
    private double m2 = 0.0;
    private double maxValue = Double.NEGATIVE_INFINITY;
    private double minValue = Double.POSITIVE_INFINITY;

    public static StatCounter apply(Seq<Object> seq) {
        return StatCounter$.MODULE$.apply(seq);
    }

    public static StatCounter apply(IterableOnce<Object> iterableOnce) {
        return StatCounter$.MODULE$.apply(iterableOnce);
    }

    private long n() {
        return this.n;
    }

    private void n_$eq(long x$1) {
        this.n = x$1;
    }

    private double mu() {
        return this.mu;
    }

    private void mu_$eq(double x$1) {
        this.mu = x$1;
    }

    private double m2() {
        return this.m2;
    }

    private void m2_$eq(double x$1) {
        this.m2 = x$1;
    }

    private double maxValue() {
        return this.maxValue;
    }

    private void maxValue_$eq(double x$1) {
        this.maxValue = x$1;
    }

    private double minValue() {
        return this.minValue;
    }

    private void minValue_$eq(double x$1) {
        this.minValue = x$1;
    }

    public StatCounter merge(double value) {
        double delta = value - this.mu();
        this.n_$eq(this.n() + 1L);
        this.mu_$eq(this.mu() + delta / (double)this.n());
        this.m2_$eq(this.m2() + delta * (value - this.mu()));
        this.maxValue_$eq(package$.MODULE$.max(this.maxValue(), value));
        this.minValue_$eq(package$.MODULE$.min(this.minValue(), value));
        return this;
    }

    public StatCounter merge(IterableOnce<Object> values) {
        IterableOnceExtensionMethods$.MODULE$.foreach$extension(IterableOnce$.MODULE$.iterableOnceExtensionMethods(values), (Function1 & Serializable)v -> this.merge(BoxesRunTime.unboxToDouble((Object)v)));
        return this;
    }

    public StatCounter merge(StatCounter other) {
        StatCounter statCounter;
        StatCounter statCounter2 = other;
        StatCounter statCounter3 = this;
        if (!(statCounter2 != null ? !statCounter2.equals(statCounter3) : statCounter3 != null)) {
            statCounter = this.merge(other.copy());
        } else {
            if (this.n() == 0L) {
                this.mu_$eq(other.mu());
                this.m2_$eq(other.m2());
                this.n_$eq(other.n());
                this.maxValue_$eq(other.maxValue());
                this.minValue_$eq(other.minValue());
            } else if (other.n() != 0L) {
                double delta = other.mu() - this.mu();
                if (other.n() * 10L < this.n()) {
                    this.mu_$eq(this.mu() + delta * (double)other.n() / (double)(this.n() + other.n()));
                } else if (this.n() * 10L < other.n()) {
                    this.mu_$eq(other.mu() - delta * (double)this.n() / (double)(this.n() + other.n()));
                } else {
                    this.mu_$eq((this.mu() * (double)this.n() + other.mu() * (double)other.n()) / (double)(this.n() + other.n()));
                }
                this.m2_$eq(this.m2() + (other.m2() + delta * delta * (double)this.n() * (double)other.n() / (double)(this.n() + other.n())));
                this.n_$eq(this.n() + other.n());
                this.maxValue_$eq(package$.MODULE$.max(this.maxValue(), other.maxValue()));
                this.minValue_$eq(package$.MODULE$.min(this.minValue(), other.minValue()));
            }
            statCounter = this;
        }
        return statCounter;
    }

    /*
     * WARNING - void declaration
     */
    public StatCounter copy() {
        void var1_1;
        StatCounter other = new StatCounter();
        other.n_$eq(this.n());
        other.mu_$eq(this.mu());
        other.m2_$eq(this.m2());
        other.maxValue_$eq(this.maxValue());
        other.minValue_$eq(this.minValue());
        return var1_1;
    }

    public long count() {
        return this.n();
    }

    public double mean() {
        return this.mu();
    }

    public double sum() {
        return (double)this.n() * this.mu();
    }

    public double max() {
        return this.maxValue();
    }

    public double min() {
        return this.minValue();
    }

    public double variance() {
        return this.popVariance();
    }

    public double popVariance() {
        return this.n() == 0L ? Double.NaN : this.m2() / (double)this.n();
    }

    public double sampleVariance() {
        return this.n() <= 1L ? Double.NaN : this.m2() / (double)(this.n() - 1L);
    }

    public double stdev() {
        return this.popStdev();
    }

    public double popStdev() {
        return package$.MODULE$.sqrt(this.popVariance());
    }

    public double sampleStdev() {
        return package$.MODULE$.sqrt(this.sampleVariance());
    }

    public String toString() {
        return StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("(count: %d, mean: %f, stdev: %f, max: %f, min: %f)"), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.count()), BoxesRunTime.boxToDouble((double)this.mean()), BoxesRunTime.boxToDouble((double)this.stdev()), BoxesRunTime.boxToDouble((double)this.max()), BoxesRunTime.boxToDouble((double)this.min())}));
    }

    public StatCounter(IterableOnce<Object> values) {
        this.merge(values);
    }

    public StatCounter() {
        this((IterableOnce<Object>)scala.package$.MODULE$.Nil());
    }
}

