/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.util.io;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import org.apache.commons.io.IOUtils;
import org.apache.spark.network.buffer.FileSegmentManagedBuffer;
import org.apache.spark.network.buffer.ManagedBuffer;
import org.apache.spark.network.util.LimitedInputStream;
import org.apache.spark.storage.EncryptedManagedBuffer;
import org.apache.spark.unsafe.array.ByteArrayMethods;
import org.apache.spark.util.Utils$;
import org.apache.spark.util.io.ChunkedByteBuffer;
import org.apache.spark.util.io.ChunkedByteBufferOutputStream;
import org.sparkproject.guava.io.ByteStreams;
import scala.Function0;
import scala.Function1;
import scala.math.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

public final class ChunkedByteBuffer$ {
    public static final ChunkedByteBuffer$ MODULE$ = new ChunkedByteBuffer$();

    public ChunkedByteBuffer fromManagedBuffer(ManagedBuffer data) {
        ChunkedByteBuffer chunkedByteBuffer;
        ManagedBuffer managedBuffer = data;
        if (managedBuffer instanceof FileSegmentManagedBuffer) {
            FileSegmentManagedBuffer fileSegmentManagedBuffer = (FileSegmentManagedBuffer)managedBuffer;
            chunkedByteBuffer = this.fromFile(fileSegmentManagedBuffer.getFile(), fileSegmentManagedBuffer.getOffset(), fileSegmentManagedBuffer.getLength());
        } else if (managedBuffer instanceof EncryptedManagedBuffer) {
            EncryptedManagedBuffer encryptedManagedBuffer = (EncryptedManagedBuffer)managedBuffer;
            chunkedByteBuffer = encryptedManagedBuffer.blockData().toChunkedByteBuffer((Function1<Object, ByteBuffer>)(Function1 & Serializable)x$1 -> ChunkedByteBuffer$.$anonfun$fromManagedBuffer$1(BoxesRunTime.unboxToInt((Object)x$1)));
        } else {
            chunkedByteBuffer = new ChunkedByteBuffer(managedBuffer.nioByteBuffer());
        }
        return chunkedByteBuffer;
    }

    public ChunkedByteBuffer fromFile(File file) {
        return this.fromFile(file, 0L, file.length());
    }

    private ChunkedByteBuffer fromFile(File file, long offset, long length) {
        FileInputStream is = new FileInputStream(file);
        ByteStreams.skipFully((InputStream)is, (long)offset);
        LimitedInputStream in = new LimitedInputStream((InputStream)is, length);
        int chunkSize = (int)package$.MODULE$.min((long)ByteArrayMethods.MAX_ROUNDED_ARRAY_LENGTH, length);
        ChunkedByteBufferOutputStream out = new ChunkedByteBufferOutputStream(chunkSize, (Function1<Object, ByteBuffer>)(Function1 & Serializable)x$1 -> ChunkedByteBuffer$.$anonfun$fromFile$1(BoxesRunTime.unboxToInt((Object)x$1)));
        Utils$.MODULE$.tryWithSafeFinally((JFunction0.mcI.sp & Serializable)() -> IOUtils.copy((InputStream)in, (OutputStream)out), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
            in.close();
            out.close();
        });
        return out.toChunkedByteBuffer();
    }

    public static final /* synthetic */ ByteBuffer $anonfun$fromManagedBuffer$1(int x$1) {
        return ByteBuffer.allocate(x$1);
    }

    public static final /* synthetic */ ByteBuffer $anonfun$fromFile$1(int x$1) {
        return ByteBuffer.allocate(x$1);
    }

    private ChunkedByteBuffer$() {
    }
}

