/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.util.io;

import java.io.InputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import org.apache.spark.util.io.ChunkedByteBuffer;
import org.sparkproject.guava.primitives.UnsignedBytes;
import scala.Function1;
import scala.Predef$;
import scala.collection.ArrayOps$;
import scala.collection.Iterator;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005\r4Q\u0001D\u0007\u0001#]A\u0001b\b\u0001\u0003\u0002\u0004%\t!\t\u0005\tM\u0001\u0011\t\u0019!C\u0001O!A\u0001\u0007\u0001B\u0001B\u0003&!\u0005\u0003\u00052\u0001\t\u0005\t\u0015!\u00033\u0011\u0015)\u0004\u0001\"\u00017\u0011\u0019Q\u0004\u0001)Q\u0005w!1q\t\u0001Q!\n\u0005CQ\u0001\u0013\u0001\u0005B%CQ\u0001\u0013\u0001\u0005B5CQA\u0017\u0001\u0005BmCQ!\u0019\u0001\u0005B\t\u0014Ad\u00115v].,GMQ=uK\n+hMZ3s\u0013:\u0004X\u000f^*ue\u0016\fWN\u0003\u0002\u000f\u001f\u0005\u0011\u0011n\u001c\u0006\u0003!E\tA!\u001e;jY*\u0011!cE\u0001\u0006gB\f'o\u001b\u0006\u0003)U\ta!\u00199bG\",'\"\u0001\f\u0002\u0007=\u0014xm\u0005\u0002\u00011A\u0011\u0011$H\u0007\u00025)\u0011ab\u0007\u0006\u00029\u0005!!.\u0019<b\u0013\tq\"DA\u0006J]B,Ho\u0015;sK\u0006l\u0017!E2ik:\\W\r\u001a\"zi\u0016\u0014UO\u001a4fe\u000e\u0001Q#\u0001\u0012\u0011\u0005\r\"S\"A\u0007\n\u0005\u0015j!!E\"ik:\\W\r\u001a\"zi\u0016\u0014UO\u001a4fe\u0006)2\r[;oW\u0016$')\u001f;f\u0005V4g-\u001a:`I\u0015\fHC\u0001\u0015/!\tIC&D\u0001+\u0015\u0005Y\u0013!B:dC2\f\u0017BA\u0017+\u0005\u0011)f.\u001b;\t\u000f=\u0012\u0011\u0011!a\u0001E\u0005\u0019\u0001\u0010J\u0019\u0002%\rDWO\\6fI\nKH/\u001a\"vM\u001a,'\u000fI\u0001\bI&\u001c\bo\\:f!\tI3'\u0003\u00025U\t9!i\\8mK\u0006t\u0017A\u0002\u001fj]&$h\bF\u00028qe\u0002\"a\t\u0001\t\u000b})\u0001\u0019\u0001\u0012\t\u000bE*\u0001\u0019\u0001\u001a\u0002\r\rDWO\\6t!\rat(Q\u0007\u0002{)\u0011aHK\u0001\u000bG>dG.Z2uS>t\u0017B\u0001!>\u0005!IE/\u001a:bi>\u0014\bC\u0001\"F\u001b\u0005\u0019%B\u0001#\u001c\u0003\rq\u0017n\\\u0005\u0003\r\u000e\u0013!BQ=uK\n+hMZ3s\u00031\u0019WO\u001d:f]R\u001c\u0005.\u001e8l\u0003\u0011\u0011X-\u00193\u0015\u0003)\u0003\"!K&\n\u00051S#aA%oiR!!J\u0014,Y\u0011\u0015y\u0015\u00021\u0001Q\u0003\u0011!Wm\u001d;\u0011\u0007%\n6+\u0003\u0002SU\t)\u0011I\u001d:bsB\u0011\u0011\u0006V\u0005\u0003+*\u0012AAQ=uK\")q+\u0003a\u0001\u0015\u00061qN\u001a4tKRDQ!W\u0005A\u0002)\u000ba\u0001\\3oORD\u0017\u0001B:lSB$\"\u0001X0\u0011\u0005%j\u0016B\u00010+\u0005\u0011auN\\4\t\u000b\u0001T\u0001\u0019\u0001/\u0002\u000b\tLH/Z:\u0002\u000b\rdwn]3\u0015\u0003!\u0002")
public class ChunkedByteBufferInputStream
extends InputStream {
    private ChunkedByteBuffer chunkedByteBuffer;
    private final boolean dispose;
    private Iterator<ByteBuffer> chunks;
    private ByteBuffer currentChunk;

    public ChunkedByteBuffer chunkedByteBuffer() {
        return this.chunkedByteBuffer;
    }

    public void chunkedByteBuffer_$eq(ChunkedByteBuffer x$1) {
        this.chunkedByteBuffer = x$1;
    }

    @Override
    public int read() {
        int n;
        if (this.currentChunk != null && !this.currentChunk.hasRemaining() && this.chunks.hasNext()) {
            this.currentChunk = (ByteBuffer)this.chunks.next();
        }
        if (this.currentChunk != null && this.currentChunk.hasRemaining()) {
            n = UnsignedBytes.toInt((byte)this.currentChunk.get());
        } else {
            this.close();
            n = -1;
        }
        return n;
    }

    @Override
    public int read(byte[] dest, int offset, int length) {
        int n;
        if (this.currentChunk != null && !this.currentChunk.hasRemaining() && this.chunks.hasNext()) {
            this.currentChunk = (ByteBuffer)this.chunks.next();
        }
        if (this.currentChunk != null && this.currentChunk.hasRemaining()) {
            int amountToGet = package$.MODULE$.min(this.currentChunk.remaining(), length);
            this.currentChunk.get(dest, offset, amountToGet);
            n = amountToGet;
        } else {
            this.close();
            n = -1;
        }
        return n;
    }

    @Override
    public long skip(long bytes) {
        long l;
        if (this.currentChunk != null) {
            int amountToSkip = (int)package$.MODULE$.min(bytes, (long)this.currentChunk.remaining());
            this.currentChunk.position(this.currentChunk.position() + amountToSkip);
            if (this.currentChunk.remaining() == 0) {
                if (this.chunks.hasNext()) {
                    this.currentChunk = (ByteBuffer)this.chunks.next();
                } else {
                    this.close();
                }
            }
            l = amountToSkip;
        } else {
            l = 0L;
        }
        return l;
    }

    @Override
    public void close() {
        if (this.chunkedByteBuffer() != null && this.dispose) {
            this.chunkedByteBuffer().dispose();
        }
        this.chunkedByteBuffer_$eq(null);
        this.chunks = null;
        this.currentChunk = null;
    }

    public ChunkedByteBufferInputStream(ChunkedByteBuffer chunkedByteBuffer, boolean dispose) {
        this.chunkedByteBuffer = chunkedByteBuffer;
        this.dispose = dispose;
        this.chunks = ArrayOps$.MODULE$.iterator$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.filter$extension(Predef$.MODULE$.refArrayOps((Object[])this.chunkedByteBuffer().getChunks()), (Function1 & Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)x$5.hasRemaining()))));
        this.currentChunk = this.chunks.hasNext() ? (ByteBuffer)this.chunks.next() : null;
    }
}

