/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.hive;

import java.io.Serializable;
import java.lang.reflect.Type;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.plan.TableDesc;
import org.apache.hadoop.hive.serde2.Deserializer;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorConverters;
import org.apache.hadoop.hive.serde2.objectinspector.StructField;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.BinaryObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.BooleanObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.ByteObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.DateObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.DoubleObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.FloatObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.HiveCharObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.HiveDecimalObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.HiveVarcharObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.IntObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.LongObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.ShortObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.TimestampObjectInspector;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.JobConf;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.util.DateTimeUtils$;
import org.apache.spark.sql.hive.HiveInspectors;
import org.apache.spark.sql.hive.HiveShim$;
import org.apache.spark.sql.hive.HiveTableUtil$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.unsafe.types.UTF8String;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function3;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class HadoopTableReader$
implements HiveInspectors,
Logging {
    public static HadoopTableReader$ MODULE$;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        new HadoopTableReader$();
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    @Override
    public DataType javaTypeToDataType(Type clz) {
        return HiveInspectors.javaTypeToDataType$(this, clz);
    }

    @Override
    public Function1<Object, Object> wrapperFor(ObjectInspector oi, DataType dataType) {
        return HiveInspectors.wrapperFor$(this, oi, dataType);
    }

    @Override
    public Function1<Object, Object> unwrapperFor(ObjectInspector objectInspector) {
        return HiveInspectors.unwrapperFor$((HiveInspectors)this, objectInspector);
    }

    @Override
    public Function3<Object, InternalRow, Object, BoxedUnit> unwrapperFor(StructField field) {
        return HiveInspectors.unwrapperFor$((HiveInspectors)this, field);
    }

    @Override
    public Object wrap(Object a, ObjectInspector oi, DataType dataType) {
        return HiveInspectors.wrap$(this, a, oi, dataType);
    }

    @Override
    public Object[] wrap(InternalRow row, Function1<Object, Object>[] wrappers, Object[] cache, DataType[] dataTypes) {
        return HiveInspectors.wrap$((HiveInspectors)this, row, wrappers, cache, dataTypes);
    }

    @Override
    public Object[] wrap(Seq<Object> row, Function1<Object, Object>[] wrappers, Object[] cache, DataType[] dataTypes) {
        return HiveInspectors.wrap$((HiveInspectors)this, row, wrappers, cache, dataTypes);
    }

    @Override
    public ObjectInspector toInspector(DataType dataType) {
        return HiveInspectors.toInspector$((HiveInspectors)this, dataType);
    }

    @Override
    public ObjectInspector toInspector(Expression expr) {
        return HiveInspectors.toInspector$((HiveInspectors)this, expr);
    }

    @Override
    public DataType inspectorToDataType(ObjectInspector inspector) {
        return HiveInspectors.inspectorToDataType$(this, inspector);
    }

    @Override
    public HiveInspectors.typeInfoConversions typeInfoConversions(DataType dt) {
        return HiveInspectors.typeInfoConversions$(this, dt);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public void initializeLocalJobConfFunc(String path, TableDesc tableDesc, JobConf jobConf) {
        FileInputFormat.setInputPaths((JobConf)jobConf, (Path[])((Path[])((TraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Path[]{new Path(path)}))).toArray(ClassTag$.MODULE$.apply(Path.class))));
        if (tableDesc != null) {
            HiveTableUtil$.MODULE$.configureJobPropertiesForStorageHandler(tableDesc, (Configuration)jobConf, true);
            Utilities.copyTableJobPropertiesToConf((TableDesc)tableDesc, (Configuration)jobConf);
        }
        String bufferSize = System.getProperty("spark.buffer.size", "65536");
        jobConf.set("io.file.buffer.size", bufferSize);
    }

    public Iterator<InternalRow> fillObject(Iterator<Writable> iterator, Deserializer rawDeser, Seq<Tuple2<Attribute, Object>> nonPartitionKeyAttrs, InternalRow mutableRow, Deserializer tableDeser) {
        StructObjectInspector soi = rawDeser.getObjectInspector().equals(tableDeser.getObjectInspector()) ? (StructObjectInspector)rawDeser.getObjectInspector() : (StructObjectInspector)ObjectInspectorConverters.getConvertedOI((ObjectInspector)rawDeser.getObjectInspector(), (ObjectInspector)tableDeser.getObjectInspector());
        this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> soi.toString());
        Tuple2 tuple2 = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])((TraversableOnce)nonPartitionKeyAttrs.map((Function1 & Serializable & scala.Serializable)x0$6 -> {
            Tuple2 tuple2 = x0$6;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Attribute attr = (Attribute)tuple2._1();
            int ordinal = tuple2._2$mcI$sp();
            Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)soi.getStructFieldRef(attr.name())), (Object)BoxesRunTime.boxToInteger((int)ordinal));
            return tuple22;
        }, Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(Tuple2.class)))).unzip((Function1)Predef$.MODULE$.$conforms(), ClassTag$.MODULE$.apply(StructField.class), ClassTag$.MODULE$.Int());
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        StructField[] fieldRefs = (StructField[])tuple2._1();
        int[] fieldOrdinals = (int[])tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)fieldRefs, (Object)fieldOrdinals);
        Tuple2 tuple23 = tuple22;
        StructField[] fieldRefs2 = (StructField[])tuple23._1();
        int[] fieldOrdinals2 = (int[])tuple23._2();
        Seq unwrappers = (Seq)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])fieldRefs2)).map((Function1 & Serializable & scala.Serializable)x$8 -> {
            Function3 & Serializable & scala.Serializable intersect;
            ObjectInspector objectInspector = x$8.getFieldObjectInspector();
            if (objectInspector instanceof BooleanObjectInspector) {
                BooleanObjectInspector booleanObjectInspector = (BooleanObjectInspector)objectInspector;
                intersect = (Function3 & Serializable & scala.Serializable)(value, row, ordinal) -> {
                    row.setBoolean(BoxesRunTime.unboxToInt((Object)ordinal), booleanObjectInspector.get(value));
                    return BoxedUnit.UNIT;
                };
            } else if (objectInspector instanceof ByteObjectInspector) {
                ByteObjectInspector byteObjectInspector = (ByteObjectInspector)objectInspector;
                intersect = (Function3 & Serializable & scala.Serializable)(value, row, ordinal) -> {
                    row.setByte(BoxesRunTime.unboxToInt((Object)ordinal), byteObjectInspector.get(value));
                    return BoxedUnit.UNIT;
                };
            } else if (objectInspector instanceof ShortObjectInspector) {
                ShortObjectInspector shortObjectInspector = (ShortObjectInspector)objectInspector;
                intersect = (Function3 & Serializable & scala.Serializable)(value, row, ordinal) -> {
                    row.setShort(BoxesRunTime.unboxToInt((Object)ordinal), shortObjectInspector.get(value));
                    return BoxedUnit.UNIT;
                };
            } else if (objectInspector instanceof IntObjectInspector) {
                IntObjectInspector intObjectInspector = (IntObjectInspector)objectInspector;
                intersect = (Function3 & Serializable & scala.Serializable)(value, row, ordinal) -> {
                    row.setInt(BoxesRunTime.unboxToInt((Object)ordinal), intObjectInspector.get(value));
                    return BoxedUnit.UNIT;
                };
            } else if (objectInspector instanceof LongObjectInspector) {
                LongObjectInspector longObjectInspector = (LongObjectInspector)objectInspector;
                intersect = (Function3 & Serializable & scala.Serializable)(value, row, ordinal) -> {
                    row.setLong(BoxesRunTime.unboxToInt((Object)ordinal), longObjectInspector.get(value));
                    return BoxedUnit.UNIT;
                };
            } else if (objectInspector instanceof FloatObjectInspector) {
                FloatObjectInspector floatObjectInspector = (FloatObjectInspector)objectInspector;
                intersect = (Function3 & Serializable & scala.Serializable)(value, row, ordinal) -> {
                    row.setFloat(BoxesRunTime.unboxToInt((Object)ordinal), floatObjectInspector.get(value));
                    return BoxedUnit.UNIT;
                };
            } else if (objectInspector instanceof DoubleObjectInspector) {
                DoubleObjectInspector doubleObjectInspector = (DoubleObjectInspector)objectInspector;
                intersect = (Function3 & Serializable & scala.Serializable)(value, row, ordinal) -> {
                    row.setDouble(BoxesRunTime.unboxToInt((Object)ordinal), doubleObjectInspector.get(value));
                    return BoxedUnit.UNIT;
                };
            } else if (objectInspector instanceof HiveVarcharObjectInspector) {
                HiveVarcharObjectInspector hiveVarcharObjectInspector = (HiveVarcharObjectInspector)objectInspector;
                intersect = (Function3 & Serializable & scala.Serializable)(value, row, ordinal) -> {
                    row.update(BoxesRunTime.unboxToInt((Object)ordinal), (Object)UTF8String.fromString((String)hiveVarcharObjectInspector.getPrimitiveJavaObject(value).getValue()));
                    return BoxedUnit.UNIT;
                };
            } else if (objectInspector instanceof HiveCharObjectInspector) {
                HiveCharObjectInspector hiveCharObjectInspector = (HiveCharObjectInspector)objectInspector;
                intersect = (Function3 & Serializable & scala.Serializable)(value, row, ordinal) -> {
                    row.update(BoxesRunTime.unboxToInt((Object)ordinal), (Object)UTF8String.fromString((String)hiveCharObjectInspector.getPrimitiveJavaObject(value).getValue()));
                    return BoxedUnit.UNIT;
                };
            } else if (objectInspector instanceof HiveDecimalObjectInspector) {
                HiveDecimalObjectInspector hiveDecimalObjectInspector = (HiveDecimalObjectInspector)objectInspector;
                intersect = (Function3 & Serializable & scala.Serializable)(value, row, ordinal) -> {
                    row.update(BoxesRunTime.unboxToInt((Object)ordinal), (Object)HiveShim$.MODULE$.toCatalystDecimal(hiveDecimalObjectInspector, value));
                    return BoxedUnit.UNIT;
                };
            } else if (objectInspector instanceof TimestampObjectInspector) {
                TimestampObjectInspector timestampObjectInspector = (TimestampObjectInspector)objectInspector;
                intersect = (Function3 & Serializable & scala.Serializable)(value, row, ordinal) -> {
                    row.setLong(BoxesRunTime.unboxToInt((Object)ordinal), DateTimeUtils$.MODULE$.fromJavaTimestamp(timestampObjectInspector.getPrimitiveJavaObject(value)));
                    return BoxedUnit.UNIT;
                };
            } else if (objectInspector instanceof DateObjectInspector) {
                DateObjectInspector dateObjectInspector = (DateObjectInspector)objectInspector;
                intersect = (Function3 & Serializable & scala.Serializable)(value, row, ordinal) -> {
                    row.setInt(BoxesRunTime.unboxToInt((Object)ordinal), DateTimeUtils$.MODULE$.fromJavaDate(dateObjectInspector.getPrimitiveJavaObject(value)));
                    return BoxedUnit.UNIT;
                };
            } else if (objectInspector instanceof BinaryObjectInspector) {
                BinaryObjectInspector binaryObjectInspector = (BinaryObjectInspector)objectInspector;
                intersect = (Function3 & Serializable & scala.Serializable)(value, row, ordinal) -> {
                    row.update(BoxesRunTime.unboxToInt((Object)ordinal), (Object)binaryObjectInspector.getPrimitiveJavaObject(value));
                    return BoxedUnit.UNIT;
                };
            } else {
                Function1<Object, Object> unwrapper = MODULE$.unwrapperFor(objectInspector);
                intersect = (Function3 & Serializable & scala.Serializable)(value, row, ordinal) -> {
                    row.update(BoxesRunTime.unboxToInt((Object)ordinal), unwrapper.apply(value));
                    return BoxedUnit.UNIT;
                };
            }
            return intersect;
        }, Array$.MODULE$.fallbackCanBuildFrom(Predef.DummyImplicit$.MODULE$.dummyImplicit()));
        ObjectInspectorConverters.Converter converter = ObjectInspectorConverters.getConverter((ObjectInspector)rawDeser.getObjectInspector(), (ObjectInspector)soi);
        return iterator.map((Function1 & Serializable & scala.Serializable)value -> {
            Object raw = converter.convert(rawDeser.deserialize(value));
            int length = fieldRefs2.length;
            for (int i = 0; i < length; ++i) {
                Object object;
                Object fieldValue = soi.getStructFieldData(raw, fieldRefs2[i]);
                if (fieldValue == null) {
                    mutableRow.setNullAt(fieldOrdinals2[i]);
                    object = BoxedUnit.UNIT;
                    continue;
                }
                object = ((Function3)unwrappers.apply(i)).apply(fieldValue, (Object)mutableRow, (Object)BoxesRunTime.boxToInteger((int)fieldOrdinals2[i]));
            }
            return mutableRow;
        });
    }

    private HadoopTableReader$() {
        MODULE$ = this;
        HiveInspectors.$init$(this);
        Logging.$init$((Logging)this);
    }
}

