/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.container.configuration.script;

import java.util.HashMap;
import java.util.Map;
import org.apache.tools.ant.types.FilterChain;
import org.codehaus.cargo.container.configuration.Configuration;
import org.codehaus.cargo.container.configuration.LocalConfiguration;
import org.codehaus.cargo.container.configuration.entry.Resource;
import org.codehaus.cargo.container.configuration.script.ScriptCommand;
import org.codehaus.cargo.container.internal.util.ResourceUtils;
import org.codehaus.cargo.util.AntUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractScriptCommand
implements ScriptCommand {
    private static final String NEW_LINE = System.getProperty("line.separator");
    private Configuration configuration;
    private String resourcePath;
    private ResourceUtils resourceUtils;
    private AntUtils antUtils;

    public AbstractScriptCommand(Configuration configuration, String resourcePath) {
        this.configuration = configuration;
        this.resourcePath = resourcePath;
        this.resourceUtils = new ResourceUtils();
        this.antUtils = new AntUtils();
    }

    @Override
    public String readScript() {
        FilterChain filterChain = new FilterChain();
        this.antUtils.addTokensToFilterChain(filterChain, this.configuration.getProperties());
        HashMap<String, String> propertiesMap = new HashMap<String, String>();
        this.addConfigurationScriptProperties(propertiesMap);
        this.antUtils.addTokensToFilterChain(filterChain, propertiesMap);
        return this.resourceUtils.readResource(this.resourcePath + this.getScriptRelativePath(), filterChain, "UTF-8") + NEW_LINE;
    }

    protected abstract String getScriptRelativePath();

    protected void addConfigurationScriptProperties(Map<String, String> propertiesMap) {
    }

    protected Resource findResource(String type) {
        Resource foundResource = null;
        for (Resource resource : ((LocalConfiguration)this.configuration).getResources()) {
            if (!type.equals(resource.getType())) continue;
            foundResource = resource;
        }
        return foundResource;
    }

    protected Configuration getConfiguration() {
        return this.configuration;
    }
}

