/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.generic.configuration.builder;

import java.lang.reflect.Constructor;
import org.codehaus.cargo.container.ContainerException;
import org.codehaus.cargo.container.ContainerType;
import org.codehaus.cargo.container.LocalContainer;
import org.codehaus.cargo.container.configuration.LocalConfiguration;
import org.codehaus.cargo.container.configuration.builder.ConfigurationBuilder;
import org.codehaus.cargo.container.configuration.entry.Resource;
import org.codehaus.cargo.generic.AbstractFactoryRegistry;
import org.codehaus.cargo.generic.configuration.builder.ConfigurationBuilderFactory;
import org.codehaus.cargo.generic.internal.util.FullContainerIdentity;
import org.codehaus.cargo.generic.internal.util.RegistrationKey;
import org.codehaus.cargo.generic.spi.AbstractGenericHintFactory;
import org.codehaus.cargo.generic.spi.AbstractIntrospectionGenericHintFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultConfigurationBuilderFactory
extends AbstractIntrospectionGenericHintFactory<ConfigurationBuilder>
implements ConfigurationBuilderFactory {
    public DefaultConfigurationBuilderFactory() {
        this(null);
    }

    public DefaultConfigurationBuilderFactory(ClassLoader classLoader) {
        AbstractFactoryRegistry.register(classLoader, this);
    }

    @Override
    public void registerConfigurationBuilder(String containerId, ContainerType containerType, String configurationEntryType, Class<? extends ConfigurationBuilder> configurationBuilderClass) {
        this.registerImplementation(new RegistrationKey(new FullContainerIdentity(containerId, containerType), configurationEntryType), configurationBuilderClass);
    }

    @Override
    public boolean isConfigurationBuilderRegistered(String containerId, ContainerType containerType, String configurationEntryType) {
        return this.hasMapping(new RegistrationKey(new FullContainerIdentity(containerId, containerType), configurationEntryType));
    }

    @Override
    public ConfigurationBuilder createConfigurationBuilder(LocalContainer container, Resource resource) {
        String resourceType = resource.getType();
        if (!this.isConfigurationBuilderRegistered(container.getId(), container.getType(), resourceType)) {
            throw new ContainerException("There's no registered conf. builder matching your resource [" + resourceType + "]");
        }
        this.getLogger().debug("Creating configuration builder for [" + resourceType + "] ", this.getClass().getName());
        ConfigurationBuilderFactoryParameters parameters = new ConfigurationBuilderFactoryParameters();
        parameters.configuration = container.getConfiguration();
        ConfigurationBuilder configurationBuilder = (ConfigurationBuilder)this.createImplementation(new RegistrationKey(new FullContainerIdentity(container.getId(), container.getType()), resourceType), parameters, "configuration builder");
        return configurationBuilder;
    }

    @Override
    protected Constructor<? extends ConfigurationBuilder> getConstructor(Class<? extends ConfigurationBuilder> configurationBuilderClass, String hint, AbstractGenericHintFactory.GenericParameters parameters) throws NoSuchMethodException {
        Constructor<?>[] constructors;
        Constructor<?> result = null;
        for (Constructor<?> constructor : constructors = configurationBuilderClass.getConstructors()) {
            Class<?> parameter;
            Class<?>[] parameterTypes = constructor.getParameterTypes();
            if (parameterTypes == null || parameterTypes.length != 1 || !LocalConfiguration.class.isAssignableFrom(parameter = parameterTypes[0])) continue;
            result = constructor;
            break;
        }
        if (result == null) {
            throw new NoSuchMethodException("No constructor found on class " + configurationBuilderClass + " for configuration builder for resource type [" + hint + "]");
        }
        return result;
    }

    @Override
    protected ConfigurationBuilder createInstance(Constructor<? extends ConfigurationBuilder> constructor, String hint, AbstractGenericHintFactory.GenericParameters parameters) throws Exception {
        LocalConfiguration configuration = ((ConfigurationBuilderFactoryParameters)parameters).configuration;
        return constructor.newInstance(configuration);
    }

    private static class ConfigurationBuilderFactoryParameters
    implements AbstractGenericHintFactory.GenericParameters {
        public LocalConfiguration configuration;

        private ConfigurationBuilderFactoryParameters() {
        }
    }
}

