/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.util;

import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Location;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Target;
import org.apache.tools.ant.Task;
import org.codehaus.cargo.util.AntTaskFactory;
import org.codehaus.cargo.util.CargoException;

public class DefaultAntTaskFactory
implements AntTaskFactory {
    private Project currentProject;
    private String currentTaskName;
    private Location currentLocation;
    private Target currentOwningTarget;

    public DefaultAntTaskFactory(Project project) {
        this.currentProject = project;
        this.currentTaskName = "cargo";
        this.currentLocation = new Location("in cargo code");
        this.currentOwningTarget = new Target();
    }

    public DefaultAntTaskFactory(Project project, String currentTaskName, Location currentLocation, Target currentTarget) {
        this.currentProject = project;
        this.currentTaskName = currentTaskName;
        this.currentLocation = currentLocation;
        this.currentOwningTarget = currentTarget;
    }

    public Task createTask(String theName) {
        this.ifSshLoadTaskDef(theName);
        Task retVal = this.currentProject.createTask(theName);
        if (retVal != null) {
            retVal.setTaskName(this.currentTaskName);
            retVal.setLocation(this.currentLocation);
            retVal.setOwningTarget(this.currentOwningTarget);
        }
        return retVal;
    }

    private void ifSshLoadTaskDef(String taskName) {
        if (taskName.equals("sshjava") && !this.currentProject.getTaskDefinitions().containsKey("sshjava")) {
            try {
                this.currentProject.addTaskDefinition("sshjava", Class.forName("org.jclouds.tools.ant.taskdefs.sshjava.SSHJava"));
            }
            catch (BuildException e) {
                throw new CargoException("Error adding sshjava task", e);
            }
            catch (ClassNotFoundException e) {
                throw new CargoException("Please ensure jclouds-antcontrib is in the classpath", e);
            }
        }
    }
}

