/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.search;

import java.io.IOException;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRunnable;
import org.elasticsearch.action.search.AbstractSearchAsyncAction;
import org.elasticsearch.action.search.ReduceSearchPhaseException;
import org.elasticsearch.action.search.SearchPhaseController;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.search.SearchTask;
import org.elasticsearch.action.search.SearchTransportService;
import org.elasticsearch.action.search.TransportSearchHelper;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.routing.GroupShardsIterator;
import org.elasticsearch.common.util.concurrent.AtomicArray;
import org.elasticsearch.search.SearchPhaseResult;
import org.elasticsearch.search.dfs.AggregatedDfs;
import org.elasticsearch.search.dfs.DfsSearchResult;
import org.elasticsearch.search.fetch.QueryFetchSearchResult;
import org.elasticsearch.search.internal.AliasFilter;
import org.elasticsearch.search.internal.InternalSearchResponse;
import org.elasticsearch.search.internal.ShardSearchTransportRequest;
import org.elasticsearch.search.query.QuerySearchRequest;

class SearchDfsQueryAndFetchAsyncAction
extends AbstractSearchAsyncAction<DfsSearchResult> {
    private final AtomicArray<QueryFetchSearchResult> queryFetchResults;
    private final SearchPhaseController searchPhaseController;

    SearchDfsQueryAndFetchAsyncAction(Logger logger, SearchTransportService searchTransportService, Function<String, DiscoveryNode> nodeIdToDiscoveryNode, Map<String, AliasFilter> aliasFilter, SearchPhaseController searchPhaseController, Executor executor, SearchRequest request, ActionListener<SearchResponse> listener, GroupShardsIterator shardsIts, long startTime, long clusterStateVersion, SearchTask task) {
        super(logger, searchTransportService, nodeIdToDiscoveryNode, aliasFilter, executor, request, listener, shardsIts, startTime, clusterStateVersion, task);
        this.searchPhaseController = searchPhaseController;
        this.queryFetchResults = new AtomicArray(this.firstResults.length());
    }

    @Override
    protected String firstPhaseName() {
        return "dfs";
    }

    @Override
    protected void sendExecuteFirstPhase(DiscoveryNode node, ShardSearchTransportRequest request, ActionListener<DfsSearchResult> listener) {
        this.searchTransportService.sendExecuteDfs(node, request, this.task, listener);
    }

    @Override
    protected void moveToSecondPhase() {
        AggregatedDfs dfs = this.searchPhaseController.aggregateDfs(this.firstResults);
        AtomicInteger counter = new AtomicInteger(this.firstResults.asList().size());
        for (AtomicArray.Entry entry : this.firstResults.asList()) {
            DfsSearchResult dfsResult = (DfsSearchResult)entry.value;
            DiscoveryNode node = (DiscoveryNode)this.nodeIdToDiscoveryNode.apply(dfsResult.shardTarget().nodeId());
            QuerySearchRequest querySearchRequest = new QuerySearchRequest(this.request, dfsResult.id(), dfs);
            this.executeSecondPhase(entry.index, dfsResult, counter, node, querySearchRequest);
        }
    }

    void executeSecondPhase(final int shardIndex, final DfsSearchResult dfsResult, final AtomicInteger counter, final DiscoveryNode node, final QuerySearchRequest querySearchRequest) {
        this.searchTransportService.sendExecuteFetch(node, querySearchRequest, this.task, new ActionListener<QueryFetchSearchResult>(){

            @Override
            public void onResponse(QueryFetchSearchResult result) {
                result.shardTarget(dfsResult.shardTarget());
                SearchDfsQueryAndFetchAsyncAction.this.queryFetchResults.set(shardIndex, result);
                if (counter.decrementAndGet() == 0) {
                    SearchDfsQueryAndFetchAsyncAction.this.finishHim();
                }
            }

            @Override
            public void onFailure(Exception t) {
                try {
                    SearchDfsQueryAndFetchAsyncAction.this.onSecondPhaseFailure(t, querySearchRequest, shardIndex, dfsResult, counter);
                }
                finally {
                    SearchDfsQueryAndFetchAsyncAction.this.sendReleaseSearchContext(querySearchRequest.id(), node);
                }
            }
        });
    }

    void onSecondPhaseFailure(Exception e, QuerySearchRequest querySearchRequest, int shardIndex, DfsSearchResult dfsResult, AtomicInteger counter) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(() -> new ParameterizedMessage("[{}] Failed to execute query phase", (Object)querySearchRequest.id()), (Throwable)e);
        }
        this.addShardFailure(shardIndex, dfsResult.shardTarget(), e);
        this.successfulOps.decrementAndGet();
        if (counter.decrementAndGet() == 0) {
            this.finishHim();
        }
    }

    private void finishHim() {
        this.getExecutor().execute(new ActionRunnable<SearchResponse>(this.listener){

            @Override
            public void doRun() throws IOException {
                SearchDfsQueryAndFetchAsyncAction.this.sortedShardDocs = SearchDfsQueryAndFetchAsyncAction.this.searchPhaseController.sortDocs(true, SearchDfsQueryAndFetchAsyncAction.this.queryFetchResults);
                InternalSearchResponse internalResponse = SearchDfsQueryAndFetchAsyncAction.this.searchPhaseController.merge(true, SearchDfsQueryAndFetchAsyncAction.this.sortedShardDocs, SearchDfsQueryAndFetchAsyncAction.this.queryFetchResults, SearchDfsQueryAndFetchAsyncAction.this.queryFetchResults);
                String scrollId = null;
                if (SearchDfsQueryAndFetchAsyncAction.this.request.scroll() != null) {
                    scrollId = TransportSearchHelper.buildScrollId(SearchDfsQueryAndFetchAsyncAction.this.request.searchType(), (AtomicArray<? extends SearchPhaseResult>)SearchDfsQueryAndFetchAsyncAction.this.firstResults);
                }
                this.listener.onResponse(new SearchResponse(internalResponse, scrollId, SearchDfsQueryAndFetchAsyncAction.this.expectedSuccessfulOps, SearchDfsQueryAndFetchAsyncAction.this.successfulOps.get(), SearchDfsQueryAndFetchAsyncAction.this.buildTookInMillis(), SearchDfsQueryAndFetchAsyncAction.this.buildShardFailures()));
            }

            @Override
            public void onFailure(Exception e) {
                ReduceSearchPhaseException failure = new ReduceSearchPhaseException("query_fetch", "", e, SearchDfsQueryAndFetchAsyncAction.this.buildShardFailures());
                if (SearchDfsQueryAndFetchAsyncAction.this.logger.isDebugEnabled()) {
                    SearchDfsQueryAndFetchAsyncAction.this.logger.debug("failed to reduce search", (Throwable)failure);
                }
                super.onFailure(e);
            }
        });
    }
}

